#!/bin/bash

#########################################################
# Function :统计某个帐户下所有桶（最多1000个桶）的多段信息#
# Version  :1.0                                         #
# Date     :2023-11-05                                  #
#########################################################

AK="xx"
SK="xxxx"
IP="127.0.0.1:5080"
maxKeys=1000

function listBucketPartsInfo() {
    BUCKET=$1
    taskNum=1

    TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
    SSTR="GET\n\n\n${TIME}\n/${BUCKET}?uploads"
    SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
    curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s -v "http://${IP}/${BUCKET}?uploads&max-uploads=${maxKeys}" | xmllint --format - >"${BUCKET}-task-${taskNum}".log
    nextKeyMarker=$(grep "NextKeyMarker" "${BUCKET}-task-${taskNum}".log | sed 's/^.*<NextKeyMarker>//g' | sed 's/<\/NextKeyMarker>.*$//g')

    while [ "${nextKeyMarker}" ]; do
        ((taskNum += 1))
        TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
        SSTR="GET\n\n\n${TIME}\n/${BUCKET}?uploads"
        SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
        curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s "http://${IP}/${BUCKET}?uploads&max-uploads=${maxKeys}&key-marker=${nextKeyMarker}" | xmllint --format - >"${BUCKET}-task-${taskNum}".log
        nextKeyMarker=$(grep "NextKeyMarker" "${BUCKET}-task-${taskNum}".log | sed 's/^.*<NextKeyMarker>//g' | sed 's/<\/NextKeyMarker>.*$//g')
    done

    queryParts $BUCKET
}

function queryParts() {
    BUCKET=$1

    keys=($(grep "<Key>" ${BUCKET}-task-*.log | sed 's/^.*<Key>//g' | sed 's/<\/Key>.*$//g' | sed 's/ /%20/g'))
    uploadIds=($(grep "<UploadId>" ${BUCKET}-task-*.log | sed 's/^.*<UploadId>//g' | sed 's/<\/UploadId>.*$//g'))
    touch "${BUCKET}-analysis".txt

    for ((i = 0; i < ${#keys[@]}; i++)); do
        OBJECT="${keys[i]}?uploadId=${uploadIds[i]}"
        echo $OBJECT
        fileNum=1

        TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
        SSTR="GET\n\n\n${TIME}\n/${BUCKET}/${OBJECT}"
        SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
        curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s "http://${IP}/${BUCKET}/${OBJECT}&max-parts=${maxKeys}" | xmllint --format - >"${uploadIds[i]}-${fileNum}".log
        curMarker=$(grep "<PartNumberMarker>" "${uploadIds[i]}-${fileNum}".log | sed 's/^.*<PartNumberMarker>//g' | sed 's/<\/PartNumberMarker>.*$//g')
        nextMarker=$(grep "NextPartNumberMarker" "${uploadIds[i]}-${fileNum}".log | sed 's/^.*<NextPartNumberMarker>//g' | sed 's/<\/NextPartNumberMarker>.*$//g')
        # 有些版本，需要改成"${nextMarker}" != "0"
        while [ "${nextMarker}" != "${curMarker}" ]; do
            ((fileNum += 1))
            TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
            SSTR="GET\n\n\n${TIME}\n/${BUCKET}/${OBJECT}"
            SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
            curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s "http://${IP}/${BUCKET}/${OBJECT}&max-parts=${maxKeys}&part-number-marker=${nextMarker}" | xmllint --format - >"${uploadIds[i]}-${fileNum}".log
            curMarker=$(grep "<PartNumberMarker>" "${uploadIds[i]}-${fileNum}".log | sed 's/^.*<PartNumberMarker>//g' | sed 's/<\/PartNumberMarker>.*$//g')
            nextMarker=$(grep "NextPartNumberMarker" "${uploadIds[i]}-${fileNum}".log | sed 's/^.*<NextPartNumberMarker>//g' | sed 's/<\/NextPartNumberMarker>.*$//g')
        done

        totalSize=$(grep "<Size>" ${uploadIds[i]}-*.log | sed 's/^.*<Size>//g' | sed 's/<\/Size>.*$//g' | awk -F '' '{sum+=$0}END{print sum}')
        echo "${keys[i]} ${uploadIds[i]} $totalSize" >>"${BUCKET}-analysis".txt
    done
}

function listAllPartsInfo() {
    TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
    SSTR="GET\n\n\n${TIME}\n/"
    SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
    curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -L -v "http://${IP}" | xmllint --format - >buckets.log

    buckets=($(grep "<Name>" buckets.log | sed 's/^.*<Name>//g' | sed 's/<\/Name>.*$//g'))

    for ((j = 0; j < ${#buckets[@]}; j++)); do
        listBucketPartsInfo "${buckets[j]}"
    done
}

function main() {
    # 如果没有传桶名，统计帐户下所有的桶
    if [ ! -n "$1" ]; then
        listAllPartsInfo
        exit 1
    fi
    # 否则只统计传入的这一个桶
    listBucketPartsInfo "$1"
}

main "$@"
