#!/bin/bash

#########################################################
# Function :列举(删除)一个桶内的所有多段任务             #
# Version  :1.0                                         #
# Date     :2023-11-05                                  #
#########################################################

AK="xx"
SK="xxxx"
BUCKET="bucket001"
IP="127.0.0.1:5080"
maxKeys=1000
fileNum=1
prefix=

function usage() {
    echo "Usage: ${0##*/} {list|delete}"
    exit 1
}

function deleteMultiPart() {
    fileName=$1
    echo "start delete multipart task: ${fileName}"
    keys=($(grep "<Key>" ${fileName} | sed 's/^.*<Key>//g' | sed 's/<\/Key>.*$//g' | sed 's/ /%20/g'))
    uploadIds=($(grep "<UploadId>" ${fileName} | sed 's/^.*<UploadId>//g' | sed 's/<\/UploadId>.*$//g'))

    for ((i = 0; i < ${#keys[@]}; i++)); do
        OBJECT="${keys[i]}?uploadId=${uploadIds[i]}"
        echo $OBJECT

        TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
        SSTR="DELETE\n\n\n${TIME}\n/${BUCKET}/${OBJECT}"
        SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
        curl -X DELETE -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s "http://${IP}/${BUCKET}/${OBJECT}"
    done
    rm -f ${fileName}
    echo "end delete multipart task: ${fileName}"
}

function iterMultiPartTask() {
    echo "start list multi parts..."
    TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
    SSTR="GET\n\n\n${TIME}\n/${BUCKET}?uploads"
    SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
    curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s -v "http://${IP}/${BUCKET}?uploads&max-uploads=${maxKeys}" | xmllint --format - >task-${fileNum}.log
    nextMarker=$(grep "NextKeyMarker" task-${fileNum}.log | sed 's/^.*<NextKeyMarker>//g' | sed 's/<\/NextKeyMarker>.*$//g')
    case "$1" in
    list) ;;
    delete)
        deleteMultiPart task-${fileNum}.log
        ;;
    esac

    while [ ${nextMarker} ]; do
        ((fileNum += 1))
        TIME=$(date -u "+%a, %d %b %Y %H:%M:%S %Z")
        SSTR="GET\n\n\n${TIME}\n/${BUCKET}?uploads"
        SIGN=$(echo -en "${SSTR}" | openssl sha1 -hmac "${SK}" -binary | base64)
        curl -H "Date:${TIME}" -H "Authorization:AWS ${AK}:${SIGN}" -s -v "http://${IP}/${BUCKET}?uploads&max-uploads=${maxKeys}" | xmllint --format - >task-${fileNum}.log
        nextMarker=$(grep "NextKeyMarker" task-${fileNum}.log | sed 's/^.*<NextKeyMarker>//g' | sed 's/<\/NextKeyMarker>.*$//g')

        case "$1" in
        list) ;;
        delete)
            deleteMultiPart task-${fileNum}.log
            ;;
        esac
    done
    echo "end list multi parts..."
}

main() {
    # check parameter, must have at least one parameter.
    [ $# -gt 0 ] || usage

    iterMultiPartTask "$1"
}

main "$@"
