#!/bin/bash
# chmod 500 changeAutoMergeSwitch.sh
# 脚本路径：/opt/dfv/obs_service_layer/objectwebservice/otm/script
# lifecycle 执行时间段配置，时间是UTC时间，如 lifecycle_execution_time_segment=14~20 左闭右开， grep lifecycle_execution_time_segment /opt/dfv/obs_service_layer/objectwebservice/otm/conf/obs_sod.properties 
# lifecycle执行完，开启合并 echo 'sh.setBalancerAutoSettingEnabled("autoMerge", true)' | /usr/local/bin/mongoshell client
# lifecycle开始执行，关闭合并 echo 'sh.setBalancerAutoSettingEnabled("autoMerge", false)' | /usr/local/bin/mongoshell client
# 01 21 * * * sh /opt/dfv/obs_service_layer/objectwebservice/otm/script/changeAutoMergeSwitch.sh "false" >/dev/null 2>&1
# 01 04 * * * sh /opt/dfv/obs_service_layer/objectwebservice/otm/script/changeAutoMergeSwitch.sh "true" >/dev/null 2>&1

LOG_FILE=/var/log/obs/otm/run/obs.otm.alarm.log

function log()
{
    local date_str=$(date);
    local msg="$1";
    local log_str="["${date_str}"] ["${msg}"] [changeAutoMergeSwitch.sh]";
    su - obs -s "/bin/bash" -c "echo -e \"${log_str}\" >> \"${LOG_FILE}\""
}

function changeAutoMerge() {
	local times=0
	local ret="success"
	while [ $times -le 10 ]
	do
		echo 'sh.setBalancerAutoSettingEnabled("autoMerge", '$switch')' | /usr/local/bin/mongoshell client | grep '{ "ok" : 1 }'
		if [ $ret -ne 0 ]
		then 
			sleep 1
			times=`expr 1 + $times`
		else
			break
		fi
	done
	
	if [ $ret -ne 0 ]
	then 
		log "changeAutoMerge $switch failed"
		exit 1
	fi
}

function usage() {
    echo "Usage: sh $0 {true | false}"
}

function main() {
    local switch=$1
    case $switch in
    "true")
        changeAutoMerge $1;;
    "false")
        changeAutoMerge $1;;
    *)
        usage
    esac
    
}
main $@