#!/bin/bash
#1.monitorOBSAccess.sh 脚本需要依赖定时任务crontab，每分钟执行一次 */1 * * * * sh /home/monitorOBSAccess.sh >/dev/null 2>&1 &
#2.每分钟内检索出时延大于10秒的put/get对象但对象小于1M的请求都打印/var/log/obs/osc/run/highLatencyAccess.log，数量多于3个就上报告警
#3./var/log/obs/osc/run/highLatencyAccess.log日志总大小当前限制为10M，超出总大小就不写，由原有osc日志归档任务归档，
#  在每个小时01分时归档到/var/log/obs/uploaded/osc或/var/log/obs/backup/osc下
#4.30分钟无告警再次出现，告警自动恢复

ACCESS_LOG_DIR=/var/uds/user/accesslog/tmpaccesslog
TARGET_FILE=""

HIGH_LATENCY_LOG="/var/log/highLatency.log"
HIGH_LATENCY_ACCESS_LOG="/var/log/obs/osc/run/highLatencyAccess.log"
SEND_ALARM_FLAG=""
LOCAL_MANAGERMENT_IP=""
NEED_TEE=""

function prepare() {
    if [[ -f $HIGH_LATENCY_ACCESS_LOG ]]; then
        LOG_SIZE=$(stat -c %s "$HIGH_LATENCY_ACCESS_LOG")
        LOG_SIZE_MB=$(echo "scale=2; $LOG_SIZE/1024/1024" | bc)
        if [[ $LOG_SIZE_MB < 10 ]]; then
            NEED_TEE="true"
        fi
    else
        NEED_TEE="true"
    fi
}

function getAccessFiles() {
    cd $ACCESS_LOG_DIR
    TARGET_FILE=$(find ./ -type f -mmin -2 -printf "%f\n" | grep "1.zip" |sed 's/\.1.zip//g' | sort -r | head -n 1)
}

function checkAccessMonitor() {
    if [[ -n $TARGET_FILE ]]; then
        local highLatencyCount
        if [[ -n $NEED_TEE ]]; then
            highLatencyCount=$(zgrep -aE "PUT.OBJECT|GET.OBJECT" ${TARGET_FILE}* | grep -vE "ACL|METADATA|COPY|STORAGECLASS" | awk -F '|' '{if ($4 >10000000 && $14 < 1048576) print $0}' | tee -a $HIGH_LATENCY_ACCESS_LOG | wc -l)
        else
            highLatencyCount=$(zgrep -aE "PUT.OBJECT|GET.OBJECT" ${TARGET_FILE}* | grep -vE "ACL|METADATA|COPY|STORAGECLASS" | awk -F '|' '{if ($4 >10000000 && $14 < 1048576) print $0}' | wc -l)
        fi

        if [[ $highLatencyCount -gt 3 ]]; then
            now=$(date +%s)
            SEND_ALARM_FLAG="true"
            echo $now >$HIGH_LATENCY_LOG
        fi
    else
        exit 1
    fi

}
function getIP() {

    LOCAL_MANAGERMENT_IP=$(iptool local management ip)
    if [[ -z $LOCAL_MANAGERMENT_IP ]]; then
        LOCAL_MANAGERMENT_IP=$(cat /etc/dfv/network.ini | grep om_ip | awk -F "=" '{print $2}')
    fi

}

function sendAlarm() {
    if [[ -n $SEND_ALARM_FLAG ]]; then
        getIP
        ALARM_MSG=$LOCAL_MANAGERMENT_IP"存储时延较高，请关注"
        /opt/dfv/oam/fma/tools/sendAlarm 17656624709691 0 2 0 '' 'Service layer' 'ServiceLayer' $ALARM_MSG ''
    fi
}

function recoverAlarm() {
    if [[ -z $SEND_ALARM_FLAG && -f $HIGH_LATENCY_LOG ]]; then
        alarm_ts=$(cat $HIGH_LATENCY_LOG | head -n 1)
        now_ts=$(date +%s)
        diff=$((now_ts - alarm_ts))
        if [ $diff -ge 1800 ]; then
            getIP
            ALARM_MSG=$LOCAL_MANAGERMENT_IP"存储时延较高，请关注"
            /opt/dfv/oam/fma/tools/sendAlarm 17656624709691 1 2 0 '' 'Service layer' 'ServiceLayer' $ALARM_MSG ''
        fi
    fi
}

prepare
getAccessFiles
checkAccessMonitor
sendAlarm
recoverAlarm
