# -*-coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import string
import pathlib


class DeployConstant:
    PORT = '8088'
    IP = '127.0.0.1'
    DM_LOGIN_USER = 'admin'
    FSM_USER = 'fsadmin'
    ROOT_USER = 'root'
    CREATE_DMK_USER = 'fsadmin'
    ARB_USER = 'root'
    CREATE_DMK_GROUP = 'Distributed-storage'
    HTTP = 'http://'
    HTTPS = 'https://'

    # 安装FSM常用参数
    HA_FILE = "/home/HAInfoFromInstallTool.properties"
    ACCOUNT_SET_FILE = "/home/AccountSetting.ini.tmp"

    # 配置参数
    HA_MODE = 'double'

    # 管理存储池名
    BACKEND_NAME = 'murano'
    HA_BACKEND_NAME = 'ha_murano'
    MGR_STORAGE_NET_INTF = 'storage_data0'
    BACKEND_STORAGE_NET_INTF = 'storage_inner'
    REP0_NIC_NAME = "rep0"
    REP1_NIC_NAME = "rep1"
    ARB_NIC_NAME = "rep_arb"

    AVAILABILITY_ZONE = 'manage-az'
    HA_AVAILABILITY_ZONE = 'dr-manage-az'  # 配置KVM资源池时用于获取已配置的kvm-cinder所在主机信息
    THIN_ALLOC_RATE = '1.0'  # 对接KVM资源池使用的廋分比

    X86_ARM_COMPUTE_NODE_ROLE_LIST = ['kvm', 'dpdk']  # X86/ARM场景下业务融合计算节点角色类型
    FS_DUMP_TMP_DIR = "/home/pkg/.distribute_storage_tmp_dir"

    # 安装操作系统依赖文件
    CPU_ARCH_FILE_FOR_INSTALL_OS = "{}/DistributedStorage/Deploy/scripts/PreCheck/common/" \
                                   "distributed_storage_node_cpu_arch.json"

    # 最大业务存储后端数
    MAX_BUSINESS_BACKEND = 5

    # FS8.0 DeployManager部署REST接口
    LOGIN = '/api/v2/aa/sessions'
    LOGOUT = '/api/v2/aa/sessions?is_timeout=false'
    LOGIN_OUT = '/api/v2/aa/sessions?is_timeout=false'
    MODIFY_PWD = '/deviceManager/rest/%s/user/admin'
    GET_LICENSE_INFORMATION = "/deviceManager/rest/%s/license/activelicense"
    UPD_LICENSE = '/deviceManager/rest/%s/file/license/Upload'
    NODES_CHECK_VALIDITY = '/api/v2/deploy_manager/nodes.check_validity()'
    ADD_SERVERS = '/api/v2/deploy_manager/servers'
    NODES_RESTORE_FACTORY = '/api/v2/deploy_manager/nodes.restore_factory_settings()'
    DEPLOY_SERVICE_TASK = '/api/v2/deploy_manager/deploy_service_task'
    DEPLOY_SERVICE = '/api/v2/deploy_manager/deploy_service'
    DEPLOY_SERVICE_RETRY = '/api/v2/deploy_manager/deploy_service/retry'
    NET_SERVICE = '/api/v2/network_service/servers'
    NET_PLATFORM = '/api/v2/network_service/network_platform'
    DEPLOY_MANAGER_SERVERS = '/api/v2/deploy_manager/servers'
    CLUSTER_SERVERS = '/api/v2/cluster/servers'
    CLUSTER_NODE = '/api/v2/cluster/cluster_node'
    CREATE_CLUSTER = '/dsware/service/cluster/createManageCluster'
    QUERY_MANAGE_CLUSTER = '/dsware/service/cluster/queryManageCluster'
    DELETE_MANAGE_CLUSTER = '/dsware/service/cluster/deleteManageCluster'
    CREATE_POOL = '/dsware/service/cluster/storagepool/createStoragePool'
    EXPAND_POOL = '/dsware/service/cluster/storagepool/storagenode/addStorageNode'
    QUERY_ALL_DISK = '/dsware/service/resource/queryAllDisk'
    SCAN_SERVER_MEDIA = '/dsware/service/vsan/scanServerMedia'
    QUERY_TASK_INFO = '/dsware/service/task/queryTaskInfo'
    QUERY_STORAGE_POOL = '/dsware/service/resource/queryStoragePool'
    QUERY_DISK_POOL = "/api/v2/data_service/diskpool?storagePoolId={}"
    CREATE_CLIENT = '/dsware/service/cluster/dswareclient/createDSwareClient'
    CLEAR = '/api/v2/deploy_manager/clear'
    SET_TIME_ZONE = '/api/v2/common/time_config'
    CHECK_NTP_SERVER = '/deviceManager/rest/%s/check_ntp_server_address_connective'
    SET_NTP_SERVER = '/deviceManager/rest/%s/ntp_client_config'
    CONFIG_ISCSI_SWITCH = '/dsware/service/configIscsiSwitch'
    ADD_ISCSI_PORTAL = '/dsware/service/cluster/dswareclient/addIscsiPortal'
    QUERY_STORAGE_NODE_INFO = '/dsware/service/cluster/storagepool/queryStorageNodeInfo'
    SET_GLOBALPARAM = "/dsware/service/cluster/globalParametersOperation"
    CHECK_SPDK_SWITCH = "/api/v2/cluster_service/storagepool/checkSpdkSwitch"
    SET_POLICY_ROUTE = "/dsware/service/setPolicyRoute"
    DEL_POLICY_ROUTE = "/dsware/service/clearPolicyRoute"
    QUERY_POLICY_ROUTE = "/api/v2/network_service/policy_routes"
    SET_STATIC_ROUTE = "/api/v2/network_service/routes"
    CONFIG_BMC_PWD = "/api/v2/hwm/bmc_users"
    CONFIG_EXTERNAL_KMS_INFO = "/dsware/service/kms/configureExternalKMS"
    QUERY_EXTERNAL_KMS_INFO = "/dsware/service/kms/queryExternalKMS"
    TEST_KMS_CONNECTIVITY = "/dsware/service/kms/testServerConnectivity"
    DELETE_EXTERNAL_KMS_INFO = "/dsware/service/kms/deleteExternalKMS"
    CREATE_ACCOUNT_WITH_ENCRYPT = '/gui/dfv/service/obsPOE/accounts'
    IMPORT_CERTIFICAT = "/gui/deviceManager/rest/%s/file/certificate"
    ACTIVATE_CERTIFICAT = "/deviceManager/rest/%s/certificate/active"
    CURRENT_SESSION = "/api/v2/aa/current_session"
    CHECK_DSW_GLOBAL = "/dsware/service/cluster/querySysDynamicPara"
    MODIFY_DSW_GLOBAL = "/dsware/service/cluster/globalParametersOperation"
    SANDBOX_FOR_NODES = "/api/v2/cluster/sandbox"
    EXPORT_CSR = "/deviceManager/rest/%s/certificate/exportpath?CERTIFICATE_TYPE=%s&KEY_ALGORITHM=%s"
    DOWNLOAD_CSR = "/deviceManager/rest/%s/file/certificate?path=%s&certificateType=%s"
    CSR_UPLOAD = "/deviceManager/rest/%s/file/csrupload?certName=%s"
    ISSUE_CERT = "/deviceManager/rest/%s/certificate/issuecert"
    EXPORT_CERT = "/deviceManager/rest/%s/certificate/exportdigitalcert?certName=%s"
    SAVE_CERT = "/deviceManager/rest/%s/file/digitalcert?path=%s&certName=%s"
    EXPORT_CA = "/deviceManager/rest/%s/certificate/exportcacert?caName=%s"
    SAVE_CA = "/deviceManager/rest/%s/file/cacert?path=%s&caType=1&caName=%s"

    NET_VALIDITY = "/api/v2/network_service/validity"
    GET_UPGRADE_STATUS = "/api/v2/upgrade/upgrade_status"

    # CMDB需求相关参数
    VERSION = '/api/v2/cluster/product'
    GET_PRODUCT = '/api/v2/cluster/product'
    GET_DSWARE_CERT = '/dsware/service/cert/exportCertificate'
    DEL_DSWARE_CERT = '/api/v2/cert/exported_cert'
    ESN = "/api/v2/common/esn"
    CLOUD_SERVICE_INDEX = "FusionStorageBlock"
    CLOUD_SERVICE_NAME = "DistributedStorageBusiness"
    REL_CLOUD_SERVICE_NAME = "DistributedStorageReplication"
    CLOUD_SERVICE_PARAMS_KEY = "region0_id"
    REP_SERVICE_NAME = "FusionStorageBlockReplication"
    DEPLOYMENT_TYPE = "separate"

    # 任意、分离、融合场景待适配的驱动
    DRIVER_INTER_COM_LIST = {'X86': {'euleros2.0sp5': ['es3000']},
                             'ARM': {'euleros2.0sp8': ['es3000']}
                             }
    DRIVER_INTER_SEPARATED_LIST = {
        'X86': {'euleros2.0sp5': ['cx4', 'cx5', 'raid']},
        'ARM': {'euleros2.0sp8': ["hi1822", "cx4", 'cx5']}
        }
    DRIVER_INTER_CONVERGE_LIST = {'X86': {'euleros2.0sp5': ['cx4', 'cx5']},
                                  'ARM': {'euleros2.0sp8': ["cx4", 'cx5']}
                                  }
    # 待适配驱动对应的硬件查询命令
    DRIVER_TYPE_CONDITION = {
        "es3000": {
            "cmd": "lspci -n | grep -E '19e5:0123|19e5:3714'",
            "pattern": '19e5:0123|19e5:3714'
        },
        "hi1822": {
            "cmd": "lspci | grep Ethernet | grep Hi1822",
            "pattern": "Hi1822"
        },
        "cx4": {
            "cmd": "lspci | grep ConnectX-4",
            "pattern": "ConnectX-4"
        },
        "cx5": {
            "cmd": "lspci | grep ConnectX-5",
            "pattern": "ConnectX-5"
        },
        "raid": {
            "cmd": "lspci | grep -i LSI",
            "pattern": "3008|3408|3416|3508"
        },
        "bp3152": {
            "cmd": 'lspci -m | grep -i "Smart Storage PQI"',
            "pattern": r"Union Memory \(Shenzhen\)"
        },
        "1880raid": {
            "cmd": 'lspci | grep -E "RAID.*3758"',
            "pattern": r"RAID.*3758"
        }
    }

    # 待上传至存储节点的驱动安装脚本
    DRIVER_SCRIPT = [
        str(pathlib.Path(pathlib.Path(__file__).resolve().parent.parent.parent, 'tool/install_driver.sh')),
        str(pathlib.Path(pathlib.Path(__file__).resolve().parent.parent.parent, 'tool/install_driver_es3000.sh')),
        str(pathlib.Path(pathlib.Path(__file__).resolve().parent.parent.parent, 'tool/ofed_install.sh'))
    ]

    # tool路径
    TOOL_PATH = pathlib.Path(pathlib.Path(__file__).resolve().parent.parent.parent, 'tool/{}')

    # 驱动包
    DRIVER_TYPE_PKG_PATTERN = {
        'es3000': {
            'ARM': ['^ES3000_V5_Tool_5.0.3.9.zip$',
                    '^ES3000_V5_NVMe_Driver_5.0.3.9.zip$',
                    '^ES3000_V5_Firmware_3232.zip$'
                    ],
            'X86': ['^HUAWEI_SSD_Driver_6.0.2.7.zip$',
                    '^HUAWEI_SSD_Tool_6.0.2.7.zip$',
                    '^ES3000_V5_Firmware_3253.zip$'
                    ]
        },
        'hi1822': {
            'ARM': ['^IN500_solution_[a-zA-Z0-9.]+.zip$'],
            'X86': ['^IN500_solution_[a-zA-Z0-9.]+.zip$'],
        },
        'cx4': {
            'ARM': [
                '^MLNX_OFED_LINUX-4.7-3.2.9.0-euleros2.0sp8-aarch64.tgz$'],
            'X86': ['^MLNX_OFED_LINUX-4.7-3.2.9.0-rhel7.5-x86_64.tgz$']
        },
        'cx5': {
            'ARM': [
                '^MLNX_OFED_LINUX-4.7-3.2.9.0-euleros2.0sp8-aarch64.tgz$'],
            'X86': ['^MLNX_OFED_LINUX-4.7-3.2.9.0-rhel7.5-x86_64.tgz$']
        },
        'raid': {
            'ARM': ['^FusionServer iDriver-CentOS7.5-Driver-V101.zip$'],
            'X86': ['^FusionServer iDriver-CentOS7.5-Driver-V101.zip$']
        }
    }

    RAID_RPM = {
        '3408': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3416': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3508': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3008': 'RAID-3008IR_3008IT_3408IT_3416IT-CentOS7.5-mpt3sas-27.00.00.00-1-x86_64.rpm'
    }

    SEPARATED_SERVER_MODEL = {'X86': ['2288HV5', '5288V5'],
                              'ARM': ['TaiShan200-2280',
                                      'TaiShan200K-2280',
                                      'TaiShan200-5280',
                                      'TaiShan100-2280',
                                      'TaiShan100-5280'
                                      ]
                              }

    STORAGE_PACKAGES_PATTERN = [
        {
            "FusionStorage_OS-x86_64":
                "^(FusionStorage_OS[-_]([V0-9._]|SP)+-x86_64-dvd.iso)$"
        },
        {
            "FusionStorage_OS-aarch64":
                "^(FusionStorage_OS[-_]([V0-9._V]|SP)+-aarch64-dvd.iso)$"
        },
        {
            "OceanStor-Pacific_8.1.5*_OS*x86-64*.tgz":
                "^(OceanStor-Pacific_8.1.5([0-9._]|SPH|SPC|RC|HP)*_OS(x86-64|_|[0-9.]|SP|-)+.tgz)$"
        },
        {
            "OceanStor-Pacific_8.1.5*_OS*aarch64*.tgz":
                "^OceanStor-Pacific_8.1.5([0-9._]|SPH|SPC|RC|HP)*_OS([0-9.]|SP|_|-|aarch64)+.tgz$"
        },
        {
            "OceanStor-Pacific_8.1.*_UVP.tar.gz":
                "^OceanStor-Pacific_8.([0-9.]|SPH|SPC|RC|HP)+_UVP.tar.gz$"
        },
        {
            "OceanStor-Pacific_8.1.*.tar.gz":
                "^(OceanStor-Pacific|Distributed-Storage)_8.([0-9._]|SPC|RC|HP)+.tar.gz$"
        },
        {
            "OceanStor-Pacific_8.1.5*_PANGEA-SmartPkg.zip": "^OceanStor-Pacific_8.1.5.*_PANGEA-SmartPkg.zip$"
        }
    ]

    ONE_STEP_UPGRADE = {
        "basic_pkg": "(OceanStor-Pacific|Distributed-Storage)_8.1.5([0-9.]|SPC|RC|HP)*.tar.gz$",
        "hot_pkg": "^(OceanStor-Pacific|Distributed-Storage)_8.1.5.SPH[0-9]+.tar.gz$"
    }

    HOT_PATCH_PATTERN = "^(OceanStor-Pacific|Distributed-Storage)_8.+SPH[0-9]+.tar.gz$"

    QUORUM_SERVER_PKG = {"OceanStor-Pacific_8.*_QuorumServer.tar.gz": "^OceanStor-Pacific_8(.*)_QuorumServer.tar.gz$"}

    # 硬盘厂商与管控面定义的厂商ID映射关系
    VENDOR_ID_MAP = {
        "UNKNOWN": 0,  # 未知厂商
        "SEAGATE": 1,  # 希捷
        "WDC": 2,  # 西数
        "TOSHIBA": 3,  # 东芝
        "HUAWEI": 4,  # 华为厂商
        "HGST": 5,  # 昱科环球
        "HP": 6,  # 惠普厂商
        "ATA": 7,  # 普通ATA硬盘
        "HITACHI": 8,  # 日立厂商
        "WD": 9,  # 西数厂商
        "IBM_ESXS": 10,  # 西数厂商
        "LSI": 11,  # LSI 厂商
        "SAMSUNG": 12,  # SAMSUNG厂商
        "INTEL": 13,  # INTEL厂商
        "WHITE_VENDOR": 15  # 白牌盘厂商
    }

    # 引入的NVME缓存厂商ID与名称映射表
    NVME_ID_MAP = {
        VENDOR_ID_MAP.get("HUAWEI"): "es3000",
        VENDOR_ID_MAP.get("INTEL"): "intel_p4610",
        VENDOR_ID_MAP.get("WHITE_VENDOR"): "white_label_A28",
        VENDOR_ID_MAP.get("SAMSUNG"): "samsung_nvme"
    }

    NVME_TYPE_CONDITION = {
        "es3000": {
            "cmd": "lspci -n | grep -E '19e5:0123|19e5:3714|19e5:3754'",
            "pattern": 'last cmd result: 0'},
        "intel_p4610": {
            "cmd": "lspci -n | grep '8086:0a54'",
            "pattern": 'last cmd result: 0'},
        "white_label_A28": {
            "cmd": "lspci -n | grep -E '1e81:1203|1cc4:1203|1e3b:1098'",
            "pattern": 'last cmd result: 0'},
        'samsung_nvme': {
            "cmd": "lspci -n | grep -E '144d:a822|144d:a824'",
            "pattern": 'last cmd result: 0'}
    }

    OCEAN_STORAGE_BLOCK_BOM_CODES = {
        "Standard": ['LFSSTDAVBCAPSATA02', 'LFSSTDAVBCAPSAS02', 'LFSSTDAVBCAPSSD02',
                     'LFSSTDAVBCAPSATA01', 'LFSSTDAVBCAPSAS01', 'LFSSTDAVBCAPSSD01',
                     'LFS0STEL01'],
        "Advanced": ['LFSADAVBCAPSATA03', 'LFSADAVBCAPSAS03', 'LFSADAVBCAPSSD03',
                     'LFSADAVBCAPSATA02', 'LFSADAVBCAPSAS02', 'LFSADAVBCAPSSD02',
                     'LFS0PLEL01', 'LFS0ADEL01']
    }
    WHITESPACE = '\t\v\f'
    PUNCTUATION = r""""#%'()*+,-./:=?@[]^_{}~"""
    ACCOUNT_ILLEGAL_CHARACTERS = r"[\\;‘|&><!$]+"  # 813沙箱需求，nms安全校验，防注入,root密码不能包含这些特殊字符
    ACCOUNT_LEGAL_CHARACTERS_LIST = ["[a-z]", "[A-Z]", "[\d]", "[~@#%^*()\-_=+\[{}\]:'\"./?]"]
    PRINTABLE = string.digits + string.ascii_letters + PUNCTUATION + WHITESPACE
    ACCOUNT_WHITE_LIST = ['bin', 'ftp', 'nobody', 'daemon', 'adm',
                          'lp', 'sync', 'shutdown', 'halt', 'mail',
                          'operator', 'games', 'dbus', 'polkitd',
                          'tss', 'systemd-coredump', 'systemd-resolve',
                          'unbound', 'systemd-timesync', 'rpc',
                          'systemd-network', 'ntp', 'sshd', 'chrony',
                          'omm', 'ommdba', 'oam', 'fdadmin', 'dmdbadmin',
                          'replication', 'eds', 'persistence', 'saslauth',
                          'storage', 'rpcuser', 'dhcpd', 'named', 'fdsa',
                          'ha_omm', 'oceanstor_agent', 'dsware', 'fsadmin',
                          'ibc_os_hs']

    REP_METADATA_SUPPORT_DISK_TYPE = ["sas_hdd", "ssd", "nvme"]
    BASIC_SERVICE_METADATA_SUPPORT_DISK_TYPE = ["sas_hdd", "sata_hdd", "ssd", "nvme"]
    LLD_DISK_TYPE = ["sas_hdd", "sata_hdd", "ssd", "nvme"]
    SUPPORT_CACHE_TYPE = ['ssd_card', 'ssd_disk', 'none']
    STORAGE_TYPE_MAP = {'sas_hdd': 'sas_disk', 'sata_hdd': 'sata_disk', 'ssd': 'ssd_disk', 'nvme': 'ssd_card'}
    PRODUCT_TO_LLD_MAP = {'sas_disk': 'sas_hdd', 'sata_disk': 'sata_hdd', 'ssd_disk': 'ssd', 'ssd_card': 'nvme'}
    KERNEL_DIC = {'x86_64': {'management': "4.18.0-147.5.2.[a-z0-9._]+.x86_64",
                             'business': "4.18.0-147.5.2.[a-z0-9._]+.eulerosv2r10.x86_64"},
                  'aarch64': {'management': "4.19.90-vhulk([a-z0-9._])+.eulerosv2r10.aarch64",
                              'business': "4.19.90-vhulk[a-z0-9._]+.eulerosv2r10.aarch64"}
                  }

    NVME_NAME = {'x86_64': ['Huawei ES3000 NVME Tool for FusionStorage_x86',
                            'Huawei ES3000 NVME Driver for FusionStorage_x86'],
                 'aarch64': ['Huawei ES3000 NVME Tool for FusionStorage_arrch64',
                             'Huawei ES3000 NVME Driver for FusionStorage_aarch64']}

    LLD_DOWN_LIST_X86 = ['1288HV5', '2288HV5', '2288HV6', '2288XV5', '2488HV5', '2488V5', '5288V3', '5288V5',
                         '5288XV5', '5885HV5', 'E9000CH225V5', 'RH2288HV3', 'X6800XH628V5', 'GENERAL',
                         'Pacific9520', 'Pacific9540', 'Pacific9920']

    query_raid_cmd = {
        '3008': 'rpm -qa | grep -i mpt3sas',
        '3408': 'rpm -qa | grep kmod-megaraid',
        '3416': 'rpm -qa | grep kmod-megaraid',
        '3508': 'rpm -qa | grep kmod-megaraid'
    }
    delete_raid_cmd = {
        '3008': 'kmod-mpt3sas',
        '3408': 'kmod-megaraid_sas',
        '3416': 'kmod-megaraid_sas',
        '3508': 'kmod-megaraid_sas'
    }


class PostCheckStatus(object):
    CHECKING = 0
    SUCCESSED = 1
    FAILERED = 2


class ErrorInfo(object):
    OK = 0
    ERROR_IS_MASTER = 2
    ERROR_IS_STANDBY = 3
    ERROR_PACKAGE_DIR_NOT_EXIST = 4
    ERROR_PACKAGE_DIR_IS_EXIST = 5
    ERROR_SAME_VERSION = 6


class ServerList(object):
    """
    device type  constant
    updated in 2018-2-24 14:21:14
    """
    TaiShan2280 = "TaiShan100-2280"
    TaiShan2280v2 = "TaiShan200-2280"
    TaiShan200k_v2 = "TaiShan200K-2280"
    TaiShan5280 = "TaiShan100-5280"
    TaiShan5280v2 = "TaiShan200-5280"
    TaiShan2280_LIST = [TaiShan2280, TaiShan2280v2, TaiShan200k_v2]
    TaiShan5280_LIST = [TaiShan5280, TaiShan5280v2]


class PangeaConstant:
    SAS_DRIVER_NAME = "PANGEA_V600R007C00_Euler_SAS_for_DistributedStorage"
    PRODUCT_TYPE_CMD = "dmidecode -t 2 | grep 'Product Name' -i | awk -F ': ' '{print $2}'"
    SAS_DRIVER_TAI_SHAN_200_WHITELIST = ["BC82AMDQ", "BC82AMDDR", "BC82AMDDRA", "BC82AMDGK", "BC82AMDDA", "BC82AMDDC"]


class NodeRole:
    COMPUTE_ROLE = "compute"
    STORAGE_ROLE = "storage"
    MANAGEMENT_ROLE = "management"


class DeployType:
    CONVERGE = "converge"
    SEPARATE = "separate"


class ComponentName:
    DEPLOY = "DistributedStorage"
    REPLICATION = "FusionStorageBlockReplication"


class WeakPasswordList:
    BLACKLIST = [
        "!!Huawei", "!akira%chaichai",
        "#a$*u* t!h", "$1$wn7vr$q",
        "$5$huawei$", "*&16_@At#",
        "/EzFp+2%r6@IxSCv", "@HuaweiHgw",
        "@S#_U!T$V&C*0(0)%1^R&78D", "@Wv1X!1P3",
        "00000a", "12wedfvb09iuhgvcz",
        "1qwe32!QWE#@", "2012PSNetView",
        "321_emegnahC", "3er4#ER$3er4#ER$12",
        "4a747f28cb32100b",
        "4r5t$R%T4r5t$R%T12",
        "5Bjiw_JB5",
        "6b6K6Xk]Zws)+[Y5",
        "6SSfJezESqjr14Me",
        "8@o6EuxWqwJf2Y47",
        "9061csl",
        "9061cslX",
        "9061cslX@",
        "9061mgw",
        "9061mgwX",
        "9061mgwX@",
        "A#dpftp_1",
        "A#dpmdb_1",
        "A#dpuoa_1",
        "A#udit_01",
        "a123456",
        "A2d@min!_",
        "Aa123456",
        "abc123",
        "Abc1234%",
        "Abc1234%$9876zyX",
        "Access@7*24",
        "Admin!123",
        "Admin@123",
        "Admin@1234",
        "Admin@7*2",
        "admin@86",
        "admin@Ats9900?",
        "admin@DNS9816",
        "Admin@huawei",
        "admin@huawei.com",
        "Admin@revive",
        "Admin@storage",
        "Admin_01",
        "Admin_12#",
        "Admin_123",
        "Admin_1234#",
        "Admin_1243",
        "Admin1@BCM",
        "admin123",
        "Admin123!",
        "admin123@CallEnabler",
        "admin123Q!",
        "Admin23@#",
        "adminAdmin23@#",
        "adminHW",
        "admintelecom",
        "aep_On_Install_123",
        "Am0s@gent",
        "aO9S#oR@!k",
        "aomsbo_On_Install_123",
        "AOSV100R002",
        "apimg_On_Install_123",
        "APMadmin@123",
        "AqkxNwgj@huawei99",
        "Ardb_001",
        "Arshar_1",
        "Atae1234",
        "B#dihm_01",
        "B#illdb_1",
        "B#illhm_123",
        "B#illmg_1",
        "B#llftp_1",
        "B#lluoa_1",
        "B#mduoa_1",
        "B#mftp_01",
        "B#mpapp_1",
        "B#mpdb_01",
        "B#mpftp_1",
        "B#mpsyn_1",
        "B#mpuoa_1",
        "B#muoa_01",
        "BCM@GaussDB123",
        "bdiApps0",
        "BDIOra00",
        "BGq98Zoo@63DOciX",
        "Bigdata123@",
        "Bill_001",
        "BK3l0c36lF3PkL1x",
        "Bm_00001",
        "bmeB4000",
        "bmeB5000",
        "BMEIMPL@YYYYMMDD",
        "Bmpapp_1Bmpapp_1",
        "bmu_hss",
        "BT%qQ^9X",
        "C#bpadp_1",
        "C#bpapp_1",
        "C#bpftp_1",
        "C#bpmdb_1",
        "C#bpmuo_1",
        "C#bpuoa_1",
        "C#bsadm_1",
        "C#dr2db_1",
        "C#drftp_1",
        "C#drhm_123",
        "C#druoa_1",
        "C14#e4TM",
        "C1Ja6F4gM2e_Lb3s",
        "c8$d+S9Q[#n!)v&c",
        "CAAS_OMP9360",
        "cce2OMUrest600@HW",
        "CCN4fma2_dbpd0$",
        "Cdr_0001",
        "cej_Apps0cej_Apps0",
        "cgp data2@HW",
        "Change_Me",
        "Changeme",
        "Changeme@123",
        "ChangeMe@123456",
        "Changeme_029",
        "Changeme_123",
        "Changeme_12345",
        "Changeme_1234567890",
        "Changeme123",
        "Changemeacs_635241",
        "Changemegvn_635241",
        "Changemenf_635241",
        "Changemepol_635241",
        "charging_On_Install_123",
        "Cloud12#$",
        "CloudService@123!",
        "Cmpapp12!",
        "CNCare2019%@!",
        "cnp123@HW",
        "cnp200@cspos@HW",
        "cnp200@cspPaaS",
        "cnp200@HW",
        "cnp200@HWomu800@HW",
        "cps_0001",
        "cps123",
        "cps200@HW",
        "Crh_0001",
        "Cs_00001",
        "CSP@gaussdb@2017",
        "Cspdbg@2017",
        "Cspdbr@2017",
        "cti-1234",
        "Cxp_0001",
        "D#eploy_1",
        "D4I$awOD7k",
        "data1@HW",
        "data2@HW",
        "dbChangeMe@123456",
        "dbomMql_17itiADb",
        "Dcdb_001",
        "Dcnsj98%^",
        "Dcshar_1",
        "Dds_1234",
        "Derby123",
        "Df_app12",
        "Dg_00001",
        "Dis_13579",
        "Dis_13579Dis_13579",
        "Dmkadmin12#$",
        "dsbo_On_Install_123",
        "Dsdp@12345",
        "DSDP@12345!",
        "DSDPamg_1qaz2wsx",
        "DSDPchg_1qaz2wsx",
        "DSDPitaptl_1qaz2wsx",
        "DSDPmdp_1qaz2wsx",
        "DSDPoper_1qaz2wsx",
        "DSDPord_1qaz2wsx",
        "DSDPpay_1qaz2wsx",
        "DSDPpro_1qaz2wsx",
        "DSDPrem_1qaz2wsx",
        "DSDPsub_1qaz2wsx",
        "DSDPupm_1qaz2wsx",
        "DSDPZookeeper@1q",
        "DSSPamg_1qaz2wsx",
        "E#drhis_1",
        "E#druoa_1",
        "E#tl_0001",
        "E#tlftp_1",
        "E#tluoa_1",
        "Easyms_1",
        "Edr_0001",
        "eh_Apps0eh_Apps0",
        "ei*b+@b#6Nh(tS1j",
        "em_Apps0em_Apps0",
        "Eo_00001",
        "er_Apps0er_Apps0",
        "Errfil!2",
        "eSight@123",
        "EWg)(!!1",
        "eWindCloud",
        "expert@cnp200@HW",
        "eyf_Apps0eyf_Apps0",
        "F#iclie_1",
        "F1_00001",
        "Fems@4321",
        "Ftp12345",
        "FusionSphere123",
        "G#mdb_001",
        "GalaxManager7!",
        "gaussdb@123",
        "Gaussdba@Mpp",
        "gcGe_28#F@k83cJk",
        "Genera_1",
        "Go_00001",
        "gridOs_123",
        "GrUB1@ATCA",
        "GrUB2@SOFT",
        "Gsdba@123$",
        "guestX",
        "gW@xtsGyvz9DxAWq",
        "gwca2017@HW",
        "H#uawei_1",
        "H#uawei123",
        "Hacs@123",
        "Hbase@123",
        "Hdfs@123",
        "Hk%w-!d@8Ve)qH6p",
        "hlrhlrv9",
        "Hs23_rt74",
        "hsQ7VX^m#Cjoae(y",
        "Huawei#12",
        "Huawei#123",
        "Huawei@.123",
        "huawei@123",
        "Huawei@123456789",
        "Huawei@2009",
        "Huawei@2019",
        "Huawei@CLOUD8",
        "Huawei@CLOUD8!",
        "huawei_1008",
        "Huawei_123",
        "Huawei12#$",
        "huawei123",
        "Huawei123@MuHS#A195N",
        "Huawei123@R3ZhjAgE6X",
        "Huawei123@Vdj5F3O#YI",
        "Huawei2019QWERT#$",
        "Huawei2019ZXCVB#$",
        "Huaweiecm2102",
        "HuaweiEncryption_123",
        "HuaweiETL2015",
        "Huaweiftps2102#",
        "Huaweimm_1314",
        "Huaweinetview2102!",
        "Hw!Sec1#_Admin",
        "HW@_77wa",
        "hwbs@com",
        "HWbss23%",
        "hwDB_1234",
        "HWeiRTN",
        "hwosta2.0",
        "HWps123+",
        "Hwrbt_123",
        "I#nv_0001",
        "I#nvftp_1",
        "I#nvmdb_1",
        "I#nvmuo_1",
        "I#nvuoa_1",
        "IaaS@CLOUD8!",
        "IaaS@DATABASE-CLOUD8!",
        "IaaS@DATABASE-PublicCLOUD9!",
        "IaaS@OS-CLOUD0!",
        "IaaS@OS-CLOUD8!",
        "IaaS@OS-CLOUD9!",
        "IaaS@OS-FSBCLOUD8!",
        "IaaS@OS-FSBDBACLOUD8!",
        "IaaS@PORTAL-CLOUD8!",
        "IaaS@PORTAL-CLOUD9!",
        "IaaS@SERVICE-CLOUD8!",
        "IaaS@SERVICE-CLOUD9!",
        "Ideploy_Derby123",
        "Ideploy_Ftp12345",
        "Ideploy_Sftp12345",
        "Ideploy_Sysadmin123",
        "Image0@Huawei123",
        "iMRMU2.0",
        "IMS_spg2800",
        "InvalidAuthInfo_InvalidAuthInfo_",
        "Invent_1",
        "IR2res@37$Adapter",
        "itabfm _On_Install_123",
        "itaBfm_On_Install_123",
        "Itadb@123",
        "itaportal _On_Install_123",
        "itaportal_On_Install_123",
        "itcbbS@EVP123ASD",
        "IVAS@Huawei_1234",
        "iZE3CNDq",
        "J2c55640@999301_",
        "J73aG#$Vax",
        "k3<N5\"_A:l4uYFu?",
        "kafka-1qaz@WSX",
        "Kspass_12",
        "L#icens_1",
        "L#ogcbp_1",
        "L#oguoa_1",
        "LbSynIf@C72#2016",
        "Lc_00001",
        "LdapChangeMe@123",
        "lem600@HW",
        "Licens_1",
        "Liiw@2Wb",
        "Log_0001",
        "LusXH_83576",
        "M#dbcbp_1",
        "M#dbinv_1",
        "m3i7N3yMiR1",
        "M8p#iYdQnpv$2u@z",
        "ManageOne12#$",
        "Manager@123",
        "Mapred@123",
        "Mdb_bil1",
        "Mdb_rou1",
        "Mdb_usr1",
        "mdp_On_Install_123",
        "Med_0001",
        "Meter@123",
        "Meterticket_6!",
        "MIIXvcNAQ@cCoII_XSDC",
        "Mj40NT_zNzMwMTgx",
        "mm_user@storage",
        "MOBILE OM",
        "Modify_key0",
        "ModifyMe_123",
        "Monitor@123",
        "MrB@!9p",
        "msqlOs_179itiADb",
        "mt2013@HW",
        "mt2013@HW;",
        "mt2017@cspos@HW",
        "myftp@123",
        "Mysql_01",
        "Nc_00001",
        "Netrix@Huawei",
        "NetViewCommon2012",
        "NFRoot.123",
        "O#racle_1",
        "OBSMemcache12#$",
        "OdpInner_3er4#ER$12",
        "Omm@1234",
        "ommHuawei@123",
        "omp@123!",
        "omu800@HW",
        "On_Install_12",
        "openasadminAdmin23@#",
        "Ops_1234#",
        "oracle_00001",
        "Oracle_omOrc_123",
        "Oracle_omOs_123",
        "oracleOs_123",
        "order_On_Install_123",
        "Osc@cso",
        "p~r $%i^vx",
        "paasSoft321",
        "Padmin12!",
        "Pass456$",
        "Password",
        "Password@123",
        "payment_On_Install_123",
        "pg_search_dn@123",
        "pgw#2013",
        "Pinter12",
        "Pmscer@2013",
        "Pmssys@2013",
        "Printer@123",
        "prm_On_Install_123",
        "Prmlic_1",
        "Promo@123",
        "Proton_4spg",
        "PSVNtest2019@hw",
        "Public",
        "PXU9@ctuNov10!",
        "PXU9@ctuNov17!",
        "QAZ2wsx@123!",
        "qpsubm_Apps0qpsubm_Apps0",
        "r1+@z(9Ho3b",
        "Rc_00001",
        "RCS9880_ideploy",
        "RCS9880_sdu",
        "REDIS@B2B_HWsdp-2015",
        "redisdb@dbuser@Cspdbr@2017",
        "role#Huawei",
        "Root_001",
        "rootMql_17itiADb",
        "rootOs_123",
        "rplMql_179itiADb",
        "rtdWebrtd",
        "rtnuser@HW",
        "S#ee_0001",
        "S#msload_1",
        "S#ysomc_1",
        "Sc_00001",
        "secOrc_179itiADb",
        "sek12345",
        "SG7000",
        "Sncfo12@#*",
        "soap800@HW",
        "Spark@123",
        "Spg800?",
        "sps600@HW",
        "SSHAdmin_HW",
        "sshusrOs_123",
        "stemsyOrc_179iti",
        "svcOac_179itiADb",
        "sw$24Is@W9Pe#S4s",
        "Sy@1#3!5-OC6",
        "sys data1@HW",
        "Sysadmin@2009",
        "Sysdb_01",
        "Sysman123",
        "T#m_5432",
        "T#mload_1",
        "t_authoroperatorinfo",
        "Tc_00001",
        "Tellin_aaa1",
        "Test_key12345",
        "thirdcn_On_Install_123",
        "tms1@cnpWSX",
        "tNsZg@123",
        "Topus@789)",
        "Trace$Fba$db3@2C6#4bG3",
        "Traffic_013579",
        "tusfbnjoh_Apps0tusfbnjoh_Apps0",
        "U#oa_0001",
        "U#srcbp_1",
        "U#sruoa_1",
        "U0@agEnt",
        "U0A@gent",
        "UCPSW2008",
        "udaApps0Huawei123#",
        "Uds6200!_12345",
        "UGW9811admin",
        "UGW9811adminhwbs@com",
        "Ulrad#9n",
        "Update@7*24",
        "Uscdb_sys0",
        "Uscdb_sys1",
        "User_hw123",
        "usr@86",
        "Usr_0001",
        "Ussd123",
        "Uvcdb_01",
        "UVP_2012",
        "V#cpapp_1",
        "V#cpuoa_1",
        "V#mpapp_1",
        "V#mpuoa_1",
        "vBlUSqMN3VQ1VjBj",
        "vbpqe_Apps0vbpqe_Apps0",
        "vbpqu_Apps0vbpqu_Apps0",
        "Vcpdb_01",
        "veb_Apps0veb_Apps0",
        "VI2018%@!",
        "video_rbtdb",
        "Visit@7*24",
        "VIWMs2019%@!",
        "Vmpdb_01",
        "vnIaaS@PORTAL-CLOUD9!",
        "vrpv8@huawei.com",
        "vtf_Apps0vtf_Apps0",
        "vW+64#u9",
        "w0KLJ4xEgZ5XdBvF",
        "WBaESpPNNOKEJsIK",
        "wetallOrc_179iti",
        "wIs3#KqP6M$i@8sU",
        "Work@7*24",
        "workssys1qaz@WSX",
        "www.huawei.com",
        "WWW@HUAWEI",
        "wy3oo&w4",
        "x86bpw",
        "xu2NDe2hIOClL8C5",
        "Y7xohbheY!",
        "z(7%Uk@sd04NiE*b!Q2w#E8r",
        "zieTmnYtSId0zCKX",
        "Zjg5MjIwNWE3ZTU2",
        "Zshw3@DH",
        "ZyJdJdYwDl,@18y$",
        "Huawei@123",
        "OBSCharging8800!",
        "Storage@21st",
        "IaaS@NODEMANAGER-",
        "PublicCLOUD9!",
        "Admin@9000",
    ]