/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ConcurrentProgressManager;
import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.utils.SecureObjectInputStream;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.MonitorableProgressListener;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DownloadResumableClient {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");
    private AbstractClient obsClient;

    public DownloadResumableClient(AbstractClient obsClient) {
        this.obsClient = obsClient;
    }

    public DownloadFileResult downloadFileResume(DownloadFileRequest downloadFileRequest) {
        ServiceUtils.asserParameterNotNull(downloadFileRequest, "DownloadFileRequest is null");
        ServiceUtils.asserParameterNotNull(downloadFileRequest.getBucketName(), "the bucketName is null");
        String key = downloadFileRequest.getObjectKey();
        ServiceUtils.asserParameterNotNull2(key, "the objectKey is null");
        if (downloadFileRequest.getDownloadFile() == null) {
            downloadFileRequest.setDownloadFile(key);
        }
        if (downloadFileRequest.isEnableCheckpoint() && (downloadFileRequest.getCheckpointFile() == null || downloadFileRequest.getCheckpointFile().isEmpty())) {
            downloadFileRequest.setCheckpointFile(downloadFileRequest.getDownloadFile() + ".downloadFile_record");
        }
        try {
            return this.downloadCheckPoint(downloadFileRequest);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw ServiceUtils.changeFromServiceException(e);
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    private DownloadFileResult downloadCheckPoint(DownloadFileRequest downloadFileRequest) throws Exception {
        ObjectMetadata objectMetadata = this.getObjectMetadata(downloadFileRequest);
        DownloadFileResult downloadFileResult = new DownloadFileResult();
        downloadFileResult.setObjectMetadata(objectMetadata);
        if (objectMetadata.getContentLength() == 0L) {
            ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getTempDownloadFile());
            ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getCheckpointFile());
            File dfile = new File(downloadFileRequest.getDownloadFile());
            if (!dfile.getParentFile().mkdirs() && log.isWarnEnabled()) {
                log.warn("create parent directory failed.");
            }
            new RandomAccessFile(dfile, "rw").close();
            if (downloadFileRequest.getProgressListener() != null) {
                downloadFileRequest.getProgressListener().progressChanged(new DefaultProgressStatus(0L, 0L, 0L, 0L, 0L));
            }
            return downloadFileResult;
        }
        DownloadCheckPoint downloadCheckPoint = new DownloadCheckPoint();
        if (downloadFileRequest.isEnableCheckpoint()) {
            boolean needRecreate = false;
            try {
                downloadCheckPoint.load(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                needRecreate = true;
            }
            if (!needRecreate) {
                if (!(downloadFileRequest.getBucketName().equals(downloadCheckPoint.bucketName) && downloadFileRequest.getObjectKey().equals(downloadCheckPoint.objectKey) && downloadFileRequest.getDownloadFile().equals(downloadCheckPoint.downloadFile))) {
                    needRecreate = true;
                } else if (!downloadCheckPoint.isValid(downloadFileRequest.getTempDownloadFile(), objectMetadata)) {
                    needRecreate = true;
                } else if (downloadFileRequest.getVersionId() == null) {
                    if (downloadCheckPoint.versionId != null) {
                        needRecreate = true;
                    }
                } else if (!downloadFileRequest.getVersionId().equals(downloadCheckPoint.versionId)) {
                    needRecreate = true;
                }
            }
            if (needRecreate) {
                if (downloadCheckPoint.tmpFileStatus != null) {
                    ServiceUtils.deleteFileIgnoreException(downloadCheckPoint.tmpFileStatus.tmpFilePath);
                }
                ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getCheckpointFile());
                this.prepare(downloadFileRequest, downloadCheckPoint, objectMetadata);
            }
        } else {
            this.prepare(downloadFileRequest, downloadCheckPoint, objectMetadata);
        }
        DownloadResult downloadResult = this.download(downloadCheckPoint, downloadFileRequest);
        this.checkDownloadResult(downloadFileRequest, downloadCheckPoint, downloadResult);
        this.renameTo(downloadFileRequest.getTempDownloadFile(), downloadFileRequest.getDownloadFile());
        if (downloadFileRequest.isEnableCheckpoint()) {
            ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getCheckpointFile());
        }
        return downloadFileResult;
    }

    private void checkDownloadResult(DownloadFileRequest downloadFileRequest, DownloadCheckPoint downloadCheckPoint, DownloadResult downloadResult) throws Exception {
        for (PartResultDown partResult : downloadResult.getPartResults()) {
            if (!partResult.isFailed() || partResult.getException() == null) continue;
            if (!downloadFileRequest.isEnableCheckpoint()) {
                ServiceUtils.deleteFileIgnoreException(downloadCheckPoint.tmpFileStatus.tmpFilePath);
            } else if (downloadCheckPoint.isAbort) {
                ServiceUtils.deleteFileIgnoreException(downloadCheckPoint.tmpFileStatus.tmpFilePath);
                ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getCheckpointFile());
            }
            throw partResult.getException();
        }
    }

    private ObjectMetadata getObjectMetadata(DownloadFileRequest downloadFileRequest) {
        ObjectMetadata objectMetadata;
        try {
            GetObjectMetadataRequest request = new GetObjectMetadataRequest(downloadFileRequest.getBucketName(), downloadFileRequest.getObjectKey(), downloadFileRequest.getVersionId());
            request.setRequesterPays(downloadFileRequest.isRequesterPays());
            objectMetadata = this.obsClient.getObjectMetadata(request);
        }
        catch (ObsException e) {
            if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getTempDownloadFile());
                ServiceUtils.deleteFileIgnoreException(downloadFileRequest.getCheckpointFile());
            }
            throw e;
        }
        return objectMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTo(String tempDownloadFilePath, String downloadFilePath) throws IOException {
        File tmpfile = new File(tempDownloadFilePath);
        File downloadFile = new File(downloadFilePath);
        if (!tmpfile.exists()) {
            throw new FileNotFoundException("tmpFile '" + tmpfile + "' does not exist");
        }
        if (downloadFile.exists() && !downloadFile.delete()) {
            throw new IOException("downloadFile '" + downloadFile + "' is exist");
        }
        if (tmpfile.isDirectory() || downloadFile.isDirectory()) {
            throw new IOException("downloadPath is a directory");
        }
        boolean renameFlag = tmpfile.renameTo(downloadFile);
        if (!renameFlag) {
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                int length;
                input = new FileInputStream(tmpfile);
                output = new FileOutputStream(downloadFile);
                byte[] buffer = new byte[8192];
                while ((length = ((InputStream)input).read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, length);
                }
            }
            finally {
                block22: {
                    block21: {
                        if (null != input) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (IOException e) {
                                if (!log.isWarnEnabled()) break block21;
                                log.warn("close failed.", e);
                            }
                        }
                    }
                    if (null != output) {
                        try {
                            ((OutputStream)output).close();
                        }
                        catch (IOException e) {
                            if (!log.isWarnEnabled()) break block22;
                            log.warn("close failed.", e);
                        }
                    }
                }
            }
            if (!tmpfile.delete()) {
                if (log.isErrorEnabled()) {
                    log.error("the tmpfile '" + tmpfile + "' can not delete, please delete it to ensure the download finish.");
                }
                throw new IOException("the tmpfile '" + tmpfile + "' can not delete, please delete it to ensure the download finish.");
            }
        }
    }

    private DownloadResult download(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws Exception {
        ArrayList<PartResultDown> taskResults = new ArrayList<PartResultDown>();
        DownloadResult downloadResult = new DownloadResult();
        ArrayList<Future<PartResultDown>> futures = new ArrayList<Future<PartResultDown>>();
        LinkedList<Object> unfinishedTasks = new LinkedList<Object>();
        long transferredBytes = 0L;
        for (int i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
            DownloadPart downloadPart = downloadCheckPoint.downloadParts.get(i);
            if (!downloadPart.isCompleted) {
                Task task = new Task(i, "download-" + i, downloadCheckPoint, i, downloadFileRequest, this.obsClient);
                unfinishedTasks.add(task);
                continue;
            }
            transferredBytes += downloadPart.end - downloadPart.offset + 1L;
            taskResults.add(new PartResultDown(i + 1, downloadPart.offset, downloadPart.end));
        }
        ConcurrentProgressManager progressManager = null;
        if (null != downloadFileRequest.getProgressListener()) {
            progressManager = new ConcurrentProgressManager(downloadCheckPoint.objectStatus.size, transferredBytes, downloadFileRequest.getProgressListener(), downloadFileRequest.getProgressInterval() > 0L ? downloadFileRequest.getProgressInterval() : 102400L);
        }
        ExecutorService service = Executors.newFixedThreadPool(downloadFileRequest.getTaskNum());
        for (Task task : unfinishedTasks) {
            task.setProgressManager(progressManager);
            futures.add(service.submit(task));
        }
        service.shutdown();
        List<Runnable> notStartTasks = null;
        try {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            notStartTasks = service.shutdownNow();
            Thread.currentThread().interrupt();
            throw interruptedException;
        }
        finally {
            if (null != notStartTasks && log.isWarnEnabled()) {
                log.warn("there are still " + notStartTasks.size() + " tasks not started for request : " + downloadFileRequest);
            }
        }
        for (Future future : futures) {
            PartResultDown tr = (PartResultDown)future.get();
            taskResults.add(tr);
        }
        downloadResult.setPartResults(taskResults);
        if (progressManager != null) {
            ((ProgressManager)progressManager).progressEnd();
        }
        return downloadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(DownloadFileRequest downloadFileRequest, DownloadCheckPoint downloadCheckPoint, ObjectMetadata objectMetadata) throws Exception {
        downloadCheckPoint.bucketName = downloadFileRequest.getBucketName();
        downloadCheckPoint.objectKey = downloadFileRequest.getObjectKey();
        downloadCheckPoint.versionId = downloadFileRequest.getVersionId();
        downloadCheckPoint.downloadFile = downloadFileRequest.getDownloadFile();
        ObjectStatus objStatus = new ObjectStatus();
        objStatus.size = objectMetadata.getContentLength();
        objStatus.lastModified = objectMetadata.getLastModified();
        objStatus.etag = objectMetadata.getEtag();
        downloadCheckPoint.objectStatus = objStatus;
        downloadCheckPoint.downloadParts = this.splitObject(downloadCheckPoint.objectStatus.size, downloadFileRequest.getPartSize());
        File tmpfile = new File(downloadFileRequest.getTempDownloadFile());
        if (null != tmpfile.getParentFile() && !tmpfile.getParentFile().mkdirs() && log.isWarnEnabled()) {
            log.warn("create parent directory for tempfile failed.");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(tmpfile, "rw");
            randomAccessFile.setLength(downloadCheckPoint.objectStatus.size);
        }
        finally {
            block13: {
                if (null != randomAccessFile) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block13;
                        log.warn("close failed.", e);
                    }
                }
            }
        }
        downloadCheckPoint.tmpFileStatus = new TmpFileStatus(downloadCheckPoint.objectStatus.size, new Date(tmpfile.lastModified()), downloadFileRequest.getTempDownloadFile());
        if (downloadFileRequest.isEnableCheckpoint()) {
            try {
                downloadCheckPoint.record(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                ServiceUtils.deleteFileIgnoreException(tmpfile);
                throw e;
            }
        }
    }

    private ArrayList<DownloadPart> splitObject(long size, long partSize) {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        long piece = size / partSize;
        if (piece >= 10000L) {
            partSize = size % 10000L == 0L ? size / 10000L : size / 10000L + 1L;
        }
        long offset = 0L;
        int i = 0;
        while (offset < size) {
            DownloadPart downloadPart = new DownloadPart();
            downloadPart.partNumber = i;
            downloadPart.offset = offset;
            downloadPart.end = offset + partSize > size ? size - 1L : offset + partSize - 1L;
            parts.add(downloadPart);
            offset += partSize;
            ++i;
        }
        return parts;
    }

    static class DownloadResult {
        private List<PartResultDown> partResults;

        DownloadResult() {
        }

        public List<PartResultDown> getPartResults() {
            return this.partResults;
        }

        public void setPartResults(List<PartResultDown> partResults) {
            this.partResults = partResults;
        }
    }

    static class PartResultDown {
        private int partNumber;
        private long start;
        private long end;
        private boolean isFailed;
        private Exception exception;

        public PartResultDown(int partNumber, long start, long end) {
            this.partNumber = partNumber;
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public int getpartNumber() {
            return this.partNumber;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public void setFailed(boolean failed) {
            this.isFailed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class DownloadPart
    implements Serializable {
        private static final long serialVersionUID = 961987949814206093L;
        public int partNumber;
        public long offset;
        public long end;
        public boolean isCompleted;

        DownloadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.partNumber;
            result = 31 * result + (this.isCompleted ? 0 : 8);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            DownloadPart downloadPart;
            if (obj == null) {
                return false;
            }
            return obj instanceof DownloadPart && (downloadPart = (DownloadPart)obj).hashCode() == this.hashCode();
        }

        public String toString() {
            return "DownloadPart [partNumber=" + this.partNumber + ", offset=" + this.offset + ", end=" + this.end + ", isCompleted=" + this.isCompleted + "]";
        }
    }

    static class TmpFileStatus
    implements Serializable {
        private static final long serialVersionUID = 4478330948103112660L;
        public long size;
        public Date lastModified;
        public String tmpFilePath;

        public TmpFileStatus(long size, Date lastMoidified, String tmpFilePath) {
            this.size = size;
            this.lastModified = lastMoidified;
            this.tmpFilePath = tmpFilePath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (this.tmpFilePath == null ? 0 : this.tmpFilePath.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            TmpFileStatus tmpFileStatus;
            if (obj == null) {
                return false;
            }
            return obj instanceof TmpFileStatus && (tmpFileStatus = (TmpFileStatus)obj).hashCode() == this.hashCode();
        }
    }

    static class ObjectStatus
    implements Serializable {
        private static final long serialVersionUID = -6267040832855296342L;
        public long size;
        public Date lastModified;
        public String etag;

        ObjectStatus() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.etag == null ? 0 : this.etag.hashCode());
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            ObjectStatus objectStatus;
            if (obj == null) {
                return false;
            }
            return obj instanceof ObjectStatus && (objectStatus = (ObjectStatus)obj).hashCode() == this.hashCode();
        }
    }

    static class DownloadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 2282950186694419179L;
        public int md5;
        public String bucketName;
        public String objectKey;
        public String versionId;
        public String downloadFile;
        public ObjectStatus objectStatus;
        public TmpFileStatus tmpFileStatus;
        ArrayList<DownloadPart> downloadParts;
        public volatile transient boolean isAbort = false;

        DownloadCheckPoint() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.downloadFile == null ? 0 : this.downloadFile.hashCode());
            result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.objectStatus == null ? 0 : this.objectStatus.hashCode());
            result = 31 * result + (this.tmpFileStatus == null ? 0 : this.tmpFileStatus.hashCode());
            result = 31 * result + (this.downloadParts == null ? 0 : this.downloadParts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            DownloadCheckPoint downloadCheckPoint;
            if (obj == null) {
                return false;
            }
            return obj instanceof DownloadCheckPoint && (downloadCheckPoint = (DownloadCheckPoint)obj).hashCode() == this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String checkPointFile) throws Exception {
            FileInputStream fileIn = null;
            ObjectInputStream in = null;
            try {
                fileIn = new FileInputStream(checkPointFile);
                in = new SecureObjectInputStream(fileIn);
                DownloadCheckPoint info = (DownloadCheckPoint)in.readObject();
                this.assign(info);
            }
            finally {
                block15: {
                    block14: {
                        if (null != in) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (!log.isWarnEnabled()) break block14;
                                log.warn("close failed.", e);
                            }
                        }
                    }
                    if (null != fileIn) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException e) {
                            if (!log.isWarnEnabled()) break block15;
                            log.warn("close failed.", e);
                        }
                    }
                }
            }
        }

        private void assign(DownloadCheckPoint info) {
            this.md5 = info.md5;
            this.downloadFile = info.downloadFile;
            this.bucketName = info.bucketName;
            this.objectKey = info.objectKey;
            this.versionId = info.versionId;
            this.objectStatus = info.objectStatus;
            this.tmpFileStatus = info.tmpFileStatus;
            this.downloadParts = info.downloadParts;
        }

        public boolean isValid(String tmpFilePath, ObjectMetadata objectMetadata) {
            if (this.md5 != this.hashCode()) {
                return false;
            }
            if (objectMetadata.getContentLength() != this.objectStatus.size || !objectMetadata.getLastModified().equals(this.objectStatus.lastModified) || !objectMetadata.getEtag().equals(this.objectStatus.etag)) {
                return false;
            }
            File tmpfile = new File(tmpFilePath);
            return this.tmpFileStatus.size == tmpfile.length();
        }

        public synchronized void update(int index, boolean completed, String tmpFilePath) throws IOException {
            this.downloadParts.get((int)index).isCompleted = completed;
            File tmpfile = new File(tmpFilePath);
            this.tmpFileStatus.lastModified = new Date(tmpfile.lastModified());
        }

        public synchronized void updateTmpFile(String tmpFilePath) throws IOException {
            File tmpfile = new File(tmpFilePath);
            this.tmpFileStatus.lastModified = new Date(tmpfile.lastModified());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void record(String checkPointFilePath) throws IOException {
            FileOutputStream fileOutStream = null;
            ObjectOutputStream objOutStream = null;
            this.md5 = this.hashCode();
            try {
                fileOutStream = new FileOutputStream(checkPointFilePath);
                objOutStream = new ObjectOutputStream(fileOutStream);
                objOutStream.writeObject(this);
            }
            finally {
                if (objOutStream != null) {
                    try {
                        objOutStream.close();
                    }
                    catch (Exception e) {
                        log.warn("close outputstrem failed.", e);
                    }
                }
                if (fileOutStream != null) {
                    try {
                        fileOutStream.close();
                    }
                    catch (Exception e) {
                        log.warn("close outputstrem failed.", e);
                    }
                }
            }
        }
    }

    static class Task
    implements Callable<PartResultDown> {
        private int id;
        private String name;
        private DownloadCheckPoint downloadCheckPoint;
        private int partIndex;
        private final DownloadFileRequest downloadFileRequest;
        private AbstractClient obsClient;
        private ProgressManager progressManager;

        public Task(int id, String name, DownloadCheckPoint downloadCheckPoint, int partIndex, DownloadFileRequest downloadFileRequest, AbstractClient obsClient) {
            if (null == downloadCheckPoint || null == downloadFileRequest || null == obsClient) {
                log.warn("some parameters is null. { " + downloadCheckPoint + ", " + downloadFileRequest + ", " + obsClient + " }");
                throw new IllegalArgumentException("some parameters is null.");
            }
            this.id = id;
            this.name = name;
            this.downloadCheckPoint = downloadCheckPoint;
            this.partIndex = partIndex;
            this.downloadFileRequest = downloadFileRequest;
            this.obsClient = obsClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public PartResultDown call() throws Exception {
            DownloadPart downloadPart = this.downloadCheckPoint.downloadParts.get(this.partIndex);
            PartResultDown tr = new PartResultDown(this.partIndex + 1, downloadPart.offset, downloadPart.end);
            if (this.downloadCheckPoint.isAbort) {
                tr.setFailed(true);
                return tr;
            }
            RandomAccessFile output = null;
            InputStream content = null;
            try {
                int bytesOffset;
                if (log.isDebugEnabled()) {
                    log.debug("start task : " + downloadPart.toString());
                }
                this.startOneTask(this.downloadFileRequest);
                output = new RandomAccessFile(this.downloadFileRequest.getTempDownloadFile(), "rw");
                output.seek(downloadPart.offset);
                GetObjectRequest getObjectRequest = this.createNewGetObjectRequest(this.downloadFileRequest, downloadPart);
                ObsObject object = this.obsClient.getObject(getObjectRequest);
                content = object.getObjectContent();
                if (this.progressManager != null) {
                    content = new ProgressInputStream(content, this.progressManager, false);
                }
                byte[] buffer = new byte[4096];
                while ((bytesOffset = content.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesOffset);
                }
                this.downloadCheckPoint.update(this.partIndex, true, this.downloadFileRequest.getTempDownloadFile());
            }
            catch (ObsException e) {
                if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                    this.downloadCheckPoint.isAbort = true;
                }
                this.signPartResultFailed(tr, e);
                if (log.isErrorEnabled()) {
                    log.error(String.format("Task %d:%s download part %d failed: ", this.id, this.name, this.partIndex), e);
                }
                this.finishOneTask(this.downloadFileRequest);
                this.closeResource(output);
                this.closeResource(content);
                if (log.isDebugEnabled()) {
                    log.debug("end task : " + downloadPart.toString());
                }
                if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
                this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                return tr;
            }
            catch (Exception e2) {
                this.signPartResultFailed(tr, e2);
                if (log.isErrorEnabled()) {
                    log.error(String.format("Task %d:%s download part %d failed: ", this.id, this.name, this.partIndex), e2);
                }
                this.finishOneTask(this.downloadFileRequest);
                this.closeResource(output);
                this.closeResource(content);
                if (log.isDebugEnabled()) {
                    log.debug("end task : " + downloadPart.toString());
                }
                if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
                {
                    catch (Throwable throwable) {
                        this.finishOneTask(this.downloadFileRequest);
                        this.closeResource(output);
                        this.closeResource(content);
                        if (log.isDebugEnabled()) {
                            log.debug("end task : " + downloadPart.toString());
                        }
                        if (!this.downloadFileRequest.isEnableCheckpoint()) throw throwable;
                        this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                        this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                        throw throwable;
                    }
                }
                this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                return tr;
            }
            this.finishOneTask(this.downloadFileRequest);
            this.closeResource(output);
            this.closeResource(content);
            if (log.isDebugEnabled()) {
                log.debug("end task : " + downloadPart.toString());
            }
            if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
            this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
            this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
            return tr;
        }

        private void closeResource(Closeable resource) {
            block3: {
                if (null != resource) {
                    try {
                        resource.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block3;
                        log.warn("close failed.", e);
                    }
                }
            }
        }

        private void finishOneTask(DownloadFileRequest downloadFileRequest) {
            if (null != downloadFileRequest.getProgressListener() && downloadFileRequest.getProgressListener() instanceof MonitorableProgressListener) {
                ((MonitorableProgressListener)downloadFileRequest.getProgressListener()).finishOneTask();
            }
        }

        private void startOneTask(DownloadFileRequest downloadFileRequest) {
            if (null != downloadFileRequest.getProgressListener() && downloadFileRequest.getProgressListener() instanceof MonitorableProgressListener) {
                ((MonitorableProgressListener)downloadFileRequest.getProgressListener()).startOneTask();
            }
        }

        private void signPartResultFailed(PartResultDown tr, Exception e) {
            tr.setFailed(true);
            tr.setException(e);
        }

        private GetObjectRequest createNewGetObjectRequest(DownloadFileRequest downloadFileRequest, DownloadPart downloadPart) {
            GetObjectRequest getObjectRequest = new GetObjectRequest(downloadFileRequest.getBucketName(), downloadFileRequest.getObjectKey(), downloadFileRequest.getVersionId());
            getObjectRequest.setRequesterPays(downloadFileRequest.isRequesterPays());
            getObjectRequest.setIfMatchTag(downloadFileRequest.getIfMatchTag());
            getObjectRequest.setIfNoneMatchTag(downloadFileRequest.getIfNoneMatchTag());
            getObjectRequest.setIfModifiedSince(downloadFileRequest.getIfModifiedSince());
            getObjectRequest.setIfUnmodifiedSince(downloadFileRequest.getIfUnmodifiedSince());
            getObjectRequest.setRangeStart(downloadPart.offset);
            getObjectRequest.setRangeEnd(downloadPart.end);
            getObjectRequest.setCacheOption(downloadFileRequest.getCacheOption());
            getObjectRequest.setTtl(downloadFileRequest.getTtl());
            return getObjectRequest;
        }

        public void setProgressManager(ProgressManager progressManager) {
            this.progressManager = progressManager;
        }
    }
}

