/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.IConvertor;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbstractNotification;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCorsRule;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.FunctionGraphConfiguration;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.Permission;
import com.obs.services.model.SSEAlgorithmEnum;
import com.obs.services.model.TopicConfiguration;
import com.obs.services.model.fs.FSStatusEnum;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import obs.shaded.com.jamesmurty.utils.XMLBuilder;

public abstract class V2BucketConvertor
implements IConvertor {
    @Override
    public String transBucketQuota(BucketQuota quota) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("Quota").elem("StorageQuota").text(String.valueOf(quota.getBucketQuota())).up();
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for storageQuota", e);
        }
    }

    @Override
    public String transBucketLoction(String location) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("CreateBucketConfiguration").elem("LocationConstraint").text(ServiceUtils.toValid(location));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String transBucketEcryption(BucketEncryption encryption) throws ServiceException {
        String algorithm = encryption.getSseAlgorithm().getCode();
        String kmsKeyId = "";
        if (algorithm.equals(SSEAlgorithmEnum.KMS.getCode())) {
            algorithm = "aws:" + algorithm;
            kmsKeyId = encryption.getKmsKeyId();
        }
        return this.transBucketEcryptionXML(algorithm, kmsKeyId);
    }

    protected String transBucketEcryptionXML(String algorithm, String kmsKeyId) throws FactoryConfigurationError {
        try {
            XMLBuilder builder = XMLBuilder.create("ServerSideEncryptionConfiguration").e("Rule").e("ApplyServerSideEncryptionByDefault");
            builder.e("SSEAlgorithm").t(algorithm);
            if (ServiceUtils.isValid(kmsKeyId)) {
                builder.e("KMSMasterKeyID").t(kmsKeyId);
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for bucketEncryption", e);
        }
    }

    @Override
    public String transBucketLoggingConfiguration(BucketLoggingConfiguration c) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("BucketLoggingStatus");
            if (c.isLoggingEnabled()) {
                GrantAndPermission[] grants;
                XMLBuilder enabledBuilder = builder.elem("LoggingEnabled");
                if (c.getTargetBucketName() != null) {
                    enabledBuilder.elem("TargetBucket").text(ServiceUtils.toValid(c.getTargetBucketName()));
                }
                if (c.getLogfilePrefix() != null) {
                    enabledBuilder.elem("TargetPrefix").text(ServiceUtils.toValid(c.getLogfilePrefix()));
                }
                if ((grants = c.getTargetGrants()).length > 0) {
                    XMLBuilder grantsBuilder = enabledBuilder.elem("TargetGrants");
                    this.transGrantsBuilder(grants, grantsBuilder);
                }
            }
            return builder.asString();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Failed to build XML document for BucketLoggingConfiguration", e);
        }
        catch (TransformerException e) {
            throw new ServiceException("Failed to build XML document for BucketLoggingConfiguration", e);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for BucketLoggingConfiguration", e);
        }
    }

    private void transGrantsBuilder(GrantAndPermission[] grants, XMLBuilder grantsBuilder) throws ParserConfigurationException, FactoryConfigurationError {
        for (GrantAndPermission gap : grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            if (permission == null) continue;
            XMLBuilder subBuilder = null;
            if (grantee instanceof CanonicalGrantee) {
                subBuilder = this.buildCanonicalGrantee(grantee);
            } else if (grantee instanceof GroupGrantee) {
                subBuilder = this.buildGroupGrantee(grantee);
            }
            if (subBuilder == null) continue;
            grantsBuilder.elem("Grant").importXMLBuilder(subBuilder).elem("Permission").text(ServiceUtils.toValid(permission.getPermissionString()));
        }
    }

    protected XMLBuilder buildGroupGrantee(GranteeInterface grantee) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder subBuilder = XMLBuilder.create("Grantee").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").attr("xsi:type", "Group").element("URI").text(this.transGroupGrantee(((GroupGrantee)grantee).getGroupGranteeType()));
        return subBuilder;
    }

    protected XMLBuilder buildCanonicalGrantee(GranteeInterface grantee) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder subBuilder = null;
        subBuilder = XMLBuilder.create("Grantee").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").attr("xsi:type", "CanonicalUser").element("ID").text(ServiceUtils.toValid(grantee.getIdentifier()));
        String displayName = ((CanonicalGrantee)grantee).getDisplayName();
        if (ServiceUtils.isValid2(displayName)) {
            subBuilder.up().element("DisplayName").text(displayName);
        }
        return subBuilder;
    }

    @Override
    public String transBucketCors(BucketCors cors) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("CORSConfiguration");
            for (BucketCorsRule rule : cors.getRules()) {
                builder = builder.e("CORSRule");
                if (rule.getId() != null) {
                    builder.e("ID").t(rule.getId());
                }
                if (rule.getAllowedMethod() != null) {
                    for (String method : rule.getAllowedMethod()) {
                        builder.e("AllowedMethod").t(ServiceUtils.toValid(method));
                    }
                }
                if (rule.getAllowedOrigin() != null) {
                    for (String origin : rule.getAllowedOrigin()) {
                        builder.e("AllowedOrigin").t(ServiceUtils.toValid(origin));
                    }
                }
                if (rule.getAllowedHeader() != null) {
                    for (String header : rule.getAllowedHeader()) {
                        builder.e("AllowedHeader").t(ServiceUtils.toValid(header));
                    }
                }
                builder.e("MaxAgeSeconds").t(String.valueOf(rule.getMaxAgeSecond()));
                if (rule.getExposeHeader() != null) {
                    for (String exposeHeader : rule.getExposeHeader()) {
                        builder.e("ExposeHeader").t(ServiceUtils.toValid(exposeHeader));
                    }
                }
                builder = builder.up();
            }
            return builder.asString();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Failed to build XML document for cors", e);
        }
        catch (TransformerException e) {
            throw new ServiceException("Failed to build XML document for cors", e);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for cors", e);
        }
    }

    @Override
    public String transBucketTagInfo(BucketTagInfo bucketTagInfo) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("Tagging").e("TagSet");
            for (BucketTagInfo.TagSet.Tag tag : bucketTagInfo.getTagSet().getTags()) {
                if (tag == null) continue;
                builder.e("Tag").e("Key").t(ServiceUtils.toValid(tag.getKey())).up().e("Value").t(ServiceUtils.toValid(tag.getValue()));
            }
            return builder.up().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Tagging", e);
        }
    }

    @Override
    public String transBucketNotificationConfiguration(BucketNotificationConfiguration bucketNotificationConfiguration) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("NotificationConfiguration");
            if (bucketNotificationConfiguration == null) {
                return builder.asString();
            }
            for (TopicConfiguration topicConfiguration : bucketNotificationConfiguration.getTopicConfigurations()) {
                this.packNotificationConfig(builder, topicConfiguration, "TopicConfiguration", "Topic", "S3Key");
            }
            for (FunctionGraphConfiguration functionGraphConfiguration : bucketNotificationConfiguration.getFunctionGraphConfigurations()) {
                this.packNotificationConfig(builder, functionGraphConfiguration, "FunctionGraphConfiguration", "FunctionGraph", "S3Key");
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Notification", e);
        }
    }

    protected void packNotificationConfig(XMLBuilder builder, AbstractNotification config, String configType, String urnType, String adapter) {
        builder = builder.e(configType);
        if (config.getId() != null) {
            builder.e("Id").t(config.getId());
        }
        if (config.getFilter() != null && !config.getFilter().getFilterRules().isEmpty()) {
            builder = builder.e("Filter").e(adapter);
            for (AbstractNotification.Filter.FilterRule rule : config.getFilter().getFilterRules()) {
                if (rule == null) continue;
                builder.e("FilterRule").e("Name").t(ServiceUtils.toValid(rule.getName())).up().e("Value").t(ServiceUtils.toValid(rule.getValue()));
            }
            builder = builder.up().up();
        }
        String urn = null;
        if (config instanceof TopicConfiguration) {
            urn = ((TopicConfiguration)config).getTopic();
        }
        if (config instanceof FunctionGraphConfiguration) {
            urn = ((FunctionGraphConfiguration)config).getFunctionGraph();
        }
        if (urn != null) {
            builder.e(urnType).t(urn);
        }
        if (config.getEventTypes() != null) {
            for (EventTypeEnum event : config.getEventTypes()) {
                if (event == null) continue;
                builder.e("Event").t(this.transEventType(event));
            }
        }
    }

    @Override
    public String transBucketFileInterface(FSStatusEnum status) throws ServiceException {
        try {
            return XMLBuilder.create("FileInterfaceConfiguration").e("Status").t(status.getCode()).up().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for FileInterface", e);
        }
    }

    @Override
    public String transBucketDirectColdAccess(BucketDirectColdAccess access) throws ServiceException {
        try {
            XMLBuilder builder = XMLBuilder.create("DirectColdAccessConfiguration");
            builder = builder.e("Status").t(access.getStatus().getCode());
            builder = builder.up();
            return builder.up().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Tagging", e);
        }
    }
}

