/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import java.io.Closeable;
import java.io.IOException;

public interface BasicMetricsConsumer
extends Closeable {
    public boolean putMetrics(MetricRecord var1);

    @Override
    public void close() throws IOException;

    public static class MetricRecord {
        private String opName;
        private boolean success;
        private long costTime;
        private String opType;
        public static final String READ = "read";
        public static final String CLOSE = "close";
        public static final String READFULLY = "readFully";
        static final String HFLUSH = "hflush";
        static final String WRITE = "write";
        static final String CREATE = "create";
        static final String CREATE_NR = "createNonRecursive";
        static final String APPEND = "append";
        static final String RENAME = "rename";
        static final String DELETE = "delete";
        static final String LIST_STATUS = "listStatus";
        static final String MKDIRS = "mkdirs";
        static final String GET_FILE_STATUS = "getFileStatus";
        static final String GET_CONTENT_SUMMARY = "getContentSummary";
        static final String COPYFROMLOCAL = "copyFromLocalFile";
        static final String LIST_FILES = "listFiles";
        static final String LIST_LOCATED_STS = "listLocatedStatus";
        static final String OPEN = "open";
        public static final String ONEBYTE = "1byte";
        public static final String BYTEBUF = "byteBuf";
        public static final String INPUT = "input";
        public static final String RANDOM = "random";
        public static final String SEQ = "seq";
        static final String OUTPUT = "output";
        static final String FLAGS = "flags";
        static final String NONRECURSIVE = "nonrecursive";
        static final String RECURSIVE = "recursive";
        static final String FS = "fs";
        static final String OVERWRITE = "overwrite";

        public MetricRecord(String opType, String opName, boolean success, long costTime) {
            this.opName = opName;
            this.opType = opType;
            this.success = success;
            this.costTime = costTime;
        }

        public String getOpName() {
            return this.opName;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public long getCostTime() {
            return this.costTime;
        }

        public String getOpType() {
            return this.opType;
        }

        public String toString() {
            return "MetricRecord{opName='" + this.opName + ", success=" + this.success + ", costTime=" + this.costTime + ", opType=" + this.opType + '}';
        }
    }
}

