/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.util.concurrent.MoreExecutors;
import com.sun.istack.NotNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.obs.SemaphoredDelegatingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class BlockingThreadPoolExecutorService
extends SemaphoredDelegatingExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingThreadPoolExecutorService.class);
    private static final AtomicInteger POOLNUMBER = new AtomicInteger(1);
    private final ThreadPoolExecutor eventProcessingExecutor;

    private BlockingThreadPoolExecutorService(int permitCount, ThreadPoolExecutor executor) {
        super(MoreExecutors.listeningDecorator((ExecutorService)executor), permitCount, false);
        this.eventProcessingExecutor = executor;
    }

    private static ThreadFactory getNamedThreadFactory(final String prefix) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNum = BlockingThreadPoolExecutorService.access$000().getAndIncrement();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                String name = prefix + "-pool" + this.poolNum + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(r, name);
            }
        };
    }

    static ThreadFactory newDaemonThreadFactory(String prefix) {
        ThreadFactory namedFactory = BlockingThreadPoolExecutorService.getNamedThreadFactory(prefix);
        return r -> {
            Thread t = namedFactory.newThread(r);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        };
    }

    static BlockingThreadPoolExecutorService newInstance(int activeTasks, int waitingTasks, long keepAliveTime, String prefixName) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(waitingTasks + activeTasks);
        ThreadPoolExecutor eventProcessingExecutor = new ThreadPoolExecutor(activeTasks, activeTasks, keepAliveTime, TimeUnit.SECONDS, workQueue, BlockingThreadPoolExecutorService.newDaemonThreadFactory(prefixName), (r, executor) -> LOG.error("Could not submit task to executor {}", (Object)executor.toString()));
        eventProcessingExecutor.allowCoreThreadTimeOut(true);
        return new BlockingThreadPoolExecutorService(waitingTasks + activeTasks, eventProcessingExecutor);
    }

    private int getActiveCount() {
        return this.eventProcessingExecutor.getActiveCount();
    }

    @Override
    public String toString() {
        return "BlockingThreadPoolExecutorService{" + super.toString() + ", activeCount=" + this.getActiveCount() + '}';
    }

    static /* synthetic */ AtomicInteger access$000() {
        return POOLNUMBER;
    }
}

