/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.obs.BasicMetricsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMetricsConsumer
implements BasicMetricsConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetricsConsumer.class);
    private URI uri;
    private Configuration conf;

    DefaultMetricsConsumer(URI uriName, Configuration configuration) {
        this.uri = uriName;
        this.conf = configuration;
        LOG.debug("DefaultMetricsConsumer with URI [{}] and Configuration[{}]", (Object)this.uri, (Object)this.conf);
    }

    @Override
    public boolean putMetrics(BasicMetricsConsumer.MetricRecord metricRecord) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[Metrics]: url[{}], opName [{}], costTime[{}], opResult[{}]", new Object[]{this.uri, metricRecord.getOpName(), metricRecord.getCostTime(), metricRecord.isSuccess()});
        }
        return true;
    }

    @Override
    public void close() {
    }
}

