/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.internal.ext.ExtObsConfiguration;
import com.obs.services.model.AuthTypeEnum;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.obs.BasicSessionCredential;
import org.apache.hadoop.fs.obs.OBSClientFactory;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSLoginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultOBSClientFactory
extends Configured
implements OBSClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOBSClientFactory.class);

    DefaultOBSClientFactory() {
    }

    private static void initConnectionSettings(Configuration conf, ExtObsConfiguration obsConf) {
        obsConf.setMaxConnections(OBSCommonUtils.intOption(conf, "fs.obs.connection.maximum", 1000, 1));
        boolean secureConnections = conf.getBoolean("fs.obs.connection.ssl.enabled", false);
        String originEndPoint = conf.getTrimmed("fs.obs.endpoint", "");
        if (!(originEndPoint.isEmpty() || originEndPoint.startsWith("http://") || originEndPoint.startsWith("https://"))) {
            String newEndPointWithSchema = secureConnections ? "https://" + originEndPoint : "http://" + originEndPoint;
            conf.set("fs.obs.endpoint", newEndPointWithSchema);
        }
        obsConf.setMaxErrorRetry(OBSCommonUtils.intOption(conf, "fs.obs.attempts.maximum", 3, 0));
        obsConf.setConnectionTimeout(OBSCommonUtils.intOption(conf, "fs.obs.connection.establish.timeout", 120000, 0));
        obsConf.setSocketTimeout(OBSCommonUtils.intOption(conf, "fs.obs.connection.timeout", 120000, 0));
        obsConf.setIdleConnectionTime(OBSCommonUtils.intOption(conf, "fs.obs.idle.connection.time", 30000, 1));
        obsConf.setMaxIdleConnections(OBSCommonUtils.intOption(conf, "fs.obs.max.idle.connections", 1000, 1));
        obsConf.setReadBufferSize(OBSCommonUtils.intOption(conf, "fs.obs.read.buffer.size", 262144, -1));
        obsConf.setWriteBufferSize(OBSCommonUtils.intOption(conf, "fs.obs.write.buffer.size", 262144, -1));
        obsConf.setSocketReadBufferSize(OBSCommonUtils.intOption(conf, "fs.obs.socket.recv.buffer", 262144, -1));
        obsConf.setSocketWriteBufferSize(OBSCommonUtils.intOption(conf, "fs.obs.socket.send.buffer", 262144, -1));
        obsConf.setKeepAlive(conf.getBoolean("fs.obs.keep.alive", true));
        obsConf.setValidateCertificate(conf.getBoolean("fs.obs.validate.certificate", false));
        obsConf.setVerifyResponseContentType(conf.getBoolean("fs.obs.verify.response.content.type", true));
        obsConf.setCname(conf.getBoolean("fs.obs.cname", false));
        obsConf.setIsStrictHostnameVerification(conf.getBoolean("fs.obs.strict.hostname.verification", false));
        obsConf.setAuthTypeNegotiation(conf.getBoolean("fs.obs.authtype.negotiation.enable", false));
        if (!obsConf.isAuthTypeNegotiation()) {
            obsConf.setAuthType(AuthTypeEnum.OBS);
        }
        obsConf.retryOnConnectionFailureInOkhttp(conf.getBoolean("fs.obs.connection.retry.enable", true));
        int retryTime = conf.getInt("fs.obs.unexpectedend.retrytime", -1);
        if (retryTime > 0 && retryTime < 2000 || !obsConf.isRetryOnConnectionFailureInOkhttp() && retryTime < 0) {
            retryTime = 2000;
        }
        obsConf.setMaxRetryOnUnexpectedEndException(retryTime);
    }

    private static void initProxySupport(Configuration conf, ExtObsConfiguration obsConf) throws IllegalArgumentException, IOException {
        String proxyHost = conf.getTrimmed("fs.obs.proxy.host", "");
        int proxyPort = conf.getInt("fs.obs.proxy.port", -1);
        if (!proxyHost.isEmpty() && proxyPort < 0) {
            if (conf.getBoolean("fs.obs.connection.ssl.enabled", false)) {
                LOG.warn("Proxy host set without port. Using HTTPS default 443");
                obsConf.getHttpProxy().setProxyPort(443);
            } else {
                LOG.warn("Proxy host set without port. Using HTTP default 80");
                obsConf.getHttpProxy().setProxyPort(80);
            }
        }
        String proxyUsername = conf.getTrimmed("fs.obs.proxy.username");
        String proxyPassword = null;
        char[] proxyPass = conf.getPassword("fs.obs.proxy.password");
        if (proxyPass != null) {
            proxyPassword = new String(proxyPass).trim();
        }
        if (proxyUsername == null != (proxyPassword == null)) {
            String msg = "Proxy error: fs.obs.proxy.username or fs.obs.proxy.password set without the other.";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        obsConf.setHttpProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using proxy server {}:{} as user {} on domain {} as workstation {}", new Object[]{obsConf.getHttpProxy().getProxyAddr(), obsConf.getHttpProxy().getProxyPort(), obsConf.getHttpProxy().getProxyUName(), obsConf.getHttpProxy().getDomain(), obsConf.getHttpProxy().getWorkstation()});
        }
    }

    private static ObsClient createHuaweiObsClient(Configuration conf, ObsConfiguration obsConf, URI name) throws IOException {
        BasicSessionCredential credentialsProvider;
        Class credentialsProviderClass;
        try {
            credentialsProviderClass = conf.getClass("fs.obs.credentials.provider", null);
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option fs.obs.credentials.provider " + c, c);
        }
        if (credentialsProviderClass == null) {
            return DefaultOBSClientFactory.createObsClientWithoutCredentialsProvider(conf, obsConf, name);
        }
        try {
            Constructor cons = credentialsProviderClass.getDeclaredConstructor(URI.class, Configuration.class);
            credentialsProvider = (BasicSessionCredential)cons.newInstance(name, conf);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option fs.obs.credentials.provider " + c, c);
        }
        String sessionToken = credentialsProvider.getSessionToken();
        String ak = credentialsProvider.getOBSAccessKeyId();
        String sk = credentialsProvider.getOBSSecretKey();
        String endPoint = conf.getTrimmed("fs.obs.endpoint", "");
        obsConf.setEndPoint(endPoint);
        ObsClient obsClient = sessionToken != null && sessionToken.length() != 0 ? new ObsClient(ak, sk, sessionToken, obsConf) : new ObsClient(ak, sk, obsConf);
        return obsClient;
    }

    private static ObsClient createObsClientWithoutCredentialsProvider(Configuration conf, ObsConfiguration obsConf, URI name) throws IOException {
        IObsCredentialsProvider securityProvider;
        Class securityProviderClass;
        OBSLoginHelper.Login creds = OBSCommonUtils.getOBSAccessKeys(name, conf);
        String ak = creds.getUser();
        String sk = creds.getPassword();
        String token = creds.getToken();
        String endPoint = conf.getTrimmed("fs.obs.endpoint", "");
        obsConf.setEndPoint(endPoint);
        if (!StringUtils.isEmpty((String)ak) || !StringUtils.isEmpty((String)sk)) {
            ObsClient obsClient = new ObsClient(ak, sk, token, obsConf);
            return obsClient;
        }
        try {
            securityProviderClass = conf.getClass("fs.obs.security.provider", null);
            LOG.info("From option {} get {}", (Object)"fs.obs.security.provider", (Object)securityProviderClass);
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option fs.obs.security.provider " + c, c);
        }
        if (securityProviderClass == null) {
            ObsClient obsClient = new ObsClient(ak, sk, token, obsConf);
            return obsClient;
        }
        try {
            Optional<Constructor> cons = DefaultOBSClientFactory.tryGetConstructor(securityProviderClass, new Class[]{URI.class, Configuration.class});
            securityProvider = cons.isPresent() ? (IObsCredentialsProvider)cons.get().newInstance(name, conf) : (IObsCredentialsProvider)securityProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option fs.obs.security.provider " + c, c);
        }
        ObsClient obsClient = new ObsClient(securityProvider, obsConf);
        return obsClient;
    }

    public static Optional<Constructor> tryGetConstructor(Class mainClss, Class[] args) {
        try {
            Constructor constructor = mainClss.getDeclaredConstructor(args);
            return Optional.ofNullable(constructor);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    @Override
    public ObsClient createObsClient(URI name) throws IOException {
        Configuration conf = this.getConf();
        ExtObsConfiguration obsConf = new ExtObsConfiguration();
        DefaultOBSClientFactory.initConnectionSettings(conf, obsConf);
        DefaultOBSClientFactory.initProxySupport(conf, obsConf);
        return DefaultOBSClientFactory.createHuaweiObsClient(conf, obsConf, name);
    }
}

