/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.obs.services.exception.ObsException;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.fs.WriteFileRequest;
import com.sun.istack.NotNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.obs.BasicMetricsConsumer;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSDataBlocks;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSWriteOperationHelper;
import org.apache.hadoop.fs.obs.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OBSBlockOutputStream
extends OutputStream
implements Syncable {
    private static final Logger LOG = LoggerFactory.getLogger(OBSBlockOutputStream.class);
    private final OBSFileSystem fs;
    private final String key;
    private final String uri;
    private long objectLen;
    private final int blockSize;
    private final ListeningExecutorService executorService;
    private final OBSDataBlocks.BlockFactory blockFactory;
    private final byte[] singleCharWrite = new byte[1];
    private volatile boolean closed = false;
    private final AtomicBoolean hasException = new AtomicBoolean(false);
    private final AtomicBoolean appendAble;
    private MultiPartUpload multiPartUpload;
    private OBSDataBlocks.DataBlock activeBlock;
    private long blockCount = 0L;
    private OBSWriteOperationHelper writeOperationHelper;
    private boolean mockUploadPartError = false;

    OBSBlockOutputStream(OBSFileSystem owner, String obsObjectKey, long objLen, ExecutorService execService, boolean isAppendable) throws IOException {
        this.appendAble = new AtomicBoolean(isAppendable);
        this.fs = owner;
        this.key = obsObjectKey;
        this.uri = "obs://" + this.fs.getBucket() + "/" + this.key;
        this.objectLen = objLen;
        this.blockFactory = owner.getBlockFactory();
        this.blockSize = (int)owner.getPartSize();
        this.writeOperationHelper = owner.getWriteHelper();
        Preconditions.checkArgument((owner.getPartSize() >= 0x500000L ? 1 : 0) != 0, (String)"Block size is too small: %d", (Object[])new Object[]{owner.getPartSize()});
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)execService);
        this.multiPartUpload = null;
        this.createBlockIfNeeded();
        LOG.debug("Initialized OBSBlockOutputStream for {} output to {}", (Object)owner.getWriteHelper(), (Object)this.activeBlock);
    }

    private synchronized OBSDataBlocks.DataBlock createBlockIfNeeded() throws IOException {
        if (this.activeBlock == null) {
            ++this.blockCount;
            if (this.blockCount >= 10000L) {
                LOG.debug("Number of partitions in stream exceeds limit for OBS: 10000 write may fail.");
            }
            this.activeBlock = this.blockFactory.create(this.blockCount, this.blockSize);
        }
        return this.activeBlock;
    }

    synchronized OBSDataBlocks.DataBlock getActiveBlock() {
        return this.activeBlock;
    }

    @VisibleForTesting
    void mockPutPartError(boolean isException) {
        this.mockUploadPartError = isException;
    }

    private synchronized boolean hasActiveBlock() {
        return this.activeBlock != null;
    }

    private synchronized void clearActiveBlock() {
        if (this.activeBlock != null) {
            LOG.debug("Clearing active block");
        }
        this.activeBlock = null;
    }

    private void checkStreamOpen() throws IOException {
        if (this.closed) {
            throw new IOException(this.uri + ": " + "Stream is closed!");
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
        OBSDataBlocks.DataBlock dataBlock = this.getActiveBlock();
        if (dataBlock != null) {
            dataBlock.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
        this.singleCharWrite[0] = (byte)b;
        this.write(this.singleCharWrite, 0, 1);
    }

    @Override
    public synchronized void write(@NotNull byte[] source, int offset, int len) throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
        long startTime = System.currentTimeMillis();
        if (this.hasException.get()) {
            String closeWarning = String.format("write has error. bs : pre upload obs[%s] has error.", this.key);
            LOG.warn(closeWarning);
            throw new IOException(closeWarning);
        }
        OBSDataBlocks.validateWriteArgs(source, offset, len);
        if (len == 0) {
            return;
        }
        OBSDataBlocks.DataBlock block = this.createBlockIfNeeded();
        int written = block.write(source, offset, len);
        int remainingCapacity = block.remainingCapacity();
        try {
            this.innerWrite(source, offset, len, written, remainingCapacity);
            long endTime = System.currentTimeMillis();
            if (this.fs.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "write", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this.fs, record);
            }
        }
        catch (IOException e) {
            long endTime = System.currentTimeMillis();
            if (this.fs.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "write", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this.fs, record);
            }
            LOG.error("Write data for key {} of bucket {} error, error message {}", new Object[]{this.key, this.fs.getBucket(), e.getMessage()});
            throw e;
        }
    }

    private synchronized void innerWrite(byte[] source, int offset, int len, int written, int remainingCapacity) throws IOException {
        if (written < len) {
            LOG.debug("writing more data than block has capacity -triggering upload");
            if (this.appendAble.get()) {
                LOG.debug("[Append] open stream and single write size {} greater than buffer size {}, append buffer to obs.", (Object)len, (Object)this.blockSize);
                this.flushCurrentBlock();
            } else {
                this.uploadCurrentBlock();
            }
            this.write(source, offset + written, len - written);
        } else if (remainingCapacity == 0) {
            if (this.appendAble.get()) {
                LOG.debug("[Append] open stream and already write size equal to buffer size {}, append buffer to obs.", (Object)this.blockSize);
                this.flushCurrentBlock();
            } else {
                this.uploadCurrentBlock();
            }
        }
    }

    private synchronized void uploadCurrentBlock() throws IOException {
        Preconditions.checkState((boolean)this.hasActiveBlock(), (Object)"No active block");
        LOG.debug("Writing block # {}", (Object)this.blockCount);
        try {
            if (this.multiPartUpload == null) {
                LOG.debug("Initiating Multipart upload");
                this.multiPartUpload = new MultiPartUpload();
            }
            this.multiPartUpload.uploadBlockAsync(this.getActiveBlock());
        }
        catch (IOException e) {
            this.hasException.set(true);
            LOG.error("Upload current block on ({}/{}) failed.", new Object[]{this.fs.getBucket(), this.key, e});
            throw e;
        }
        finally {
            this.clearActiveBlock();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        long startTime = System.currentTimeMillis();
        if (this.closed) {
            LOG.debug("Ignoring close() as stream is already closed");
            return;
        }
        if (this.hasException.get()) {
            String closeWarning = String.format("closed has error. bs : pre write obs[%s] has error.", this.key);
            LOG.warn(closeWarning);
            long endTime = System.currentTimeMillis();
            if (this.fs.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("output", "close", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this.fs, record);
            }
            throw new IOException(closeWarning);
        }
        this.fs.checkOpen();
        this.completeCurrentBlock();
        this.clearHFlushOrSync();
        this.writeOperationHelper.writeSuccessful(this.key);
        this.fs.removeFileBeingWritten(this.key);
        long endTime = System.currentTimeMillis();
        if (this.fs.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("output", "close", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this.fs, record);
        }
        this.closed = true;
    }

    private synchronized void putObjectIfNeedAppend() throws IOException {
        if (this.appendAble.get() && this.fs.exists(OBSCommonUtils.keyToQualifiedPath(this.fs, this.key))) {
            this.appendFsFile();
        } else {
            this.putObject();
        }
    }

    private synchronized void appendFsFile() throws IOException {
        LOG.debug("bucket is posix, to append file. key is {}", (Object)this.key);
        OBSDataBlocks.DataBlock block = this.getActiveBlock();
        WriteFileRequest writeFileReq = block instanceof OBSDataBlocks.DiskBlock ? OBSCommonUtils.newAppendFileRequest(this.fs, this.key, this.objectLen, (File)block.startUpload()) : OBSCommonUtils.newAppendFileRequest(this.fs, this.key, this.objectLen, (InputStream)block.startUpload());
        OBSCommonUtils.appendFile(this.fs, writeFileReq);
        this.objectLen += (long)block.dataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void putObject() throws IOException {
        LOG.debug("Executing regular upload for {}", (Object)this.writeOperationHelper.toString(this.key));
        OBSDataBlocks.DataBlock block = this.getActiveBlock();
        this.clearActiveBlock();
        int size = block.dataSize();
        PutObjectRequest putObjectRequest = block instanceof OBSDataBlocks.DiskBlock ? this.writeOperationHelper.newPutRequest(this.key, (File)block.startUpload()) : this.writeOperationHelper.newPutRequest(this.key, (InputStream)block.startUpload(), size);
        putObjectRequest.setAcl(this.fs.getCannedACL());
        this.fs.getSchemeStatistics().incrementWriteOps(1);
        try {
            this.writeOperationHelper.putObject(putObjectRequest);
        }
        catch (Throwable throwable) {
            OBSCommonUtils.closeAll(block);
            throw throwable;
        }
        OBSCommonUtils.closeAll(block);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("OBSBlockOutputStream{");
        sb.append(this.writeOperationHelper.toString());
        sb.append(", blockSize=").append(this.blockSize);
        OBSDataBlocks.DataBlock block = this.activeBlock;
        if (block != null) {
            sb.append(", activeBlock=").append(block);
        }
        sb.append('}');
        return sb.toString();
    }

    public synchronized void sync() throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
    }

    public synchronized void hflush() throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
        long startTime = System.currentTimeMillis();
        this.flushOrSync();
        long endTime = System.currentTimeMillis();
        if (this.fs.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "hflush", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this.fs, record);
        }
    }

    private synchronized void flushOrSync() throws IOException {
        this.checkStreamOpen();
        if (this.hasException.get()) {
            String flushWarning = String.format("flushOrSync has error. bs : pre write obs[%s] has error.", this.key);
            LOG.warn(flushWarning);
            throw new IOException(flushWarning);
        }
        if (this.fs.isFsBucket()) {
            this.flushCurrentBlock();
            this.clearHFlushOrSync();
        } else {
            LOG.warn("not posix bucket, not support hflush or hsync.");
            this.flush();
        }
    }

    private synchronized void clearHFlushOrSync() {
        this.appendAble.set(true);
        this.multiPartUpload = null;
    }

    private synchronized void uploadWriteBlocks(OBSDataBlocks.DataBlock block, boolean hasBlock) throws IOException {
        if (this.multiPartUpload == null) {
            if (hasBlock) {
                this.putObjectIfNeedAppend();
            }
        } else {
            if (hasBlock && block.hasData()) {
                this.uploadCurrentBlock();
            }
            List partETags = this.multiPartUpload.waitForAllPartUploads();
            ArrayList listPartETags = new ArrayList();
            int countSize = 0;
            for (Pair pair : partETags) {
                listPartETags.add(pair.getKey());
                countSize += ((Integer)pair.getValue()).intValue();
            }
            this.multiPartUpload.complete(listPartETags);
            this.objectLen = countSize;
        }
        LOG.debug("Upload complete for {}", (Object)this.writeOperationHelper.toString(this.key));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void completeCurrentBlock() throws IOException {
        OBSDataBlocks.DataBlock block = this.getActiveBlock();
        boolean hasBlock = this.hasActiveBlock();
        LOG.debug("{}: complete block #{}: current block= {}", new Object[]{this, this.blockCount, hasBlock ? block : "(none)"});
        try {
            this.uploadWriteBlocks(block, hasBlock);
        }
        catch (IOException ioe) {
            try {
                LOG.error("Upload data to obs error. io exception : {}", (Object)ioe.getMessage());
                throw ioe;
                catch (Exception e) {
                    LOG.error("Upload data to obs error. other exception : {}", (Object)e.getMessage());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                OBSCommonUtils.closeAll(block);
                this.clearActiveBlock();
                throw throwable;
            }
        }
        OBSCommonUtils.closeAll(block);
        this.clearActiveBlock();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void flushCurrentBlock() throws IOException {
        OBSDataBlocks.DataBlock block = this.getActiveBlock();
        boolean hasBlock = this.hasActiveBlock();
        LOG.debug("{}: complete block #{}: current block= {}", new Object[]{this, this.blockCount, hasBlock ? block : "(none)"});
        try {
            this.uploadWriteBlocks(block, hasBlock);
        }
        catch (IOException ioe) {
            try {
                LOG.error("hflush data to obs error. io exception : {}", (Object)ioe.getMessage());
                this.hasException.set(true);
                throw ioe;
                catch (Exception e) {
                    LOG.error("hflush data to obs error. other exception : {}", (Object)e.getMessage());
                    this.hasException.set(true);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                OBSCommonUtils.closeAll(block);
                this.clearActiveBlock();
                throw throwable;
            }
        }
        OBSCommonUtils.closeAll(block);
        this.clearActiveBlock();
    }

    public synchronized void hsync() throws IOException {
        this.fs.checkOpen();
        this.checkStreamOpen();
        long startTime = System.currentTimeMillis();
        this.flushOrSync();
        long endTime = System.currentTimeMillis();
        if (this.fs.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "hflush", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this.fs, record);
        }
    }

    private class MultiPartUpload {
        private final String uploadId;
        private final List<ListenableFuture<Pair<PartEtag, Integer>>> partETagsFutures;

        MultiPartUpload() throws IOException {
            this.uploadId = OBSBlockOutputStream.this.writeOperationHelper.initiateMultiPartUpload(OBSBlockOutputStream.this.key);
            this.partETagsFutures = new ArrayList<ListenableFuture<Pair<PartEtag, Integer>>>(2);
            LOG.debug("Initiated multi-part upload for {} with , the key is {}id '{}'", new Object[]{OBSBlockOutputStream.this.writeOperationHelper, this.uploadId, OBSBlockOutputStream.this.key});
        }

        private void uploadBlockAsync(OBSDataBlocks.DataBlock block) throws IOException {
            LOG.debug("Queueing upload of {}", (Object)block);
            int size = block.dataSize();
            int currentPartNumber = this.partETagsFutures.size() + 1;
            UploadPartRequest request = block instanceof OBSDataBlocks.DiskBlock ? OBSBlockOutputStream.this.writeOperationHelper.newUploadPartRequest(OBSBlockOutputStream.this.key, this.uploadId, currentPartNumber, size, (File)block.startUpload()) : OBSBlockOutputStream.this.writeOperationHelper.newUploadPartRequest(OBSBlockOutputStream.this.key, this.uploadId, currentPartNumber, size, (InputStream)block.startUpload());
            ListenableFuture partETagFuture = OBSBlockOutputStream.this.executorService.submit(() -> {
                LOG.debug("Uploading part {} for id '{}'", (Object)currentPartNumber, (Object)this.uploadId);
                PartEtag partETag = null;
                try {
                    if (OBSBlockOutputStream.this.mockUploadPartError) {
                        throw new ObsException("mock upload part error");
                    }
                    UploadPartResult uploadPartResult = OBSCommonUtils.uploadPart(OBSBlockOutputStream.this.fs, request);
                    partETag = new PartEtag(uploadPartResult.getEtag(), uploadPartResult.getPartNumber());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Completed upload of {} to part {}", (Object)block, (Object)partETag);
                    }
                }
                catch (ObsException e) {
                    try {
                        OBSBlockOutputStream.this.hasException.set(true);
                        IOException ioException = OBSCommonUtils.translateException("UploadPart", OBSBlockOutputStream.this.key, e);
                        LOG.error("UploadPart failed (ObsException). {}", (Object)ioException.getMessage());
                        throw ioException;
                    }
                    catch (Throwable throwable) {
                        OBSCommonUtils.closeAll(block);
                        throw throwable;
                    }
                }
                OBSCommonUtils.closeAll(block);
                return new Pair<PartEtag, Integer>(partETag, size);
            });
            this.partETagsFutures.add((ListenableFuture<Pair<PartEtag, Integer>>)partETagFuture);
        }

        private List<Pair<PartEtag, Integer>> waitForAllPartUploads() throws IOException {
            LOG.debug("Waiting for {} uploads to complete", (Object)this.partETagsFutures.size());
            try {
                return (List)Futures.allAsList(this.partETagsFutures).get();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted partUpload", (Throwable)ie);
                LOG.debug("Cancelling futures");
                for (ListenableFuture<Pair<PartEtag, Integer>> future : this.partETagsFutures) {
                    future.cancel(true);
                }
                this.abort();
                throw new IOException("Interrupted multi-part upload with id '" + this.uploadId + "' to " + OBSBlockOutputStream.this.key);
            }
            catch (ExecutionException ee) {
                LOG.debug("While waiting for upload completion", (Throwable)ee);
                LOG.debug("Cancelling futures");
                for (ListenableFuture<Pair<PartEtag, Integer>> future : this.partETagsFutures) {
                    future.cancel(true);
                }
                this.abort();
                throw OBSCommonUtils.extractException("Multi-part upload with id '" + this.uploadId + "' to " + OBSBlockOutputStream.this.key, OBSBlockOutputStream.this.key, ee);
            }
        }

        private CompleteMultipartUploadResult complete(List<PartEtag> partETags) throws IOException {
            String operation = String.format("Completing multi-part upload for key '%s', id '%s' with %s partitions ", OBSBlockOutputStream.this.key, this.uploadId, partETags.size());
            try {
                LOG.debug(operation);
                return OBSBlockOutputStream.this.writeOperationHelper.completeMultipartUpload(OBSBlockOutputStream.this.key, this.uploadId, partETags);
            }
            catch (ObsException e) {
                throw OBSCommonUtils.translateException(operation, OBSBlockOutputStream.this.key, e);
            }
        }

        void abort() {
            String operation = String.format("Aborting multi-part upload for '%s', id '%s", OBSBlockOutputStream.this.writeOperationHelper, this.uploadId);
            try {
                LOG.debug(operation);
                OBSBlockOutputStream.this.writeOperationHelper.abortMultipartUpload(OBSBlockOutputStream.this.key, this.uploadId);
            }
            catch (ObsException e) {
                LOG.warn("Unable to abort multipart upload, you may need to purge  uploaded parts", (Throwable)e);
            }
        }
    }
}

