/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.obs.BasicMetricsConsumer;
import org.apache.hadoop.fs.obs.DefaultMetricsConsumer;
import org.apache.hadoop.fs.obs.DefaultOBSClientFactory;
import org.apache.hadoop.fs.obs.OBSClientFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class OBSConstants {
    public static final int MULTIPART_MIN_SIZE = 0x500000;
    public static final String ACCESS_KEY = "fs.obs.access.key";
    public static final String SECRET_KEY = "fs.obs.secret.key";
    static final String OBS_CREDENTIALS_PROVIDER = "fs.obs.credentials.provider";
    static final String OBS_METRICS_CONSUMER = "fs.obs.metrics.consumer";
    static final Class<? extends BasicMetricsConsumer> DEFAULT_OBS_METRICS_CONSUMER = DefaultMetricsConsumer.class;
    static final String OBS_SECURITY_PROVIDER = "fs.obs.security.provider";
    static final String OBS_SECURITY_CREDENTIAL_PROVIDER_PATH = "fs.obs.security.credential.provider.path";
    static final String VERIFY_BUFFER_DIR_ACCESSIBLE_ENABLE = "fs.obs.bufferdir.verify.enable";
    static final String SESSION_TOKEN = "fs.obs.session.token";
    static final String MAXIMUM_CONNECTIONS = "fs.obs.connection.maximum";
    static final int DEFAULT_MAXIMUM_CONNECTIONS = 1000;
    static final String SECURE_CONNECTIONS = "fs.obs.connection.ssl.enabled";
    static final boolean DEFAULT_SECURE_CONNECTIONS = false;
    public static final String ENDPOINT = "fs.obs.endpoint";
    static final String PROXY_HOST = "fs.obs.proxy.host";
    static final String PROXY_PORT = "fs.obs.proxy.port";
    static final String PROXY_USERNAME = "fs.obs.proxy.username";
    static final String PROXY_PASSWORD = "fs.obs.proxy.password";
    static final String HTTP_PREFIX = "http://";
    static final String HTTPS_PREFIX = "https://";
    static final int DEFAULT_HTTPS_PORT = 443;
    static final int DEFAULT_HTTP_PORT = 80;
    static final String MAX_ERROR_RETRIES = "fs.obs.attempts.maximum";
    static final int DEFAULT_MAX_ERROR_RETRIES = 3;
    static final String ESTABLISH_TIMEOUT = "fs.obs.connection.establish.timeout";
    static final int DEFAULT_ESTABLISH_TIMEOUT = 120000;
    static final String SOCKET_TIMEOUT = "fs.obs.connection.timeout";
    static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    static final String SOCKET_SEND_BUFFER = "fs.obs.socket.send.buffer";
    static final int DEFAULT_SOCKET_SEND_BUFFER = 262144;
    static final String SOCKET_RECV_BUFFER = "fs.obs.socket.recv.buffer";
    static final int DEFAULT_SOCKET_RECV_BUFFER = 262144;
    static final String MAX_PAGING_KEYS = "fs.obs.paging.maximum";
    static final int DEFAULT_MAX_PAGING_KEYS = 1000;
    static final String MAX_THREADS = "fs.obs.threads.max";
    static final int DEFAULT_MAX_THREADS = 20;
    static final String MAX_TOTAL_TASKS = "fs.obs.max.total.tasks";
    static final int DEFAULT_MAX_TOTAL_TASKS = 20;
    static final String MAX_COPY_THREADS = "fs.obs.copy.threads.max";
    static final int DEFAULT_MAX_COPY_THREADS = 40;
    static final String MAX_DELETE_THREADS = "fs.obs.delete.threads.max";
    static final int DEFAULT_MAX_DELETE_THREADS = 20;
    @Deprecated
    static final String CORE_THREADS = "fs.obs.threads.core";
    static final String KEEPALIVE_TIME = "fs.obs.threads.keepalivetime";
    static final int DEFAULT_KEEPALIVE_TIME = 60;
    public static final String MULTIPART_SIZE = "fs.obs.multipart.size";
    static final long DEFAULT_MULTIPART_SIZE = 0x6400000L;
    static final String ENABLE_MULTI_DELETE = "fs.obs.multiobjectdelete.enable";
    static final String MULTI_DELETE_MAX_NUMBER = "fs.obs.multiobjectdelete.maximum";
    static final int DEFAULT_MULTI_DELETE_MAX_NUMBER = 1000;
    static final String MULTI_DELETE_THRESHOLD = "fs.obs.multiobjectdelete.threshold";
    static final int MULTI_DELETE_DEFAULT_THRESHOLD = 3;
    static final String BUFFER_DIR = "fs.obs.buffer.dir";
    public static final String FAST_UPLOAD = "fs.obs.fast.upload";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER = "fs.obs.fast.upload.buffer";
    @InterfaceStability.Unstable
    static final String FAST_UPLOAD_BUFFER_DISK = "disk";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER_ARRAY = "array";
    @InterfaceStability.Unstable
    static final String FAST_UPLOAD_BYTEBUFFER = "bytebuffer";
    @InterfaceStability.Unstable
    static final String FAST_UPLOAD_ACTIVE_BLOCKS = "fs.obs.fast.upload.active.blocks";
    @InterfaceStability.Unstable
    static final int DEFAULT_FAST_UPLOAD_ACTIVE_BLOCKS = 4;
    static final String CANNED_ACL = "fs.obs.acl.default";
    static final String DEFAULT_CANNED_ACL = "";
    static final String PURGE_EXISTING_MULTIPART = "fs.obs.multipart.purge";
    static final boolean DEFAULT_PURGE_EXISTING_MULTIPART = false;
    static final String PURGE_EXISTING_MULTIPART_AGE = "fs.obs.multipart.purge.age";
    static final long DEFAULT_PURGE_EXISTING_MULTIPART_AGE = 86400L;
    static final String OBS_FOLDER_SUFFIX = "_$folder$";
    static final String FS_OBS_BLOCK_SIZE = "fs.obs.block.size";
    static final int DEFAULT_FS_OBS_BLOCK_SIZE = 0x8000000;
    static final String OBS_SCHEME = "obs";
    static final String FS_OBS_PREFIX = "fs.obs.";
    static final String FS_OBS_BUCKET_PREFIX = "fs.obs.bucket.";
    static final int OBS_DEFAULT_PORT = -1;
    static final String USER_AGENT_PREFIX = "fs.obs.user.agent.prefix";
    @InterfaceStability.Unstable
    public static final String READAHEAD_POLICY = "fs.obs.readahead.policy";
    @InterfaceStability.Unstable
    public static final String READAHEAD_POLICY_PRIMARY = "primary";
    @InterfaceStability.Unstable
    public static final String READAHEAD_POLICY_ADVANCE = "advance";
    public static final String READAHEAD_RANGE = "fs.obs.readahead.range";
    public static final long DEFAULT_READAHEAD_RANGE = 0x100000L;
    public static final String READAHEAD_MAX_NUM = "fs.obs.readahead.max.number";
    public static final int DEFAULT_READAHEAD_MAX_NUM = 4;
    public static final String READAHEAD_TRANSFORM_ENABLE = "fs.obs.read.transform.enable";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static final String OBS_CLIENT_FACTORY_IMPL = "fs.obs.client.factory.impl";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static final Class<? extends OBSClientFactory> DEFAULT_OBS_CLIENT_FACTORY_IMPL = DefaultOBSClientFactory.class;
    @InterfaceAudience.Private
    static final int MAX_MULTIPART_COUNT = 10000;
    static final String IDLE_CONNECTION_TIME = "fs.obs.idle.connection.time";
    static final int DEFAULT_IDLE_CONNECTION_TIME = 30000;
    static final String MAX_IDLE_CONNECTIONS = "fs.obs.max.idle.connections";
    static final int DEFAULT_MAX_IDLE_CONNECTIONS = 1000;
    static final String KEEP_ALIVE = "fs.obs.keep.alive";
    static final boolean DEFAULT_KEEP_ALIVE = true;
    static final String VALIDATE_CERTIFICATE = "fs.obs.validate.certificate";
    static final boolean DEFAULT_VALIDATE_CERTIFICATE = false;
    static final String VERIFY_RESPONSE_CONTENT_TYPE = "fs.obs.verify.response.content.type";
    static final boolean DEFAULT_VERIFY_RESPONSE_CONTENT_TYPE = true;
    static final String UPLOAD_STREAM_RETRY_SIZE = "fs.obs.upload.stream.retry.buffer.size";
    static final int DEFAULT_UPLOAD_STREAM_RETRY_SIZE = 524288;
    static final String READ_BUFFER_SIZE = "fs.obs.read.buffer.size";
    static final int DEFAULT_READ_BUFFER_SIZE = 262144;
    static final String WRITE_BUFFER_SIZE = "fs.obs.write.buffer.size";
    static final int DEFAULT_WRITE_BUFFER_SIZE = 262144;
    static final String CNAME = "fs.obs.cname";
    static final boolean DEFAULT_CNAME = false;
    static final String STRICT_HOSTNAME_VERIFICATION = "fs.obs.strict.hostname.verification";
    static final boolean DEFAULT_STRICT_HOSTNAME_VERIFICATION = false;
    static final String COPY_PART_SIZE = "fs.obs.copypart.size";
    static final long MAX_COPY_PART_SIZE = 0x140000000L;
    static final long DEFAULT_COPY_PART_SIZE = 0x6400000L;
    static final String MAX_COPY_PART_THREADS = "fs.obs.copypart.threads.max";
    static final int DEFAULT_MAX_COPY_PART_THREADS = 40;
    static final String CORE_LIST_THREADS = "fs.obs.list.threads.core";
    static final int DEFAULT_CORE_LIST_THREADS = 30;
    static final String MAX_LIST_THREADS = "fs.obs.list.threads.max";
    static final int DEFAULT_MAX_LIST_THREADS = 60;
    static final String LIST_WORK_QUEUE_CAPACITY = "fs.obs.list.workqueue.capacity";
    static final int DEFAULT_LIST_WORK_QUEUE_CAPACITY = 1024;
    static final String LIST_PARALLEL_FACTOR = "fs.obs.list.parallel.factor";
    static final int DEFAULT_LIST_PARALLEL_FACTOR = 30;
    static final String TRASH_ENABLE = "fs.obs.trash.enable";
    static final String OBS_CONTENT_SUMMARY_ENABLE = "fs.obs.content.summary.enable";
    static final String OBS_CLIENT_DFS_LIST_ENABLE = "fs.obs.client.dfs.list.enable";
    static final boolean DEFAULT_TRASH = false;
    static final String TRASH_DIR = "fs.obs.trash.dir";
    static final String SSE_TYPE = "fs.obs.server-side-encryption-type";
    static final String SSE_KEY = "fs.obs.server-side-encryption-key";
    static final String FAST_UPLOAD_BUFFER_ARRAY_FIRST_BLOCK_SIZE = "fs.obs.fast.upload.array.first.buffer";
    public static final int FAST_UPLOAD_BUFFER_ARRAY_FIRST_BLOCK_SIZE_DEFAULT = 0x100000;
    static final String SDK_AUTH_TYPE_NEGOTIATION_ENABLE = "fs.obs.authtype.negotiation.enable";
    static final boolean DEFAULT_SDK_AUTH_TYPE_NEGOTIATION_ENABLE = false;
    static final String SDK_RETRY_ON_CONNECTION_FAILURE_ENABLE = "fs.obs.connection.retry.enable";
    static final boolean DEFAULT_SDK_RETRY_ON_CONNECTION_FAILURE_ENABLE = true;
    static final String SDK_RETRY_TIMES_ON_UNEXPECTED_END_EXCEPTION = "fs.obs.unexpectedend.retrytime";
    static final int DEFAULT_SDK_RETRY_TIMES_ON_UNEXPECTED_END_EXCEPTION = -1;
    static final int DEFAULT_MAX_SDK_CONNECTION_RETRY_TIMES = 2000;
    static final String GET_CANONICAL_SERVICE_NAME_ENABLE = "fs.obs.getcanonicalservicename.enable";
    static final boolean DEFAULT_GET_CANONICAL_SERVICE_NAME_ENABLE = false;
    static final String MAX_TIME_IN_MILLISECOND_TO_RETRY = "fs.obs.retry.maxtime";
    static final long DEFAULT_TIME_IN_MILLISECOND_TO_RETRY = 180000L;
    static final String FILE_VISIBILITY_AFTER_CREATE_ENABLE = "fs.obs.file.visibility.enable";
    static final boolean DEFAULT_FILE_VISIBILITY_AFTER_CREATE_ENABLE = false;
    static final int SEC2MILLISEC_FACTOR = 1000;
    static final String METRICS_COUNT = "fs.obs.metrics.count";
    static final int DEFAULT_METRICS_COUNT = 1;
    static final String METRICS_SWITCH = "fs.obs.metrics.switch";
    static final boolean DEFAULT_METRICS_SWITCH = false;

    private OBSConstants() {
    }
}

