/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.obs.AlreadyBeingCreatedException;
import org.apache.hadoop.fs.obs.BasicMetricsConsumer;
import org.apache.hadoop.fs.obs.BlockingThreadPoolExecutorService;
import org.apache.hadoop.fs.obs.DefaultMetricsConsumer;
import org.apache.hadoop.fs.obs.FileConflictException;
import org.apache.hadoop.fs.obs.OBSBlockOutputStream;
import org.apache.hadoop.fs.obs.OBSClientFactory;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSConstants;
import org.apache.hadoop.fs.obs.OBSDataBlocks;
import org.apache.hadoop.fs.obs.OBSFileStatus;
import org.apache.hadoop.fs.obs.OBSListing;
import org.apache.hadoop.fs.obs.OBSLoginHelper;
import org.apache.hadoop.fs.obs.OBSObjectBucketUtils;
import org.apache.hadoop.fs.obs.OBSPosixBucketUtils;
import org.apache.hadoop.fs.obs.OBSWriteOperationHelper;
import org.apache.hadoop.fs.obs.SemaphoredDelegatingExecutor;
import org.apache.hadoop.fs.obs.SseWrapper;
import org.apache.hadoop.fs.obs.input.InputPolicyFactory;
import org.apache.hadoop.fs.obs.input.InputPolicys;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OBSFileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(OBSFileSystem.class);
    private volatile boolean closed = false;
    private URI uri;
    private Path workingDir;
    private String shortUserName;
    private boolean metricSwitch;
    private int invokeCountThreshold = 0;
    private ObsClient obs;
    private BasicMetricsConsumer metricsConsumer;
    private boolean enablePosix = false;
    private boolean obsContentSummaryEnable = true;
    private boolean obsClientDFSListEnable = true;
    private String bucket;
    private int maxKeys;
    private OBSListing obsListing;
    private OBSWriteOperationHelper writeHelper;
    private long partSize;
    private boolean enableMultiObjectDelete;
    private int multiDeleteThreshold;
    private int maxEntriesToDelete;
    private ListeningExecutorService boundedMultipartUploadThreadPool;
    private ThreadPoolExecutor boundedCopyThreadPool;
    private ThreadPoolExecutor boundedDeleteThreadPool;
    private ThreadPoolExecutor boundedCopyPartThreadPool;
    private ThreadPoolExecutor boundedListThreadPool;
    private int listParallelFactor;
    private long readAheadRange;
    private boolean readTransformEnable = true;
    private OBSDataBlocks.BlockFactory blockFactory;
    private InputPolicyFactory inputPolicyFactory;
    private int blockOutputActiveBlocks;
    private long copyPartSize;
    private boolean enableTrash = false;
    private String trashDir;
    private AccessControlList cannedACL;
    private SseWrapper sse;
    private long blockSize;
    private boolean enableCanonicalServiceName = false;
    private Map<String, FSDataOutputStream> filesBeingWritten = new HashMap<String, FSDataOutputStream>();
    private boolean enableFileVisibilityAfterCreate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllFilesBeingWritten() {
        while (true) {
            FSDataOutputStream outputStream;
            String objectKey;
            Map<String, FSDataOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    break;
                }
                objectKey = this.filesBeingWritten.keySet().iterator().next();
                outputStream = this.filesBeingWritten.remove(objectKey);
            }
            if (outputStream == null) continue;
            try {
                outputStream.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed to close file: " + objectKey, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBeingWritten(String file) {
        Map<String, FSDataOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileBeingWritten(String file) {
        Map<String, FSDataOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.containsKey(file);
        }
    }

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.bucket = name.getAuthority();
        Configuration conf = OBSCommonUtils.propagateBucketOptions(originalConf, this.bucket);
        OBSCommonUtils.patchSecurityCredentialProviders(conf);
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            if (conf.getBoolean("fs.obs.bufferdir.verify.enable", false)) {
                OBSCommonUtils.verifyBufferDirAccessible(conf);
            }
            this.metricSwitch = conf.getBoolean("fs.obs.metrics.switch", false);
            this.invokeCountThreshold = conf.getInt("fs.obs.metrics.count", 1);
            this.shortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
            this.workingDir = new Path("/user", this.shortUserName).makeQualified(this.uri, this.getWorkingDirectory());
            Class obsClientFactoryClass = conf.getClass("fs.obs.client.factory.impl", OBSConstants.DEFAULT_OBS_CLIENT_FACTORY_IMPL, OBSClientFactory.class);
            this.obs = ((OBSClientFactory)ReflectionUtils.newInstance((Class)obsClientFactoryClass, (Configuration)conf)).createObsClient(name);
            this.sse = new SseWrapper(conf);
            Class metricsConsumerClass = conf.getClass("fs.obs.metrics.consumer", OBSConstants.DEFAULT_OBS_METRICS_CONSUMER, BasicMetricsConsumer.class);
            if (!metricsConsumerClass.equals(DefaultMetricsConsumer.class) || this.metricSwitch) {
                try {
                    Constructor cons = metricsConsumerClass.getDeclaredConstructor(URI.class, Configuration.class);
                    this.metricsConsumer = (BasicMetricsConsumer)cons.newInstance(name, conf);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Throwable c = e.getCause() != null ? e.getCause() : e;
                    throw new IOException("From option fs.obs.metrics.consumer", c);
                }
            }
            OBSCommonUtils.verifyBucketExists(this);
            this.enablePosix = OBSCommonUtils.getBucketFsStatus(this.obs, this.bucket);
            this.maxKeys = OBSCommonUtils.intOption(conf, "fs.obs.paging.maximum", 1000, 1);
            this.obsListing = new OBSListing(this);
            this.partSize = OBSCommonUtils.getMultipartSizeProperty(conf, "fs.obs.multipart.size", 0x6400000L);
            this.blockSize = OBSCommonUtils.longBytesOption(conf, "fs.obs.block.size", 0x8000000L, 1L);
            this.enableMultiObjectDelete = conf.getBoolean("fs.obs.multiobjectdelete.enable", true);
            this.maxEntriesToDelete = conf.getInt("fs.obs.multiobjectdelete.maximum", 1000);
            this.obsContentSummaryEnable = conf.getBoolean("fs.obs.content.summary.enable", true);
            this.readAheadRange = OBSCommonUtils.longBytesOption(conf, "fs.obs.readahead.range", 0x100000L, 0L);
            this.readTransformEnable = conf.getBoolean("fs.obs.read.transform.enable", true);
            this.multiDeleteThreshold = conf.getInt("fs.obs.multiobjectdelete.threshold", 3);
            this.initThreadPools(conf);
            this.writeHelper = new OBSWriteOperationHelper(this);
            this.initCannedAcls(conf);
            OBSCommonUtils.initMultipartUploads(this, conf);
            String blockOutputBuffer = conf.getTrimmed("fs.obs.fast.upload.buffer", "disk");
            this.partSize = OBSCommonUtils.ensureOutputParameterInRange("fs.obs.multipart.size", this.partSize);
            this.blockFactory = OBSDataBlocks.createFactory(this, blockOutputBuffer);
            this.blockOutputActiveBlocks = OBSCommonUtils.intOption(conf, "fs.obs.fast.upload.active.blocks", 4, 1);
            LOG.debug("Using OBSBlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            String readPolicy = conf.getTrimmed("fs.obs.readahead.policy", "primary");
            this.inputPolicyFactory = InputPolicys.createFactory(readPolicy);
            this.enableTrash = conf.getBoolean("fs.obs.trash.enable", false);
            if (this.enableTrash) {
                if (!this.isFsBucket()) {
                    String errorMsg = String.format("The bucket [%s] is not posix. not supported for trash.", this.bucket);
                    LOG.warn(errorMsg);
                    this.enableTrash = false;
                    this.trashDir = null;
                } else {
                    this.trashDir = conf.get("fs.obs.trash.dir");
                    if (StringUtils.isEmpty((String)this.trashDir)) {
                        String errorMsg = String.format("The trash feature(fs.obs.trash.enable) is enabled, but the configuration(fs.obs.trash.dir [%s]) is empty.", this.trashDir);
                        LOG.error(errorMsg);
                        throw new ObsException(errorMsg);
                    }
                    this.trashDir = OBSCommonUtils.maybeAddBeginningSlash(this.trashDir);
                    this.trashDir = OBSCommonUtils.maybeAddTrailingSlash(this.trashDir);
                }
            }
            OBSCommonUtils.setMaxTimeInMillisecondsToRetry(conf.getLong("fs.obs.retry.maxtime", 180000L));
            this.enableCanonicalServiceName = conf.getBoolean("fs.obs.getcanonicalservicename.enable", false);
            this.enableFileVisibilityAfterCreate = conf.getBoolean("fs.obs.file.visibility.enable", false);
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("initializing ", new Path(name), e);
        }
        LOG.info("Finish initializing filesystem instance for uri: {}", (Object)this.uri);
    }

    private void initThreadPools(Configuration conf) {
        long keepAliveTime = OBSCommonUtils.longOption(conf, "fs.obs.threads.keepalivetime", 60L, 0L);
        int maxThreads = conf.getInt("fs.obs.threads.max", 20);
        if (maxThreads < 2) {
            LOG.warn("fs.obs.threads.max must be at least 2: forcing to 2.");
            maxThreads = 2;
        }
        int totalTasks = OBSCommonUtils.intOption(conf, "fs.obs.max.total.tasks", 20, 1);
        this.boundedMultipartUploadThreadPool = BlockingThreadPoolExecutorService.newInstance(maxThreads, maxThreads + totalTasks, keepAliveTime, "obs-transfer-shared");
        int maxDeleteThreads = conf.getInt("fs.obs.delete.threads.max", 20);
        if (maxDeleteThreads < 2) {
            LOG.warn("fs.obs.delete.threads.max must be at least 2: forcing to 2.");
            maxDeleteThreads = 2;
        }
        int coreDeleteThreads = (int)Math.ceil((double)maxDeleteThreads / 2.0);
        this.boundedDeleteThreadPool = new ThreadPoolExecutor(coreDeleteThreads, maxDeleteThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory("obs-delete-transfer-shared"));
        this.boundedDeleteThreadPool.allowCoreThreadTimeOut(true);
        if (this.enablePosix) {
            this.obsClientDFSListEnable = conf.getBoolean("fs.obs.client.dfs.list.enable", true);
            if (this.obsClientDFSListEnable) {
                int coreListThreads = conf.getInt("fs.obs.list.threads.core", 30);
                int maxListThreads = conf.getInt("fs.obs.list.threads.max", 60);
                int listWorkQueueCapacity = conf.getInt("fs.obs.list.workqueue.capacity", 1024);
                this.listParallelFactor = conf.getInt("fs.obs.list.parallel.factor", 30);
                if (this.listParallelFactor < 1) {
                    LOG.warn("fs.obs.list.parallel.factor must be at least 1: forcing to 1.");
                    this.listParallelFactor = 1;
                }
                this.boundedListThreadPool = new ThreadPoolExecutor(coreListThreads, maxListThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(listWorkQueueCapacity), BlockingThreadPoolExecutorService.newDaemonThreadFactory("obs-list-transfer-shared"));
                this.boundedListThreadPool.allowCoreThreadTimeOut(true);
            }
        } else {
            int maxCopyPartThreads;
            int maxCopyThreads = conf.getInt("fs.obs.copy.threads.max", 40);
            if (maxCopyThreads < 2) {
                LOG.warn("fs.obs.copy.threads.max must be at least 2: forcing to 2.");
                maxCopyThreads = 2;
            }
            int coreCopyThreads = (int)Math.ceil((double)maxCopyThreads / 2.0);
            this.boundedCopyThreadPool = new ThreadPoolExecutor(coreCopyThreads, maxCopyThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory("obs-copy-transfer-shared"));
            this.boundedCopyThreadPool.allowCoreThreadTimeOut(true);
            this.copyPartSize = OBSCommonUtils.longOption(conf, "fs.obs.copypart.size", 0x6400000L, 0L);
            if (this.copyPartSize > 0x140000000L) {
                LOG.warn("obs: {} capped to ~5GB (maximum allowed part size with current output mechanism)", (Object)"fs.obs.copypart.size");
                this.copyPartSize = 0x140000000L;
            }
            if ((maxCopyPartThreads = conf.getInt("fs.obs.copypart.threads.max", 40)) < 2) {
                LOG.warn("fs.obs.copypart.threads.max must be at least 2: forcing to 2.");
                maxCopyPartThreads = 2;
            }
            int coreCopyPartThreads = (int)Math.ceil((double)maxCopyPartThreads / 2.0);
            this.boundedCopyPartThreadPool = new ThreadPoolExecutor(coreCopyPartThreads, maxCopyPartThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory("obs-copy-part-transfer-shared"));
            this.boundedCopyPartThreadPool.allowCoreThreadTimeOut(true);
        }
    }

    public boolean isFsBucket() {
        return this.enablePosix;
    }

    public boolean isReadTransformEnabled() {
        return this.readTransformEnable;
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.obs.acl.default", "");
        if (!cannedACLName.isEmpty()) {
            switch (cannedACLName) {
                case "Private": {
                    this.cannedACL = AccessControlList.REST_CANNED_PRIVATE;
                    break;
                }
                case "PublicRead": {
                    this.cannedACL = AccessControlList.REST_CANNED_PUBLIC_READ;
                    break;
                }
                case "PublicReadWrite": {
                    this.cannedACL = AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
                    break;
                }
                case "AuthenticatedRead": {
                    this.cannedACL = AccessControlList.REST_CANNED_AUTHENTICATED_READ;
                    break;
                }
                case "LogDeliveryWrite": {
                    this.cannedACL = AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE;
                    break;
                }
                case "BucketOwnerRead": {
                    this.cannedACL = AccessControlList.REST_CANNED_BUCKET_OWNER_READ;
                    break;
                }
                case "BucketOwnerFullControl": {
                    this.cannedACL = AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL;
                    break;
                }
                default: {
                    this.cannedACL = null;
                    break;
                }
            }
        } else {
            this.cannedACL = null;
        }
    }

    AccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public String getScheme() {
        return "obs";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    @VisibleForTesting
    public ObsClient getObsClient() {
        return this.obs;
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAheadRange;
    }

    String getBucket() {
        return this.bucket;
    }

    public void checkPath(Path path) {
        OBSLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return OBSLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fileStatus;
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        LOG.debug("Opening '{}' for reading.", (Object)f);
        try {
            fileStatus = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
        }
        catch (FileConflictException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "open", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new AccessControlException((Throwable)e);
        }
        if (fileStatus.isDirectory()) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "open", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        FSInputStream fsInputStream = this.inputPolicyFactory.create(this, this.bucket, OBSCommonUtils.pathToKey(this, f), fileStatus.getLen(), this.statistics, this.boundedMultipartUploadThreadPool);
        FSDataInputStream fsDataInputStream = new FSDataInputStream((InputStream)fsInputStream);
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "open", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        return fsDataInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blkSize, Progressable progress) throws IOException {
        this.checkOpen();
        String key = OBSCommonUtils.pathToKey(this, f);
        long startTime = System.currentTimeMillis();
        boolean exist = true;
        try {
            FileStatus status;
            try {
                status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
            }
            catch (FileConflictException e) {
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("overwrite", "create", false, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                throw new ParentNotDirectoryException(e.getMessage());
            }
            if (status.isDirectory()) {
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("overwrite", "create", false, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("overwrite", "create", false, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                throw new FileAlreadyExistsException(f + " already exists");
            }
            LOG.debug("create: Overwriting file {}", (Object)f);
        }
        catch (FileNotFoundException e) {
            LOG.debug("create: Creating new file {}", (Object)f);
            exist = false;
        }
        FSDataOutputStream outputStream = new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, 0L, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true)), false), null);
        if (this.enableFileVisibilityAfterCreate && !exist) {
            outputStream.close();
            outputStream = new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, 0L, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true)), false), null);
        }
        Object record = this.filesBeingWritten;
        synchronized (record) {
            this.filesBeingWritten.put(key, outputStream);
        }
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            record = new BasicMetricsConsumer.MetricRecord("overwrite", "create", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, (BasicMetricsConsumer.MetricRecord)record);
        }
        return outputStream;
    }

    long getPartSize() {
        return this.partSize;
    }

    OBSDataBlocks.BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    OBSWriteOperationHelper getWriteHelper() {
        return this.writeHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blkSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        LOG.debug("create: Creating new file {}, flags:{}, isFsBucket:{}", new Object[]{f, flags, this.isFsBucket()});
        OBSCommonUtils.checkCreateFlag(flags);
        if (null != flags && flags.contains(CreateFlag.APPEND)) {
            if (!this.isFsBucket()) {
                throw new UnsupportedOperationException("non-posix bucket. Append is not supported by OBSFileSystem");
            }
            String key = OBSCommonUtils.pathToKey(this, f);
            boolean exist = true;
            try {
                FileStatus status;
                try {
                    status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
                }
                catch (FileConflictException e) {
                    long endTime = System.currentTimeMillis();
                    if (this.getMetricSwitch()) {
                        BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("flags", "create", false, endTime - startTime);
                        OBSCommonUtils.setMetricsInfo(this, record);
                    }
                    throw new ParentNotDirectoryException(e.getMessage());
                }
                if (status.isDirectory()) {
                    long endTime = System.currentTimeMillis();
                    if (this.getMetricSwitch()) {
                        BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("flags", "create", false, endTime - startTime);
                        OBSCommonUtils.setMetricsInfo(this, record);
                    }
                    throw new FileAlreadyExistsException(f + " is a directory");
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("FileNotFoundException, create: Creating new file {}", (Object)f);
                exist = false;
            }
            FSDataOutputStream outputStream = new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, 0L, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true)), true), null);
            if (this.enableFileVisibilityAfterCreate && !exist) {
                outputStream.close();
                outputStream = new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, 0L, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true)), true), null);
            }
            Map<String, FSDataOutputStream> e = this.filesBeingWritten;
            synchronized (e) {
                this.filesBeingWritten.put(key, outputStream);
            }
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("flags", "create", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return outputStream;
        }
        FSDataOutputStream outputStream = this.create(f, permission, flags == null || flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blkSize, progress);
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("flags", "create", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        return outputStream;
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blkSize, Progressable progress) throws IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        OBSCommonUtils.checkCreateFlag(flags);
        if (path.getParent() != null && !this.exists(path.getParent())) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "createNonRecursive", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new FileNotFoundException(path.toString() + " parent directory not exist.");
        }
        FSDataOutputStream fsDataOutputStream = this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blkSize, progress);
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "createNonRecursive", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        return fsDataOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        FileStatus status;
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        if (!this.isFsBucket()) {
            throw new UnsupportedOperationException("non-posix bucket. Append is not supported by OBSFileSystem");
        }
        LOG.debug("append: Append file {}.", (Object)f);
        String key = OBSCommonUtils.pathToKey(this, f);
        try {
            status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
        }
        catch (FileConflictException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "append", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new AccessControlException((Throwable)e);
        }
        long objectLen = status.getLen();
        if (status.isDirectory()) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "append", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new FileAlreadyExistsException(f + " is a directory");
        }
        if (this.isFileBeingWritten(key)) {
            throw new IOException("Cannot append " + f + " that is being written.");
        }
        FSDataOutputStream outputStream = new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, objectLen, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true)), true), null, objectLen);
        Map<String, FSDataOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(key, outputStream);
        }
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "append", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        return outputStream;
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        FileStatus status;
        this.checkOpen();
        if (!this.enablePosix) {
            super.truncate(f, newLength);
        }
        if (newLength < 0L) {
            throw new IOException((Throwable)new HadoopIllegalArgumentException("Cannot truncate " + f + " to a negative file size: " + newLength + "."));
        }
        try {
            status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
        }
        catch (FileConflictException e) {
            throw new AccessControlException((Throwable)e);
        }
        if (!status.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + f);
        }
        String key = OBSCommonUtils.pathToKey(this, f);
        if (this.isFileBeingWritten(key)) {
            throw new AlreadyBeingCreatedException("Cannot truncate " + f + " that is being written.");
        }
        long oldLength = status.getLen();
        if (oldLength == newLength) {
            return true;
        }
        if (oldLength < newLength) {
            throw new IOException((Throwable)new HadoopIllegalArgumentException("Cannot truncate " + f + " to a larger file size. Current size: " + oldLength + ", truncate size: " + newLength + "."));
        }
        OBSPosixBucketUtils.innerFsTruncateWithRetry(this, f, newLength);
        return true;
    }

    public boolean exists(Path f) throws IOException {
        this.checkOpen();
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean rename(Path src, Path dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getMaxEntriesToDelete() {
        return this.maxEntriesToDelete;
    }

    int getListParallelFactor() {
        return this.listParallelFactor;
    }

    ThreadPoolExecutor getBoundedListThreadPool() {
        return this.boundedListThreadPool;
    }

    boolean isObsClientDFSListEnable() {
        return this.obsClientDFSListEnable;
    }

    FileSystem.Statistics getSchemeStatistics() {
        return this.statistics;
    }

    int getMultiDeleteThreshold() {
        return this.multiDeleteThreshold;
    }

    boolean isEnableMultiObjectDelete() {
        return this.enableMultiObjectDelete;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        try {
            FileStatus status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
            LOG.debug("delete: path {} - recursive {}", (Object)status.getPath(), (Object)recursive);
            if (this.enablePosix) {
                boolean success = OBSPosixBucketUtils.fsDelete(this, status, recursive);
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "delete", true, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                return success;
            }
            boolean success = OBSObjectBucketUtils.objectDelete(this, status, recursive);
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "delete", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return success;
        }
        catch (FileNotFoundException e) {
            LOG.warn("Couldn't delete {} - does not exist", (Object)f);
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "delete", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return false;
        }
        catch (FileConflictException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "delete", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new AccessControlException((Throwable)e);
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "delete", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("delete", f, e);
        }
    }

    boolean isEnableTrash() {
        return this.enableTrash;
    }

    String getTrashDir() {
        return this.trashDir;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        try {
            FileStatus[] statuses = OBSCommonUtils.innerListStatus(this, f, false);
            long endTime = System.currentTimeMillis();
            LOG.debug("List status for path:{}, thread:{}, timeUsedInMilliSec:{}", new Object[]{f, threadId, endTime - startTime});
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("nonrecursive", "listStatus", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return statuses;
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("nonrecursive", "listStatus", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("listStatus", f, e);
        }
    }

    public FileStatus[] listStatus(Path f, boolean recursive) throws FileNotFoundException, IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        try {
            FileStatus[] statuses = OBSCommonUtils.innerListStatus(this, f, recursive);
            long endTime = System.currentTimeMillis();
            LOG.debug("List status for path:{}, thread:{}, timeUsedInMilliSec:{}", new Object[]{f, threadId, endTime - startTime});
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("recursive", "listStatus", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return statuses;
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("recursive", "listStatus", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("listStatus with recursive flag[" + (recursive ? "true] " : "false] "), f, e);
        }
    }

    OBSListing getObsListing() {
        return this.obsListing;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path newDir) {
        String result = this.fixRelativePart(newDir).toUri().getPath();
        if (!OBSCommonUtils.isValidName(result)) {
            throw new IllegalArgumentException("Invalid directory name " + result);
        }
        this.workingDir = this.fixRelativePart(newDir);
    }

    String getShortUserName() {
        return this.shortUserName;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        try {
            boolean success = OBSCommonUtils.innerMkdirs(this, path);
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "mkdirs", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return success;
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "mkdirs", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("mkdirs", path, e);
        }
    }

    public FileStatus getFileStatus(Path f) throws FileNotFoundException, IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        try {
            FileStatus fileStatus = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getFileStatus", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return fileStatus;
        }
        catch (FileConflictException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getFileStatus", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new FileNotFoundException(e.getMessage());
        }
    }

    @VisibleForTesting
    OBSFileStatus innerGetFileStatus(Path f) throws IOException {
        if (this.enablePosix) {
            OBSFileStatus fileStatus = OBSPosixBucketUtils.innerFsGetObjectStatus(this, f);
            return fileStatus;
        }
        OBSFileStatus fileStatus = OBSObjectBucketUtils.innerGetObjectStatus(this, f);
        return fileStatus;
    }

    public ContentSummary getContentSummary(Path f) throws FileNotFoundException, IOException {
        FileStatus status;
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        if (!this.obsContentSummaryEnable) {
            return super.getContentSummary(f);
        }
        try {
            status = OBSCommonUtils.innerGetFileStatusWithRetry(this, f);
        }
        catch (FileConflictException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getContentSummary", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw new AccessControlException((Throwable)e);
        }
        if (status.isFile()) {
            long length = status.getLen();
            ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getContentSummary", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return contentSummary;
        }
        if (this.enablePosix) {
            ContentSummary contentSummary = OBSPosixBucketUtils.fsGetDirectoryContentSummary(this, OBSCommonUtils.pathToKey(this, f));
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getContentSummary", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return contentSummary;
        }
        ContentSummary contentSummary = OBSObjectBucketUtils.getDirectoryContentSummary(this, OBSCommonUtils.pathToKey(this, f));
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "getContentSummary", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        return contentSummary;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws FileAlreadyExistsException, IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        try {
            super.copyFromLocalFile(delSrc, overwrite, src, dst);
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "copyFromLocalFile", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "copyFromLocalFile", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("copyFromLocalFile(" + src + ", " + dst + ")", src, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LOG.debug("This Filesystem closed by user, clear resource.");
        if (this.closed) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.closeAllFilesBeingWritten();
        this.closed = true;
        long endTime = System.currentTimeMillis();
        if (this.getMetricSwitch()) {
            BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord("fs", "close", true, endTime - startTime);
            OBSCommonUtils.setMetricsInfo(this, record);
        }
        try {
            super.close();
            if (this.metricsConsumer != null) {
                this.metricsConsumer.close();
            }
            this.obs.close();
        }
        catch (Throwable throwable) {
            OBSCommonUtils.shutdownAll(new ExecutorService[]{this.boundedMultipartUploadThreadPool, this.boundedCopyThreadPool, this.boundedDeleteThreadPool, this.boundedCopyPartThreadPool, this.boundedListThreadPool});
            throw throwable;
        }
        OBSCommonUtils.shutdownAll(new ExecutorService[]{this.boundedMultipartUploadThreadPool, this.boundedCopyThreadPool, this.boundedDeleteThreadPool, this.boundedCopyPartThreadPool, this.boundedListThreadPool});
        LOG.info("Finish closing filesystem instance for uri: {}", (Object)this.uri);
    }

    public String getCanonicalServiceName() {
        if (this.enableCanonicalServiceName) {
            return this.getScheme() + "://" + this.bucket;
        }
        return null;
    }

    long getCopyPartSize() {
        return this.copyPartSize;
    }

    ThreadPoolExecutor getBoundedCopyPartThreadPool() {
        return this.boundedCopyPartThreadPool;
    }

    ThreadPoolExecutor getBoundedCopyThreadPool() {
        return this.boundedCopyThreadPool;
    }

    public long getDefaultBlockSize() {
        return this.blockSize;
    }

    public long getDefaultBlockSize(Path f) {
        return this.blockSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OBSFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAheadRange=").append(this.readAheadRange);
        sb.append(", blockSize=").append(this.getDefaultBlockSize());
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", boundedMultipartUploadThreadPool=").append(this.boundedMultipartUploadThreadPool);
        sb.append(", statistics {").append(this.statistics).append("}");
        sb.append(", metrics {").append("}");
        sb.append('}');
        return sb.toString();
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        this.checkOpen();
        long startTime = System.currentTimeMillis();
        Path path = OBSCommonUtils.qualify(this, f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            FileStatus fileStatus;
            try {
                fileStatus = OBSCommonUtils.innerGetFileStatusWithRetry(this, path);
            }
            catch (FileConflictException e) {
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listFiles", false, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                throw new AccessControlException((Throwable)e);
            }
            if (fileStatus.isFile()) {
                OBSListing.SingleStatusRemoteIterator locatedFileStatus = new OBSListing.SingleStatusRemoteIterator(OBSCommonUtils.toLocatedFileStatus(this, fileStatus));
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listFiles", true, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                LOG.debug("Path is a file");
                return locatedFileStatus;
            }
            LOG.debug("listFiles: doing listFiles of directory {} - recursive {}", (Object)path, (Object)recursive);
            String key = OBSCommonUtils.maybeAddTrailingSlash(OBSCommonUtils.pathToKey(this, path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            OBSListing.LocatedFileStatusIterator locatedFileStatus = this.obsListing.createLocatedFileStatusIterator(this.obsListing.createFileStatusListingIterator(path, OBSCommonUtils.createListObjectsRequest(this, key, delimiter), OBSListing.ACCEPT_ALL, new OBSListing.AcceptFilesOnly(path)));
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listFiles", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return locatedFileStatus;
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listFiles", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        this.checkOpen();
        return this.listLocatedStatus(f, OBSListing.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        this.checkOpen();
        Path path = OBSCommonUtils.qualify(this, f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        long startTime = System.currentTimeMillis();
        try {
            FileStatus fileStatus;
            try {
                fileStatus = OBSCommonUtils.innerGetFileStatusWithRetry(this, path);
            }
            catch (FileConflictException e) {
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listLocatedStatus", false, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                throw new AccessControlException((Throwable)e);
            }
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                OBSListing.SingleStatusRemoteIterator locatedFileStatusRemoteList = new OBSListing.SingleStatusRemoteIterator(filter.accept(path) ? OBSCommonUtils.toLocatedFileStatus(this, fileStatus) : null);
                long endTime = System.currentTimeMillis();
                if (this.getMetricSwitch()) {
                    BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listLocatedStatus", true, endTime - startTime);
                    OBSCommonUtils.setMetricsInfo(this, record);
                }
                return locatedFileStatusRemoteList;
            }
            String key = OBSCommonUtils.maybeAddTrailingSlash(OBSCommonUtils.pathToKey(this, path));
            OBSListing.LocatedFileStatusIterator locatedFileStatusRemoteList = this.obsListing.createLocatedFileStatusIterator(this.obsListing.createFileStatusListingIterator(path, OBSCommonUtils.createListObjectsRequest(this, key, "/"), filter, new OBSListing.AcceptAllButSelfAndS3nDirs(path)));
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listLocatedStatus", true, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            return locatedFileStatusRemoteList;
        }
        catch (ObsException e) {
            long endTime = System.currentTimeMillis();
            if (this.getMetricSwitch()) {
                BasicMetricsConsumer.MetricRecord record = new BasicMetricsConsumer.MetricRecord(null, "listLocatedStatus", false, endTime - startTime);
                OBSCommonUtils.setMetricsInfo(this, record);
            }
            throw OBSCommonUtils.translateException("listLocatedStatus", path, e);
        }
    }

    public SseWrapper getSse() {
        return this.sse;
    }

    @VisibleForTesting
    void setBucketPolicy(String policy) {
        this.obs.setBucketPolicy(this.bucket, policy);
    }

    public void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("OBSFilesystem closed");
        }
    }

    BasicMetricsConsumer getMetricsConsumer() {
        return this.metricsConsumer;
    }

    public boolean getMetricSwitch() {
        return this.metricSwitch;
    }

    int getInvokeCountThreshold() {
        return this.invokeCountThreshold;
    }
}

