/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.obs.Pair;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.util.Progressable;

public class OBSHDFSFileSystem
extends DistributedFileSystem {
    public static final Log LOG = LogFactory.getLog(OBSHDFSFileSystem.class);
    private static final String CONFIG_HDFS_PREFIX = "fs.hdfs.mounttable";
    private static final String CONFIG_HDFS_DEFAULT_MOUNT_TABLE = "default";
    private static final String CONFIG_HDFS_LINK = "link";
    public static final String WRAPPERFS_RESERVED = "/.wrapperfs_reserved";
    private Configuration wrapperConf;
    private Map<String, MountInfo> mountMap;
    private DistributedFileSystem underHDFS;

    public void setWorkingDirectory(Path path) {
        TransferedPath newPath = this.transferToNewPath(path);
        try {
            newPath.getFS().setWorkingDirectory(newPath.toPath());
        }
        catch (IOException e) {
            LOG.error((Object)"failed to set working directoy");
        }
    }

    private List<Pair<String, String>> getMountList(Configuration config, String viewName) {
        ArrayList<Pair<String, String>> mountList = new ArrayList<Pair<String, String>>();
        String mountTableName = viewName;
        if (mountTableName == null) {
            mountTableName = CONFIG_HDFS_DEFAULT_MOUNT_TABLE;
        }
        String mountTablePrefix = "fs.hdfs.mounttable." + mountTableName + ".";
        String linkPrefix = "link.";
        for (Map.Entry si : config) {
            String src;
            String key = (String)si.getKey();
            if (!key.startsWith(mountTablePrefix) || !(src = key.substring(mountTablePrefix.length())).startsWith("link.")) continue;
            String pathPrefix = src.substring("link.".length()).trim();
            if (pathPrefix.endsWith("/") && !pathPrefix.trim().equals("/")) {
                pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
            }
            mountList.add(new Pair(pathPrefix, si.getValue()));
        }
        return mountList;
    }

    private List<Pair<String, String>> initMountList(List<Pair<String, String>> mountList) {
        ArrayList<Pair<String, String>> mappingPaths = new ArrayList<Pair<String, String>>();
        Collections.sort(mountList, Comparator.comparingInt(p -> ((String)p.getKey()).length()));
        for (int i = 0; i < mountList.size(); ++i) {
            String mountTarget = mountList.get(i).getValue();
            String mountPoint = mountList.get(i).getKey();
            URI.create(mountTarget);
            boolean conflict = mappingPaths.stream().map(Pair::getKey).filter(mp -> mountPoint.equals(mp) || mountPoint.startsWith((String)mp) && mountPoint.substring(mp.length()).startsWith("/")).map(mp -> {
                LOG.warn((Object)("mount point: " + mountPoint + " is ignored by shorted mount point: " + mp));
                return mp;
            }).findFirst().isPresent();
            if (conflict) continue;
            mappingPaths.add(mountList.get(i));
            LOG.info((Object)(mountList.get(i).getKey() + "->" + mountList.get(i).getValue()));
        }
        return mappingPaths;
    }

    private TransferedPath transferToNewPath(Path path) {
        Object pathComps;
        String inputPath = path.toUri().getPath();
        if (inputPath.startsWith(WRAPPERFS_RESERVED) && ((String[])(pathComps = inputPath.split("/", 5))).length >= 4) {
            Object object = pathComps[2];
            Object authority = pathComps[3];
            if ("null".equals(authority)) {
                authority = null;
            }
            String reservedPath = "/" + (String)pathComps[4];
            MountInfo mi = this.findMountWithSchemaAndAuthority((String)object, (String)authority);
            if (mi != null) {
                return new TransferedPath(mi, reservedPath, true);
            }
            MountInfo reservedMountInfo = new MountInfo(String.format("%s/%s/%s/", WRAPPERFS_RESERVED, object, authority), "/", () -> this.underHDFS);
            return new TransferedPath(reservedMountInfo, reservedPath, true);
        }
        for (Map.Entry entry : this.mountMap.entrySet()) {
            String subPath;
            if (!inputPath.startsWith((String)entry.getKey()) || (subPath = inputPath.substring(((String)entry.getKey()).length())).length() != 0 && !subPath.startsWith("/")) continue;
            return new TransferedPath(this.mountMap.get(entry.getKey()), subPath);
        }
        MountInfo originMount = new MountInfo("/", "/", () -> this.underHDFS);
        return new TransferedPath(originMount, inputPath, false);
    }

    private MountInfo findMountWithSchemaAndAuthority(String schema, String authority) {
        for (MountInfo m : this.mountMap.values()) {
            try {
                if (!Objects.equals(m.getToFileSystem().getUri().getScheme(), schema) || !Objects.equals(m.getToFileSystem().getUri().getAuthority(), authority)) continue;
                return m;
            }
            catch (IOException e) {
                LOG.warn((Object)"ignore this warn", (Throwable)e);
            }
        }
        return null;
    }

    private Path toWrappedPath(Path inMountPath, FileSystem mountPointFS) throws IOException {
        URI inMountURI = inMountPath.toUri();
        String schema = Optional.ofNullable(inMountURI.getScheme()).orElse(mountPointFS.getScheme());
        String authority = inMountURI.getAuthority();
        String path = inMountURI.getPath();
        for (MountInfo m : this.mountMap.values()) {
            if (!this.inSameFileSystem(mountPointFS, schema, authority, m) || !path.startsWith(m.toPath)) continue;
            String subFolder = path.substring(m.toPath.length());
            return this.makeQualified(new Path(new Path(m.fromPath), new Path(subFolder)));
        }
        return Path.mergePaths((Path)this.getReservedPath(schema, authority), (Path)new Path(path));
    }

    private Path getReservedPath(String schema, String authority) {
        return new Path(String.format("/.wrapperfs_reserved/%s/%s/", schema, authority));
    }

    private boolean inSameFileSystem(FileSystem mountPointFS, String schema, String authority, MountInfo m) throws IOException {
        return m.getToFileSystem() == mountPointFS || Objects.equals(m.getToFileSystem().getUri().getScheme(), schema) && Objects.equals(m.getToFileSystem().getUri().getAuthority(), authority);
    }

    private Path transferToWrappedPath(Path path, TransferedPath newPath) {
        String remainPart;
        String targetPrefix;
        String currentPath = path.toUri().getPath();
        String fromPrefix = newPath.getMountInfo().getToPath();
        String string = targetPrefix = newPath.isReservedPath ? "/" : newPath.getMountInfo().getFromPath();
        if (currentPath.startsWith(fromPrefix)) {
            remainPart = currentPath.substring(fromPrefix.length());
            if (remainPart.startsWith("/")) {
                remainPart = remainPart.substring(1);
            }
        } else {
            try {
                remainPart = this.toWrappedPath(new Path(currentPath), newPath.getFS()).toString();
            }
            catch (IOException e) {
                LOG.warn((Object)"failed in toWrappedPath", (Throwable)e);
                remainPart = currentPath;
            }
        }
        Path targetPrefixPath = new Path(this.getUri().getScheme(), this.getUri().getAuthority(), targetPrefix);
        return new Path(targetPrefixPath, remainPart);
    }

    public void initialize(URI theUri, Configuration conf) throws IOException {
        this.wrapperConf = new Configuration(conf);
        this.wrapperConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        super.initialize(theUri, conf);
        this.underHDFS = (DistributedFileSystem)FileSystem.newInstance((URI)theUri, (Configuration)this.wrapperConf);
        String authority = theUri.getAuthority();
        this.mountMap = new HashMap<String, MountInfo>();
        for (Pair<String, String> p : this.initMountList(this.getMountList(conf, authority))) {
            String fromPath = new Path(p.getKey()).toString();
            Path toRawPath = new Path(p.getValue());
            String toPath = toRawPath.toUri().getPath();
            LOG.info((Object)("Initialize mount fs from " + fromPath + " to " + toRawPath));
            this.mountMap.put(p.getKey(), new MountInfo(fromPath, toPath, () -> {
                try {
                    return toRawPath.getFileSystem(this.wrapperConf);
                }
                catch (IOException e) {
                    throw new UncheckException(e);
                }
            }));
        }
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        TransferedPath newPath = this.transferToNewPath(file.getPath());
        return newPath.getFS().getFileBlockLocations(newPath.toPath(), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        return newPath.getFS().getFileBlockLocations(newPath.toPath(), start, len);
    }

    public boolean recoverLease(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.recoverLease(path);
        }
        return true;
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().open(newPath.toPath(), i);
    }

    public FSDataOutputStream append(Path f, EnumSet<CreateFlag> flag, int bufferSize, Progressable progress) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().append(newPath.toPath(), bufferSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().create(newPath.toPath(), fsPermission, overwrite, bufferSize, replication, blockSize, progressable);
    }

    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, InetSocketAddress[] favoredNodes) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.create(newPath.toPath(), permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
        }
        throw new UnsupportedOperationException("Not implemented create(final Path f, final FsPermission permission, final boolean overwrite, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final InetSocketAddress[] favoredNodes)!");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> cflags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().create(newPath.toPath(), permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().createNonRecursive(newPath.toPath(), permission, flag, bufferSize, replication, blockSize, progress);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        return newPath.getFS().setReplication(newPath.toPath(), replication);
    }

    public void setStoragePolicy(Path src, String policyName) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        if (newPath.getFS() != this.underHDFS) {
            throw new UnsupportedOperationException("Not implemented setStoragePolicy(Path src, final String policyName)!");
        }
        this.underHDFS.setStoragePolicy(newPath.toPath(), policyName);
    }

    public void unsetStoragePolicy(Path src) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        if (newPath.getFS() != this.underHDFS) {
            throw new UnsupportedOperationException("Not implemented unsetStoragePolicy");
        }
        this.underHDFS.unsetStoragePolicy(newPath.toPath());
    }

    public BlockStoragePolicySpi getStoragePolicy(Path path) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.getStoragePolicy(newPath.toPath());
        }
        throw new UnsupportedOperationException("Not implemented getStoragePolicy(Path path)!");
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        TransferedPath newPath = this.transferToNewPath(trg);
        List newpsrcs = Arrays.stream(psrcs).map(this::transferToNewPath).collect(Collectors.toList());
        String targetAuthority = newPath.getFS().getUri().getAuthority();
        String targetSchema = newPath.getFS().getUri().getScheme();
        for (TransferedPath newpsrc : newpsrcs) {
            if (newpsrc.getFS().getUri().getScheme().equals(targetSchema) && newpsrc.getFS().getUri().getAuthority().equals(targetAuthority)) continue;
            throw new UnsupportedOperationException("can not concat files across the filesystem, target filesystem: " + newPath.getFS().getUri() + ", source: " + newpsrc.getFS().getUri());
        }
        Path[] concatPaths = (Path[])newpsrcs.stream().map(TransferedPath::toPath).toArray(Path[]::new);
        newPath.getFS().concat(newPath.toPath(), concatPaths);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        TransferedPath newPathDest = this.transferToNewPath(dst);
        if (!Objects.equals(newPath.getFS().getUri().getAuthority(), newPathDest.getFS().getUri().getAuthority())) {
            throw new IOException(new UnsupportedOperationException("can not support rename across filesystem. srcfs: " + newPath.getFS().getUri() + ", dsffs: " + newPathDest.getFS().getUri()));
        }
        return newPath.getFS().rename(newPath.toPath(), newPathDest.toPath());
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        TransferedPath newPathDest = this.transferToNewPath(dst);
        if (!Objects.equals(newPath.getFS().getUri().getAuthority(), newPathDest.getFS().getUri().getAuthority())) {
            throw new IOException(new UnsupportedOperationException("can not support rename across filesystem"));
        }
        if (newPath.toPath().toString().equals(newPathDest.toPath().toString())) {
            return;
        }
        try {
            Class<?> classType = newPath.getFS().getClass();
            Method method = classType.getDeclaredMethod("rename", Path.class, Path.class, Options.Rename[].class);
            method.setAccessible(true);
            method.invoke((Object)newPath.getFS(), newPath.toPath(), newPathDest.toPath(), options);
            return;
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)"ignore, use rename function, go to below code", (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.warn((Object)"use reflection rename failed, ignore this and use FileSystem.rename method.", (Throwable)e);
        }
        if (options.length > 0 && options[0] == Options.Rename.OVERWRITE) {
            newPath.getFS().delete(newPathDest.toPath(), false);
            newPath.getFS().rename(newPath.toPath(), newPathDest.toPath());
        } else {
            newPath.getFS().rename(newPath.toPath(), newPathDest.toPath());
        }
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().truncate(newPath.toPath(), newLength);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().delete(newPath.toPath(), recursive);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().getContentSummary(newPath.toPath());
    }

    public QuotaUsage getQuotaUsage(Path f) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().getQuotaUsage(newPath.toPath());
    }

    public void setQuota(Path src, long namespaceQuota, long storagespaceQuota) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        if (newPath.getFS() != this.underHDFS) {
            throw new UnsupportedOperationException("Not implemented setQuota(Path src, final long namespaceQuota, final long storagespaceQuota)!");
        }
        this.underHDFS.setQuota(newPath.toPath(), namespaceQuota, storagespaceQuota);
    }

    public void setQuotaByStorageType(Path src, StorageType type, long quota) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(src);
        if (newPath.getFS() != this.underHDFS) {
            throw new UnsupportedOperationException("Not implemented setQuotaByStorageType(Path src, final StorageType type, final long quota)!");
        }
        this.underHDFS.setQuotaByStorageType(newPath.toPath(), type, quota);
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.listStatus(newPath.toPath());
        }
        FileStatus[] fileStatuses = newPath.getFS().listStatus(newPath.toPath());
        for (int i = 0; i < fileStatuses.length; ++i) {
            fileStatuses[i].setPath(this.transferToWrappedPath(fileStatuses[i].getPath(), newPath));
        }
        return fileStatuses;
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return new WrappedRemoteIterator<LocatedFileStatus>(newPath.getFS().listFiles(newPath.toPath(), recursive), fileStatus -> {
            Path originPath = this.transferToWrappedPath(fileStatus.getPath(), newPath);
            fileStatus.setPath(originPath);
            return fileStatus;
        });
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path p, PathFilter filter) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        return new WrappedRemoteIterator<LocatedFileStatus>(newPath.getFS().listLocatedStatus(newPath.toPath()), fileStatus -> {
            Path originPath = this.transferToWrappedPath(fileStatus.getPath(), newPath);
            fileStatus.setPath(originPath);
            return fileStatus;
        });
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        return new WrappedRemoteIterator<FileStatus>(newPath.getFS().listStatusIterator(newPath.toPath()), fileStatus -> {
            Path originPath = this.transferToWrappedPath(fileStatus.getPath(), newPath);
            fileStatus.setPath(originPath);
            return fileStatus;
        });
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.mkdir(newPath.toPath(), permission);
        }
        return newPath.getFS().mkdirs(newPath.toPath(), permission);
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().mkdirs(newPath.toPath(), fsPermission);
    }

    public void close() throws IOException {
        IOException ex = null;
        try {
            super.close();
        }
        catch (IOException e) {
            ex = e;
            LOG.error((Object)"failed to close", (Throwable)e);
        }
        for (MountInfo value : this.mountMap.values()) {
            try {
                if (value.toFileSystem == null) continue;
                value.toFileSystem.close();
            }
            catch (IOException e) {
                ex = e;
                LOG.error((Object)("failed to close " + value), (Throwable)e);
            }
        }
        if (this.underHDFS != null) {
            this.underHDFS.close();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public FsStatus getStatus(Path p) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        return newPath.getFS().getStatus(newPath.toPath());
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return new WrappedRemoteIterator<Path>(newPath.getFS().listCorruptFileBlocks(newPath.toPath()), p -> this.transferToWrappedPath((Path)p, newPath));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        FileStatus fileStatus = newPath.getFS().getFileStatus(newPath.toPath());
        Optional.ofNullable(fileStatus).ifPresent(f -> f.setPath(path));
        return fileStatus;
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        TransferedPath newTarget = this.transferToNewPath(target);
        TransferedPath newLink = this.transferToNewPath(link);
        if (!newTarget.getFS().getUri().getAuthority().equals(newLink.getFS().getUri().getAuthority())) {
            throw new UnsupportedOperationException("can not support createSymlink across filesystem");
        }
        newLink.getFS().createSymlink(newTarget.toPath(), newLink.toPath(), createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.getFileLinkStatus(newPath.toPath());
        }
        FileStatus fileStatus = newPath.getFS().getFileLinkStatus(newPath.toPath());
        Optional.ofNullable(fileStatus).ifPresent(fileStatus1 -> fileStatus1.setPath(f));
        return fileStatus;
    }

    public Path getLinkTarget(Path f) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        if (newPath.getFS() == this.underHDFS) {
            return this.underHDFS.getLinkTarget(newPath.toPath());
        }
        return newPath.getFS().getLinkTarget(newPath.toPath());
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().getFileChecksum(newPath.toPath());
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        TransferedPath newPath = this.transferToNewPath(f);
        return newPath.getFS().getFileChecksum(newPath.toPath(), length);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        newPath.getFS().setPermission(newPath.toPath(), permission);
    }

    public void setOwner(Path p, String username, String groupname) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        newPath.getFS().setOwner(newPath.toPath(), username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws UnsupportedOperationException, IOException {
        TransferedPath newPath = this.transferToNewPath(p);
        newPath.getFS().setTimes(newPath.toPath(), mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().createSnapshot(newPath.toPath(), snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().renameSnapshot(newPath.toPath(), snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        TransferedPath newPath = this.transferToNewPath(snapshotDir);
        newPath.getFS().deleteSnapshot(newPath.toPath(), snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().modifyAclEntries(newPath.toPath(), aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().removeAclEntries(newPath.toPath(), aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().removeDefaultAcl(newPath.toPath());
    }

    public void removeAcl(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().removeAcl(newPath.toPath());
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().setAcl(newPath.toPath(), aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().getAclStatus(newPath.toPath());
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().setXAttr(newPath.toPath(), name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().getXAttr(newPath.toPath(), name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().getXAttrs(newPath.toPath());
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().getXAttrs(newPath.toPath(), names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        return newPath.getFS().listXAttrs(newPath.toPath());
    }

    public void removeXAttr(Path path, String name) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().removeXAttr(newPath.toPath(), name);
    }

    public void access(Path path, FsAction mode) throws IOException {
        TransferedPath newPath = this.transferToNewPath(path);
        newPath.getFS().access(newPath.toPath(), mode);
    }

    public Path getTrashRoot(Path path) {
        TransferedPath newPath = this.transferToNewPath(path);
        try {
            return this.toWrappedPath(newPath.getFS().getTrashRoot(newPath.toPath()), newPath.getFS());
        }
        catch (IOException e) {
            throw new UncheckException(e);
        }
    }

    static class UncheckException
    extends RuntimeException {
        public UncheckException(IOException origin) {
            super(origin);
        }

        public IOException getException() {
            return (IOException)this.getCause();
        }
    }

    static class TransferedPath {
        private final boolean isReservedPath;
        MountInfo mountInfo;
        String remainPath;

        public TransferedPath(MountInfo mountInfo, String remainPath, boolean isReservedPath) {
            this.mountInfo = mountInfo;
            this.remainPath = remainPath;
            this.isReservedPath = isReservedPath;
        }

        public TransferedPath(MountInfo mountInfo, String remainPath) {
            this(mountInfo, remainPath, false);
        }

        public MountInfo getMountInfo() {
            return this.mountInfo;
        }

        public String getRemainPath() {
            return this.remainPath;
        }

        public FileSystem getFS() throws IOException {
            return this.mountInfo.getToFileSystem();
        }

        public Path toPath() {
            if (this.remainPath == null || this.remainPath.trim().length() == 0) {
                return new Path(this.mountInfo.toPath);
            }
            if (this.isReservedPath) {
                return new Path(this.remainPath);
            }
            return this.remainPath.length() > 1 ? new Path(this.mountInfo.toPath, this.remainPath.substring(1)) : new Path(this.mountInfo.toPath);
        }
    }

    static class MountInfo {
        String fromPath;
        String toPath;
        Supplier<FileSystem> toFileSystemSupplier;
        FileSystem toFileSystem = null;

        public MountInfo(String from, String to, Supplier<FileSystem> toFileSystem) {
            this.fromPath = from;
            this.toPath = to;
            this.toFileSystemSupplier = toFileSystem;
        }

        public String getFromPath() {
            return this.fromPath;
        }

        public String getToPath() {
            return this.toPath;
        }

        public FileSystem getToFileSystem() throws IOException {
            if (this.toFileSystem != null) {
                return this.toFileSystem;
            }
            if (this.toFileSystemSupplier != null) {
                this.initToFileSystem();
            }
            return this.toFileSystem;
        }

        private synchronized void initToFileSystem() throws IOException {
            if (this.toFileSystem == null) {
                try {
                    this.toFileSystem = this.toFileSystemSupplier.get();
                }
                catch (UncheckException e) {
                    throw e.getException();
                }
            }
        }
    }

    private static class WrappedRemoteIterator<T>
    implements RemoteIterator {
        private final RemoteIterator<T> origin;
        private final Function<T, T> convertFunc;

        WrappedRemoteIterator(RemoteIterator<T> origin, Function<T, T> convertFunc) {
            this.origin = origin;
            this.convertFunc = convertFunc;
        }

        public boolean hasNext() throws IOException {
            return this.origin.hasNext();
        }

        public Object next() throws IOException {
            return this.convertFunc.apply(this.origin.next());
        }
    }
}

