/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.exception.ObsException;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSFileStatus;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OBSListing {
    static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(OBSListing.class);
    private final OBSFileSystem owner;

    OBSListing(OBSFileSystem ownerFS) {
        this.owner = ownerFS;
    }

    FileStatusListingIterator createFileStatusListingIterator(Path listPath, ListObjectsRequest request, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
        return new FileStatusListingIterator(new ObjectListingIterator(listPath, request), filter, acceptor);
    }

    LocatedFileStatusIterator createLocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
        return new LocatedFileStatusIterator(statusIterator);
    }

    class LocatedFileStatusIterator
    implements RemoteIterator<LocatedFileStatus> {
        private final RemoteIterator<FileStatus> statusIterator;

        LocatedFileStatusIterator(RemoteIterator<FileStatus> statusRemoteIterator) {
            this.statusIterator = statusRemoteIterator;
        }

        public boolean hasNext() throws IOException {
            return this.statusIterator.hasNext();
        }

        public LocatedFileStatus next() throws IOException {
            return OBSCommonUtils.toLocatedFileStatus(OBSListing.this.owner, (FileStatus)this.statusIterator.next());
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<ObjectListing> {
        private final Path listPath;
        private ObjectListing objects;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;

        ObjectListingIterator(Path path, ListObjectsRequest request) throws IOException {
            this.listPath = path;
            this.maxKeys = OBSListing.this.owner.getMaxKeys();
            this.objects = OBSCommonUtils.listObjects(OBSListing.this.owner, request);
        }

        public boolean hasNext() {
            return this.firstListing || this.objects.isTruncated();
        }

        public ObjectListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                try {
                    if (!this.objects.isTruncated()) {
                        throw new NoSuchElementException("No more results in listing of " + this.listPath);
                    }
                    LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                    this.objects = OBSCommonUtils.continueListObjects(OBSListing.this.owner, this.objects);
                    ++this.listingCount;
                    LOG.debug("New listing status: {}", (Object)this);
                }
                catch (ObsException e) {
                    throw OBSCommonUtils.translateException("listObjects()", this.listPath, e);
                }
            }
            return this.objects;
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated();
        }
    }

    class FileStatusListingIterator
    implements RemoteIterator<FileStatus> {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<FileStatus> statusBatchIterator;

        FileStatusListingIterator(ObjectListingIterator listPath, PathFilter pathFilter, FileStatusAcceptor fileStatusAcceptor) throws IOException {
            this.source = listPath;
            this.filter = pathFilter;
            this.acceptor = fileStatusAcceptor;
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.statusBatchIterator.hasNext() || this.requestNextBatch();
        }

        public FileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.statusBatchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(ObjectListing objects) {
            Path keyPath;
            String key;
            int added = 0;
            int ignored = 0;
            ArrayList<OBSFileStatus> stats = new ArrayList<OBSFileStatus>(objects.getObjects().size() + objects.getCommonPrefixes().size());
            for (ObsObject summary : objects.getObjects()) {
                key = summary.getObjectKey();
                keyPath = OBSCommonUtils.keyToQualifiedPath(OBSListing.this.owner, key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)OBSCommonUtils.stringify(summary));
                }
                if (this.acceptor.accept(keyPath, summary) && this.filter.accept(keyPath)) {
                    OBSFileStatus status = OBSCommonUtils.createFileStatus(keyPath, summary, OBSListing.this.owner.getDefaultBlockSize(keyPath), OBSListing.this.owner.getShortUserName());
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (ObsObject prefix : objects.getExtenedCommonPrefixes()) {
                key = prefix.getObjectKey();
                keyPath = OBSCommonUtils.keyToQualifiedPath(OBSListing.this.owner, key);
                if (this.acceptor.accept(keyPath, key) && this.filter.accept(keyPath)) {
                    long lastModified = prefix.getMetadata().getLastModified() == null ? System.currentTimeMillis() : OBSCommonUtils.dateToLong(prefix.getMetadata().getLastModified());
                    OBSFileStatus status = new OBSFileStatus(keyPath, lastModified, lastModified, OBSListing.this.owner.getShortUserName());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }
    }

    static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        AcceptAllButSelfAndS3nDirs(Path path) {
            this.qualifiedPath = path;
        }

        @Override
        public boolean accept(Path keyPath, ObsObject summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getObjectKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals((Object)this.qualifiedPath);
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        AcceptFilesOnly(Path path) {
            this.qualifiedPath = path;
        }

        @Override
        public boolean accept(Path keyPath, ObsObject summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getObjectKey().endsWith("_$folder$") && !OBSCommonUtils.objectRepresentsDirectory(summary.getObjectKey(), summary.getMetadata().getContentLength());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }
    }

    static final class SingleStatusRemoteIterator
    implements RemoteIterator<LocatedFileStatus> {
        private LocatedFileStatus status;

        SingleStatusRemoteIterator(LocatedFileStatus locatedFileStatus) {
            this.status = locatedFileStatus;
        }

        public boolean hasNext() {
            return this.status != null;
        }

        public LocatedFileStatus next() {
            if (this.hasNext()) {
                LocatedFileStatus s = this.status;
                this.status = null;
                return s;
            }
            throw new NoSuchElementException();
        }
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, ObsObject var2);

        public boolean accept(Path var1, String var2);
    }
}

