/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.base.Preconditions;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.UploadPartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSObjectBucketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OBSWriteOperationHelper {
    public static final Logger LOG = LoggerFactory.getLogger(OBSWriteOperationHelper.class);
    static final int PART_NUMBER = 10000;
    private final OBSFileSystem owner;
    private final String bucket;
    private final ObsClient obs;

    protected OBSWriteOperationHelper(OBSFileSystem fs) {
        this.owner = fs;
        this.bucket = fs.getBucket();
        this.obs = fs.getObsClient();
    }

    PutObjectRequest newPutRequest(String destKey, InputStream inputStream, long length) {
        return OBSCommonUtils.newPutObjectRequest(this.owner, destKey, this.newObjectMetadata(length), inputStream);
    }

    PutObjectRequest newPutRequest(String destKey, File sourceFile) {
        int length = (int)sourceFile.length();
        return OBSCommonUtils.newPutObjectRequest(this.owner, destKey, this.newObjectMetadata(length), sourceFile);
    }

    void writeSuccessful(String destKey) {
        LOG.debug("Finished write to {}", (Object)destKey);
    }

    public ObjectMetadata newObjectMetadata(long length) {
        return OBSObjectBucketUtils.newObjectMetadata(length);
    }

    String initiateMultiPartUpload(String destKey) throws IOException {
        LOG.debug("Initiating Multipart upload");
        InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(this.bucket, destKey);
        initiateMPURequest.setAcl(this.owner.getCannedACL());
        initiateMPURequest.setMetadata(this.newObjectMetadata(-1L));
        if (this.owner.getSse().isSseCEnable()) {
            initiateMPURequest.setSseCHeader(this.owner.getSse().getSseCHeader());
        } else if (this.owner.getSse().isSseKmsEnable()) {
            initiateMPURequest.setSseKmsHeader(this.owner.getSse().getSseKmsHeader());
        }
        try {
            return this.obs.initiateMultipartUpload(initiateMPURequest).getUploadId();
        }
        catch (ObsException ace) {
            throw OBSCommonUtils.translateException("Initiate MultiPartUpload", destKey, ace);
        }
    }

    CompleteMultipartUploadResult completeMultipartUpload(String destKey, String uploadId, List<PartEtag> partETags) throws ObsException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        Preconditions.checkArgument((!partETags.isEmpty() ? 1 : 0) != 0, (Object)"No partitions have been uploaded");
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.obs.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucket, destKey, uploadId, new ArrayList<PartEtag>(partETags)));
    }

    void abortMultipartUpload(String destKey, String uploadId) throws ObsException {
        LOG.debug("Aborting multipart upload {}", (Object)uploadId);
        this.obs.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, destKey, uploadId));
    }

    UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, File sourceFile) {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((sourceFile != null ? 1 : 0) != 0, (Object)"Data source");
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (Object[])new Object[]{size});
        Preconditions.checkArgument((partNumber > 0 && partNumber <= 10000 ? 1 : 0) != 0);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        UploadPartRequest request = new UploadPartRequest();
        request.setUploadId(uploadId);
        request.setBucketName(this.bucket);
        request.setObjectKey(destKey);
        request.setPartSize(Long.valueOf(size));
        request.setPartNumber(partNumber);
        request.setFile(sourceFile);
        if (this.owner.getSse().isSseCEnable()) {
            request.setSseCHeader(this.owner.getSse().getSseCHeader());
        }
        return request;
    }

    UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream) {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((uploadStream != null ? 1 : 0) != 0, (Object)"Data source");
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (Object[])new Object[]{size});
        Preconditions.checkArgument((partNumber > 0 && partNumber <= 10000 ? 1 : 0) != 0);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        UploadPartRequest request = new UploadPartRequest();
        request.setUploadId(uploadId);
        request.setBucketName(this.bucket);
        request.setObjectKey(destKey);
        request.setPartSize(Long.valueOf(size));
        request.setPartNumber(partNumber);
        request.setInput(uploadStream);
        if (this.owner.getSse().isSseCEnable()) {
            request.setSseCHeader(this.owner.getSse().getSseCHeader());
        }
        return request;
    }

    public String toString(String destKey) {
        return "{bucket=" + this.bucket + ", key='" + destKey + '\'' + '}';
    }

    PutObjectResult putObject(PutObjectRequest putObjectRequest) throws IOException {
        try {
            return OBSCommonUtils.putObjectDirect(this.owner, putObjectRequest);
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("put", putObjectRequest.getObjectKey(), e);
        }
    }
}

