/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.istack.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SemaphoredDelegatingExecutor
extends ForwardingListeningExecutorService {
    private final Semaphore queueingPermits;
    private final ListeningExecutorService executorDelegatee;
    private final int permitCount;

    public SemaphoredDelegatingExecutor(ListeningExecutorService listExecutorDelegatee, int permitSize, boolean fair) {
        this.permitCount = permitSize;
        this.queueingPermits = new Semaphore(permitSize, fair);
        this.executorDelegatee = listExecutorDelegatee;
    }

    protected ListeningExecutorService delegate() {
        return this.executorDelegatee;
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) {
        throw new RuntimeException("Not implemented");
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) {
        throw new RuntimeException("Not implemented");
    }

    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) {
        throw new RuntimeException("Not implemented");
    }

    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) {
        throw new RuntimeException("Not implemented");
    }

    @NotNull
    public <T> ListenableFuture<T> submit(@NotNull Callable<T> task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    @NotNull
    public <T> ListenableFuture<T> submit(@NotNull Runnable task, @NotNull T result) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task), result);
    }

    @NotNull
    public ListenableFuture<?> submit(@NotNull Runnable task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task));
    }

    public void execute(@NotNull Runnable command) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute((Runnable)new RunnableWithPermitRelease(command));
    }

    public int getAvailablePermits() {
        return this.queueingPermits.availablePermits();
    }

    public int getWaitingCount() {
        return this.queueingPermits.getQueueLength();
    }

    public int getPermitCount() {
        return this.permitCount;
    }

    public String toString() {
        return "SemaphoredDelegatingExecutor{permitCount=" + this.getPermitCount() + ", available=" + this.getAvailablePermits() + ", waiting=" + this.getWaitingCount() + '}';
    }

    class CallableWithPermitRelease<T>
    implements Callable<T> {
        private Callable<T> delegatee;

        CallableWithPermitRelease(Callable<T> delegateeTask) {
            this.delegatee = delegateeTask;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.delegatee.call();
                return t;
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }

    class RunnableWithPermitRelease
    implements Runnable {
        private Runnable delegatee;

        RunnableWithPermitRelease(Runnable exeDelegatee) {
            this.delegatee = exeDelegatee;
        }

        @Override
        public void run() {
            try {
                this.delegatee.run();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }
}

