/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs.input;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReadAheadBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private final byte[] buffer;
    private STATUS status;
    private long start;
    private long end;

    public ReadAheadBuffer(long bufferStart, long bufferEnd) {
        this.buffer = new byte[(int)(bufferEnd - bufferStart) + 1];
        this.status = STATUS.INIT;
        this.start = bufferStart;
        this.end = bufferEnd;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void await(STATUS waitStatus) throws InterruptedException {
        while (this.status == waitStatus) {
            this.condition.await();
        }
    }

    public void signalAll() {
        this.condition.signalAll();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public long getByteStart() {
        return this.start;
    }

    public long getByteEnd() {
        return this.end;
    }

    public static enum STATUS {
        INIT,
        SUCCESS,
        ERROR;

    }
}

