/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs.input;

import com.obs.services.ObsClient;
import com.obs.services.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.obs.input.ReadAheadBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAheadTask
implements Runnable {
    public final Logger log = LoggerFactory.getLogger(ReadAheadTask.class);
    private String bucketName;
    private String key;
    private ObsClient client;
    private ReadAheadBuffer buffer;
    private static final int MAX_RETRIES = 3;
    private RetryPolicy retryPolicy;

    public ReadAheadTask(String bucketName, String key, ObsClient client, ReadAheadBuffer buffer) {
        this.bucketName = bucketName;
        this.key = key;
        this.client = client;
        this.buffer = buffer;
        RetryPolicy defaultPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)3, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<NullPointerException>, RetryPolicy> policies = new HashMap<Class<NullPointerException>, RetryPolicy>();
        policies.put(IOException.class, defaultPolicy);
        policies.put(IndexOutOfBoundsException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        policies.put(NullPointerException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        this.retryPolicy = RetryPolicies.retryByException((RetryPolicy)defaultPolicy, policies);
    }

    private boolean shouldRetry(Exception e, int retries) {
        boolean shouldRetry = true;
        try {
            RetryPolicy.RetryAction retry = this.retryPolicy.shouldRetry(e, retries, 0, true);
            if (retry.action == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                Thread.sleep(retry.delayMillis);
            } else {
                shouldRetry = false;
            }
        }
        catch (Exception ex) {
            this.log.warn("Exception thrown when call shouldRetry, exception " + ex);
            shouldRetry = false;
        }
        return shouldRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int retries = 0;
        this.buffer.lock();
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, this.key);
            request.setRangeStart(this.buffer.getByteStart());
            request.setRangeEnd(this.buffer.getByteEnd());
            while (true) {
                try (InputStream in = this.client.getObject(request).getObjectContent();){
                    IOUtils.readFully((InputStream)in, (byte[])this.buffer.getBuffer(), (int)0, (int)this.buffer.getBuffer().length);
                    this.buffer.setStatus(ReadAheadBuffer.STATUS.SUCCESS);
                }
                catch (Exception e) {
                    this.log.warn("Exception thrown when retrieve key: " + this.key + ", exception: " + e);
                    if (this.shouldRetry(e, ++retries)) continue;
                }
                break;
            }
            if (this.buffer.getStatus() != ReadAheadBuffer.STATUS.SUCCESS) {
                this.buffer.setStatus(ReadAheadBuffer.STATUS.ERROR);
            }
            this.buffer.signalAll();
        }
        finally {
            this.buffer.unlock();
        }
    }
}

