# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import FCDException
import utils.common.log as logger
from plugins.DistributedStorage.scripts.ManageConverge.implement.tc_install_node import InstallNode
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain


class InstallNodeIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            InstallNode(project_id, pod_id, self.fs_args).run()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626066, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            InstallNode(project_id, pod_id, self.fs_args).retry_install_node()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626066, str(e)))
        return Message()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
