/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.exception.InnerException;
import uds.eds.adapter.EdsClientWrapper;

public abstract class AbstractEdsAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEdsAction.class);
    protected EdsClientWrapper edsClient;

    public AbstractEdsAction(EdsClientWrapper edsClient) {
        this.edsClient = edsClient;
    }

    public abstract Object process() throws Exception;

    public abstract void processException() throws InnerException;

    public Object call() throws Exception {
        try {
            return this.process();
        }
        catch (IOException e) {
            LOGGER.warn("eds action io error [{}] failed. needToRetry:[{}], msg:{}", new Object[]{this.getName(), this.needToRetry(), e.getMessage()});
            if (this.needToRetry()) {
                this.processException();
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("eds action [{}] failed. needToRetry:[{}], msg:{}", new Object[]{this.getName(), this.needToRetry(), e.getMessage()});
            if (this.needToRetry()) {
                this.processException();
            }
            throw e;
        }
    }

    public abstract String getName();

    public abstract boolean needToRetry();
}

