/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter;

import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.exception.InnerException;
import uds.common.storage.exception.StorEngineException;
import uds.common.util.CommonUtils;
import uds.common.util.PerfUtils;
import uds.common.util.SystemProperties;
import uds.eds.adapter.AbstractEdsAction;

public class EdsActionExecutor<T extends AbstractEdsAction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdsActionExecutor.class);
    private static final int EDS_CLIENT_UNAVAILABLE_SLEEP_TIME = 20000;
    private static final long MAX_COST_TIME_MS = OBSConfig.getInstance().getInt("eds_action_max_cost_time_ms", 160000);
    private static final long POW_BASE = 2L;
    private int baseSleepTimeMS;
    private int baseSleepBoundaryS = OBSConfig.getInstance().getInt("eds_action_base_sleep_boundary_second", 2);
    private long maxSleepTimeMS = OBSConfig.getInstance().getInt("eds_action_max_sleep_time_ms", 20000);
    private int maxRetryCount;

    public EdsActionExecutor(int maxRetryCount, int baseSleepTime) {
        this.maxRetryCount = maxRetryCount;
        this.baseSleepTimeMS = baseSleepTime;
    }

    /*
     * Loose catch block
     */
    public Object execute(T t) throws InnerException, ExecutionException {
        if (t == null) {
            LOGGER.warn("action is null");
            throw new IllegalArgumentException("eds action is null");
        }
        long actionStartTime = System.nanoTime();
        int businessRetryCount = 0;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new ExecutionException("thread has been interrupted", new InterruptedException());
            }
            try {
                return ((AbstractEdsAction)t).call();
            }
            catch (StorEngineException e) {
                if (((AbstractEdsAction)t).needToRetry()) {
                    businessRetryCount = this.handleExceptionWhenRetry(actionStartTime, businessRetryCount, e, t);
                    continue;
                }
                throw e;
            }
            break;
        }
        catch (Exception e) {
            throw new InnerException((Throwable)e);
        }
    }

    private int handleExceptionWhenRetry(long startTime, int businessRetryCount, StorEngineException engineException, T t) throws StorEngineException {
        long sleepInterval;
        long baseSleepInterval = this.baseSleepTimeMS;
        if (this.baseSleepBoundaryS > 0) {
            Random rand = new Random();
            baseSleepInterval += (long)(rand.nextInt(this.baseSleepBoundaryS) * 1000);
        }
        sleepInterval = (sleepInterval = baseSleepInterval * (long)Math.pow(2.0, Math.min(businessRetryCount, 20))) > this.maxSleepTimeMS || sleepInterval <= 0L ? this.maxSleepTimeMS : sleepInterval;
        int tmpMaxRetryCount = this.maxRetryCount;
        long costTime = PerfUtils.calcTimeCostInMS((long)startTime);
        if (++businessRetryCount >= tmpMaxRetryCount || costTime > MAX_COST_TIME_MS) {
            LOGGER.warn("failed to execute action." + this.generateLogMsg(businessRetryCount, sleepInterval, (Exception)((Object)engineException), t, startTime));
            SystemProperties.setAttribute((String)"response_error_code", (Object)"ServerOverLoad");
            throw engineException;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.generateLogMsg(businessRetryCount, sleepInterval, (Exception)((Object)engineException), t, startTime));
        }
        CommonUtils.sleepQuiet((long)sleepInterval);
        return businessRetryCount;
    }

    private String generateLogMsg(int retryCount, long curSleepTime, Exception exception, T t, long actionStartTime) {
        StringBuilder sb = new StringBuilder("");
        sb.append("action=").append(t == null ? null : ((AbstractEdsAction)t).getName());
        sb.append(", retryCount=").append(retryCount);
        sb.append(", maxRetryCount=").append(this.maxRetryCount);
        sb.append(", curSleepTime=").append(curSleepTime);
        sb.append(", costTime=").append(PerfUtils.calcTimeCostInMS((long)actionStartTime));
        sb.append(", maxCostTime=").append(MAX_COST_TIME_MS);
        sb.append(", baseSleepTimeMS=").append(this.baseSleepTimeMS);
        sb.append(", Exception=").append(exception == null ? null : exception.getMessage());
        sb.append('}');
        return sb.toString();
    }
}

