/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.SHIMErrorCode;
import uds.common.config.interf.OBSConfig;
import uds.common.constants.OSCInnerContants;
import uds.common.entity.eio.ProxyByteBuffer;
import uds.common.exception.InnerException;
import uds.common.log.ErrorLogLimiter;
import uds.common.storage.exception.StorBusyException;
import uds.common.util.SystemProperties;
import uds.eds.adapter.AbstractEdsAction;
import uds.eds.adapter.EdsActionExecutor;
import uds.eds.adapter.EdsClientWrapper;
import uds.eds.adapter.action.AllocateEdsAction;
import uds.eds.adapter.action.ExtendEdsAction;
import uds.eds.adapter.action.ReleaseEdsAction;
import uds.eds.adapter.action.SendRequestEdsAction;
import uds.eds.client.FileRequest;
import uds.eds.client.FileResponse;
import uds.eds.client.OpResult;
import uds.eds.client.OpType;

public enum EdsAdapter {
    INSTANCE;

    private static final Logger LOGGER;
    private static EdsClientWrapper client;
    private static final int EDS_EXE_RETRY_COUNT;
    private static final int EDS_EXE_SLEEP_BASE_TIME;
    private static EdsActionExecutor<AbstractEdsAction> executor;
    private AtomicLong readIOPS = new AtomicLong(0L);
    private AtomicLong writeIOPS = new AtomicLong(0L);

    public ProxyByteBuffer allocateBuffer(long fileOffset, int len) throws IOException {
        try {
            return (ProxyByteBuffer)executor.execute(new AllocateEdsAction(fileOffset, len, client));
        }
        catch (Exception e) {
            LOGGER.warn("allocate failed finally!", (Throwable)e);
            throw new IOException("fail to allocate buffer.", e);
        }
    }

    public void extendBuffer(ProxyByteBuffer proxyByteBuffer, int len) throws IOException {
        try {
            executor.execute(new ExtendEdsAction(proxyByteBuffer, len, client));
        }
        catch (ExecutionException | InnerException e) {
            LOGGER.warn("extend failed finally!", e);
            throw new IOException("fail to extend buffer.", e);
        }
    }

    public void releaseBuffer(ProxyByteBuffer buffer) throws Exception {
        try {
            executor.execute(new ReleaseEdsAction(buffer, client));
        }
        catch (Exception e) {
            throw new Exception("fail to release buffer.", e);
        }
    }

    public FileResponse sendRequest(FileRequest request, ProxyByteBuffer data) throws Exception {
        try {
            if (this.checkNeedIOPS()) {
                if (!request.isReadOperation()) {
                    this.writeIOPS.incrementAndGet();
                } else {
                    this.readIOPS.incrementAndGet();
                }
            }
            FileResponse response = (FileResponse)executor.execute(new SendRequestEdsAction(request, data, client));
            if (this.isDebugLog(request)) {
                LOGGER.debug("execute action, ERR_CODE:[{}], opType:{}, src:{}", new Object[]{request.getResponse().getErrorCode(), request.getType(), request.getFileInfo().getSrc()});
                return response;
            }
            if ((request.getResponse().getResult() != OpResult.Success || LOGGER.isDebugEnabled()) && !OSCInnerContants.MULTI_FULL_PART_PATH.equals(request.getFileInfo().getSrc()) && ErrorLogLimiter.getInstance().tryAcquire() && request.getResponse().getErrorCode() != SHIMErrorCode.SHM_STATUS_ENOTEMPTY.getErrorCode()) {
                LOGGER.warn("execute action, ERR_CODE:[{}], opType:{}, src:{}", new Object[]{request.getResponse().getErrorCode(), request.getType(), request.getFileInfo().getSrc()});
            }
            return response;
        }
        catch (StorBusyException e) {
            if (ErrorLogLimiter.getInstance().tryAcquire()) {
                LOGGER.error("send flush request error. request:" + request, (Throwable)e);
            }
            return request.getResponse();
        }
        catch (Exception e) {
            if (ErrorLogLimiter.getInstance().tryAcquire()) {
                LOGGER.warn("execute send eds request action failed, {}", (Object)request);
            }
            throw new Exception("fail to send request.", e);
        }
    }

    private boolean isDebugLog(FileRequest request) {
        if (request.getResponse().getErrorCode() != SHIMErrorCode.SHM_STATUS_OBJECT_NOT_FOUND.getErrorCode() && request.getResponse().getErrorCode() != SHIMErrorCode.SHM_STATUS_DATA_NOT_FOUND.getErrorCode()) {
            return false;
        }
        if (request.getType() == OpType.GET_META || request.getType() == OpType.GET_DATA_AND_METADATA || request.getType() == OpType.GET_DATA) {
            return true;
        }
        return request.getType() == OpType.GET_XATTR || request.getType() == OpType.LIST;
    }

    private boolean checkNeedIOPS() {
        Object innerDpsRequest = SystemProperties.getAttribute((String)"inner_dps_request");
        return innerDpsRequest == null;
    }

    public long getReadIOPS() {
        return this.readIOPS.getAndSet(0L);
    }

    public long getWriteIOPS() {
        return this.writeIOPS.getAndSet(0L);
    }

    static {
        LOGGER = LoggerFactory.getLogger(EdsAdapter.class);
        client = EdsClientWrapper.getInstance();
        EDS_EXE_RETRY_COUNT = OBSConfig.getInstance().getInt("eds_write_action_max_retry_count", 15);
        EDS_EXE_SLEEP_BASE_TIME = OBSConfig.getInstance().getInt("eds_write_action_base_sleep_time_ms", 80);
        executor = new EdsActionExecutor(EDS_EXE_RETRY_COUNT, EDS_EXE_SLEEP_BASE_TIME);
    }
}

