/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.SHIMErrorCode;
import uds.common.config.interf.OBSConfig;
import uds.common.entity.eio.ProxyByteBuffer;
import uds.common.entity.eio.ProxySglByteBuffer;
import uds.common.entity.eio.SglByteBuffer;
import uds.common.exception.InnerException;
import uds.common.util.ftds.FTDSID;
import uds.common.util.ftds.FTDSPerfStatManager;
import uds.core.util.OBSExecutors;
import uds.eds.adapter.ObsThroughSeparatorLocalCache;
import uds.eds.client.EdsClient;
import uds.eds.client.EdsClientBuilder;
import uds.eds.client.FileRequest;
import uds.eds.client.FileResponse;
import uds.eds.client.InitType;
import uds.eds.client.KVRequest;
import uds.eds.client.KVResponse;
import uds.eds.client.OpResult;
import uds.eds.client.OpType;
import uds.eds.client.ThirdAclPolicy;
import uds.eds.ftdsutils.EdsFtdsUtils;
import uds.eds.partition.EdsOpAdpter;

public class EdsClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdsClientWrapper.class);
    private static final String SNAPSHOT_WITH_DELIMITER = "/.snapshot";
    private static final String RECYCLE_WITH_DELIMITER = "/.recyclebininternal";
    private static final String CONFLICT_WITH_DELIMITER = "/.conflictdirinternal";
    private final EdsClient edsClient = EdsClientBuilder.getInstance().buildInterface();
    private final Executor executor = OBSExecutors.newThreadPoolExecutor((int)1, (int)1, (long)0L, (int)100, (String)"eds-client");
    private final LoadingCache<Integer, Boolean> hdfsFeatureSupportCache = CacheBuilder.newBuilder().maximumSize(10L).refreshAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, Boolean>(){

        public Boolean load(Integer type) {
            return EdsClientWrapper.this.edsClient.hdfsFeatureSupport(type.intValue());
        }

        public ListenableFuture<Boolean> reload(Integer type, Boolean isSupportPrev) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> EdsClientWrapper.this.edsClient.hdfsFeatureSupport(type.intValue()));
            EdsClientWrapper.this.executor.execute((Runnable)task);
            return task;
        }
    });

    public static EdsClientWrapper getInstance() {
        return EdsClientWrapperHolder.INSTANCE;
    }

    public int init(InitType initType) throws IOException {
        int result;
        LOGGER.warn("begin to load EDS. initType:{}", (Object)initType);
        if (initType == null) {
            throw new IOException("initType is null.");
        }
        if (initType != InitType.INIT_PLOG_CLIENT && (result = this.edsClient.initSrv()) != 0) {
            LOGGER.error("call native method failed {}", (Object)result);
            throw new IOException("initSrv failed.");
        }
        LOGGER.warn("success load EDS.");
        return 0;
    }

    public int destroy() {
        return this.edsClient.destroyFromEds();
    }

    public int flushEdsLog() {
        return this.edsClient.flushEdsLog();
    }

    public ProxyByteBuffer allocateBuffer(long fileOffset, int len) throws Exception {
        return this.allocateSglByteBuffer(fileOffset, len);
    }

    public ProxyByteBuffer extendBuffer(ProxyByteBuffer buffer, int len) throws IOException {
        buffer.extend(len);
        long startTime = System.nanoTime();
        if (!(buffer.getByteBuffer() instanceof SglByteBuffer)) {
            throw new IOException("not ProxySglByteBuffer, do not support extend");
        }
        int ret = this.edsClient.extendSglByteBuffer((SglByteBuffer)buffer.getByteBuffer(), len);
        FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_ALLOC_SGL_BUFFER, (long)startTime);
        if (ret != 0) {
            throw new IOException("alloc sgl byte buffer failed!");
        }
        return buffer;
    }

    public void releaseBuffer(ProxyByteBuffer buffer) {
        if (buffer instanceof ProxySglByteBuffer) {
            long startTime = System.nanoTime();
            this.edsClient.freeSglByteBuffer((SglByteBuffer)buffer.getByteBuffer());
            FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_FREE_SGL_BUFFER, (long)startTime);
        } else {
            this.edsClient.releaseBufferFromEds((ByteBuffer)buffer.getByteBuffer());
        }
    }

    public void releaseFileResponse(FileResponse response) {
        this.edsClient.releaseFileResponseFromEds(response);
    }

    public static boolean need2ReTry(FileRequest request) {
        boolean shouldReTry = false;
        if (request != null && request.getResponse() != null) {
            FileResponse response = request.getResponse();
            switch (request.getType()) {
                case FLUSH: 
                case PUT_DATA: 
                case GET_DATA: 
                case GET_DATA_AND_METADATA: 
                case APPEND: 
                case CREATE_WITH_DATA: 
                case DELETE: 
                case LIST: 
                case GET_XATTR: 
                case PUT_DATA_WITH_METADATA: 
                case CREATE: {
                    if (response.getResult() == OpResult.Success || !EdsClientWrapper.checkNeedRetry(response.getErrorCode())) break;
                    shouldReTry = true;
                    break;
                }
            }
        }
        return shouldReTry;
    }

    public static boolean checkNeedRetry(long errorCode) {
        SHIMErrorCode shimErrorCode = SHIMErrorCode.valueOf((long)errorCode);
        if (shimErrorCode == null) {
            return false;
        }
        switch (shimErrorCode) {
            case SHM_STATUS_UNKNOWN_ERRNO: 
            case SHM_STATUS_INTERNAL_ERROR: 
            case SHM_STATUS_TIMEOUT: 
            case SHM_STATUS_INVALID_WORKCTL: 
            case SHM_STATUS_FWD_RETRY: 
            case SHM_STATUS_FORWARD_INTERNAL_TIMEOUT: 
            case SHM_STATUS_FORWARD_RETRY: 
            case SHM_STATUS_FORWARD_TRANS_ERR: 
            case SHM_STATUS_FORWARD_ERR: 
            case SHM_STATUS_DCACHE_BUSY: 
            case SHM_STATUS_ALLOC_FAILED: 
            case ENOMEM: {
                return true;
            }
        }
        return false;
    }

    public FileResponse sendRequest(FileRequest request, ProxyByteBuffer data) throws Exception {
        this.resetSrc(request);
        long startTime = System.nanoTime();
        Optional<FTDSID> ftdsId = EdsFtdsUtils.getFtdsIdByType(request.getType());
        long delayId = 0L;
        if (ftdsId.isPresent()) {
            delayId = FTDSPerfStatManager.objHighDelayWithStatusStart((FTDSID)ftdsId.get(), (long)startTime);
        }
        if (OBSConfig.getInstance().isSupportPartition()) {
            EdsOpAdpter.sendRequestToEds(request, data);
        } else {
            this.edsClient.sendRequestToEds(request, data);
        }
        if (ftdsId.isPresent()) {
            FTDSPerfStatManager.objHighDelayWithStatusEnd((FTDSID)ftdsId.get(), (long)delayId, (int)(request.getResult() == OpResult.Success ? 0 : (EdsClientWrapper.checkNeedRetry(request.getResponse().getErrorCode()) ? 3 : 1)));
        }
        EdsFtdsUtils.ftdsOpType(request.getType(), startTime, request.getResponse().getResult() == OpResult.Success ? 0 : this.convertErrorToFtds(request.getResponse().getErrorCode()));
        if (request.getType() == OpType.CREATE_WITH_DATA) {
            EdsClientWrapper.resetResp2Request(request);
        }
        LOGGER.debug("send request: {}", (Object)request);
        if (request.getResponse() == null) {
            throw new IOException("response is empty.");
        }
        return request.getResponse();
    }

    private static void resetResp2Request(FileRequest request) {
        FileResponse fileResponse = new FileResponse();
        fileResponse.setFileInfo(request.getFileInfo());
        fileResponse.setResult(request.getResult());
        if (request.getResult() != OpResult.Success && request.getResponse() != null) {
            long errorCode = request.getResponse().getErrorCode();
            fileResponse.setErrorCode(errorCode);
        }
        fileResponse.getFileInfo().setFId(request.getResponse().getFileInfo().getFId());
        fileResponse.getFileInfo().setObjectVersionId(request.getResponse().getFileInfo().getObjectVersionId());
        fileResponse.getFileInfo().setDeleteMarker(request.getResponse().getFileInfo().isDeleteMarker());
        request.setResponse(fileResponse);
    }

    private void resetSrc(FileRequest request) throws InnerException {
        if (StringUtils.isEmpty((CharSequence)request.getFileInfo().getSrc())) {
            return;
        }
        boolean isNativeBucket = ObsThroughSeparatorLocalCache.getInstance().isObsThroughSeparatorOn(request.getFileInfo().getNsID());
        String src = request.getFileInfo().getSrc();
        if (isNativeBucket) {
            boolean isReservedFolder;
            boolean bl = isReservedFolder = src.startsWith(SNAPSHOT_WITH_DELIMITER) || src.startsWith(RECYCLE_WITH_DELIMITER) || src.startsWith(CONFLICT_WITH_DELIMITER);
            if (isReservedFolder) {
                return;
            }
            if (request.getFileInfo().isRestSrc()) {
                return;
            }
            if (!OpType.LIST.equals((Object)request.getType()) || !src.startsWith("/")) {
                request.getFileInfo().setSrc(String.format(Locale.ROOT, "/%s", src));
                request.getFileInfo().setRestSrc(true);
            }
        } else if (!src.startsWith("/")) {
            request.getFileInfo().setSrc(String.format(Locale.ROOT, "/%s", src));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVResponse sendKVRequest(KVRequest request, ProxyByteBuffer data) throws Exception {
        KVResponse kVResponse;
        long startTime = System.nanoTime();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("send KVRequest: {}", (Object)request.toString());
            }
            this.edsClient.sendKVRequestToEds(request, data);
            if (request.getResponse() == null) {
                throw new IOException("response is empty.");
            }
            kVResponse = request.getResponse();
        }
        catch (Throwable throwable) {
            EdsFtdsUtils.ftdsOpType(request.getType(), startTime, request.getResponse().getResult() == OpResult.Success ? 0 : this.convertErrorToFtds(request.getResponse().getErrorCode()));
            throw throwable;
        }
        EdsFtdsUtils.ftdsOpType(request.getType(), startTime, request.getResponse().getResult() == OpResult.Success ? 0 : this.convertErrorToFtds(request.getResponse().getErrorCode()));
        return kVResponse;
    }

    private ProxyByteBuffer allocateSglByteBuffer(long fileOffset, int len) throws IOException {
        SglByteBuffer buffer = new SglByteBuffer(fileOffset, len);
        long startTime = System.nanoTime();
        int ret = this.edsClient.allocateSglByteBuffer(buffer);
        FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_ALLOC_SGL_BUFFER, (long)startTime);
        if (ret != 0) {
            throw new IOException("alloc sgl byte buffer failed!");
        }
        return new ProxySglByteBuffer(buffer);
    }

    public List<String> getFileDomains() {
        return Stream.of((Object[])Optional.ofNullable(this.edsClient.getFileDomains()).orElseGet(() -> new String[0])).collect(Collectors.toList());
    }

    public boolean setThirdAclPolicies(ThirdAclPolicy thirdAclPolicy) {
        if (OBSConfig.getInstance().getBoolean("ranger_data_need_to_srv", true)) {
            LOGGER.warn("==>setThirdAclPolicies thirdAclPolicy namespace is {}, version={}", (Object)thirdAclPolicy.getNamespaceId(), (Object)thirdAclPolicy.getVersion());
            int result = this.edsClient.setThirdAclPolicies(thirdAclPolicy);
            LOGGER.warn("<==setThirdAclPolicies result={}", (Object)result);
            return result == 0;
        }
        LOGGER.warn("setThirdAclPolicies success {}", (Object)thirdAclPolicy.getVersion());
        return true;
    }

    public int setMemAlarmThreshold(int type, int threshold) {
        return this.edsClient.setAlarmThreshold(type, threshold);
    }

    public boolean hdfsFeatureSupport(int type) {
        try {
            return (Boolean)this.hdfsFeatureSupportCache.get((Object)type);
        }
        catch (ExecutionException e) {
            LOGGER.error("hdfsFeatureSupport failed", (Throwable)e);
            return false;
        }
    }

    private int convertErrorToFtds(long errorCode) {
        SHIMErrorCode shimErrorCode = SHIMErrorCode.valueOf((long)errorCode);
        int ftdsRet = 4;
        if (shimErrorCode == null) {
            return ftdsRet;
        }
        switch (shimErrorCode) {
            case SHM_STATUS_UNKNOWN_ERRNO: 
            case SHM_STATUS_INTERNAL_ERROR: 
            case SHM_STATUS_TIMEOUT: 
            case SHM_STATUS_INVALID_WORKCTL: 
            case SHM_STATUS_FWD_RETRY: 
            case SHM_STATUS_FORWARD_INTERNAL_TIMEOUT: 
            case SHM_STATUS_FORWARD_RETRY: 
            case SHM_STATUS_FORWARD_TRANS_ERR: 
            case SHM_STATUS_FORWARD_ERR: 
            case SHM_STATUS_DCACHE_BUSY: 
            case ENOMEM: 
            case SHM_STATUS_NODE_IP_NOT_FOUND: 
            case SHM_STATUS_DIO_CONFLICT: 
            case SHM_STATUS_DIO_NEED_RETRY: 
            case SHM_STATUS_DIO_TIMEPOINT_RETRY: 
            case SHM_STATUS_DIO_VERSION_MISMATCH: {
                ftdsRet = 3;
                break;
            }
            case SHM_STATUS_READ_ONLY_FS: 
            case SHM_STATUS_ACCESS_DENIED: 
            case SHM_STATUS_OP_NOT_PERMITTED: 
            case SHM_STATUS_CROSS_DEVICE_LINK: 
            case SHM_STATUS_FILE_SHRINKED: 
            case SHM_STATUS_ACL_SUBTREE_ERR: {
                ftdsRet = 5;
                break;
            }
            case SHM_STATUS_CRC_ERROR: 
            case SHM_STATUS_PATH_COMPONENT_TOO_LONG: 
            case SHM_STATUS_PATH_TOO_LONG: 
            case SHM_STATUS_LMGR_SHARE_CONFLICT: 
            case SHM_STATUS_IS_DIRECTORY: 
            case SHM_STATUS_NOT_A_DIRECTORY: 
            case SHM_STATUS_PATH_SYMLINK_NOT_SUP: 
            case SHM_STATUS_PATH_OVER_SYMLINK_CNT: {
                ftdsRet = 6;
                break;
            }
            default: {
                ftdsRet = 4;
            }
        }
        return ftdsRet;
    }

    public Map<String, String> getNodeInfoMaps(String request, List<String> localIps) {
        return this.edsClient.getNodeInfoMaps(request, localIps);
    }

    private static class EdsClientWrapperHolder {
        private static final EdsClientWrapper INSTANCE = new EdsClientWrapper();

        private EdsClientWrapperHolder() {
        }
    }
}

