/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.exception.InnerException;
import uds.common.exception.NoSuchNameSpaceInfoException;
import uds.common.util.cache.LRULinkedHashMap;
import uds.space.client.SpaceClientFactory;
import uds.space.client.SpaceQueryResponse;

public class ObsThroughSeparatorLocalCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObsThroughSeparatorLocalCache.class);
    private static final ObsThroughSeparatorLocalCache INSTANCE = new ObsThroughSeparatorLocalCache();
    private static final int CACHE_CAPACITY = 10000;
    private static final int CACHE_TIME_OUT = 600000;
    private static final int MAX_TRY_COUNT = 10;
    private static final long NAMESPACE_ENTRY_NOT_EXIST = -2L;
    private static final long SPACE_TIME_OUT = -110L;
    private static final int WAIT_TIME = 500;
    private final Map<Long, ObsThroughSeparatorEntity> entityLRULinkedHashMap = new LRULinkedHashMap(10000);

    private ObsThroughSeparatorLocalCache() {
    }

    public static ObsThroughSeparatorLocalCache getInstance() {
        return INSTANCE;
    }

    public boolean isObsThroughSeparatorOn(long namespaceId) throws InnerException {
        if (namespaceId <= 0L) {
            LOGGER.debug("isObsThroughSeparatorOn unsupported namespaceId[{}] ", (Object)namespaceId);
            return false;
        }
        ObsThroughSeparatorEntity entity = this.entityLRULinkedHashMap.getOrDefault(namespaceId, null);
        if (entity != null && !entity.hasExpired()) {
            return entity.isObsThroughSeparator();
        }
        int retCode = 0;
        for (int tryCnt = 0; tryCnt < 10; ++tryCnt) {
            SpaceQueryResponse rsp = new SpaceQueryResponse();
            retCode = SpaceClientFactory.getSpaceClient().queryObsThroughSeparatorStatus(namespaceId, rsp);
            if (retCode == 0) {
                ObsThroughSeparatorEntity edsEntity = new ObsThroughSeparatorEntity(rsp.isObsThroughSeparatorOn());
                this.entityLRULinkedHashMap.put(namespaceId, edsEntity);
                return edsEntity.isObsThroughSeparator();
            }
            if ((long)retCode == -2L) {
                LOGGER.warn("isObsThroughSeparatorOn failed, namespace:{} not exits.", (Object)namespaceId);
                throw new NoSuchNameSpaceInfoException("namespace not exits." + namespaceId, retCode);
            }
            if ((long)retCode == -110L) {
                LOGGER.error("isObsThroughSeparator failed, nsID:{}, retCode:{}", (Object)namespaceId, (Object)retCode);
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new InnerException();
                }
            }
            LOGGER.error("isObsThroughSeparator failed, nsID:{}, retCode:{}", (Object)namespaceId, (Object)retCode);
        }
        throw new InnerException("call space interface isObsThroughSeparator failed, retCode:" + retCode, 500);
    }

    private static class ObsThroughSeparatorEntity {
        private final boolean isObsThroughSeparator;
        private final long updateTime;

        public ObsThroughSeparatorEntity(boolean isObsThroughSeparator) {
            this.isObsThroughSeparator = isObsThroughSeparator;
            this.updateTime = System.nanoTime();
        }

        public boolean isObsThroughSeparator() {
            return this.isObsThroughSeparator;
        }

        public boolean hasExpired() {
            return System.nanoTime() - this.updateTime > 600000L;
        }
    }
}

