/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter.action;

import uds.common.exception.InnerException;
import uds.common.storage.exception.StorEngineException;
import uds.eds.adapter.AbstractEdsAction;
import uds.eds.adapter.EdsClientWrapper;

public class AllocateEdsAction
extends AbstractEdsAction {
    private int len;
    private long fileOffset;
    private boolean isNeedToRetry;

    public AllocateEdsAction(long fileOffset, int len, EdsClientWrapper edsClient) {
        super(edsClient);
        this.len = len;
        this.isNeedToRetry = false;
        this.fileOffset = fileOffset;
    }

    @Override
    public Object process() throws Exception {
        try {
            return this.edsClient.allocateBuffer(this.fileOffset, this.len);
        }
        catch (Exception e) {
            this.isNeedToRetry = true;
            throw new StorEngineException("allocate eds buffer failed", (Throwable)e);
        }
    }

    @Override
    public void processException() throws InnerException {
    }

    @Override
    public String getName() {
        return AllocateEdsAction.class.getName();
    }

    @Override
    public boolean needToRetry() {
        return this.isNeedToRetry;
    }
}

