/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter.action;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.entity.eio.ProxyByteBuffer;
import uds.common.storage.exception.StorEngineException;
import uds.eds.adapter.AbstractEdsAction;
import uds.eds.adapter.EdsClientWrapper;

public class ExtendEdsAction
extends AbstractEdsAction {
    private static final Logger log = LoggerFactory.getLogger(ExtendEdsAction.class);
    private boolean isNeedToRetry = false;
    private final ProxyByteBuffer sglByteBuffer;
    private final int len;

    public ExtendEdsAction(ProxyByteBuffer sglByteBuffer, int len, EdsClientWrapper edsClient) {
        super(edsClient);
        this.sglByteBuffer = sglByteBuffer;
        this.len = len;
    }

    @Override
    public Object process() throws Exception {
        try {
            return this.edsClient.extendBuffer(this.sglByteBuffer, this.len);
        }
        catch (IOException e) {
            this.isNeedToRetry = true;
            throw new StorEngineException("allocate eds buffer failed", (Throwable)e);
        }
    }

    @Override
    public void processException() {
    }

    @Override
    public String getName() {
        return ExtendEdsAction.class.getName();
    }

    @Override
    public boolean needToRetry() {
        return this.isNeedToRetry;
    }
}

