/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.adapter.action;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.entity.eio.ProxyByteBuffer;
import uds.common.storage.exception.StorBusyException;
import uds.eds.adapter.AbstractEdsAction;
import uds.eds.adapter.EdsClientWrapper;
import uds.eds.client.FileRequest;
import uds.eds.client.FileResponse;

public class SendRequestEdsAction
extends AbstractEdsAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendRequestEdsAction.class);
    private FileRequest request;
    private boolean isNeedToRetry;
    private ProxyByteBuffer data;

    public SendRequestEdsAction(FileRequest request, ProxyByteBuffer data, EdsClientWrapper edsClient) {
        super(edsClient);
        this.data = data;
        this.request = request;
        this.isNeedToRetry = false;
    }

    @Override
    public Object process() throws Exception {
        LOGGER.info("sendRequest start, request:[{}]", (Object)this.request);
        FileResponse result = this.edsClient.sendRequest(this.request, this.data);
        LOGGER.info("process sendRequest end, result:[{}]", (Object)result);
        if (EdsClientWrapper.need2ReTry(this.request)) {
            LOGGER.warn("process sendRequest failed, need reTry! [{}]", (Object)this.request);
            this.isNeedToRetry = true;
            throw new StorBusyException("sendRequest failed");
        }
        return result;
    }

    @Override
    public void processException() {
    }

    @Override
    public String getName() {
        return SendRequestEdsAction.class.getName();
    }

    @Override
    public boolean needToRetry() {
        return this.isNeedToRetry;
    }
}

