/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.ftdsutils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import uds.common.util.ftds.FTDSID;
import uds.common.util.ftds.FTDSPerfStatManager;
import uds.eds.client.OpType;

public class EdsFtdsUtils {
    private static Map<String, FTDSID> ftdsOpCodeMap = new HashMap<String, FTDSID>();

    public static FTDSID getFtdsId(OpType type) {
        FTDSID id = ftdsOpCodeMap.get(EdsFtdsUtils.getKey(type));
        return id == null ? FTDSID.OBJECT_OTHER_OP : id;
    }

    public static Optional<FTDSID> getFtdsIdByType(OpType type) {
        switch (type) {
            case CREATE: 
            case PUT_DATA_WITH_METADATA: 
            case PUT_DATA: 
            case FLUSH: 
            case CREATE_WITH_DATA: {
                return Optional.of(FTDSID.OBJECT_SUBHEAL_PUT);
            }
            case GET_BUCKET_META: 
            case GET_DATA_AND_METADATA: 
            case GET_DATA: 
            case GET_META: {
                return Optional.of(FTDSID.OBJECT_SUBHEAL_GET);
            }
            case DELETE: {
                return Optional.of(FTDSID.OBJECT_SUBHEAL_OTHER);
            }
        }
        return Optional.empty();
    }

    private static String getKey(OpType type) {
        return type.name();
    }

    public static void ftdsOpType(OpType type, long startTime) {
        FTDSID id = EdsFtdsUtils.getFtdsId(type);
        FTDSPerfStatManager.highDelay((FTDSID)id, (long)startTime);
    }

    public static void ftdsOpType(OpType type, long startTime, int status) {
        FTDSID id = EdsFtdsUtils.getFtdsId(type);
        FTDSPerfStatManager.highDelayWithStatus((FTDSID)id, (long)startTime, (int)status);
    }

    static {
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.SET_META), FTDSID.OBJECT_SETMETA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_META), FTDSID.OBJECT_GETMETA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.PUT_DATA), FTDSID.OBJECT_PUTDATA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.PUT_DATA_WITH_METADATA), FTDSID.OBJECT_PUTDATAWITHMETADATA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.FLUSH), FTDSID.OBJECT_FLUSH);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_DATA_AND_METADATA), FTDSID.OBJECT_GETDATAANDMETADATA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_DATA), FTDSID.OBJECT_GETDATA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.CREATE), FTDSID.OBJECT_CREATE);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.CREATE_WITH_DATA), FTDSID.OBJECT_CREATEWITHDATA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.DELETE), FTDSID.OBJECT_DELETE);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.COPY), FTDSID.OBJECT_COPY);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.LIST), FTDSID.OBJECT_LIST);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.SET_ACL), FTDSID.OBJECT_SETACL);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.SET_MAP), FTDSID.OBJECT_SETMAP);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_MAP), FTDSID.OBJECT_GETMAP);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_BUCKET_STORAGE), FTDSID.OBJECT_GETBUCKETSTORAGE);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.SET_TAGGING), FTDSID.OBJECT_SETTAGGING);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_BUCKET_QUOTA), FTDSID.OBJECT_GETBUCKETQUOTA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.CREATE_BUCKET_QUOTA), FTDSID.OBJECT_CREATEBUCKETQUOTA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.MODIFY_BUCKET_QUOTA), FTDSID.OBJECT_MODIFYBUCKETQUOTA);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.MKDIR), FTDSID.OBJECT_MKDIR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.PUT_BUCKET_META), FTDSID.OBJECT_PUT_BUCKET_META);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_BUCKET_META), FTDSID.OBJECT_GET_BUCKET_META);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.DELETE_BUCKET_META), FTDSID.OBJECT_DEL_BUCKET_META);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.SET_XATTR), FTDSID.OBJECT_SET_XATTR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.GET_XATTR), FTDSID.OBJECT_GET_XATTR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.STS_SET_XATTR), FTDSID.OBJECT_STS_SET_XATTR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.STS_GET_XATTR), FTDSID.OBJECT_STS_GET_XATTR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.STS_LIST_XATTR), FTDSID.OBJECT_STS_LIST_XATTR);
        ftdsOpCodeMap.put(EdsFtdsUtils.getKey(OpType.STS_REMOVE_XATTR), FTDSID.OBJECT_STS_REMOVE_XATTR);
    }
}

