/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.partition;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.SHIMErrorCode;
import uds.common.exception.InnerException;
import uds.common.util.ftds.FTDSID;
import uds.common.util.ftds.FTDSPerfStatManager;
import uds.component.statistics.MDCWrapper;
import uds.core.util.OBSExecutors;
import uds.eds.client.EdsClient;
import uds.eds.client.EdsClientBuilder;
import uds.eds.client.FileInfo;
import uds.eds.client.FileRequest;
import uds.eds.client.FileResponse;
import uds.eds.client.ListContainer;
import uds.eds.client.OpResult;
import uds.eds.client.OpType;
import uds.eds.partition.EdsNameRouter;

public class EdsMergeLister {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdsMergeLister.class);
    private EdsClient edsClient = EdsClientBuilder.getInstance().buildInterface();
    private LinkedBlockingQueue<OrderedNode> orderedNodes = new LinkedBlockingQueue();
    private FileRequest request;
    private int maxCount;
    private volatile boolean hasError;
    private int partitionNum;
    private CountDownLatch countDown;
    private long listStartTime;

    EdsMergeLister(FileRequest request) {
        this.request = request;
        this.maxCount = request.getFileInfo().getMaxCount();
        this.partitionNum = EdsNameRouter.getPartitionNum();
        this.countDown = new CountDownLatch(this.partitionNum);
    }

    private ListContainer doMergeList(Queue<OrderedNode> orderedNodes) {
        if (orderedNodes.size() == 1) {
            return orderedNodes.poll().getContainer();
        }
        long startTime = System.nanoTime();
        ListContainer container = new ListContainer();
        PriorityQueue<OrderedNode> minHeap = new PriorityQueue<OrderedNode>(this.maxCount, new NodeComparator());
        for (OrderedNode con : orderedNodes) {
            if (!con.hasNext()) continue;
            minHeap.offer(con);
        }
        for (int i = 0; i < this.maxCount && !minHeap.isEmpty(); ++i) {
            FileInfo last;
            OrderedNode node = minHeap.poll();
            FileInfo cur = node.getFileInfo();
            FileInfo fileInfo = last = container.size() == 0L ? null : container.get((int)(container.size() - 1L));
            if (last != null && cur.isDir() && last.isDir() && last.getSrc().equals(cur.getSrc())) {
                --i;
            } else {
                container.add(node.getFileInfo());
            }
            node.next();
            if (!node.hasNext()) continue;
            minHeap.offer(node);
        }
        FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_MERGE_LIST, (long)startTime);
        return container;
    }

    private FileRequest geneFileRequest(FileRequest request, FileInfo file) {
        FileInfo fileInfo = new FileInfo(file.getNsID(), file.getSrc());
        fileInfo.setMaxCount(file.getMaxCount());
        fileInfo.setStartAfter(file.getStartAfter());
        fileInfo.setPrefix(file.getPrefix());
        FileRequest fileRequest = new FileRequest(OpType.LIST, fileInfo, null, MDCWrapper.get((String)"ctx_request_id"));
        fileRequest.setFsUserName(request.getFsUserName());
        fileRequest.setLdapUser(Boolean.valueOf(request.isLdapUser()));
        return fileRequest;
    }

    private String getListDirName(int partitionId, String src) {
        if ("/".equals(src)) {
            return EdsNameRouter.getPartitionName(partitionId);
        }
        return EdsNameRouter.getPartitionName(partitionId) + src;
    }

    private OrderedNode pollNode() throws InnerException {
        OrderedNode node = null;
        int timeOut = 20;
        int cnt = 500;
        while (node == null && cnt-- > 0 && this.countDown.getCount() != 0L) {
            try {
                node = this.orderedNodes.poll(timeOut, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("list [{}] failed, maxCount={}, partitions={}.", new Object[]{this.request.getFileInfo().getSrc(), this.maxCount, this.partitionNum, e});
                throw new InnerException("list obj failed!");
            }
        }
        if (node == null && this.countDown.getCount() != 0L) {
            LOGGER.error("list [{}] timeout, maxCount={}, partitions={}.", new Object[]{this.request.getFileInfo().getSrc(), this.maxCount, this.partitionNum});
            throw new InnerException("list obj timeout!");
        }
        if (node == null && !this.orderedNodes.isEmpty()) {
            node = this.orderedNodes.poll();
        }
        return node;
    }

    private ListContainer processListResults() throws InnerException {
        long startTime = System.nanoTime();
        ListContainer resultContainer = null;
        boolean isListFinished = false;
        int groupNum = 5;
        while (!this.hasError) {
            ArrayDeque<OrderedNode> queue = new ArrayDeque<OrderedNode>(groupNum);
            for (int i = 0; i < groupNum; ++i) {
                OrderedNode node = this.pollNode();
                if (node == null) {
                    isListFinished = true;
                    break;
                }
                queue.add(node);
            }
            if (isListFinished) {
                resultContainer = this.doMergeList(queue);
                break;
            }
            ListThreadPool.submit(new MergeTask(queue));
        }
        FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_DO_MERGE_LIST, (long)startTime);
        return resultContainer;
    }

    void listAllPartitionObjects() {
        long startTime = System.nanoTime();
        this.listStartTime = System.nanoTime();
        for (int i = 0; i < this.partitionNum; ++i) {
            FileRequest req = this.geneFileRequest(this.request, this.request.getFileInfo());
            req.getFileInfo().setSrc(this.getListDirName(i, req.getFileInfo().getSrc()));
            ListThreadPool.submit(new ListTask(req, this.countDown));
        }
        FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_SUBMIT_LIST, (long)startTime);
        FileResponse response = new FileResponse();
        ListContainer container = null;
        try {
            container = this.processListResults();
            if (this.hasError) {
                throw new InnerException("list failed.");
            }
            response.setResult(OpResult.Success);
        }
        catch (InnerException e) {
            response.setResult(OpResult.FAILED);
            LOGGER.error("list [{}] failed, prefix={}, marker={}, maxCount={}, partitions={}.", new Object[]{this.request.getFileInfo().getSrc(), this.request.getFileInfo().getPrefix(), this.request.getFileInfo().getStartAfter(), this.maxCount, this.partitionNum});
            LOGGER.error("list [" + this.request.getFileInfo().getSrc() + "] failed.", (Throwable)e);
        }
        response.setFileInfoList(container);
        this.request.setResponse(response);
    }

    private static class ListThreadPool {
        private static int coreSize = 10;
        private static int maxPoolSize = 50;
        private static int queueSize = 500;
        private static int expireTime = 1000;
        private static ExecutorService threadPool = OBSExecutors.newThreadPoolExecutor((int)coreSize, (int)maxPoolSize, (long)expireTime, (int)queueSize, (String)"list_partition_t");

        private ListThreadPool() {
        }

        static void submit(Runnable runnable) {
            threadPool.submit(runnable);
        }
    }

    private class MergeTask
    implements Runnable {
        Queue<OrderedNode> queue;

        MergeTask(Queue<OrderedNode> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            ListContainer container = EdsMergeLister.this.doMergeList(this.queue);
            EdsMergeLister.this.orderedNodes.add(new OrderedNode(container));
        }
    }

    private class ListTask
    implements Runnable {
        private FileRequest fileRequest;
        private CountDownLatch countDownLatch;
        private ListContainer resultContainer;

        ListTask(FileRequest fileRequest, CountDownLatch countDownLatch) {
            this.fileRequest = fileRequest;
            this.countDownLatch = countDownLatch;
            this.resultContainer = new ListContainer();
        }

        @Override
        public void run() {
            ListContainer container;
            long startTime = System.nanoTime();
            FileRequest curReq = this.fileRequest;
            while ((container = this.doListEds(curReq)) != null) {
                long remainCnt = container.getNumRemaining();
                int i = 0;
                while ((long)i < container.size() && this.resultContainer.size() < (long)EdsMergeLister.this.maxCount) {
                    this.resultContainer.add(container.get(i));
                    ++i;
                }
                curReq = this.geneNextRequest(curReq);
                if (this.resultContainer.size() < (long)EdsMergeLister.this.maxCount && remainCnt > 0L) continue;
            }
            if (this.resultContainer.size() != 0L) {
                EdsMergeLister.this.orderedNodes.add(new OrderedNode(this.resultContainer));
            }
            this.countDownLatch.countDown();
            if (this.countDownLatch.getCount() == 0L) {
                FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_PARALLEL_LIST, (long)EdsMergeLister.this.listStartTime);
            }
            FTDSPerfStatManager.highDelay((FTDSID)FTDSID.OBJECT_PARTITION_LIST, (long)startTime);
        }

        private FileRequest geneNextRequest(FileRequest curReq) {
            FileInfo fileInfo = new FileInfo(curReq.getFileInfo().getNsID(), curReq.getFileInfo().getSrc());
            fileInfo.setMaxCount((int)((long)EdsMergeLister.this.maxCount - this.resultContainer.size()));
            String marker = this.resultContainer.size() == 0L ? null : this.resultContainer.get((int)(this.resultContainer.size() - 1L)).getSrc();
            fileInfo.setStartAfter(marker);
            fileInfo.setPrefix(curReq.getFileInfo().getPrefix());
            FileRequest nextReq = new FileRequest(OpType.LIST, fileInfo, null, MDCWrapper.get((String)"ctx_request_id"));
            nextReq.setFsUserName(curReq.getFsUserName());
            nextReq.setLdapUser(Boolean.valueOf(curReq.isLdapUser()));
            return nextReq;
        }

        private ListContainer doListEds(FileRequest request) {
            EdsMergeLister.this.edsClient.sendRequestToEds(request, null);
            if (request.getResponse().getResult() == OpResult.Success) {
                return request.getResponse().getFileInfoList();
            }
            StringBuilder msg = new StringBuilder();
            msg.append("list partition [").append(request.getFileInfo().getSrc()).append("], maxCount=").append(request.getFileInfo().getMaxCount()).append(", prefix=").append(request.getFileInfo().getPrefix()).append(", startAfter=").append(request.getFileInfo().getStartAfter());
            if (request.getResponse().getErrorCode() == SHIMErrorCode.SHM_STATUS_OBJECT_NOT_FOUND.getErrorCode()) {
                LOGGER.info(msg.append(" not found.").toString());
            } else {
                LOGGER.error(msg.append(" failed.").toString());
                EdsMergeLister.this.hasError = true;
            }
            return null;
        }
    }

    private static class NodeComparator
    implements Comparator<OrderedNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(OrderedNode one, OrderedNode another) {
            return one.getFileInfo().getSrc().compareTo(another.getFileInfo().getSrc());
        }
    }

    private static class OrderedNode {
        private int index = 0;
        private ListContainer container;

        OrderedNode(ListContainer container) {
            this.container = container;
        }

        FileInfo getFileInfo() {
            return this.container.get(this.index);
        }

        ListContainer getContainer() {
            return this.container;
        }

        void next() {
            ++this.index;
        }

        boolean hasNext() {
            return (long)this.index < this.container.size();
        }
    }
}

