/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.partition;

import org.apache.commons.lang3.StringUtils;
import uds.common.config.interf.OBSConfig;

class EdsNameRouter {
    static final String NAME_SEPARATOR = "/";
    static final boolean IS_SUPPORT_ALL_PATH_HASH = OBSConfig.getInstance().getBoolean("support_all_path_hash", false);
    private static final String PARTITION_PREFIX = "PTN";
    private static final int PARTITION_NUM = OBSConfig.getInstance().getSysPartitionNum();

    EdsNameRouter() {
    }

    private static int hash(String src) {
        return src.hashCode() & Integer.MAX_VALUE;
    }

    static String getLogicName(String src) {
        String hashSrc;
        if (IS_SUPPORT_ALL_PATH_HASH) {
            hashSrc = src;
        } else {
            String[] paths = src.split(NAME_SEPARATOR);
            hashSrc = paths[1];
        }
        if (StringUtils.endsWith((CharSequence)hashSrc, (CharSequence)NAME_SEPARATOR)) {
            hashSrc = hashSrc.substring(0, hashSrc.length() - 1);
        }
        return EdsNameRouter.getPartitionName(EdsNameRouter.hash(hashSrc)) + src;
    }

    static String getSrcName(String logicName) {
        int index = logicName.indexOf(NAME_SEPARATOR, 1);
        return logicName.substring(index);
    }

    static String getPartitionName(int hashcode) {
        return "/PTN" + hashcode % PARTITION_NUM;
    }

    static int getPartitionNum() {
        return PARTITION_NUM;
    }
}

