/*
 * Decompiled with CFR 0.152.
 */
package uds.eds.partition;

import uds.common.entity.eio.ProxyByteBuffer;
import uds.eds.client.EdsClientBuilder;
import uds.eds.client.FileRequest;
import uds.eds.partition.EdsMergeLister;
import uds.eds.partition.EdsNameRouter;

public class EdsOpAdpter {
    public static void sendRequestToEds(FileRequest request, ProxyByteBuffer data) {
        switch (request.getType()) {
            case LIST: {
                EdsOpAdpter.listOp(request, data);
                break;
            }
            case GET_BUCKET_STORAGE: 
            case GET_BUCKET_QUOTA: 
            case CREATE_BUCKET_QUOTA: 
            case MODIFY_BUCKET_QUOTA: {
                EdsOpAdpter.originalOp(request, data);
                break;
            }
            default: {
                EdsOpAdpter.normalOp(request, data);
            }
        }
    }

    private static void listOp(FileRequest request, ProxyByteBuffer data) {
        if (EdsNameRouter.IS_SUPPORT_ALL_PATH_HASH || "/".equals(request.getFileInfo().getSrc())) {
            new EdsMergeLister(request).listAllPartitionObjects();
        } else {
            EdsOpAdpter.normalOp(request, data);
        }
    }

    private static void prepareDo(FileRequest request) {
        String locName = EdsNameRouter.getLogicName(request.getFileInfo().getSrc());
        request.getFileInfo().setSrc(locName);
    }

    private static void afterDo(FileRequest request) {
        String src = EdsNameRouter.getSrcName(request.getFileInfo().getSrc());
        request.getFileInfo().setSrc(src);
    }

    private static void normalOp(FileRequest request, ProxyByteBuffer data) {
        EdsOpAdpter.prepareDo(request);
        EdsClientBuilder.getInstance().buildInterface().sendRequestToEds(request, data);
        EdsOpAdpter.afterDo(request);
    }

    private static void originalOp(FileRequest request, ProxyByteBuffer data) {
        EdsClientBuilder.getInstance().buildInterface().sendRequestToEds(request, data);
    }
}

