/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.bill;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.bill.DefaultConfBill;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class BillConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillConfig.class);
    private static final int HOUR_START = 0;
    private static final int HOUR_END = 23;
    private static final int FORMAT_NUM = 24;
    private static final int DEFAULT_NODE_ID = -1;
    private String billingFormat;
    private String statBucketName;
    private String nodeType;
    private int nodeid = -1;
    private long billWriteRegionAlarmTimeout;
    private int billWriteRegionAlarmThreshold;
    private int billMonThreshold;
    private long timeUsed2GenerateStorBill;
    private boolean isRequestIdLogOpen;
    private boolean isStatisticLogInfoOpen;
    private int billOverdueTime;
    private String billingMDCMode;
    private int userQuotaCacheSize;
    private String billCanoUserId;
    private String hwsCloudResourSpecCode;
    private String hwsCloudResourceType;
    private String billingType;
    private String hwsCloudServiceType;
    private String billBucketName;
    private String accessLogBucketName;
    private boolean hkUserWithoutBillingSwitch;
    private boolean sysBillingForMeterName;
    private boolean sysBillingShowUserType;
    private boolean isUploadBillFileToBucket;
    private boolean sysBillingTest;
    private int billAlarmTime;
    private boolean sysBillingByHour;
    private boolean sysBillingOpen;
    private int sysAccesslogLifeCycle;
    private String sysBillingUploadMode;
    private int billTaskInterval;
    private int accessLogIntervalTime;
    private String testRegionID;
    private long accesslogInterTime;
    private long bucketQuotaisNotZeroDelThreshold;
    private long bucketQuotaisZeroDelThreshold;
    private long bucketQuotaisNotZeroThreshold;
    private long bucketQuotaisZeroThreshold;
    private int userQuotaStatusAvailTime;
    private int statOscNumInOnePB;
    private int statRecordWriteMaxNum;
    private int statCalculatedRecordStoreMaxNum;
    private int statRecordManagerTaskInterval;
    private int asyncUpdateBucketStorageThreadNum;
    private int asyncUpdateBucketStorageTaskInterval;
    private String systemUnitedUser;
    private boolean isStatisticOpenBetweenOsc;
    private long tmpfsBlockTime;
    private int tmpfsMaxBillInfoCount;
    private String tmpfsPath;
    private int storageBillFileSize;
    private int numOfStorageStatTask;
    private boolean billIsForBucket;
    private boolean isRecordNeedXdomainId;
    private boolean billIsWithTagging;
    private int statisticOpenBetweenOscSendRetryTime;
    private int testPreStopWaitFlushCacheTime;
    private boolean testStopAsyn2Sod;
    private int numOfStorageBillTask;
    private int generateStorageBillTime;
    private int checkUserStorageBillTime;
    private int storageBillGeneratorInfoCheckInterval;
    private int abnormalNodeId;
    private String origBillType;
    private String billingSdrSwitch;
    private String billingSdrHostIp;
    private String billingSdrUserName;
    private String billingSdrPassword;
    private String billingSdrPassphrase;
    private String billingSdrAuthMode;
    private String billingSdrPkFilepath;
    private String billingSdrOrigUploadPath;
    private String billingSdrStorageUploadPath;
    private String billingSdrRefreshTime;
    private String billingSdrPort;
    private String billDigestType;
    private int standardIaAssignedTime;
    private int glacierAssignedTime;
    private long billIdleTime;
    private int bucketInfoMapMaxCapacity;
    private int maxCESAccessLogUsageRate;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            return;
        }
        this.origBillType = config.getString("orig_bill_type", "01");
        this.abnormalNodeId = config.getInt("abnormal_node_id", -1);
        this.storageBillGeneratorInfoCheckInterval = config.getInt("storage_bill_generator_info_check_interval", 60);
        this.checkUserStorageBillTime = config.getInt("check_user_storage_bill_time", 4);
        this.generateStorageBillTime = config.getInt("generate_storage_bill_time", 4);
        this.numOfStorageBillTask = config.getInt("num_of_storage_bill_task", 50);
        this.testStopAsyn2Sod = config.getBoolean("testStopAsyn2Sod", false);
        this.testPreStopWaitFlushCacheTime = config.getInt("testPreStopWaitFlushCacheTime", 1000);
        this.statisticOpenBetweenOscSendRetryTime = config.getInt("statisticOpenBetweenOscRetryTime", 3);
        this.billIsForBucket = config.getBoolean("bill_is_for_bucket", true);
        this.isRecordNeedXdomainId = config.getBoolean("is_record_need_xdomainId", true);
        this.billIsWithTagging = config.getBoolean("bucket_tagging_enable", true);
        this.numOfStorageStatTask = config.getInt("num_of_storage_stat_task", 10);
        this.storageBillFileSize = config.getInt("storage_bill_file_size", 0x6400000);
        this.tmpfsPath = config.getString("billing_tmpfs_path", DefaultConfBill.BILLING_TMPFS_PATH);
        this.tmpfsMaxBillInfoCount = config.getInt("billing_tmpfs_max_bill_info_count", 20000);
        this.tmpfsBlockTime = config.getLong("billing_tmpfs_block_time", 10000L);
        this.isStatisticOpenBetweenOsc = config.getBoolean("statisticOpenBetweenOsc", false);
        this.systemUnitedUser = config.getString("Sys_User_AuthUerNameAndId", "SystemUnitedUserId");
        this.asyncUpdateBucketStorageTaskInterval = config.getInt("async_update_bukcet_storage_task_interval", 300);
        this.asyncUpdateBucketStorageThreadNum = config.getInt("async_update_bukcet_storage_thread_num", 1);
        this.statRecordManagerTaskInterval = config.getInt("stat_record_manager_task_interval", 300);
        this.statCalculatedRecordStoreMaxNum = config.getInt("stat_calculated_record_store_max_num", 200000);
        this.statRecordWriteMaxNum = config.getInt("stat_record_write_max_num", 90000);
        this.statOscNumInOnePB = config.getInt("stat_osc_num_in_one_pb", 5);
        this.userQuotaStatusAvailTime = config.getInt("user_quota_status_avail_time", 10000);
        this.bucketQuotaisZeroThreshold = this.getLongSafe(config, "stat_bucket_quota_is_zero_threshold", 0x40000000L);
        this.bucketQuotaisNotZeroThreshold = config.getLong("stat_bucket_quota_is_not_zero_threshold", 0xA00000L);
        this.bucketQuotaisZeroDelThreshold = config.getLong("stat_bucket_quota_is_zero_delete_threshold", 0x40000000L);
        this.bucketQuotaisNotZeroDelThreshold = config.getLong("stat_bucket_quota_is_not_zero_delete_threshold", 0x40000000L);
        this.billBucketName = config.getString("statistic_unitedUserBucket", ".Ya89Soshla6S4Uma_bill");
        this.accessLogBucketName = config.getString("accesslog_unitedUserBucket", ".Ya89Soshla6S4Uma_accesslog");
        this.hkUserWithoutBillingSwitch = config.getBoolean("bill_hkuser_no_bill_switch", false);
        this.hwsCloudServiceType = config.getString("billing_service_type", "hws.service.type.obs");
        this.billingType = config.getString("BILLINGPrefix", "hws");
        this.hwsCloudResourceType = config.getString("billing_resource_type", "hws.resource.type.obs");
        this.hwsCloudResourSpecCode = config.getString("billing_resource_speccode", "0");
        this.billCanoUserId = config.getString("CanoUserId_SystemUnitedUser", "00000000000000000000000000000000");
        this.userQuotaCacheSize = config.getInt("user_quota_cache_size", 200);
        this.billingMDCMode = config.getString("billing_MDC_Mode", "Master");
        this.billOverdueTime = config.getInt("bill_overdue_time", 1);
        this.isStatisticLogInfoOpen = config.getBoolean("statistic_log_info_open", false);
        this.isRequestIdLogOpen = config.getBoolean("requestid_log_open", false);
        this.timeUsed2GenerateStorBill = config.getLong("time_used2generate_stor_bill", DefaultConfBill.TIME_USED2GENERATE_STOR_BILL);
        this.billMonThreshold = config.getInt("bill_mon_thresh", 3);
        this.billWriteRegionAlarmThreshold = config.getInt("bill_write_to_region_alarm_thresh", 10);
        this.billWriteRegionAlarmTimeout = config.getLong("bill_write_to_region_alarm_timeout", 900000L);
        this.statBucketName = config.getString("statistic_bucket_name", ".Ya89Soshla6S4Uma_stat");
        this.sysBillingForMeterName = config.getBoolean("bill_is_for_meterName", false);
        this.sysBillingShowUserType = config.getBoolean("bill_show_user_type", false);
        this.sysBillingTest = config.getBoolean("billingTestOpen", false);
        this.isUploadBillFileToBucket = config.getBoolean("is_bill_file_upload_to_bucket", true);
        this.billAlarmTime = config.getInt("billingAlarmTime", 60);
        this.sysBillingByHour = config.getBoolean("billingByHour", true);
        this.billTaskInterval = config.getInt("bill_task_interval", 60);
        this.accessLogIntervalTime = config.getInt("accesslog_file_interval", 60000);
        this.sysBillingOpen = config.getBoolean("billingOpen", false);
        this.accesslogInterTime = config.getLong("accesslog_inter_time", 10L);
        this.sysAccesslogLifeCycle = config.getInt("bill_access_log_life", 365);
        this.testRegionID = config.getString("billingTestRegionID", "default");
        this.standardIaAssignedTime = config.getInt("assigned_time_ia", 720);
        this.glacierAssignedTime = config.getInt("assigned_time_glacier", 2160);
        this.billingSdrSwitch = config.getString("billing_sdr_switch", "false");
        this.billingSdrHostIp = config.getString("billing_sdr_host_ip", null);
        this.billingSdrUserName = config.getString("billing_sdr_username", null);
        this.billingSdrPassword = config.getString("billing_sdr_password", null);
        this.billingSdrPassphrase = config.getString("billing_sdr_passphrase", null);
        this.billingSdrAuthMode = config.getString("billing_sdr_auth_mode", "PrivateKey");
        this.billingSdrPkFilepath = config.getString("billing_sdr_pk_filepath", "/opt/obs/obsconf/privateKey");
        this.billingSdrOrigUploadPath = config.getString("billing_sdr_orig_upload_path", "/opt/meterfiles/uploads/obs/orig/all/");
        this.billingSdrStorageUploadPath = config.getString("billing_sdr_storage_upload_path", "/opt/meterfiles/uploads/obs/storage/all/");
        this.billingSdrRefreshTime = config.getString("billing_sdr_refresh_time", "300");
        this.billingSdrPort = config.getString("billing_sdr_port", "22");
        this.sysBillingUploadMode = config.getString("bill_upload_mode", "SDR");
        this.nodeid = config.getInt("node_id", -1);
        this.bucketInfoMapMaxCapacity = config.getInt("bucket_Info_Map_maxCapacity", 10000);
        this.maxCESAccessLogUsageRate = config.getInt("max_ces_accesslog_usage_rate", 90);
        this.billIdleTime = config.getInt("bill_idle_time", 180);
        this.billDigestType = config.getString("bill_digest_type", "MD5");
    }

    private Long getLongSafe(PropertiesConfiguration config, String key, long defaultVal) {
        try {
            return config.getLong(key, defaultVal);
        }
        catch (ConversionException e) {
            return defaultVal;
        }
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    private String[] convertBillingFormatToArray() {
        if (this.billingFormat.length() != 24) {
            return this.convertString2Array("000000000000000000000000");
        }
        return this.convertString2Array(this.billingFormat);
    }

    private String[] convertString2Array(String srcString) {
        String[] billingFormatArray = new String[srcString.length()];
        for (int i = 0; i < srcString.length(); ++i) {
            billingFormatArray[i] = srcString.charAt(i) + "";
        }
        return billingFormatArray;
    }

    public String getNodeType(PropertiesConfiguration config) {
        if (null == this.nodeType) {
            this.nodeType = config.getString("node_type", "");
        }
        return this.nodeType;
    }

    public int getIAAssignedTime() {
        return this.standardIaAssignedTime;
    }

    public int getGlacierAssignedTime() {
        return this.glacierAssignedTime;
    }

    public int getNodeId(PropertiesConfiguration config) {
        return this.nodeid;
    }

    public void setNodeId(PropertiesConfiguration config, int nodeId) {
        config.setProperty("node_id", (Object)nodeId);
        this.nodeid = nodeId;
    }

    public String getOrigBillType() {
        return this.origBillType;
    }

    public void setOrigBillType(PropertiesConfiguration config, String origBillType) {
        config.setProperty("orig_bill_type", (Object)origBillType);
        this.origBillType = origBillType;
    }

    public int getAbnormalNodeId() {
        return this.abnormalNodeId;
    }

    public void setAbnormalNodeId(PropertiesConfiguration config, int abnormalNodeId) {
        config.setProperty("abnormal_node_id", (Object)abnormalNodeId);
        this.abnormalNodeId = abnormalNodeId;
    }

    public int getStorageBillGeneratorInfoCheckInterval() {
        return this.storageBillGeneratorInfoCheckInterval;
    }

    public void setStorageBillGeneratorInfoCheckInterval(PropertiesConfiguration config, int storageBillGeneratorInfoCheckInterval) {
        config.setProperty("storage_bill_generator_info_check_interval", (Object)storageBillGeneratorInfoCheckInterval);
        this.storageBillGeneratorInfoCheckInterval = storageBillGeneratorInfoCheckInterval;
    }

    public int getCheckUserStorageBillTime() {
        if (this.checkUserStorageBillTime < 0 || this.checkUserStorageBillTime > 23) {
            this.checkUserStorageBillTime = 4;
        }
        return this.checkUserStorageBillTime;
    }

    public void setCheckUserStorageBillTime(PropertiesConfiguration config, int checkUserStorageBillTime) {
        config.setProperty("check_user_storage_bill_time", (Object)checkUserStorageBillTime);
        this.checkUserStorageBillTime = checkUserStorageBillTime;
    }

    public int getGenerateStorageBillTime() {
        if (this.generateStorageBillTime < 0 || this.generateStorageBillTime > 23) {
            this.generateStorageBillTime = 4;
        }
        return this.generateStorageBillTime;
    }

    public void setGenerateStorageBillTime(PropertiesConfiguration config, int generateStorageBillTime) {
        config.setProperty("generate_storage_bill_time", (Object)generateStorageBillTime);
        this.generateStorageBillTime = generateStorageBillTime;
    }

    public int getNumOfStorageBillTask() {
        if (this.numOfStorageBillTask < 0) {
            this.numOfStorageBillTask = 50;
        }
        return this.numOfStorageBillTask;
    }

    public boolean testStopAsyn2Sod() {
        return this.testStopAsyn2Sod;
    }

    public int testPreStopWaitFlushCacheTime() {
        return this.testPreStopWaitFlushCacheTime;
    }

    public int statisticOpenBetweenOscSendRetryTime() {
        return this.statisticOpenBetweenOscSendRetryTime;
    }

    public boolean billIsForBucket() {
        return this.billIsForBucket;
    }

    public boolean isRecordNeedXdomainId() {
        return this.isRecordNeedXdomainId;
    }

    public boolean billIsWithTagging() {
        return this.billIsWithTagging;
    }

    public String[] getBillingFormatArray(PropertiesConfiguration config) {
        this.billingFormat = config.getString("BSSParams", "000000000000000000000000");
        LOGGER.debug("BSSParams is: {}.", (Object)this.billingFormat);
        return this.convertBillingFormatToArray();
    }

    public void setNumOfStorageBillTask(PropertiesConfiguration config, int numOfStorageBillTask) {
        config.setProperty("num_of_storage_bill_task", (Object)numOfStorageBillTask);
        this.numOfStorageBillTask = numOfStorageBillTask;
    }

    public int getNumOfStorageStatTask() {
        if (this.numOfStorageStatTask < 0) {
            this.numOfStorageStatTask = 10;
        }
        return this.numOfStorageStatTask;
    }

    public void setNumOfStorageStatTask(PropertiesConfiguration config, int numOfStorageStatTask) {
        config.setProperty("num_of_storage_stat_task", (Object)numOfStorageStatTask);
        this.numOfStorageStatTask = numOfStorageStatTask;
    }

    public int getStorageBillFileSize() {
        if (this.storageBillFileSize <= 0) {
            this.storageBillFileSize = 0x6400000;
        }
        return this.storageBillFileSize;
    }

    public void setStorageBillFileSize(PropertiesConfiguration config, int storageBillFileSize) {
        config.setProperty("storage_bill_file_size", (Object)storageBillFileSize);
        this.storageBillFileSize = storageBillFileSize;
    }

    public String getTmpfsPath() {
        return this.tmpfsPath;
    }

    public void setTmpfsPath(PropertiesConfiguration config, String tmpfsPath) {
        config.setProperty("billing_tmpfs_path", (Object)tmpfsPath);
        this.tmpfsPath = tmpfsPath;
    }

    public int getTmpfsMaxBillInfoCount() {
        if (this.tmpfsMaxBillInfoCount <= 0) {
            this.tmpfsMaxBillInfoCount = 20000;
        }
        return this.tmpfsMaxBillInfoCount;
    }

    public void setTmpfsMaxBillInfoCount(PropertiesConfiguration config, int tmpfsMaxBillInfoCount) {
        config.setProperty("billing_tmpfs_max_bill_info_count", (Object)tmpfsMaxBillInfoCount);
        this.tmpfsMaxBillInfoCount = tmpfsMaxBillInfoCount;
    }

    public long getTmpfsBlockTime() {
        if (this.tmpfsBlockTime < 0L) {
            this.tmpfsBlockTime = 10000L;
        }
        return this.tmpfsBlockTime;
    }

    public void setTmpfsBlockTime(PropertiesConfiguration config, long tmpfsBlockTime) {
        config.setProperty("billing_tmpfs_block_time", (Object)tmpfsBlockTime);
        this.tmpfsBlockTime = tmpfsBlockTime;
    }

    public boolean isStatisticOpenBetweenOsc() {
        return this.isStatisticOpenBetweenOsc;
    }

    public void setStatisticOpenBetweenOsc(PropertiesConfiguration config, boolean statisticOpenBetweenOsc) {
        config.setProperty("statisticOpenBetweenOsc", (Object)statisticOpenBetweenOsc);
        this.isStatisticOpenBetweenOsc = statisticOpenBetweenOsc;
    }

    public String getSystemUnitedUser() {
        return this.systemUnitedUser;
    }

    public void setSystemUnitedUser(PropertiesConfiguration config, String systemUnitedUser) {
        config.setProperty("Sys_User_AuthUerNameAndId", (Object)systemUnitedUser);
        this.systemUnitedUser = systemUnitedUser;
    }

    public int getAsyncUpdateBucketStorageTaskInterval() {
        if (this.asyncUpdateBucketStorageTaskInterval <= 0) {
            this.asyncUpdateBucketStorageTaskInterval = 300;
        }
        return this.asyncUpdateBucketStorageTaskInterval;
    }

    public void setAsyncUpdateBucketStorageTaskInterval(PropertiesConfiguration config, int asyncUpdateBucketStorageTaskInterval) {
        config.setProperty("async_update_bukcet_storage_task_interval", (Object)asyncUpdateBucketStorageTaskInterval);
        this.asyncUpdateBucketStorageTaskInterval = asyncUpdateBucketStorageTaskInterval;
    }

    public int getAsyncUpdateBucketStorageThreadNum() {
        if (this.asyncUpdateBucketStorageThreadNum <= 0) {
            this.asyncUpdateBucketStorageThreadNum = 1;
        }
        return this.asyncUpdateBucketStorageThreadNum;
    }

    public void setAsyncUpdateBucketStorageThreadNum(PropertiesConfiguration config, int asyncUpdateBucketStorageThreadNum) {
        config.setProperty("async_update_bukcet_storage_thread_num", (Object)asyncUpdateBucketStorageThreadNum);
        this.asyncUpdateBucketStorageThreadNum = asyncUpdateBucketStorageThreadNum;
    }

    public int getStatRecordManagerTaskInterval() {
        if (this.statRecordManagerTaskInterval <= 0) {
            this.statRecordManagerTaskInterval = 300;
        }
        return this.statRecordManagerTaskInterval;
    }

    public void setStatRecordManagerTaskInterval(PropertiesConfiguration config, int statRecordManagerTaskInterval) {
        config.setProperty("stat_record_manager_task_interval", (Object)statRecordManagerTaskInterval);
        this.statRecordManagerTaskInterval = statRecordManagerTaskInterval;
    }

    public int getStatCalculatedRecordStoreMaxNum() {
        if (this.statCalculatedRecordStoreMaxNum <= 0) {
            this.statCalculatedRecordStoreMaxNum = 200000;
        }
        return this.statCalculatedRecordStoreMaxNum;
    }

    public void setStatCalculatedRecordStoreMaxNum(PropertiesConfiguration config, int statCalculatedRecordStoreMaxNum) {
        config.setProperty("stat_calculated_record_store_max_num", (Object)statCalculatedRecordStoreMaxNum);
        this.statCalculatedRecordStoreMaxNum = statCalculatedRecordStoreMaxNum;
    }

    public int getStatRecordWriteMaxNum() {
        if (this.statRecordWriteMaxNum <= 0) {
            this.statRecordWriteMaxNum = 90000;
        }
        return this.statRecordWriteMaxNum;
    }

    public void setStatRecordWriteMaxNum(PropertiesConfiguration config, int statRecordWriteMaxNum) {
        config.setProperty("stat_record_write_max_num", (Object)statRecordWriteMaxNum);
        this.statRecordWriteMaxNum = statRecordWriteMaxNum;
    }

    public int getStatOscNumInOnePB() {
        if (this.statOscNumInOnePB <= 0) {
            this.statOscNumInOnePB = 5;
        }
        return this.statOscNumInOnePB;
    }

    public void setStatOscNumInOnePB(PropertiesConfiguration config, int statOscNumInOnePB) {
        config.setProperty("stat_osc_num_in_one_pb", (Object)statOscNumInOnePB);
        this.statOscNumInOnePB = statOscNumInOnePB;
    }

    public int getUserQuotaStatusAvailTime() {
        if (this.userQuotaStatusAvailTime <= 0) {
            this.userQuotaStatusAvailTime = 10000;
        }
        return this.userQuotaStatusAvailTime;
    }

    public void setUserQuotaStatusAvailTime(PropertiesConfiguration config, int userQuotaStatusAvailTime) {
        config.setProperty("user_quota_status_avail_time", (Object)userQuotaStatusAvailTime);
        this.userQuotaStatusAvailTime = userQuotaStatusAvailTime;
    }

    public long getBucketQuotaisZeroThreshold() {
        if (this.bucketQuotaisZeroThreshold <= 0L) {
            this.bucketQuotaisZeroThreshold = 0x40000000L;
        }
        return this.bucketQuotaisZeroThreshold;
    }

    public void setBucketQuotaisZeroThreshold(PropertiesConfiguration config, long bucketQuotaisZeroThreshold) {
        config.setProperty("stat_bucket_quota_is_zero_threshold", (Object)bucketQuotaisZeroThreshold);
        this.bucketQuotaisZeroThreshold = bucketQuotaisZeroThreshold;
    }

    public long getBucketQuotaisNotZeroThreshold() {
        if (this.bucketQuotaisNotZeroThreshold <= 0L) {
            this.bucketQuotaisNotZeroThreshold = 0xA00000L;
        }
        return this.bucketQuotaisNotZeroThreshold;
    }

    public void setBucketQuotaisNotZeroThreshold(PropertiesConfiguration config, long bucketQuotaisNotZeroThreshold) {
        config.setProperty("stat_bucket_quota_is_not_zero_threshold", (Object)bucketQuotaisNotZeroThreshold);
        this.bucketQuotaisNotZeroThreshold = bucketQuotaisNotZeroThreshold;
    }

    public long getBucketQuotaisZeroDelThreshold() {
        if (this.bucketQuotaisZeroDelThreshold <= 0L) {
            this.bucketQuotaisZeroDelThreshold = 0x40000000L;
        }
        return this.bucketQuotaisZeroDelThreshold;
    }

    public void setBucketQuotaisZeroDelThreshold(PropertiesConfiguration config, long bucketQuotaisZeroDelThreshold) {
        config.setProperty("stat_bucket_quota_is_zero_delete_threshold", (Object)bucketQuotaisZeroDelThreshold);
        this.bucketQuotaisZeroDelThreshold = bucketQuotaisZeroDelThreshold;
    }

    public long getBucketQuotaisNotZeroDelThreshold() {
        if (this.bucketQuotaisNotZeroDelThreshold <= 0L) {
            this.bucketQuotaisNotZeroDelThreshold = 0x40000000L;
        }
        return this.bucketQuotaisNotZeroDelThreshold;
    }

    public void setBucketQuotaisNotZeroDelThreshold(PropertiesConfiguration config, long bucketQuotaisNotZeroDelThreshold) {
        config.setProperty("stat_bucket_quota_is_not_zero_delete_threshold", (Object)bucketQuotaisNotZeroDelThreshold);
        this.bucketQuotaisNotZeroDelThreshold = bucketQuotaisNotZeroDelThreshold;
    }

    public String getAccessLogBucketName() {
        return this.accessLogBucketName;
    }

    public boolean getHKUserNoBillingSwitch() {
        return this.hkUserWithoutBillingSwitch;
    }

    public void setAccessLogBucketName(PropertiesConfiguration config, String billBucketName) {
        config.setProperty("accesslog_unitedUserBucket", (Object)billBucketName);
        this.accessLogBucketName = billBucketName;
    }

    public String getBillBucketName() {
        return this.billBucketName;
    }

    public void setBillBucketName(PropertiesConfiguration config, String billBucketName) {
        config.setProperty("statistic_unitedUserBucket", (Object)billBucketName);
        this.billBucketName = billBucketName;
    }

    public boolean getSysBillingForMeterName() {
        return this.sysBillingForMeterName;
    }

    public boolean getSysBillingShowUserType() {
        return this.sysBillingShowUserType;
    }

    public boolean getIsUploadBillFileToBucket() {
        return this.isUploadBillFileToBucket;
    }

    public void setSysBillingForMeterName(PropertiesConfiguration config, boolean billIsForMeterName) {
        config.setProperty("bill_is_for_meterName", (Object)billIsForMeterName);
        this.sysBillingForMeterName = billIsForMeterName;
    }

    public boolean getSysBillingTest() {
        return this.sysBillingTest;
    }

    public void setSysBillingTest(PropertiesConfiguration config, boolean billingTest) {
        config.setProperty("billingTestOpen", (Object)billingTest);
        this.sysBillingTest = billingTest;
    }

    public int getBillingAlarmTime() {
        return this.billAlarmTime;
    }

    public void setBillingAlarmTime(PropertiesConfiguration config, int billingTest) {
        config.setProperty("billingAlarmTime", (Object)billingTest);
        this.billAlarmTime = billingTest;
    }

    public boolean getSysGenBillingByHour() {
        return this.sysBillingByHour;
    }

    public void setSysGenBillingByHour(PropertiesConfiguration config, boolean billingByHour) {
        config.setProperty("billingByHour", (Object)billingByHour);
        this.sysBillingByHour = billingByHour;
    }

    public int getBillTaskInterval() {
        return this.billTaskInterval;
    }

    public void setBillTaskInterval(PropertiesConfiguration config, int billTaskInterval) {
        config.setProperty("bill_task_interval", (Object)billTaskInterval);
        this.billTaskInterval = billTaskInterval;
    }

    public int getAccesslogIntervalTime() {
        return this.accessLogIntervalTime;
    }

    public void setAccesslogIntervalTime(PropertiesConfiguration config, int accesslogIntervalTime) {
        config.setProperty("bill_task_interval", (Object)accesslogIntervalTime);
        this.accessLogIntervalTime = accesslogIntervalTime;
    }

    public boolean getSysBillingOpen() {
        return this.sysBillingOpen;
    }

    public String getSysBillingUploadMode() {
        return this.sysBillingUploadMode;
    }

    public void setSysBillingOpen(PropertiesConfiguration config, boolean sysBillingOpen) {
        config.setProperty("billingOpen", (Object)sysBillingOpen);
        this.sysBillingOpen = sysBillingOpen;
    }

    public int getSysAccessLogLifeCycle() {
        return this.sysAccesslogLifeCycle;
    }

    public void setSysAccessLogFormat(PropertiesConfiguration config, int sysAccessloglife) {
        config.setProperty("bill_access_log_life", (Object)sysAccessloglife);
        this.sysAccesslogLifeCycle = sysAccessloglife;
    }

    public long getaccesslogInterTime() {
        return this.accesslogInterTime;
    }

    public void setaccesslogInterTime(PropertiesConfiguration config, long accesslogInterTime) {
        config.setProperty("accesslog_inter_time", (Object)accesslogInterTime);
        this.accesslogInterTime = accesslogInterTime;
    }

    public String getSysUserTestRegionID() {
        return this.testRegionID;
    }

    public void setSysUserTestRegionID(PropertiesConfiguration config, String testRegionID) {
        config.setProperty("billingTestRegionID", (Object)testRegionID);
        this.testRegionID = testRegionID;
    }

    public String getHwsCloudServiceType() {
        return this.hwsCloudServiceType;
    }

    public void setHwsCloudServiceType(PropertiesConfiguration config, String hwsCloudServiceType) {
        config.setProperty("billing_service_type", (Object)hwsCloudServiceType);
        this.hwsCloudServiceType = hwsCloudServiceType;
    }

    public String getBillingType() {
        return this.billingType;
    }

    public void setBillingType(PropertiesConfiguration config, String billingType) {
        config.setProperty("BILLINGPrefix", (Object)billingType);
        this.billingType = billingType;
    }

    public String getHwsCloudResourceType() {
        return this.hwsCloudResourceType;
    }

    public void setHwsCloudResourceType(PropertiesConfiguration config, String hwsCloudResourceType) {
        config.setProperty("billing_resource_type", (Object)hwsCloudResourceType);
        this.hwsCloudResourceType = hwsCloudResourceType;
    }

    public void setHwsCloudResourSpecCode(PropertiesConfiguration config, String hwsCloudResourSpecCode) {
        config.setProperty("billing_resource_speccode", (Object)hwsCloudResourSpecCode);
        this.hwsCloudResourSpecCode = hwsCloudResourSpecCode;
    }

    public String getHwsCloudResourSpecCode() {
        return this.hwsCloudResourSpecCode;
    }

    public String getBillCanoUserId() {
        return this.billCanoUserId;
    }

    public void setBillCanoUserId(PropertiesConfiguration config, String billCanoUserId) {
        config.setProperty("CanoUserId_SystemUnitedUser", (Object)billCanoUserId);
        this.billCanoUserId = billCanoUserId;
    }

    public String getS3fsOrigDir(PropertiesConfiguration config) {
        return "/mnt/tmp_s3fs_bill/cdrfiles/" + config.getString("s3fsOrigDir", "orig/");
    }

    public String getS3fsStorageDir(PropertiesConfiguration config) {
        return "/mnt/tmp_s3fs_bill/cdrfiles/" + config.getString("s3fsStorageDir", "storage/");
    }

    public void setS3fsOrigDir(PropertiesConfiguration config, String s3fsOrigDir) {
        config.setProperty("s3fsOrigDir", (Object)s3fsOrigDir);
    }

    public void setS3fsStorageDir(PropertiesConfiguration config, String s3fsStorageDir) {
        config.setProperty("s3fsStorageDir", (Object)s3fsStorageDir);
    }

    public String getS3fsBackupOrigDir(PropertiesConfiguration config) {
        return "/mnt/tmp_s3fs_bill/backup/" + config.getString("s3fsOrigDir", "orig/");
    }

    public void setS3fsBackupOrigDir(PropertiesConfiguration config, String s3fsBackupOrigDir) {
        config.setProperty("s3fsOrigDir", (Object)s3fsBackupOrigDir);
    }

    public String getS3fsBackupStorageDir(PropertiesConfiguration config) {
        return "/mnt/tmp_s3fs_bill/backup/" + config.getString("s3fsStorageDir", "storage/");
    }

    public void setS3fsBackupStorageDir(PropertiesConfiguration config, String s3fsBackupStorageDir) {
        config.setProperty("s3fsStorageDir", (Object)s3fsBackupStorageDir);
    }

    public int getUserQuotaCacheSize() {
        return this.userQuotaCacheSize;
    }

    public void setUserQuotaCacheSize(PropertiesConfiguration config, int userQuotaCacheSize) {
        config.setProperty("user_quota_cache_size", (Object)userQuotaCacheSize);
        this.userQuotaCacheSize = userQuotaCacheSize;
    }

    public void setBillingMDCMode(PropertiesConfiguration config, String billingMDCMode) {
        config.setProperty("billing_MDC_Mode", (Object)billingMDCMode);
        this.billingMDCMode = billingMDCMode;
    }

    public String getBillingMDCMode() {
        return this.billingMDCMode;
    }

    public int getBillOverdueTime() {
        return this.billOverdueTime;
    }

    public void setBillOverdueTime(PropertiesConfiguration config, int billOverdueTime) {
        config.setProperty("bill_overdue_time", (Object)billOverdueTime);
        this.billOverdueTime = billOverdueTime;
    }

    public boolean isStatisticLogInfoOpen() {
        return this.isStatisticLogInfoOpen;
    }

    public void setStatisticLogInfoOpen(PropertiesConfiguration config, boolean statisticLogInfoOpen) {
        config.setProperty("statistic_log_info_open", (Object)statisticLogInfoOpen);
        this.isStatisticLogInfoOpen = statisticLogInfoOpen;
    }

    public boolean isRequestIdLogOpen() {
        return this.isRequestIdLogOpen;
    }

    public void setRequestIdLogOpen(PropertiesConfiguration config, boolean requestIdLogOpen) {
        config.setProperty("requestid_log_open", (Object)requestIdLogOpen);
        this.isRequestIdLogOpen = requestIdLogOpen;
    }

    public String getStatBucketName(PropertiesConfiguration config) {
        if (this.statBucketName == null) {
            this.statBucketName = config.getString("statistic_bucket_name", ".Ya89Soshla6S4Uma_stat");
        }
        return this.statBucketName;
    }

    public void setStatBucketName(PropertiesConfiguration config, String statBucketName) {
        config.setProperty("statistic_bucket_name", (Object)statBucketName);
        this.statBucketName = statBucketName;
    }

    public long getTimeUsed2GenerateStorBill() {
        return this.timeUsed2GenerateStorBill;
    }

    public void setTimeUsed2GenerateStorBill(PropertiesConfiguration config, long millSecs) {
        config.setProperty("time_used2generate_stor_bill", (Object)millSecs);
        this.timeUsed2GenerateStorBill = millSecs;
    }

    public int getBillMonThreshold() {
        return this.billMonThreshold;
    }

    public int getBillWriteRegionAlarmThreshold() {
        return this.billWriteRegionAlarmThreshold;
    }

    public long getBillWriteRegionAlarmTimeout() {
        return this.billWriteRegionAlarmTimeout;
    }

    public String getBillSdrHostIp(PropertiesConfiguration config) {
        return this.billingSdrHostIp;
    }

    public String getBillSdrUserName(PropertiesConfiguration config) {
        return this.billingSdrUserName;
    }

    public String getBillSdrPassword(PropertiesConfiguration config) {
        return this.billingSdrPassword;
    }

    public String getBillSdrPassphrase(PropertiesConfiguration config) {
        return this.billingSdrPassphrase;
    }

    public String getBillSdrAuthMode(PropertiesConfiguration config) {
        return this.billingSdrAuthMode;
    }

    public String getBillSdrPrivateKeyFilePath(PropertiesConfiguration config) {
        return this.billingSdrPkFilepath;
    }

    public String getBillSdrSwitch(PropertiesConfiguration config) {
        return this.billingSdrSwitch;
    }

    public String getBillSdrStorageUploadPath(PropertiesConfiguration config) {
        return this.billingSdrStorageUploadPath;
    }

    public String getBillSdrOrigUploadPath(PropertiesConfiguration config) {
        return this.billingSdrOrigUploadPath;
    }

    public String getBillSdrRefreshTime(PropertiesConfiguration config) {
        return this.billingSdrRefreshTime;
    }

    public String getBillPort(PropertiesConfiguration config) {
        return this.billingSdrPort;
    }

    public int getBucketInfoMapMaxCapacity() {
        return this.bucketInfoMapMaxCapacity;
    }

    public int getMaxCESAccessLogUsageRate() {
        return this.maxCESAccessLogUsageRate;
    }

    public long getBillIdleTime() {
        return this.billIdleTime;
    }

    public String getBillDigestType() {
        return this.billDigestType;
    }

    public void setBillDigestType(String billDigestType) {
        this.billDigestType = billDigestType;
    }
}

