/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.business.DefaultConfBusiness;
import uds.common.config.index.KVConfig;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.OBSConfig;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.util.ConfigUtil;
import uds.common.config.util.DomainUtils;

public class BusinessConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(BusinessConfig.class);
    private static final int MAX_USER_OWN_BUCKET_NUM = 100;
    private static final int MAX_OBJECT_COPIED_NUM = 1000;
    private static final int MAX_OBJECT_DEDUPED_NUM = 1000;
    private static final String IPV4_PATTERN = "^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$";
    private static final String IPV4_NET_DESC_PATTERN = "^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$".replace("$", "(/(3[0-2]|[0-2][0-9]|[0-9])){0,1}$");
    private static final int VPC_ID_LENGTH = 2;
    private static final int VPC_ID_CONFIG_LENGTH = 2;
    private static final int TENANT_ID_LENGTH = 2;
    private static final BusinessConfig INSTANCE = new BusinessConfig();
    private static boolean supportCreatingDeltaWriteECPlog = true;
    private int repMaxFailedTimes;
    private int maxOSCConnection;
    private int internalOSCRequest;
    private int maxObjectLength;
    private boolean compressSwitchOpen;
    private int fsMaxFileLength;
    private boolean listBucketValidateBucket;
    private long tempAuthExpireTime;
    private int authCacheMaxCount;
    private boolean needCalcMD5;
    private int maxKeys;
    private long userMetadataMaxSize;
    private int metaSearchMaxKeys;
    private int smallObjectSize;
    private int middleObjectSize;
    private int localBucketMetaCacheSize;
    private int localBucketMetaCacheTimeoutMs;
    private int localBucketMetaCacheLazyTimeoutMs;
    private int localBucketMetaCacheWatchPeriod;
    private boolean domainNameRegexEnable;
    private String domainNameRegex;
    private String apiHttpExternHeaders;
    private String apiAllUsersGroupURI;
    private String apiAuthenticatedUsersURI;
    private int mdcHTTPSPort;
    private int mdcHTTPPort;
    private int internalHTTPPort;
    private int internalHTTPSPort;
    private String localDataCenterID;
    private String systemUnitedUserAuthID;
    private int mdcMsgQueueBusy;
    private long mdcTaskReloadGap;
    private long mdcAsynDeleteDelayTime;
    private long maxMdcAsynDeleteDelayTime;
    private boolean mdcFlowControlOpen;
    private long fastVisitorPeriod;
    private long scanGarbageBucketPeriod;
    private long checkChunkVersionPeriod;
    private int checkChunkVersionPoolSize;
    private boolean trafficStatisticOpen;
    private int trafficStatisticPeriod;
    private int coveragePeriod;
    private int maxMultiDeleteNum;
    private int aveLoad;
    private int maxMultiDeleteRequestNum;
    private int multiDeleteTimeOut;
    private int maxMultiDeleteThreadNum;
    private int maxMultiDelReqBody;
    private int maxMultiModifyReqBody;
    private int maxMultiDelThreadPoolNum;
    private String compressContentType;
    private boolean checkUserPolicyOpen;
    private int maxLogCount;
    private long timeIntervalOfBucketAccessLog;
    private boolean checkOSCServerCert;
    private boolean checkDCMServerCert;
    private boolean checkKeystoneServerCert;
    private boolean checkIamServerCert;
    private boolean checkBssServerCert;
    private boolean checkSmnServerCert;
    private boolean checkCloudFunctionServerCert;
    private boolean checkFunctionGraphServerCert;
    private int checkParsePartitionPeriod;
    private int parsePartitionTimeOut;
    private boolean isServerSideEncryptionEnable;
    private boolean isqueryCurrentUsersSwitchOpen;
    private boolean isAkWrongAccessOpen;
    private boolean isIpWrongAccessOpen;
    private boolean isIpViolentAccessOpen;
    private boolean isAkandipWrongAccessOpen;
    private boolean isHcpCompatible;
    private boolean isDdosAtackAlarmOpen;
    private boolean isBucketAccessLogLocalConfigurated;
    private String domainName;
    private List<String> allDomainName;
    private List<Pattern> allDomainPatterns;
    private int maxUserOwnBucketNum;
    private boolean isUseOscQueue;
    private int oscQueueTimeOut;
    private int maxOSCRequest;
    private double maxOscRequestRatio;
    private int maxRequestOnCurrentSystem;
    private int maxMaintainRequest;
    private String correspondenceBetweenMemAndRequest;
    private String websiteDomainNameSuffix;
    private boolean isNeedRegionCopy;
    private String kmsTransportLayer;
    private String kmsTargetHostname;
    private String kmsKeyStoreLocation;
    private String kmsKeyStorePW;
    private String kmsTrustStorePW;
    private String kmsTrustStoreFileName;
    private String connectKmsType;
    private String kmsRestApiUrlProjectId;
    private int kmsClientMaxConnections;
    private boolean isKMSConfigured;
    private String kmsCipherType;
    private Properties akPolicy;
    private Properties ipPolicy;
    private Properties akAndIpPolicy;
    private double wrongAccessRatioImportant;
    private double wrongAccessRatioEmergency;
    private long wrongAccessTotalNumber;
    private long requestFlowThreshold;
    private long requestTimesThreshold;
    private boolean isPermitDeleteBucketData;
    private boolean isTracingEnabled;
    private boolean isAccessLogOpen;
    private boolean isInnerAccessBucketActive;
    private boolean isAbortMultiLc2Ccdb;
    private boolean isInnerAccessBucketOpen;
    private int innerAccessBucketRetention;
    private int innerAccessBucketRecycleTime;
    private boolean isInnerMgcBucketOpen;
    private int innerMgcBucketRetention;
    private int innerMgcBucketRecycleTime;
    private String innerAccessBucketNameSuffix;
    private long innerAccessBucketCapacity;
    private long stsXattrCapacity;
    private int stsRecCoreThreadNum;
    private int stsRecTotalThreadNum;
    private boolean isAccessStatOpen;
    private boolean isReadMetaFromRemoteOpen;
    private boolean isAutoSwitchWhenMasterAbnormal;
    private boolean isAllowedReadInStandy;
    private boolean isServerSideEncryptionHttps;
    private boolean isServerSideEncryptionKmsV4;
    private boolean isServerSideEncryptionSsecV4;
    private boolean isDebugCryptoEnable;
    private String kmsCmkListLimit;
    private String serverSideEncryptionKmsCmkIdAlias;
    private String lifecycleExecutionTimeSegment;
    private String websiteHomeLocation;
    private boolean conflictBucketSwitch;
    private boolean conflictBucketClusterCheckSwitch;
    private String conflictBucketClusterCheckIPs;
    private boolean isSendTaskSwitchOpen;
    private boolean isReceiveTaskSwitchOpen;
    private boolean isSMNSwitchOpen;
    private String smnAddress;
    private boolean uquerySwitch;
    private String uqueryAddress;
    private int certificationAlarmThreshold;
    private long kvPerformanceStatInterval;
    private String backendThreadPrefixt;
    private int kvAccessThreadNumber;
    private String userWhitelistStr;
    private boolean isClusterDomainAccessEnabled;
    private boolean isDeltaECWriteOpen;
    private int accessKVSemaphoreAcquireTimeoutSeconds;
    private int maintainPoolSize;
    private int lib2dDepthForRebuild;
    private String consoleOrigin;
    private boolean getAccessLogOpen;
    private boolean getMeterAccessLogOpen;
    private boolean cesAccessLogOpen;
    private long cesAccessLogUploadPeriod;
    private String cesLogBucketName;
    private boolean isOriginSourceOpen;
    private boolean isSecurityTokenServiceOpen;
    private String usersAllowedToSpecifyLocation;
    private boolean isAbsoluteRedirectUrl;
    private boolean isAccessKeyNeedcheck;
    private String functionGraphUrnCheckAddress;
    private String functionGraphAddress;
    private boolean functionGraphConnection;
    private String cloudFunctionAddress;
    private boolean cloudFunctionConnection;
    private boolean functionGraphCheckServerCertification;
    private boolean cloudFunctionCheckServerCertification;
    private boolean copySupportRange;
    private int cdmConsumerTimeout;
    private int sendCdmMesasgeSize;
    private String cdmAddress;
    private boolean dataMigrationOpen;
    private int cdmMaxQueueSize;
    private int cdmExtractorsNum;
    private int maxTagKeyLength;
    private int maxTagValueLength;
    private int maxCountOfBucketTag;
    private int objectMaxTagKeyLength;
    private int objectMaxTagValueLength;
    private int maxCountOfObjectTag;
    private int maxSizeOfObjectTag;
    private String tagValuePattern;
    private String tagKeyPattern;
    private boolean calcBuImmediately;
    private boolean isPartMetaCacheOpen;
    private int partMetaCacheSize;
    private boolean headBucketOpen;
    private boolean isAllowHeadBucket;
    private boolean isDebugLogAllow;
    private String vpcIpType;
    private List<String> vpcIpList;
    private String vpcUrl;
    private String[] vpcIdConfig;
    private List<String> vpcIdList;
    private List<String> tenantIdList;
    private List<String> vpcIdAndTenantIdList;
    private List<String> vpcReadOnlyActionList;
    private long vpcKVPeriod;
    private long partMinSize;
    private boolean reducedMeta;
    private int accountCheckMaxThreadNum;
    private String userDefaultPermission;
    private String userDirDefaultPermission;
    private int bucketCheckMaxThreadNum;
    private Boolean enterpriseSmallEC;
    private Boolean isReducedMeta;
    private int cdmConsumerThreadNumber;
    private int httpConnStackMaxCount;
    private boolean isImgTransOpen;
    private boolean isImgTransRouteOpen;
    private String imgTransAddress;
    private boolean imgS3SignatureGen;
    private boolean imgS3SignatureHttpsOnly;
    private int fsMaxDirDepth;
    private int fsMaxCacheNode;
    private int dataCenterReqRetryTime;
    private boolean isFsPartLayoutMoveAsyncSwitch;
    private int fsMaxPartLayoutMoveRate;
    private int fsTaskCleanMaxIntervalTime;
    private String coexistClusterForwardEndpoint;
    private boolean isCoexistForwardOpen;
    private boolean isCoexistLastModifyTimeOpen;
    private boolean isCompareLastModifyTimeOpen;
    private long ldapPwdCacheTimeOut;
    private int multipartMaxCount;
    private Set<String> ssecIntegrityCheckAlgorithmSet;
    private boolean isSsecSwitchOpen;
    private boolean isSsecSwitchInSmartEncryptionScenarioOpen;
    private int fullGcThreshold;
    private boolean isEnableStsSkEncrypt;
    private boolean isMultiPartLocationFormatOn;
    private boolean isMultiPartLocationFormatSwitchOpen;
    private int serverErrorAlarmCount;
    private int serverErrorAlarmRatio;
    private boolean isLogRequesterSwitchOpen;
    private int stsMaxExpiration;

    private BusinessConfig() {
    }

    public static BusinessConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() throws ConfigurationException {
        if (this.getConfig() == null) {
            return;
        }
        this.isReducedMeta = KVConfig.INSTANCE.getBoolValue("reduce_meta_switch", false) || this.getConfig().getBoolean("reduce_meta_switch", Boolean.FALSE) != false;
        this.enterpriseSmallEC = this.getConfig().getBoolean("enterprise_small_ec", Boolean.FALSE);
        this.accountCheckMaxThreadNum = this.getConfig().getInt("acccout_checking_max_thread_num", 10);
        this.userDefaultPermission = this.getConfig().getString("user_default_permission", "rw-r--r--");
        this.userDirDefaultPermission = this.getConfig().getString("user_dir_default_permission", "rwxr-xr-x");
        this.bucketCheckMaxThreadNum = this.getConfig().getInt("bucket_checking_max_thread_num", 100);
        this.repMaxFailedTimes = this.getConfig().getInt("repMaxFailedTimes", 25);
        this.maxObjectLength = this.getConfig().getInt("obs_maxObjectLength", 5);
        this.compressSwitchOpen = this.getConfig().getBoolean("compress_switch_open", false);
        this.fsMaxFileLength = this.getConfig().getInt("fs_obs_maxFileLength", 51200);
        this.maxKeys = this.getConfig().getInt("omd_listObjectsMaxKeys", 1000);
        this.metaSearchMaxKeys = this.getConfig().getInt("metaSearchMaxKeys", 1000);
        this.maxOSCConnection = this.getConfig().getInt("maxOSCConnection", 1000);
        this.internalOSCRequest = this.getConfig().getInteger("internalOSCRequest", Integer.valueOf(20));
        this.listBucketValidateBucket = this.getConfig().getBoolean("listBucket_validateBucket", false);
        this.tempAuthExpireTime = this.getConfig().getInt("tempAuthMaxExpiredTime", 31536000);
        this.authCacheMaxCount = this.getConfig().getInt("authCacheMaxCount", 0);
        this.needCalcMD5 = this.getConfig().getBoolean("needCalcMD5", true);
        this.userMetadataMaxSize = this.getConfig().getLong("obs_user_metadata_max_length", 2048L);
        this.smallObjectSize = this.getConfig().getInt("small_object_max_size", 102400);
        this.middleObjectSize = this.getConfig().getInt("middle_object_max_size", 0x100000);
        this.localBucketMetaCacheSize = this.getConfig().getInt("osc_local_bucket_meta_cache_size", 2000);
        this.localBucketMetaCacheTimeoutMs = this.getConfig().getInt("osc_local_bucket_meta_cache_timeout", 10000);
        this.localBucketMetaCacheLazyTimeoutMs = this.getConfig().getInt("osc_local_bucket_meta_cache_lazy_timeout", 1000);
        this.localBucketMetaCacheWatchPeriod = this.getConfig().getInt("osc_local_bucket_meta_cache_watch_period", 60000);
        this.compressContentType = this.getConfig().getString("ssc_ois_compress_content_type", "image;video;audio");
        this.checkUserPolicyOpen = this.getConfig().getBoolean("checkUserPolicyOpen", false);
        this.scanGarbageBucketPeriod = this.getConfig().getLong("scan_garbage_bucket_period", 720L);
        this.checkChunkVersionPeriod = this.getConfig().getLong("check_chunk_version_period", 10080L);
        this.checkChunkVersionPoolSize = this.getConfig().getInt("check_chunk_version_pool_size", 100);
        this.internalHTTPPort = this.getConfig().getInt("internal_business_http_port", 6080);
        this.internalHTTPSPort = this.getConfig().getInt("internal_business_https_port", 6443);
        this.loadVirtualHostConfig(this.getConfig());
        this.loadAPITransformConfig(this.getConfig());
        this.loadObjectMultiDeleteConfig(this.getConfig());
        this.loadMDCConfig(this.getConfig());
        this.loadWrongAccessConfig(this.getConfig());
        this.loadVPCConfig(this.getConfig());
        this.loadSSEConfig(this.getConfig());
        this.maxLogCount = this.getConfig().getInt("bucket_access_log_count", 100000);
        this.timeIntervalOfBucketAccessLog = this.getConfig().getLong("bucket_access_log_time_interval", 900000L);
        this.checkOSCServerCert = this.getConfig().getBoolean("mdc_business_check_server_certification", false);
        this.checkIamServerCert = this.getConfig().getBoolean("iam_check_server_certification", true);
        this.checkBssServerCert = this.getConfig().getBoolean("bss_check_server_certification", true);
        this.checkSmnServerCert = this.getConfig().getBoolean("smn_check_server_certification", true);
        this.checkCloudFunctionServerCert = this.getConfig().getBoolean("cloud_function_check_server_certification", true);
        this.checkFunctionGraphServerCert = this.getConfig().getBoolean("function_graph_check_server_certification", true);
        this.checkDCMServerCert = this.getConfig().getBoolean("mdc_manager_check_server_certification", false);
        this.checkKeystoneServerCert = this.getConfig().getBoolean("keystone_check_server_certification", false);
        this.checkParsePartitionPeriod = this.getConfig().getInt("check_parse_partition_per", 1440);
        if (this.checkParsePartitionPeriod <= 0) {
            this.checkParsePartitionPeriod = 1440;
        }
        this.parsePartitionTimeOut = this.getConfig().getInt("parse_partition_time_out", 10080);
        if (this.parsePartitionTimeOut <= 0) {
            this.parsePartitionTimeOut = 10080;
        }
        this.isServerSideEncryptionEnable = this.getConfig().getBoolean("serverSideEncryptionEnable", false);
        this.isqueryCurrentUsersSwitchOpen = this.getConfig().getBoolean("query_current_users_switch_open", false);
        this.isAkWrongAccessOpen = this.getConfig().getBoolean("akWrongAccessOpen", false);
        this.isIpWrongAccessOpen = this.getConfig().getBoolean("ipWrongAccessOpen", false);
        this.isIpViolentAccessOpen = this.getConfig().getBoolean("isIpViolentAccessOpen", true);
        this.isAkandipWrongAccessOpen = this.getConfig().getBoolean("akAndIpWrongAccessOpen", false);
        this.isHcpCompatible = this.getConfig().getBoolean("hcp_compatible_switch", false);
        this.isDdosAtackAlarmOpen = this.getConfig().getBoolean("ddosAtackAlarmOpen", true);
        this.isBucketAccessLogLocalConfigurated = this.getConfig().getBoolean("server_access_log_LOCAL_CONFIG", DefaultConfBusiness.BUCKET_ACCESS_LOG_SWITCH);
        this.maxUserOwnBucketNum = this.getConfig().getInt("maxBucketsPerUser", 100);
        this.isUseOscQueue = this.getConfig().getBoolean("use_osc_queue", true);
        this.oscQueueTimeOut = this.getConfig().getInt("osc_request_time_out", 30);
        this.maxOSCRequest = this.getConfig().getInt("maxOSCRequest", 200);
        this.maxOscRequestRatio = this.getConfig().getDouble("max_osc_request_ratio", 1.2);
        this.maxRequestOnCurrentSystem = this.getConfig().getInt("maxRequestOnCurrentSystem", 200);
        this.maxMaintainRequest = this.getConfig().getInt("maxMaintainRequest", 1000);
        this.correspondenceBetweenMemAndRequest = this.getConfig().getString("correspondenceBetweenMemAndRequest", "30#200#3072#4000,32#200#3072#4000,48#400#4096#4600,64#1000#8192#9378,80#1000#8192#19078,96#1000#8192#19078,112#1000#8192#19078,128#1000#8192#19078");
        this.websiteDomainNameSuffix = this.getConfig().getString("obs_api_website_root_domain_name", "website");
        this.isNeedRegionCopy = this.getConfig().getBoolean("REGIONCopy", false);
        this.kmsTransportLayer = this.getConfig().getString("kmsTransportLayer", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.kmsTargetHostname = this.getConfig().getString("kmsTargetHostname", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.kmsKeyStoreLocation = this.getConfig().getString("kmsKeyStoreLocation", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.kmsKeyStorePW = this.getConfig().getString("kmsKeyStorePW", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.kmsTrustStorePW = this.getConfig().getString("kmsTrustStorePW", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.kmsTrustStoreFileName = this.getConfig().getString("kmsTrustStoreFileName", DefaultConfBusiness.KMS_PARAMETER_DEFAULT_VALUE);
        this.connectKmsType = this.getConfig().getString("connectKmsType", "apiGateway");
        this.kmsRestApiUrlProjectId = this.getConfig().getString("kmsRestApiUrlProjectId", "apiGateway");
        this.kmsClientMaxConnections = this.getConfig().getInt("kmsClientMaxConnections", 500);
        this.isKMSConfigured = this.getConfig().getBoolean("isKMSconfigured", false);
        this.kmsCipherType = this.getConfig().getString("kmsCipherType", "AESC2");
        this.akPolicy = this.getConfig().getProperties("akPolicy");
        this.ipPolicy = this.getConfig().getProperties("ipPolicy");
        this.akAndIpPolicy = this.getConfig().getProperties("akAndIpPolicy");
        this.wrongAccessRatioImportant = this.getConfig().getDouble("wrongAccessRatioImportant", 5.0);
        this.wrongAccessRatioEmergency = this.getConfig().getDouble("wrongAccessRatioEmergency", 10.0);
        this.wrongAccessTotalNumber = this.getConfig().getLong("wrongAccessTotalNumber", 100L);
        this.requestFlowThreshold = this.getConfig().getLong("requestFlowThreshold", 300L);
        this.requestTimesThreshold = this.getConfig().getLong("requestTimesThreshold", 1000000L);
        this.isTracingEnabled = this.getConfig().getBoolean("tracing_enabled", false);
        this.isPermitDeleteBucketData = this.getConfig().getBoolean("permitDeleteBucketData", false);
        this.isAccessLogOpen = this.getConfig().getBoolean("access_log_open", false);
        this.isInnerAccessBucketActive = this.getConfig().getBoolean("access_log_to_bucket_active", false);
        this.isAbortMultiLc2Ccdb = this.getConfig().getBoolean("abort_multi_lc_ccdb", false);
        this.isInnerAccessBucketOpen = this.getConfig().getBoolean("access_log_to_bucket_switch", false);
        this.innerAccessBucketRetention = this.getConfig().getInt("access_log_to_bucket_retention", 180);
        this.innerAccessBucketRecycleTime = this.getConfig().getInt("access_log_to_bucket_deleteTime", 2);
        this.isInnerMgcBucketOpen = this.getConfig().getBoolean("mgc_log_to_bucket_switch", true);
        this.innerMgcBucketRetention = this.getConfig().getInt("mgc_log_to_bucket_retention", 365);
        this.innerMgcBucketRecycleTime = this.getConfig().getInt("access_log_to_bucket_deleteTime", 3);
        this.innerAccessBucketNameSuffix = this.getConfig().getString("access_log_bucket_suffix", "Ya89Soshla6S4Uma");
        this.innerAccessBucketCapacity = this.getConfig().getLong("access_log_bucket_capacity", 2048L);
        this.stsXattrCapacity = this.getConfig().getLong("sts_xattr_capacity", 1000000L);
        this.stsRecCoreThreadNum = this.getConfig().getInt("sts_xattr_recycle_core_thread_num", 10);
        this.stsRecTotalThreadNum = this.getConfig().getInt("sts_xattr_recycle_total_thread_num", 50);
        this.isAccessStatOpen = this.getConfig().getBoolean("access_stat_open", true);
        this.isReadMetaFromRemoteOpen = this.getConfig().getBoolean("get_meta_from_remote", false);
        this.isAutoSwitchWhenMasterAbnormal = this.getConfig().getBoolean("auto_switch_standby_to_master", true);
        this.isAllowedReadInStandy = this.getConfig().getBoolean("allow_read_in_standby", false);
        this.isServerSideEncryptionHttps = this.getConfig().getBoolean("sseHttpsOpen", true);
        this.isServerSideEncryptionKmsV4 = this.getConfig().getBoolean("sseKmsV4Open", false);
        this.isServerSideEncryptionSsecV4 = this.getConfig().getBoolean("ssecV4Open", false);
        this.isDebugCryptoEnable = this.getConfig().getBoolean("sseCryptoOpen", false);
        this.serverSideEncryptionKmsCmkIdAlias = this.getConfig().getString("sseKmsCmkIdAlias", "obs/default");
        this.kmsCmkListLimit = this.getConfig().getString("sseKmsCmkIdListLimit", "1000");
        this.lifecycleExecutionTimeSegment = this.getConfig().getString("lifecycle_execution_time_segment");
        this.websiteHomeLocation = this.getConfig().getString("website_home_location", "");
        if (OBSConfig.sys().isEnterpriseMode()) {
            this.websiteHomeLocation = this.getConfig().getString("website_home_location", "");
        }
        this.conflictBucketSwitch = this.getConfig().getBoolean("conflict_bucket_open", false);
        this.conflictBucketClusterCheckSwitch = this.getConfig().getBoolean("test_conflict_bucket_cluster_check", false);
        this.conflictBucketClusterCheckIPs = this.getConfig().getString("test_conflict_bucket_cluster_check_ips", DefaultConfBusiness.CONFLICT_BUCKET_CLUSTERID_CHECK_IPS);
        this.isSendTaskSwitchOpen = this.getConfig().getBoolean("send_task_switch_open", true);
        this.isReceiveTaskSwitchOpen = this.getConfig().getBoolean("receive_task_switch_open", true);
        this.isSMNSwitchOpen = this.getConfig().getBoolean("smn_connection", false);
        this.smnAddress = this.getConfig().getString("smn_address", "");
        this.certificationAlarmThreshold = this.getConfig().getInt("certification_alarm_threshold", 30);
        this.kvPerformanceStatInterval = this.getConfig().getLong("kv_performancestat_interval", 900000L);
        this.backendThreadPrefixt = this.getConfig().getString("background_thread_keyword", "");
        this.kvAccessThreadNumber = this.getConfig().getInt("kvaccess_thread_number", 250);
        this.userWhitelistStr = this.getConfig().getString("user_whitelist", "");
        this.isClusterDomainAccessEnabled = this.getConfig().getBoolean("enable_cluster_domain_access", true);
        this.isDeltaECWriteOpen = this.getConfig().getBoolean("delta_ec_write_switch", true);
        this.accessKVSemaphoreAcquireTimeoutSeconds = this.getConfig().getInt("accesskv_semaphoreaquire_timeout_seconds", 200);
        this.maintainPoolSize = this.getConfig().getInt("maintain_pool_size", 10);
        this.lib2dDepthForRebuild = this.getConfig().getInt("lib2d_depth_for_rebuild", 100);
        this.consoleOrigin = this.getConfig().getString("console_origin", "");
        this.getAccessLogOpen = this.getConfig().getBoolean("get_access_log_open", false);
        this.getMeterAccessLogOpen = this.getConfig().getBoolean("meter_access_log_open", false);
        this.cesAccessLogOpen = this.getConfig().getBoolean("ces_access_log_open", false);
        this.cesAccessLogUploadPeriod = this.getConfig().getLong("ces_access_log_upload_period_s", 60L);
        this.cesLogBucketName = this.getConfig().getString("ces_access_log_bucket_name", "");
        this.isOriginSourceOpen = this.getConfig().getBoolean("", false);
        this.isSecurityTokenServiceOpen = this.getConfig().getBoolean("is_security_token_service_open", true);
        this.usersAllowedToSpecifyLocation = this.getConfig().getString("users_allowed_to_specify_location", "");
        this.isAbsoluteRedirectUrl = this.getConfig().getBoolean("is_absolute_redirect_url", true);
        this.isAccessKeyNeedcheck = this.getConfig().getBoolean("is_access_key_needcheck", true);
        this.functionGraphUrnCheckAddress = this.getConfig().getString("function_graph_urn_check_address", "");
        this.functionGraphAddress = this.getConfig().getString("function_graph_address", "");
        this.functionGraphConnection = this.getConfig().getBoolean("function_graph_connection", false);
        this.cloudFunctionAddress = this.getConfig().getString("cloud_function_address", "");
        this.cloudFunctionConnection = this.getConfig().getBoolean("cloud_function_connection", false);
        this.functionGraphCheckServerCertification = this.getConfig().getBoolean("function_graph_check_server_certification", true);
        this.cloudFunctionCheckServerCertification = this.getConfig().getBoolean("cloud_function_check_server_certification", true);
        this.copySupportRange = this.getConfig().getBoolean("copy_support_range", true);
        this.allDomainName = DomainUtils.getAllDomain(this.getConfig().getString("obs_api_root_domain_name", ""));
        if (OBSConfig.sys().isEnterpriseMode()) {
            this.allDomainName = DomainUtils.getAllDomain(this.getConfig().getString("obs_api_root_domain_name", ""));
        }
        if (!this.allDomainName.isEmpty()) {
            this.domainName = this.allDomainName.get(0);
            this.allDomainPatterns = ConfigUtil.buildRegexPattern(this.allDomainName);
        }
        this.cdmConsumerTimeout = this.getConfig().getInt("cdm_consumer_execute_timeout", 1);
        this.sendCdmMesasgeSize = this.getConfig().getInt("send_cdm_message_size", 200);
        this.cdmAddress = this.getConfig().getString("cdm_address", "");
        this.dataMigrationOpen = this.getConfig().getBoolean("data_migration_open", false);
        this.cdmMaxQueueSize = this.getConfig().getInt("cdm_max_queue_size", 5000);
        this.cdmExtractorsNum = this.getConfig().getInt("cdm_extractors_num", 4);
        this.maxTagKeyLength = this.getConfig().getInt("max_tag_key_length", 36);
        this.maxTagValueLength = this.getConfig().getInt("max_tag_value_length", 43);
        this.maxCountOfBucketTag = this.getConfig().getInt("max_count_of_bucket_tag", 10);
        this.objectMaxTagKeyLength = this.getConfig().getInt("max_object_tag_key_length", 128);
        this.objectMaxTagValueLength = this.getConfig().getInt("max_object_tag_value_length", 256);
        this.maxCountOfObjectTag = this.getConfig().getInt("max_count_of_object_tag", 10);
        this.tagKeyPattern = this.getConfig().getString("tag_key_pattern", "^([^,|<>\\*\\\\\\x00-\\x1f]*)$");
        this.tagValuePattern = this.getConfig().getString("tag_value_pattern", "^([^,|<>\\*\\\\\\x00-\\x1f]*)$");
        this.calcBuImmediately = this.getConfig().getBoolean("calc_bu_immediately", Boolean.TRUE);
        this.isPartMetaCacheOpen = this.getConfig().getBoolean("isPartMetaCacheOpen", true);
        this.partMetaCacheSize = this.getConfig().getInt("parMetaCacheSize", 100);
        this.headBucketOpen = this.getConfig().getBoolean("head_bucket_open", Boolean.FALSE);
        this.isAllowHeadBucket = this.getConfig().getBoolean("allow_head_bucket", Boolean.TRUE);
        this.isDebugLogAllow = this.getConfig().getBoolean("allow_head_bucket_debug_log", Boolean.FALSE);
        this.partMinSize = this.getConfig().getLong("part_min_size", 0x500000L);
        this.cdmConsumerThreadNumber = this.getConfig().getInt("cdm_consumber_thread_number", 20);
        this.httpConnStackMaxCount = this.getConfig().getInt("http_conn_stack_max_count", 100);
        this.reducedMeta = this.getConfig().getBoolean("reduce_meta_switch", Boolean.FALSE);
        this.isImgTransOpen = this.getConfig().getBoolean("ITS_switch", false);
        this.isImgTransRouteOpen = this.getConfig().getBoolean("img_route_switch", false);
        this.imgTransAddress = this.getConfig().getString("img_transform_address", "");
        this.imgS3SignatureGen = this.getConfig().getBoolean("img_s3_signature_gen", false);
        this.imgS3SignatureHttpsOnly = this.getConfig().getBoolean("img_s3_signature_https_only", true);
        this.fsMaxDirDepth = this.getConfig().getInt("fs_max_dir_depth", 45);
        this.fsMaxCacheNode = this.getConfig().getInt("fs_max_cache_node", 1000);
        this.dataCenterReqRetryTime = this.getConfig().getInt("data_center_req_retry_time", 5);
        this.isFsPartLayoutMoveAsyncSwitch = this.getConfig().getBoolean("fs_part_layout_move_async_switch", Boolean.TRUE);
        this.fsMaxPartLayoutMoveRate = this.getConfig().getInt("fs_max_part_layout_move_rate", 1000);
        this.isCoexistForwardOpen = this.getConfig().getBoolean("coexist_forward_open", false);
        this.isCoexistLastModifyTimeOpen = this.getConfig().getBoolean("coexist_last_modify_time_open", false);
        this.isCompareLastModifyTimeOpen = this.getConfig().getBoolean("compare_last_modify_time_open", false);
        this.coexistClusterForwardEndpoint = this.getConfig().getString("coexist_cluster_forward_endpoint", "127.0.0.1");
        this.ldapPwdCacheTimeOut = this.getConfig().getLong("ldap_pwd_cache_time", DefaultConfBusiness.LDAP_PWD_CACHE_TIME);
        this.multipartMaxCount = this.getConfig().getInt("multipart_max_count", 100);
        this.fullGcThreshold = this.getConfig().getInt("full_gc_threshold", 3);
        this.isEnableStsSkEncrypt = this.getConfig().getBoolean("enable_sts_sk_encrypt", false);
        this.isMultiPartLocationFormatOn = this.getConfig().getBoolean("multipart_merge_location_aws_format", false);
        this.isMultiPartLocationFormatSwitchOpen = this.getConfig().getBoolean("multipart_merge_location_switch", false);
        this.serverErrorAlarmCount = this.getConfig().getInt("server_error_alarm_count", 5);
        this.serverErrorAlarmRatio = this.getConfig().getInt("server_error_alarm_ratio", 10);
        this.isLogRequesterSwitchOpen = this.getConfig().getBoolean("log_requester_switch", false);
        this.stsMaxExpiration = this.getConfig().getInt("sts_max_expiration", 86400);
    }

    private void loadVirtualHostConfig(PropertiesConfiguration config) {
        this.domainNameRegexEnable = config.getBoolean("domain_name_regex_enable", false);
        this.domainNameRegex = config.getString("domain_name_regex", "");
    }

    private void loadAPITransformConfig(PropertiesConfiguration config) {
        this.apiHttpExternHeaders = config.getString("obs_api_http_extern_headers", "x-amz-");
        this.apiAllUsersGroupURI = config.getString("obs_api_all_users_group_uri", "http://acs.amazonaws.com/groups/global/AllUsers");
        this.apiAuthenticatedUsersURI = config.getString("obs_api_authenticated_users_group_uri", "http://acs.amazonaws.com/groups/global/AuthenticatedUsers");
    }

    private void loadObjectMultiDeleteConfig(PropertiesConfiguration config) {
        this.maxMultiDeleteNum = config.getInt("max_multi_deleteNum", 1000);
        this.aveLoad = config.getInt("multi_delete_aveLoad", 10);
        this.maxMultiDeleteRequestNum = config.getInt("max_multi_delete_request", 20);
        this.multiDeleteTimeOut = config.getInt("ssc_osc_multi_delete_timeout", 60000);
        this.maxMultiDeleteThreadNum = config.getInt("max_multi_delete_thread_num", 40);
        this.maxMultiDelReqBody = config.getInt("max_multi_delete_request_body", 1228800);
        this.maxMultiDelThreadPoolNum = config.getInt("max_multi_delete_threadpool_num", 200);
        this.maxMultiModifyReqBody = config.getInt("max_multi_modify_request_body", 10240000);
    }

    private void loadWrongAccessConfig(PropertiesConfiguration config) {
        this.trafficStatisticPeriod = config.getInt("trafficStatisticPeriod", 10);
        this.coveragePeriod = config.getInt("trafficCoveragePeriod", 5);
        this.trafficStatisticOpen = config.getBoolean("trafficStatisticOpen", false);
    }

    private void loadMDCConfig(PropertiesConfiguration config) {
        this.localDataCenterID = config.getString("cluster_id", "");
        if (this.localDataCenterID.isEmpty()) {
            logger.error("config error,cluster_id is empty");
        }
        this.systemUnitedUserAuthID = config.getString("Sys_User_AuthCanouseId", "00000000000000000000000000000000");
        this.mdcHTTPSPort = config.getInt("mdc_https_port", 5443);
        this.mdcHTTPPort = config.getInt("mdc_http_port", 5080);
        this.mdcMsgQueueBusy = config.getInt("mdc_message_queue_mdctask_busy", 80);
        this.mdcTaskReloadGap = config.getLong("mdc_mdctask_reload_gap", 18000000L);
        this.mdcAsynDeleteDelayTime = config.getLong("mdc_asyn_delete_delay_time", 60000L);
        this.maxMdcAsynDeleteDelayTime = config.getLong("mdc_asyn_delete_max_delay_time", 50400000L);
        this.mdcFlowControlOpen = config.getBoolean("mdc_flow_control_open", false);
        this.fastVisitorPeriod = config.getLong("fastvisitor_period", 720L);
        this.fsTaskCleanMaxIntervalTime = config.getInteger("fs_task_clean_interval_time", Integer.valueOf(100));
    }

    private void loadVPCConfig(PropertiesConfiguration config) {
        this.vpcIpType = config.getString("vpc_ip_type");
        this.vpcIpList = this.parseVpcIPList(config.getString("vpc_ip_list"));
        this.vpcUrl = config.getString("vpc_url");
        this.vpcIdConfig = config.getStringArray("vpc_id_config");
        this.parseVpcIdConfigToThreeList(this.vpcIdConfig);
        this.vpcKVPeriod = config.getLong("vpc_kv_period", 60L);
        this.parseVpcReadOnlyActionList(config.getString("vpc_readonly_action_list"));
    }

    private void loadSSEConfig(PropertiesConfiguration config) {
        this.isSsecSwitchOpen = config.getBoolean("server_side_encryption_switch", true);
        this.isSsecSwitchInSmartEncryptionScenarioOpen = config.getBoolean("server_side_encryption_switch_in_smart_encryption_scenario", false);
        this.ssecIntegrityCheckAlgorithmSet = this.loadSupportCheckAlgorithmSet(config.getString("server_side_encryption_integrity_check_algorithm_list"));
    }

    private Set<String> loadSupportCheckAlgorithmSet(String input) {
        String[] list;
        HashSet<String> algorithmSet = new HashSet<String>();
        algorithmSet.add("SHA256");
        if (StringUtils.isEmpty((CharSequence)input)) {
            return algorithmSet;
        }
        for (String algorithm : list = input.split(",")) {
            algorithmSet.add(algorithm);
        }
        return algorithmSet;
    }

    private void parseVpcReadOnlyActionList(String input) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)input)) {
            BusinessConfig.parseInput(input, result);
        }
        this.vpcReadOnlyActionList = result;
        if (this.vpcReadOnlyActionList.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("vpcReadOnlyActionList success, size:[{}], content:[{}]", (Object)this.vpcReadOnlyActionList.size(), this.vpcReadOnlyActionList);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Do not found vpcReadOnlyActionList configuration.");
        }
    }

    private static void parseInput(String input, List<String> result) {
        String[] is = input.split(",");
        if (null != is && is.length > 0) {
            for (String index : is) {
                if (!StringUtils.isNotBlank((CharSequence)index)) continue;
                result.add(index.toLowerCase(Locale.ENGLISH).trim());
            }
        }
    }

    private void parseVpcIdConfigToThreeList(String[] vpcIdConfig) {
        this.vpcIdAndTenantIdList = new ArrayList<String>();
        this.vpcIdList = new ArrayList<String>();
        this.tenantIdList = new ArrayList<String>();
        for (String vpcIdMap : vpcIdConfig) {
            String[] tenantIdConfiged;
            String[] vpcIdConfiged;
            String[] vpcIdData;
            if (StringUtils.isBlank((CharSequence)vpcIdMap) || (vpcIdData = vpcIdMap.split(",")).length != 2 || StringUtils.isBlank((CharSequence)vpcIdData[0]) || StringUtils.isBlank((CharSequence)vpcIdData[1]) || (vpcIdConfiged = vpcIdData[0].split(":")).length != 2 || StringUtils.isBlank((CharSequence)vpcIdConfiged[1]) || (tenantIdConfiged = vpcIdData[1].split(":")).length != 2 || StringUtils.isBlank((CharSequence)tenantIdConfiged[1])) continue;
            this.vpcIdAndTenantIdList.add(vpcIdConfiged[1].trim() + "," + tenantIdConfiged[1].trim());
            this.vpcIdList.add(vpcIdConfiged[1].trim());
            this.tenantIdList.add(tenantIdConfiged[1].trim());
        }
        if (this.vpcIdAndTenantIdList.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("vpcIdAndTenantIdList success, size:[" + this.vpcIdAndTenantIdList.size() + "], content:[" + this.vpcIdAndTenantIdList + "]");
                logger.debug("vpcIdList success, size:[" + this.vpcIdList.size() + "], content:[" + this.vpcIdList + "]");
                logger.debug("tenantIdList success, size:[" + this.tenantIdList.size() + "], content:[" + this.tenantIdList + "]");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Do not found vpcIdAndTenantIdList configuration.");
        }
    }

    private List<String> parseVpcIPList(String vpcIPList) {
        ArrayList<String> result = new ArrayList<String>();
        if (null == vpcIPList || vpcIPList.isEmpty()) {
            return result;
        }
        List<String> ipList = BusinessConfig.splitIpList(vpcIPList);
        for (String ipWithMask : ipList) {
            if (null == ipWithMask || ipWithMask.isEmpty()) continue;
            if (!Pattern.matches(IPV4_NET_DESC_PATTERN, ipWithMask)) {
                logger.warn("Not is a network description! ip with mask:[" + ipWithMask + "]");
                continue;
            }
            result.add(ipWithMask);
        }
        return result;
    }

    private static List<String> splitIpList(String ipList) {
        ArrayList<String> result = new ArrayList<String>();
        String[] ipArray = ipList.split(",");
        Collections.addAll(result, ipArray);
        return result;
    }

    public int getRepMaxFailedTimes() {
        return this.repMaxFailedTimes;
    }

    public int getMaxUserOwnBucketNum() {
        return this.maxUserOwnBucketNum;
    }

    public boolean isUseOscQueue() {
        return this.isUseOscQueue;
    }

    public int getOscQueueTimeOut() {
        return this.oscQueueTimeOut;
    }

    public int getMaxOSCRequest() {
        return this.maxOSCRequest;
    }

    public void setUseOscQueue(boolean isUseOscQueue) {
        this.isUseOscQueue = isUseOscQueue;
    }

    public double getMaxOscRequestRatio() {
        if (this.maxOscRequestRatio < 0.0) {
            logger.debug("get max_osc_request_ratio <= 0, use default [{}].", (Object)1.2);
            this.maxOscRequestRatio = 1.2;
        }
        return this.maxOscRequestRatio;
    }

    public int getMaxRequestOnCurrentSystem() {
        return this.maxRequestOnCurrentSystem;
    }

    public int getMaxMaintainRequest() {
        return this.maxMaintainRequest;
    }

    public String getCorrespondenceBetweenMemAndRequest() {
        return this.correspondenceBetweenMemAndRequest;
    }

    public int getInternalOSCRequest() {
        if (this.internalOSCRequest <= 0) {
            this.internalOSCRequest = 20;
        }
        return this.internalOSCRequest;
    }

    public int getMaxOSCConnection() {
        return this.maxOSCConnection;
    }

    public void setMaxOSCConnection(int maxOSCConnection) {
        this.maxOSCConnection = maxOSCConnection;
    }

    public int getMaxObjectLength() {
        return this.maxObjectLength;
    }

    public boolean isCompressSwitchOpen() {
        return this.compressSwitchOpen;
    }

    public void setCompressSwitchOpen(boolean compressSwitchOpen) {
        this.compressSwitchOpen = compressSwitchOpen;
    }

    public int getMaxFileLength() {
        return this.fsMaxFileLength;
    }

    public long getTempAuthExpireTime() {
        return this.tempAuthExpireTime;
    }

    public int getAuthCacheMaxCount() {
        return this.authCacheMaxCount;
    }

    public boolean isNeedCalcMD5() {
        return this.needCalcMD5;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
    }

    public long getUserMetadataMaxSize() {
        return this.userMetadataMaxSize;
    }

    public int getMetaSearchMaxKeys() {
        return this.metaSearchMaxKeys;
    }

    public int getSmallObjectSize() {
        return this.smallObjectSize;
    }

    public boolean isDomainNameRegexEnable() {
        return this.domainNameRegexEnable;
    }

    public String getDomainNameRegex() {
        return this.domainNameRegex;
    }

    public String getApiHttpExternHeaders() {
        return this.apiHttpExternHeaders;
    }

    public String getApiAllUsersGroupURI() {
        return this.apiAllUsersGroupURI;
    }

    public String getApiAuthenticatedUsersURI() {
        return this.apiAuthenticatedUsersURI;
    }

    public String getApiRootDomainName() {
        return this.domainName;
    }

    public List<String> getAllApiRootDomainName() {
        return this.allDomainName;
    }

    public List<Pattern> getAllApiRootDomainPatterns() {
        return this.allDomainPatterns;
    }

    public String getWebsiteDomainNameSuffix() {
        return this.websiteDomainNameSuffix;
    }

    public boolean needRegionCopy() {
        return this.isNeedRegionCopy;
    }

    public boolean isCopySupportRange(PropertiesConfiguration config) {
        return this.copySupportRange;
    }

    public void setRegionCopy(PropertiesConfiguration config, boolean regioncopyTrigger) {
        config.setProperty("REGIONCopy", (Object)regioncopyTrigger);
        this.isNeedRegionCopy = regioncopyTrigger;
    }

    public int getMdcHTTPSPort() {
        return this.mdcHTTPSPort;
    }

    public int getMdcHTTPPort() {
        return this.mdcHTTPPort;
    }

    public int getInternalBusinessHTTPPort() {
        return this.internalHTTPPort;
    }

    public int getInternalBusinessHTTPSPort() {
        return this.internalHTTPSPort;
    }

    public String getLocalDataCenterID() {
        return this.localDataCenterID;
    }

    public void setLocalDataCenterID(String localDataCenterID) {
        this.localDataCenterID = localDataCenterID;
    }

    public String getSystemUnitedUserAuthID() {
        return this.systemUnitedUserAuthID;
    }

    public void setSystemUnitedUserAuthID(String systemUnitedUserAuthID) {
        this.systemUnitedUserAuthID = systemUnitedUserAuthID;
    }

    public boolean getServerSideEncryptionEnable() {
        return this.isServerSideEncryptionEnable;
    }

    public String getKmsTransportLayer() {
        return this.kmsTransportLayer;
    }

    public String getKmsTargetHostname() {
        return this.kmsTargetHostname;
    }

    public String getKmsKeyStoreLocation() {
        return this.kmsKeyStoreLocation;
    }

    public String getKmsKeyStorePW() {
        return this.kmsKeyStorePW;
    }

    public String getKmsTrustStorePW() {
        return this.kmsTrustStorePW;
    }

    public String getKmsTrustStoreFileName() {
        return this.kmsTrustStoreFileName;
    }

    public String getConnectKmsType() {
        return this.connectKmsType;
    }

    public int getKmsClientMaxConnections() {
        return this.kmsClientMaxConnections;
    }

    public boolean isAkWrongAccessOpen() {
        return this.isAkWrongAccessOpen;
    }

    public boolean isIpWrongAccessOpen() {
        return this.isIpWrongAccessOpen;
    }

    public boolean isIpViolentAccessOpen() {
        return this.isIpViolentAccessOpen;
    }

    public boolean isAkandipWrongAccessOpen() {
        return this.isAkandipWrongAccessOpen;
    }

    public boolean isHcpCompatible() {
        return this.isHcpCompatible;
    }

    public boolean isDdosAtackAlarmOpen() {
        return this.isDdosAtackAlarmOpen;
    }

    public Properties getAkPolicy() {
        return this.akPolicy;
    }

    public Properties getIpPolicy() {
        return this.ipPolicy;
    }

    public Properties getAkAndIpPolicy() {
        return this.akAndIpPolicy;
    }

    public double getWrongAccessRatioImportant() {
        return this.wrongAccessRatioImportant;
    }

    public double getWrongAccessRatioEmergency() {
        return this.wrongAccessRatioEmergency;
    }

    public long getRequestFlowThreshold() {
        return this.requestFlowThreshold;
    }

    public long getRequestTimesThreshold() {
        return this.requestTimesThreshold;
    }

    public boolean isQueryCurrentUsersSwitchOpen() {
        return this.isqueryCurrentUsersSwitchOpen;
    }

    public boolean isTrafficStatisticOpen() {
        return this.trafficStatisticOpen;
    }

    public void setTrafficStatisticOpen(boolean trafficStatisticOpen) {
        this.trafficStatisticOpen = trafficStatisticOpen;
    }

    public int getTrafficStatisticPeriod() {
        return this.trafficStatisticPeriod;
    }

    public void setTrafficStatisticPeriod(int trafficStatisticPeriod) {
        this.trafficStatisticPeriod = trafficStatisticPeriod;
    }

    public boolean isTracingEnabled() {
        return this.isTracingEnabled;
    }

    public boolean isPermitDeleteBucketData() {
        return this.isPermitDeleteBucketData;
    }

    public int getMaxMultiDeleteNum() {
        if (this.maxMultiDeleteNum <= 0) {
            this.maxMultiDeleteNum = 1000;
        }
        return this.maxMultiDeleteNum;
    }

    public int getAveLoad() {
        if (this.aveLoad <= 0) {
            this.aveLoad = 10;
        }
        return this.aveLoad;
    }

    public void setAveLoad(int aveLoad) {
        this.aveLoad = aveLoad;
    }

    public int getMaxMultiDeleteRequestNum() {
        if (this.maxMultiDeleteRequestNum <= 0) {
            this.maxMultiDeleteRequestNum = 20;
        }
        return this.maxMultiDeleteRequestNum;
    }

    public int getMultiDeleteTimeOut() {
        if (this.multiDeleteTimeOut <= 0) {
            this.multiDeleteTimeOut = 60000;
        }
        return this.multiDeleteTimeOut;
    }

    public int getMaxMultiDeleteThreadNum() {
        if (this.maxMultiDeleteThreadNum <= 0) {
            this.maxMultiDeleteThreadNum = 40;
        }
        return this.maxMultiDeleteThreadNum;
    }

    public int getMaxMultiDelReqBody() {
        if (this.maxMultiDelReqBody <= 0) {
            this.maxMultiDelReqBody = 1228800;
        }
        return this.maxMultiDelReqBody;
    }

    public int getMaxMultiModifyReqBody() {
        if (this.maxMultiModifyReqBody <= 0) {
            this.maxMultiModifyReqBody = 10240000;
        }
        return this.maxMultiModifyReqBody;
    }

    public int getMaxMultiDelThreadPoolNum() {
        if (this.maxMultiDelThreadPoolNum <= 0) {
            this.maxMultiDelThreadPoolNum = 200;
        }
        return this.maxMultiDelThreadPoolNum;
    }

    public String getCompressContentType() {
        return this.compressContentType;
    }

    public int getMaxObjectDedupedNum() {
        return 1000;
    }

    public boolean isCheckUserPolicyOpen() {
        return this.checkUserPolicyOpen;
    }

    public void setCheckUserPolicyOpen(boolean checkUserPolicyOpen) {
        this.checkUserPolicyOpen = checkUserPolicyOpen;
    }

    public String getConsoleOrigin() {
        return this.consoleOrigin;
    }

    public boolean isAccessLogOpen() {
        return this.isAccessLogOpen;
    }

    public boolean isInnerAccessBucketActive() {
        return this.isInnerAccessBucketActive;
    }

    public boolean isAbortMultiLc2Ccdb() {
        return this.isAbortMultiLc2Ccdb;
    }

    public boolean isInnerAccessBucketOpen() {
        return this.isInnerAccessBucketOpen;
    }

    public int getInnerAccessBucketRetention() {
        return this.innerAccessBucketRetention;
    }

    public int getInnerAccessBucketRecycleTime() {
        return this.innerAccessBucketRecycleTime;
    }

    public boolean isInnerMgcBucketOpen() {
        return this.isInnerMgcBucketOpen;
    }

    public int getInnerMgcBucketRetention() {
        return this.innerMgcBucketRetention;
    }

    public int getInnerMgcBucketRecycleTime() {
        return this.innerMgcBucketRecycleTime;
    }

    public String getInnerAccessBucketNameSuffix() {
        return this.innerAccessBucketNameSuffix;
    }

    public long getInnerAccessBucketCapacity() {
        return this.innerAccessBucketCapacity;
    }

    public long getStsXattrCapacity() {
        return this.stsXattrCapacity;
    }

    public int getStsRecCoreThreadNum() {
        return this.stsRecCoreThreadNum;
    }

    public int getStsRecTotalThreadNum() {
        return this.stsRecTotalThreadNum;
    }

    public boolean isGetAccessLogOpen() {
        return this.getAccessLogOpen;
    }

    public boolean isMeterAccessLogOpen() {
        return this.getMeterAccessLogOpen;
    }

    public boolean isCESAccessLogOpen() {
        return this.cesAccessLogOpen;
    }

    public long getCesAccessLogUploadPeriod() {
        return this.cesAccessLogUploadPeriod;
    }

    public String getCESLogBucketName() {
        return this.cesLogBucketName;
    }

    public boolean isReadMetaFromRemoteOpen() {
        return this.isReadMetaFromRemoteOpen;
    }

    public boolean isAutoSwitchWhenMasterAbnormal() {
        return this.isAutoSwitchWhenMasterAbnormal;
    }

    public boolean isAllowedReadInStandy() {
        return this.isAllowedReadInStandy;
    }

    public boolean getServerSideEncryptionHttps() {
        return this.isServerSideEncryptionHttps;
    }

    public boolean getServerSideEncryptionKmsV4() {
        return this.isServerSideEncryptionKmsV4;
    }

    public boolean getServerSideEncryptionSsecV4() {
        return this.isServerSideEncryptionSsecV4;
    }

    public String getServerSideEncryptionKmsCmkIdAlias() {
        return this.serverSideEncryptionKmsCmkIdAlias;
    }

    public String getKmsCmkListLimit() {
        return this.kmsCmkListLimit;
    }

    public String getLifecycleExecutionTimeSegment() {
        return this.lifecycleExecutionTimeSegment;
    }

    public int getMaxLogCount() {
        return this.maxLogCount;
    }

    public long getTimeIntervalOfBucketAccessLog() {
        return this.timeIntervalOfBucketAccessLog;
    }

    public boolean isBucketAccessLogLocalConfigurated() {
        return this.isBucketAccessLogLocalConfigurated;
    }

    public int getLocalBucketMetaCacheSize() {
        return this.localBucketMetaCacheSize;
    }

    public int getLocalBucketMetaCacheTimeoutMs() {
        return this.localBucketMetaCacheTimeoutMs;
    }

    public int getLocalBucketMetaCacheLazyTimeoutMs() {
        return this.localBucketMetaCacheLazyTimeoutMs;
    }

    public int getLocalBucketMetaCacheWatchPeriod() {
        return this.localBucketMetaCacheWatchPeriod;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setInternalOSCRequest(int internalOSCRequest) {
        this.internalOSCRequest = internalOSCRequest;
    }

    public void setCompressContentType(String compressContentType) {
        this.compressContentType = compressContentType;
    }

    public String getWebsiteHomeLocation() {
        return this.websiteHomeLocation;
    }

    public boolean getConflictBucketSwitch() {
        return this.conflictBucketSwitch;
    }

    public boolean getConflictBucketClusterCheckSwitch() {
        return this.conflictBucketClusterCheckSwitch;
    }

    public String getConflictBucketClusterCheckIPs() {
        return this.conflictBucketClusterCheckIPs;
    }

    public boolean isSendTaskSwitchOpen() {
        return this.isSendTaskSwitchOpen;
    }

    public boolean isReceiveTaskSwitchOpen() {
        return this.isReceiveTaskSwitchOpen;
    }

    public boolean isCheckOSCServerCert() {
        return this.checkOSCServerCert;
    }

    public boolean isCheckDCMServerCert() {
        return this.checkDCMServerCert;
    }

    public boolean isCheckKeystoneServerCert() {
        return this.checkKeystoneServerCert;
    }

    public boolean isCheckIamServerCert() {
        return this.checkIamServerCert;
    }

    public boolean isCheckBssServerCert() {
        return this.checkBssServerCert;
    }

    public boolean isCheckSmnServerCert() {
        return this.checkSmnServerCert;
    }

    public boolean isCheckCloudFunctionServerCert() {
        return this.checkCloudFunctionServerCert;
    }

    public boolean isCheckFunctionGraphServerCert() {
        return this.checkFunctionGraphServerCert;
    }

    public void setParsePartitionTimeOut(int parsePartitionTimeOut) {
        this.parsePartitionTimeOut = parsePartitionTimeOut;
    }

    public int getParsePartitionTimeOut() {
        return this.parsePartitionTimeOut;
    }

    public boolean isFsPartLayoutMoveAsyncSwitch() {
        return this.isFsPartLayoutMoveAsyncSwitch;
    }

    public boolean isSMNSwitchOpen() {
        return this.isSMNSwitchOpen;
    }

    public String getSMNAddress() {
        return this.smnAddress;
    }

    public boolean isCloudFunctionSwitchOpen(PropertiesConfiguration config) {
        return this.cloudFunctionConnection;
    }

    public String getCloudFunctionAddress(PropertiesConfiguration config) {
        return this.cloudFunctionAddress;
    }

    public boolean isFunctionGraphSwitchOpen(PropertiesConfiguration config) {
        return this.functionGraphConnection;
    }

    public String getFunctionGraphAddress(PropertiesConfiguration config) {
        return this.functionGraphAddress;
    }

    public String getFunctionGraphUrnCheckAddress(PropertiesConfiguration config) {
        return this.functionGraphUrnCheckAddress;
    }

    public int getCertificationAlarmThreshold() {
        return this.certificationAlarmThreshold;
    }

    public long getKVPerformanceStatInterval() {
        return this.kvPerformanceStatInterval;
    }

    public String getBackendThreadPrefixt() {
        return this.backendThreadPrefixt;
    }

    public String getUserWhitelistStr() {
        return this.userWhitelistStr;
    }

    public boolean isClusterDomainAccessEnabled() {
        return this.isClusterDomainAccessEnabled;
    }

    public boolean isDeltaECWriteOpen() {
        return this.isDeltaECWriteOpen;
    }

    public boolean getSupportCreatingDeltaWriteECPlog() {
        return supportCreatingDeltaWriteECPlog;
    }

    public void setSupportCreatingDeltaWriteECPlog(boolean supportCreatingDeltaWriteECPlog) {
        BusinessConfig.supportCreatingDeltaWriteECPlog = supportCreatingDeltaWriteECPlog;
    }

    public int getMaintainPoolSize() {
        return this.maintainPoolSize;
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            try {
                this.loadConfig();
            }
            catch (ConfigurationException e) {
                logger.warn("Refresh file[{}] failed due to error [{}]", (Object)this.getConfigBuilder().getFileHandler().getFileName());
            }
        }
    }

    public boolean isAccessKeyNeedCheck(PropertiesConfiguration config) {
        return this.isAccessKeyNeedcheck;
    }

    public boolean isAbsoluteRedirectUrl(PropertiesConfiguration config) {
        return this.isAbsoluteRedirectUrl;
    }

    public String getUsersAllowedToSpecifyLocationStr(PropertiesConfiguration config) {
        return this.usersAllowedToSpecifyLocation;
    }

    public boolean isImageTranscodeOpen(PropertiesConfiguration config) {
        return this.isImgTransOpen;
    }

    public boolean imgTranscodeRouteOpen(PropertiesConfiguration config) {
        return this.isImgTransRouteOpen;
    }

    public String getImgTransAddress(PropertiesConfiguration config) {
        return this.imgTransAddress;
    }

    public boolean imgS3SignatureGen(PropertiesConfiguration config) {
        return this.imgS3SignatureGen;
    }

    public boolean imgS3SignatureHttpsOnly(PropertiesConfiguration config) {
        return this.imgS3SignatureHttpsOnly;
    }

    public boolean isSTSOpen(PropertiesConfiguration config) {
        return this.isSecurityTokenServiceOpen;
    }

    public boolean getOriginSourceOpen() {
        return this.isOriginSourceOpen;
    }

    public int getCdmConsumerTimeout() {
        return this.cdmConsumerTimeout;
    }

    public int getSendCdmMesasgeSize() {
        return this.sendCdmMesasgeSize;
    }

    public String getCDMAddress() {
        return this.cdmAddress;
    }

    public boolean isDataMigrationOpen() {
        return this.dataMigrationOpen;
    }

    public int getCdmMaxQueueSize() {
        return this.cdmMaxQueueSize;
    }

    public int getCdmExtractorsNum() {
        if (this.cdmExtractorsNum <= 0 || this.cdmExtractorsNum > 20) {
            logger.debug("cdm_max_queue({})_size is invalid. it should be [1, 20]", (Object)this.cdmExtractorsNum);
            return 4;
        }
        return this.cdmExtractorsNum;
    }

    public int getMaxTagKeyLength() {
        return this.maxTagKeyLength > 0 ? this.maxTagKeyLength : 36;
    }

    public int getMaxTagValueLength() {
        return this.maxTagValueLength > 0 ? this.maxTagValueLength : 43;
    }

    public int getMaxCountOfBucketTag() {
        return this.maxCountOfBucketTag > 0 ? this.maxCountOfBucketTag : 10;
    }

    public int getObjectMaxTagKeyLength() {
        return this.objectMaxTagKeyLength > 0 ? this.objectMaxTagKeyLength : 128;
    }

    public int getObjectMaxTagValueLength() {
        return this.objectMaxTagValueLength > 0 ? this.objectMaxTagValueLength : 256;
    }

    public int getMaxCountOfObjectTag() {
        return this.maxCountOfObjectTag > 0 ? this.maxCountOfObjectTag : 10;
    }

    public int getMaxSizeOfObjectTag() {
        return this.maxSizeOfObjectTag > 0 ? this.maxSizeOfObjectTag : 2048;
    }

    public String getTagKeyPattern() {
        return this.tagKeyPattern;
    }

    public String getTagValuePattern() {
        return this.tagValuePattern;
    }

    public boolean isCalcBuImmediately() {
        return this.calcBuImmediately;
    }

    public boolean getPartMetaCacheOpen() {
        return this.isPartMetaCacheOpen;
    }

    public int getParMetaCacheSize() {
        return this.partMetaCacheSize;
    }

    public boolean isHeadBucketOpen() {
        return this.headBucketOpen;
    }

    public boolean isAllowHeadBucket() {
        return this.isAllowHeadBucket;
    }

    public boolean isDebugLogAllow() {
        return this.isDebugLogAllow;
    }

    public String getVpcIpType() {
        return this.vpcIpType;
    }

    public List<String> getVpcIpList() {
        return this.vpcIpList;
    }

    public String getVpcUrl() {
        return this.vpcUrl;
    }

    public String[] getVpcIdConfig() {
        return this.vpcIdConfig;
    }

    public List<String> getVpcIdList() {
        return this.vpcIdList;
    }

    public List<String> getTenantIdList() {
        return this.tenantIdList;
    }

    public List<String> getVpcIdAndTenantIdList() {
        return this.vpcIdAndTenantIdList;
    }

    public List<String> getVpcReadOnlyActionList() {
        return this.vpcReadOnlyActionList;
    }

    public long getVpcKVPeriod() {
        return this.vpcKVPeriod;
    }

    public long getPartMinSize() {
        return this.partMinSize;
    }

    public int getCdmConsumerThreadNumber() {
        return this.cdmConsumerThreadNumber;
    }

    public boolean isReducedMeta() {
        return this.isReducedMeta;
    }

    public int getAccountCheckingMaxThreadNum() {
        return this.accountCheckMaxThreadNum;
    }

    public String getUserDefaultPermission() {
        return this.userDefaultPermission;
    }

    public String getUserDirDefaultPermission() {
        return this.userDirDefaultPermission;
    }

    public int getBucketCheckingMaxThreadNum() {
        return this.bucketCheckMaxThreadNum;
    }

    public boolean enterpriseSmallECEnabled() {
        return this.enterpriseSmallEC;
    }

    public void setReducedMeta(boolean reducedMeta) {
        this.reducedMeta = reducedMeta;
    }

    public int getHttpConnStackMaxCount() {
        return this.httpConnStackMaxCount;
    }

    public int getSelectConcurrentReq() {
        return KVConfig.INSTANCE.getIntValue("select_concurrent_req", 100);
    }

    public int getFsMaxDirDepth() {
        return this.fsMaxDirDepth;
    }

    public String getHiDefCname() {
        return KVConfig.INSTANCE.getStringValue("high_defend_cname", "");
    }

    public int getFsMaxCacheNode() {
        return this.fsMaxCacheNode;
    }

    public boolean isIndexV2SwitchOpen() {
        Boolean defaultValue = OBSConfig.getInstance().isEnterpriseMode();
        return KVConfig.INSTANCE.getBoolValue("index_v2_switch", defaultValue);
    }

    public boolean isIndexV2SwitchGcOpen() {
        Boolean defaultValue = OBSConfig.getInstance().isEnterpriseMode();
        return KVConfig.INSTANCE.getBoolValue("index_v2_switch_gc", defaultValue);
    }

    public boolean isIndexV2SwitchRenewOpen() {
        Boolean defaultValue = OBSConfig.getInstance().isEnterpriseMode();
        return KVConfig.INSTANCE.getBoolValue("index_v2_switch_renew", defaultValue);
    }

    public long getKeepConnectionWaitTime() {
        return KVConfig.INSTANCE.getLongValue("keep_connection_wait_time", 30000L);
    }

    public int getDataCenterReqRetryTime() {
        return this.dataCenterReqRetryTime;
    }

    public int getFsMaxPartMoveLayoutRate() {
        return this.fsMaxPartLayoutMoveRate;
    }

    public int getFsTaskCleanMaxIntervalTime() {
        return this.fsTaskCleanMaxIntervalTime;
    }

    public boolean isCoexistForwardOpen() {
        return this.isCoexistForwardOpen;
    }

    public boolean isCoexistLastModifyTimeOpen() {
        return this.isCoexistLastModifyTimeOpen;
    }

    public boolean isCompareLastModifyTimeOpen() {
        return this.isCompareLastModifyTimeOpen;
    }

    public String getCoexistClusterForwardEndpoint() {
        return this.coexistClusterForwardEndpoint;
    }

    public long getLdapPwdCacheTimeOut() {
        return this.ldapPwdCacheTimeOut <= 0L ? 1L : this.ldapPwdCacheTimeOut;
    }

    public long getLdapReadTimeout() {
        return this.getConfig().getLong("ldap_read_timeout", 30000L);
    }

    public long getLdapAuthResultTimeout() {
        return this.getConfig().getLong("ldap_auth_result_timeout", 60L);
    }

    public String getLdapAuthPort() {
        return this.getConfig().getString("ldap_port", "389");
    }

    public int getMultipartMaxCount() {
        return this.getConfig().getInt("multipart_max_count", 100);
    }

    public int getConnectThreshold() {
        return this.getConfig().getInt("connection_threshold", 95);
    }

    public boolean isSupportMd5() {
        return this.ssecIntegrityCheckAlgorithmSet.contains("MD5");
    }

    public boolean isSsecSwitchOpen() {
        return this.isSsecSwitchOpen;
    }

    public boolean isSsecSwitchInSmartEncryptionScenarioOpen() {
        return this.isSsecSwitchInSmartEncryptionScenarioOpen;
    }

    public int getFullGcThreshold() {
        return this.fullGcThreshold;
    }

    public boolean isEnableStsSkEncrypt() {
        return this.isEnableStsSkEncrypt;
    }

    public boolean isMultiPartLocationFormatOn() {
        return this.isMultiPartLocationFormatOn;
    }

    public boolean isMultiPartLocationFormatSwitchOpen() {
        return this.isMultiPartLocationFormatSwitchOpen;
    }

    public int getServerErrorAlarmCount() {
        return this.serverErrorAlarmCount;
    }

    public int getServerErrorAlarmRatio() {
        return this.serverErrorAlarmRatio;
    }

    public boolean isLogRequesterSwitchOpen() {
        return this.isLogRequesterSwitchOpen;
    }

    public int getStsMaxExpiration() {
        return this.stsMaxExpiration;
    }
}

