/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.business;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.business.DefaultConfBusiness;

public final class InfoEqualizerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoEqualizerConfig.class);
    private static final String LOCAL_IP = "local_ip";
    private static final String INVALID_VALUE = "-1";
    private static final int LSID_INDEX = 0;
    private static final int INFO_EQUALIZER_PORT = 13211;
    private static final String INFO_EQUALIZER_IPV4_IP = "127.0.0.1";
    private static final String INFO_EQUALIZER_IPV6_IP = "::1";
    private static InfoEqualizerConfig instance = null;
    private static boolean configInitSuccess;
    private Properties infoEqualizerConfig;
    private String localIp;

    public static InfoEqualizerConfig getInstance() {
        if (instance == null || !configInitSuccess) {
            instance = new InfoEqualizerConfig();
            configInitSuccess = instance.init();
        }
        return instance;
    }

    private boolean init() {
        boolean initResult = true;
        try {
            this.readConfig();
        }
        catch (ConfigurationException e) {
            LOGGER.warn("Read config failed");
            initResult = false;
        }
        if (initResult) {
            this.localIp = this.infoEqualizerConfig.getProperty(LOCAL_IP, "");
        }
        return initResult;
    }

    private void readConfig() throws ConfigurationException {
        LOGGER.debug("Began to loadInfoEqualizerConfig.");
        FileInputStream inputStream = null;
        this.infoEqualizerConfig = new Properties();
        try {
            inputStream = new FileInputStream(DefaultConfBusiness.INFO_EQUALIZER_CONFIG_NAME);
            this.infoEqualizerConfig.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.error("load loadInfoEqualizerConfig file failed.");
            throw new ConfigurationException("load loadInfoEqualizerConfig file failed.", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.error("Close upf.properties exception.", (Throwable)ioe);
                }
            }
        }
    }

    public String getInfoEqualizerEndpoint() {
        return this.localIp;
    }

    private String parseParamByIndex(int portIndex) {
        if (StringUtils.isEmpty((CharSequence)this.localIp)) {
            LOGGER.info("parse param failed");
            return INVALID_VALUE;
        }
        String[] params = this.localIp.split(":");
        return params[portIndex];
    }

    public String getInfoEqualizerIp() {
        if (this.localIp.contains("[") && this.localIp.contains("]")) {
            return INFO_EQUALIZER_IPV6_IP;
        }
        return INFO_EQUALIZER_IPV4_IP;
    }

    public int getInfoEqualizerPort() {
        return 13211;
    }

    public long getInfoEqualizerLsId() {
        String lsId = this.parseParamByIndex(0);
        return Long.parseLong(lsId);
    }
}

