/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.cdm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class CDMConfiguration
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(CDMConfiguration.class);
    private static CDMConfiguration instance = new CDMConfiguration();
    private static final int MAX_AK_SK_LENGTH = 256;
    private static final int MAX_QINIU_ZONE_LENGTH = 10;
    private int cdmTaskQueueMaxSize;
    private int cdmTaskQueueTimeout;
    private int cdmTaskConsumeDelay;
    private int cdmTaskPageSize;
    private int cdmBucketPageSize;
    private int cdmScanBucketPoolSize;
    private boolean isCdmOfflineClient;
    private boolean isCdmMockClient;
    private String cdmOfflineAddress;
    private String cdmObjectDirectory;
    private int cdmAKLength;
    private int cdmSKLength;
    private int cdmQiniuZoneMaxLength;

    private CDMConfiguration() {
    }

    public static CDMConfiguration getInstance() {
        return instance;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.cdmTaskQueueMaxSize = this.getConfig().getInt("cdmTaskQueueMaxSize", 5000);
        this.cdmTaskQueueTimeout = this.getConfig().getInt("cdmTaskQueueTimeout", 1);
        this.cdmTaskConsumeDelay = this.getConfig().getInt("cdmTaskConsumeDelay", 5);
        this.cdmTaskPageSize = this.getConfig().getInt("cdmTaskPageSize", 20);
        this.cdmBucketPageSize = this.getConfig().getInt("cdmBucketPageSize", 5);
        this.cdmScanBucketPoolSize = this.getConfig().getInt("cdmScanBucketPoolSize", 10);
        this.isCdmMockClient = this.getConfig().getBoolean("isCdmMockClient", false);
        this.isCdmOfflineClient = this.getConfig().getBoolean("isCdmOfflineClient", false);
        this.cdmOfflineAddress = this.getConfig().getString("cdmOfflineAddress", "127.0.0.1:21203");
        this.cdmObjectDirectory = this.getConfig().getString("cdmObjectDirectory", "/");
        this.cdmAKLength = this.getConfig().getInt("cdm_ak_length", 256);
        this.cdmSKLength = this.getConfig().getInt("cdm_sk_length", 256);
        this.cdmQiniuZoneMaxLength = this.getConfig().getInt("cdm_qiniu_zone_max_length", 10);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getCdmTaskQueueMaxSize() {
        return this.cdmTaskQueueMaxSize;
    }

    public int getCdmTaskQueueTimeout() {
        return this.cdmTaskQueueTimeout;
    }

    public int getCdmTaskConsumeDelay() {
        return this.cdmTaskConsumeDelay;
    }

    public boolean isCdmMockClient() {
        return this.isCdmMockClient;
    }

    public String getCdmOfflineAddress() {
        return this.cdmOfflineAddress;
    }

    public int getCdmTaskPageSize() {
        return this.cdmTaskPageSize;
    }

    public int getCdmBucketPageSize() {
        return this.cdmBucketPageSize;
    }

    public String getCdmObjectDirectory() {
        return this.cdmObjectDirectory;
    }

    public boolean isCdmOfflineClient() {
        return this.isCdmOfflineClient;
    }

    public int getCdmScanBucketPoolSize() {
        return this.cdmScanBucketPoolSize;
    }

    public int getCdmAKLength() {
        return this.cdmAKLength;
    }

    public int getCdmSKLength() {
        return this.cdmSKLength;
    }

    public int getCdmQiniuZoneMaxLength() {
        return this.cdmQiniuZoneMaxLength;
    }
}

