/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.crr;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.index.KVConfig;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.OBSConfig;
import uds.common.config.interf.PropertiesConfigBuilder;

public class CRRConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(CRRConfig.class);
    private static final CRRConfig INSTANCE = new CRRConfig();
    private String[] crrSwitchArray = new String[8];
    private int maxObjectsEverySliceId;
    private long crrSlowObjectsMaxWaitClocks;
    private long crrTaskTimeout;
    private int crrCheckObjExistRetryTimes;
    private int crrHandleRetryTimes;
    private int crrUpdateObjExpWaitMs;
    private long crrUpdateObjExpMaxWaitMs;
    private boolean crrMockEnable;
    private int slowObjectsThreshold;
    private float slowObjectsRateInResult;
    private double crrQueueAvailablePercent;
    private int crrMergedLogObjectListersCount;
    private int crrMergedLogObjectListersQueueSize;
    private int crrListObjectByPrefixCount;
    private int crrListObjectByPrefixQueueSize;
    private int crrMergedLogDeletersCount;
    private int crrMergedLogDeletersQueueSize;
    private int crrWorkersQueueSize;
    private int crrWorkersBucketAttrQueueSize;
    private int crrMergedLogCacheSize;
    private int crrUnmergedLogCacheSize;
    private long crrWhiteListReloadPeriod;
    private long crrMergedLogScannerPeriod;
    private long crrUnmergedLogScannerPeriod;
    private long crrUnmergedBucketAttrScannerPeriod;
    private int sliceIdIntegerMultiple;
    private int sliceIdApplyOnetime;
    private double sliceIdApplyOnetimeMinimum;
    private int dangerRemainingAmount;
    private int crrPkWatcherThreadNum;
    private int crrPkWatcherSleepTime;
    private int crPkWatcherWarnLogInterval;
    private int mergedLogWatchPeriod;
    private int crrPrefixWatcherPeriod;
    private int crrDnsCacheWatcherPeriod;
    private int crrRegionInfoLoadPeriod;
    private boolean crrOverLoadSwitch;
    private int crrOverLoadPriority;
    private boolean crrUpdateCursorEnable;
    private boolean crrRegionHttps;
    private int crrRegionHttpsPort;
    private int crrRegionHttpPort;
    private int crrIPModeHttpsPort;
    private int crrIPModeHttpPort;
    private long innerExpTimeoutValue;
    private int crrComparatorThreadsNum;
    private int memExactlyExpireTime;
    private int memNotExactlyExpireTime;
    private boolean updateSlowObjects2LogEnable;
    private String crrDomainName;
    private int maxRequestPerObject;
    private boolean lowAbility;
    private boolean exeRepTask;
    private boolean clearStatistic;
    private int crrRegionCommunicationMode;
    private String crrRegionInfo;
    private String crrDnsServer;
    private String crrMockHost;
    private int crrRegionInfoMaxLine;
    private int crrPutMetaSeconds;
    private long statLockWaitTime;
    private boolean crrEnterprise;
    private long crrAssumeRoleFailCacheTime;
    private int assumeMaxNum;
    private long assumeMaxWait;
    private long cacheDeltaClockTime;
    private long adminAkSkSurviveTime;
    private int refreshAkSkTaskPeriod;
    private boolean crrKMSAssumeRole;
    private int crrRequestLimit = 600;
    private long crrBigObjectSize = 0x6400000L;
    private long crrMiddleObjectSize;
    private int crrUpdateLogCursorPeriod;
    private String repEndPoint;

    private CRRConfig() {
    }

    public static CRRConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        String tmpCrrSwitch = this.getConfig().getString("crr_switch", "00000111");
        this.crrSwitchArray = this.convertCrrSwitch2Array(tmpCrrSwitch);
        this.maxObjectsEverySliceId = this.getInt("max_objects_every_slice_id", 500);
        this.crrSlowObjectsMaxWaitClocks = this.getConfig().getLong("crr_slow_objects_max_wait_clocks", Long.MAX_VALUE);
        this.crrTaskTimeout = this.getConfig().getLong("crr_task_timeout", 43200000L);
        this.crrCheckObjExistRetryTimes = this.getInt("crr_check_obj_exist_retry_times", 10);
        this.crrHandleRetryTimes = this.getInt("crr_handle_retry_times", 3);
        this.crrUpdateObjExpWaitMs = this.getInt("crr_update_obj_exp_wait_ms", 1000);
        this.crrUpdateObjExpMaxWaitMs = this.getConfig().getLong("crr_update_obj_exp_max_wait_ms", 10000L);
        this.crrMockEnable = this.getConfig().getBoolean("crr_mock_enable", false);
        this.crrUpdateCursorEnable = this.getConfig().getBoolean("crr_update_cursor_enable", false);
        this.slowObjectsThreshold = this.getInt("crr_slow_objects_threshold", 80);
        this.slowObjectsRateInResult = this.getConfig().getFloat("slow_objects_rate_in_result", 0.95f);
        this.crrQueueAvailablePercent = this.getConfig().getDouble("crr_queue_available_percent", 0.7);
        this.crrMergedLogObjectListersCount = this.getInt("crr_merged_log_object_listers_count", 40);
        this.crrMergedLogObjectListersQueueSize = this.getInt("crr_merged_log_object_listers_queue_size", 10000);
        this.crrMergedLogDeletersCount = this.getInt("crr_merged_log_deleters_count", 30);
        this.crrMergedLogDeletersQueueSize = this.getInt("crr_merged_log_deleters_queue_size", 10000);
        this.crrWorkersQueueSize = this.getInt("crr_workers_queue_size", 10000);
        this.crrMergedLogCacheSize = this.getInt("crr_merged_log_cache_size", 1000);
        this.crrUnmergedLogCacheSize = this.getInt("crr_unmerged_log_cache_size", 100000);
        this.crrWhiteListReloadPeriod = this.getConfig().getLong("crr_whitelist_reload_period", 10L);
        this.crrMergedLogScannerPeriod = this.getConfig().getLong("crr_merged_log_scanner_period", 1L);
        this.crrUnmergedLogScannerPeriod = this.getConfig().getLong("crr_unmerged_log_scanner_period", 1L);
        this.crrUnmergedBucketAttrScannerPeriod = this.getConfig().getLong("crr_unmerged_bucketattr_scanner_period", 1L);
        this.sliceIdIntegerMultiple = this.getInt("slice_id_integer_multiple", 10000);
        this.sliceIdApplyOnetime = this.getInt("slice_id_apply_one_time", 100);
        this.sliceIdApplyOnetimeMinimum = Double.valueOf(this.getString("slice_id_apply_one_time_minimum", "0.8"));
        this.dangerRemainingAmount = this.getInt("danger_remaining_amount", 20);
        this.crrPkWatcherThreadNum = this.getInt("crr_pk_watcher_thread_num", 5);
        this.crrPkWatcherSleepTime = this.getInt("crr_pk_watcher_sleep_time", 100);
        this.crPkWatcherWarnLogInterval = this.getInt("crr_pk_watcher_warn_log_interval", 300);
        this.mergedLogWatchPeriod = this.getInt("crr_merged_log_cache_watcher_period", 500);
        this.crrPrefixWatcherPeriod = this.getInt("crr_prefix_watcher_period", 10);
        this.crrDnsCacheWatcherPeriod = this.getInt("crr_dns_cache_period", 15);
        this.crrRegionInfoLoadPeriod = this.getInt("crr_region_info_load_period", 10);
        this.crrOverLoadSwitch = this.getConfig().getBoolean("crr_overload_switch", false);
        this.crrOverLoadPriority = this.getInt("crr_overload_priority", 3);
        this.crrRegionHttps = this.getConfig().getBoolean("crr_region_https", true);
        this.crrRegionHttpsPort = this.getInt("crr_region_https_port", 5443);
        this.crrRegionHttpPort = this.getInt("crr_region_http_port", 5080);
        this.crrIPModeHttpsPort = this.getInt("crr_ip_mode_https_port", 443);
        this.crrIPModeHttpPort = this.getInt("crr_ip_mode_http_port", 80);
        this.innerExpTimeoutValue = this.getConfig().getLong("crr_inner_exp_timeout_value", 180000L);
        this.crrListObjectByPrefixCount = this.getInt("crr_list_object_by_prefix_count", 30);
        this.crrListObjectByPrefixQueueSize = this.getInt("crr_list_object_by_prefix_queue_size", 1000);
        this.updateSlowObjects2LogEnable = this.getConfig().getBoolean("crr_update_slow_objects_to_log", true);
        this.crrComparatorThreadsNum = this.getInt("crr_comparator_threads_num", 200);
        this.memExactlyExpireTime = this.getInt("crr_memcache_exactly_expiretime_minute", 1);
        this.memNotExactlyExpireTime = this.getInt("crr_memcache_not_exactly_expiretime_hours", 12);
        this.crrDomainName = this.getString("crr_domain_name", null);
        this.lowAbility = this.getConfig().getBoolean("crr_low_ability", true);
        this.exeRepTask = this.getConfig().getBoolean("crr_exe_rep_task", true);
        this.clearStatistic = this.getConfig().getBoolean("crr_clear_statistic", true);
        this.maxRequestPerObject = this.getInt("max_request_per_object", 5);
        this.crrRegionCommunicationMode = this.getInt("crr_region_communication_mode", 13);
        this.crrRegionInfo = this.getString("crr_region_info", null);
        this.repEndPoint = this.getString("osc_replication_node_ip", null);
        this.crrDnsServer = this.getString("crr_dns_server", null);
        this.crrMockHost = this.getString("crr_mock_host", null);
        this.crrRegionInfoMaxLine = this.getInt("crr_region_info_max_line", 10000);
        this.crrPutMetaSeconds = this.getInt("crr_put_meta_seconds", 180);
        this.statLockWaitTime = this.getConfig().getLong("crr_stat_wait_lock_time", 10L);
        this.crrEnterprise = this.getConfig().getBoolean("crr_enterprise", false);
        this.crrAssumeRoleFailCacheTime = this.getConfig().getLong("crr_assume_fail_cache_time", 900000L);
        this.assumeMaxNum = this.getConfig().getInt("crr_assume_max_num", 50);
        this.assumeMaxWait = this.getConfig().getLong("crr_assume_max_wait", 600000L);
        this.cacheDeltaClockTime = this.getConfig().getLong("crr_cache_delta_clock_time", 10800000L);
        this.adminAkSkSurviveTime = this.getConfig().getLong("admin_aksk_survive_time", 21600000L);
        this.refreshAkSkTaskPeriod = this.getConfig().getInt("refresh_admin_aksk_task_period", 5);
        this.crrKMSAssumeRole = this.getConfig().getBoolean("crr_kms_assume_role", Boolean.TRUE);
        this.crrRequestLimit = this.getConfig().getInt("crr_request_limit", 600);
        this.crrBigObjectSize = this.getConfig().getLong("crr_big_object_size", 0x6400000L);
        this.crrMiddleObjectSize = this.getConfig().getLong("crr_middle_object_size", 0xA00000L);
        this.crrUpdateLogCursorPeriod = this.getConfig().getInt("crr_log_cursor_update_period", 5);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public boolean isCrrEnterprise() {
        return this.crrEnterprise || KVConfig.INSTANCE.getBoolValue("crr_enterprise", false);
    }

    public boolean isCrrPermissionRetry() {
        return KVConfig.INSTANCE.getBoolValue("crr_permission_retry", true);
    }

    public boolean isCrrStatStoreInKV() {
        return KVConfig.INSTANCE.getBoolValue("crr_stat_store_in_kv", true);
    }

    public int getCrrComparatorThreadsNum() {
        if (this.crrComparatorThreadsNum <= 0) {
            logger.debug("crrComparatorThreadsNum is little or equal than zero.");
            this.crrComparatorThreadsNum = 200;
        }
        return this.crrComparatorThreadsNum;
    }

    public int getMaxObjectsEverySliceId() {
        if (this.maxObjectsEverySliceId <= 0) {
            logger.debug("maxObjectsEverySliceId is little or equal than zero.");
            this.maxObjectsEverySliceId = 500;
        }
        return this.maxObjectsEverySliceId;
    }

    public long getCrrSlowObjectsMaxWaitClocks() {
        if (this.crrSlowObjectsMaxWaitClocks <= 0L) {
            logger.debug("crrSlowObjectsMaxWaitClocks is little or equal than zero.");
            this.crrSlowObjectsMaxWaitClocks = Long.MAX_VALUE;
        }
        return this.crrSlowObjectsMaxWaitClocks;
    }

    public long getCrrTaskTimeout() {
        if (this.crrTaskTimeout <= 0L) {
            logger.debug("crrTaskTimeout is little or equal than zero.");
            this.crrTaskTimeout = 43200000L;
        }
        return this.crrTaskTimeout;
    }

    public int getCrrCheckObjExistRetryTimes() {
        if (this.crrCheckObjExistRetryTimes <= 0) {
            logger.debug("crrCheckObjExistRetryTimes is little or equal than zero.");
            this.crrCheckObjExistRetryTimes = 10;
        }
        return this.crrCheckObjExistRetryTimes;
    }

    public int getCrrHandleRetryTimes() {
        if (this.crrHandleRetryTimes <= 0) {
            logger.debug("crrHandleRetryTimes is little or equal than zero.");
            this.crrHandleRetryTimes = 3;
        }
        return this.crrHandleRetryTimes;
    }

    public int getCrrUpdateObjExpWaitMs() {
        if (this.crrUpdateObjExpWaitMs < 0) {
            logger.debug("crrUpdateObjExpWaitMs is little than zero.");
            this.crrUpdateObjExpWaitMs = 1000;
        }
        return this.crrUpdateObjExpWaitMs;
    }

    public long getCrrUpdateObjExpMaxWaitMs() {
        if (this.crrUpdateObjExpMaxWaitMs < 0L) {
            logger.debug("crrUpdateObjExpMaxWaitMs is little than zero.");
            this.crrUpdateObjExpMaxWaitMs = 10000L;
        }
        return this.crrUpdateObjExpMaxWaitMs;
    }

    public boolean isCrrMockEnable() {
        return this.crrMockEnable;
    }

    public boolean isCrrUpdateCursorEnable() {
        return this.crrUpdateCursorEnable;
    }

    public int getSlowObjectsThreshold() {
        if (this.slowObjectsThreshold <= 0) {
            logger.debug("slowObjectsThreshold is little  or equal than zero.");
            this.slowObjectsThreshold = 80;
        }
        return this.slowObjectsThreshold;
    }

    public float getSlowObjectsRateInResult() {
        if (this.slowObjectsRateInResult <= 0.0f) {
            logger.debug("slowObjectsRateInResult is little or equal than zero.");
            this.slowObjectsRateInResult = 0.95f;
        }
        return this.slowObjectsRateInResult;
    }

    public double getCrrQueueAvailablePercent() {
        if (this.crrQueueAvailablePercent <= 0.0) {
            logger.debug("crrQueueAvailablePercent is little  or equal than zero.");
            this.crrQueueAvailablePercent = 0.7;
        }
        return this.crrQueueAvailablePercent;
    }

    public int getCrrMergedLogObjectListersCount() {
        if (this.crrMergedLogObjectListersCount <= 0) {
            logger.debug("crrMergedLogObjectListersCount is little  or equal than zero.");
            this.crrMergedLogObjectListersCount = 40;
        }
        return this.crrMergedLogObjectListersCount;
    }

    public int getCrrListersQueueSize() {
        if (this.crrMergedLogObjectListersQueueSize <= 0) {
            logger.debug("crrMergedLogObjectListersQueueSize is little  or equal than zero.");
            this.crrMergedLogObjectListersQueueSize = 10000;
        }
        return this.crrMergedLogObjectListersQueueSize;
    }

    public int getListObjectByPrefixCount() {
        if (this.crrListObjectByPrefixCount <= 0) {
            logger.debug("crrListObjectByPrefixCount is little  or equal than zero.");
            this.crrListObjectByPrefixCount = 30;
        }
        return this.crrListObjectByPrefixCount;
    }

    public int getListObjectByPrefixQueueSize() {
        if (this.crrListObjectByPrefixQueueSize <= 0) {
            logger.debug("crrListObjectByPrefixQueueSize is little  or equal than zero.");
            this.crrListObjectByPrefixQueueSize = 1000;
        }
        return this.crrListObjectByPrefixQueueSize;
    }

    public int getCrrMergedLogDeletersCount() {
        if (this.crrMergedLogDeletersCount <= 0) {
            logger.debug("crrMergedLogDeletersCount is little  or equal than zero.");
            this.crrMergedLogDeletersCount = 30;
        }
        return this.crrMergedLogDeletersCount;
    }

    public int getCrrMergedLogDeletersQueueSize() {
        if (this.crrMergedLogDeletersQueueSize <= 0) {
            logger.debug("crrMergedLogDeletersQueueSize is little  or equal than zero.");
            this.crrMergedLogDeletersQueueSize = 10000;
        }
        return this.crrMergedLogDeletersQueueSize;
    }

    public int getCrrWorkersForSmallObject() {
        int crrWorkersCount = KVConfig.INSTANCE.getIntValue("crr_workers_count", 250);
        logger.debug("crrWorkersCount {}.", (Object)crrWorkersCount);
        if (crrWorkersCount <= 0) {
            logger.debug("crrWorkersCount is little  or equal than zero.");
            crrWorkersCount = 250;
        }
        return crrWorkersCount;
    }

    public int getCrrWorkersForMiddleObject() {
        int crrWorkersMidObjectCount = KVConfig.INSTANCE.getIntValue("crr_workers_middle_object_count", 80);
        logger.debug("crr middle workers count {}.", (Object)crrWorkersMidObjectCount);
        if (crrWorkersMidObjectCount <= 0) {
            logger.debug("crrWorkersCount is little  or equal than zero.");
            crrWorkersMidObjectCount = 80;
        }
        return crrWorkersMidObjectCount;
    }

    public int getCrrWorkersBucketAttrCount() {
        int crrWorkersBucketAttrCount = KVConfig.INSTANCE.getIntValue("crr_workers_bucket_attr_count", 10);
        if (crrWorkersBucketAttrCount <= 0) {
            logger.debug("crrWorkersBucketAttrCount is little or equal than zero.");
            crrWorkersBucketAttrCount = 10;
        }
        return crrWorkersBucketAttrCount;
    }

    public int getCrrWorkersBigObjectCount() {
        int crrWorkersBigObjectCount = KVConfig.INSTANCE.getIntValue("crr_workers_big_object_count", 40);
        if (crrWorkersBigObjectCount <= 0) {
            logger.debug("crrWorkersBigObjectCount is little or equal than zero.");
            crrWorkersBigObjectCount = 40;
        }
        return crrWorkersBigObjectCount;
    }

    public int getCrrWorkersQueueSize() {
        if (this.crrWorkersQueueSize <= 0) {
            logger.debug("crrWorkersQueueSize is little or equal than zero.");
            this.crrWorkersQueueSize = 10000;
        }
        return this.crrWorkersQueueSize;
    }

    public int getCRRWorkersBucketAttrQueueSize() {
        if (this.crrWorkersBucketAttrQueueSize <= 0) {
            logger.debug("crrWorkersQueueSize is little or equal than zero.");
            this.crrWorkersBucketAttrQueueSize = 1000;
        }
        return this.crrWorkersBucketAttrQueueSize;
    }

    public int getCrrWokersMultiPartCount() {
        int crrReplicateMultiPartCount = KVConfig.INSTANCE.getIntValue("crr_replicate_multipart_count", 40);
        if (crrReplicateMultiPartCount <= 0) {
            logger.debug("crrReplicateMultiPartCount is little  or equal than zero.");
            crrReplicateMultiPartCount = 40;
        }
        return crrReplicateMultiPartCount;
    }

    public int getCrrMergedLogCacheSize() {
        if (this.crrMergedLogCacheSize <= 0) {
            this.crrMergedLogCacheSize = 1000;
        }
        return this.crrMergedLogCacheSize;
    }

    public int getCrrUnmergedLogCacheSize() {
        if (this.crrUnmergedLogCacheSize <= 0) {
            this.crrUnmergedLogCacheSize = 100000;
        }
        return this.crrUnmergedLogCacheSize;
    }

    public long getCrrWhiteListReloadPeriod() {
        if (this.crrWhiteListReloadPeriod <= 0L) {
            logger.debug("crrWhiteListReloadPeriod is little or equal than zero.");
            this.crrWhiteListReloadPeriod = 10L;
        }
        return this.crrWhiteListReloadPeriod;
    }

    public long getCrrMergedLogScannerPeriod() {
        if (this.crrMergedLogScannerPeriod <= 0L) {
            this.crrMergedLogScannerPeriod = 1L;
        }
        return this.crrMergedLogScannerPeriod;
    }

    public long getCrrUnmergedLogScannerPeriod() {
        if (this.crrUnmergedLogScannerPeriod <= 0L) {
            this.crrUnmergedLogScannerPeriod = 1L;
        }
        return this.crrUnmergedLogScannerPeriod;
    }

    public long getCrrUnmergedBucketAttrScannerPeriod() {
        if (this.crrUnmergedBucketAttrScannerPeriod <= 0L) {
            this.crrUnmergedBucketAttrScannerPeriod = 1L;
        }
        return this.crrUnmergedBucketAttrScannerPeriod;
    }

    public int getSliceIdIntegerMultiple() {
        if (this.sliceIdIntegerMultiple <= 0) {
            this.sliceIdIntegerMultiple = 10000;
        }
        return this.sliceIdIntegerMultiple;
    }

    public int getSliceIdApplyOnetime() {
        if (this.sliceIdApplyOnetime <= 0) {
            this.sliceIdApplyOnetime = 100;
        }
        return this.sliceIdApplyOnetime;
    }

    public double getSliceIdApplyOnetimeMinimum() {
        if (this.sliceIdApplyOnetimeMinimum <= 0.0) {
            this.sliceIdApplyOnetimeMinimum = Double.valueOf("0.8");
        }
        return this.sliceIdApplyOnetimeMinimum;
    }

    public int getDangerRemainingAmount() {
        if (this.dangerRemainingAmount <= 0) {
            this.dangerRemainingAmount = 20;
        }
        return this.dangerRemainingAmount;
    }

    public int getCrrPkWatcherThreadNum() {
        if (this.crrPkWatcherThreadNum <= 0) {
            this.crrPkWatcherThreadNum = 5;
        }
        return this.crrPkWatcherThreadNum;
    }

    public int getCrrPkWatcherSleepTime() {
        if (this.crrPkWatcherSleepTime <= 0) {
            this.crrPkWatcherSleepTime = 100;
        }
        return this.crrPkWatcherSleepTime;
    }

    public int getCrPkWatcherWarnLogInterval() {
        if (this.crPkWatcherWarnLogInterval <= 0) {
            this.crPkWatcherWarnLogInterval = 300;
        }
        return this.crPkWatcherWarnLogInterval;
    }

    public int getMergedLogWatchPeriod() {
        if (this.mergedLogWatchPeriod <= 0) {
            this.mergedLogWatchPeriod = 500;
        }
        return this.mergedLogWatchPeriod;
    }

    public int getCrrPrefixWatcherPeriod() {
        if (this.crrPrefixWatcherPeriod <= 0) {
            this.crrPrefixWatcherPeriod = 10;
        }
        return this.crrPrefixWatcherPeriod;
    }

    public boolean isCrrOverLoadSwitch() {
        return this.crrOverLoadSwitch;
    }

    public int getCrrOverLoadPriority() {
        if (this.crrOverLoadPriority < 0) {
            this.crrOverLoadPriority = 3;
        }
        return this.crrOverLoadPriority;
    }

    public boolean isCrrRegionHttps() {
        return this.crrRegionHttps;
    }

    public int getCrrRegionHttpsPort() {
        return this.crrRegionHttpsPort;
    }

    public int getCrrRegionHttpPort() {
        return this.crrRegionHttpPort;
    }

    public int getCrrIPModeHttpsPort() {
        return this.crrIPModeHttpsPort;
    }

    public int getCrrIPModeHttpPort() {
        return this.crrIPModeHttpPort;
    }

    public long getInnerExpTimeoutValue() {
        return this.innerExpTimeoutValue;
    }

    public int getRemainObjExactlyExpireTime() {
        if (this.memExactlyExpireTime <= 0) {
            logger.debug("crrComparatorThreadsNum is little or equal than zero.");
            this.memExactlyExpireTime = 1;
        }
        return this.memExactlyExpireTime;
    }

    public int getRemainObjNotExactlyExpireTime() {
        if (this.memNotExactlyExpireTime <= 0) {
            logger.debug("crrComparatorThreadsNum is little or equal than zero.");
            this.memNotExactlyExpireTime = 12;
        }
        return this.memNotExactlyExpireTime;
    }

    public boolean isUpdateSlowObjects2LogEnable() {
        return this.updateSlowObjects2LogEnable;
    }

    public String getCrrDomainName() {
        return this.crrDomainName;
    }

    public boolean isLowAbility() {
        return this.lowAbility;
    }

    public boolean isReplicationEnabled() {
        return StringUtils.equals((CharSequence)"1", (CharSequence)this.crrSwitchArray[7]);
    }

    public boolean isCrrBillEnable() {
        if (OBSConfig.getInstance().isEnterpriseMode() && !OBSConfig.getInstance().getSysBillingOpen()) {
            return false;
        }
        return StringUtils.equals((CharSequence)"1", (CharSequence)this.crrSwitchArray[4]);
    }

    private String[] convertCrrSwitch2Array(String format) {
        if (format.length() != 8) {
            return this.convertString2Array("00000111");
        }
        return this.convertString2Array(format);
    }

    private String[] convertString2Array(String srcString) {
        String[] formatArray = new String[srcString.length()];
        for (int i = 0; i < srcString.length(); ++i) {
            formatArray[i] = srcString.charAt(i) + "";
        }
        return formatArray;
    }

    public int getMaxRequestPerObject() {
        return this.maxRequestPerObject;
    }

    public void setRepEndPoint(PropertiesConfiguration config, String repEndPoint) {
        config.setProperty("osc_replication_node_ip", (Object)repEndPoint);
        this.repEndPoint = repEndPoint;
    }

    public String getRepEndPoint() {
        return this.repEndPoint;
    }

    public boolean isExeRepTask() {
        return this.exeRepTask;
    }

    public boolean isClearStatistic() {
        return this.clearStatistic;
    }

    public int getCrrRegionCommunicationMode() {
        return this.crrRegionCommunicationMode;
    }

    public String getCrrRegionInfo() {
        return this.crrRegionInfo;
    }

    public int getCrrDnsCacheWatcherPeriod() {
        return this.crrDnsCacheWatcherPeriod;
    }

    public String getCrrDnsServer() {
        return this.crrDnsServer;
    }

    public int getCrrRegionInfoLoadPeriod() {
        return this.crrRegionInfoLoadPeriod;
    }

    public String getCrrMockHost() {
        return this.crrMockHost;
    }

    public int getCrrRegionInfoMaxLine() {
        return this.crrRegionInfoMaxLine;
    }

    public int getCrrPutMetaSeconds() {
        return this.crrPutMetaSeconds;
    }

    public long getStatLockWaitTime() {
        return this.statLockWaitTime;
    }

    public long getCrrAssumeRoleFailCacheTime() {
        return this.crrAssumeRoleFailCacheTime;
    }

    public int getAssumeMaxNum() {
        return this.assumeMaxNum;
    }

    public long getAssumeMaxWait() {
        return this.assumeMaxWait;
    }

    public long getCacheDeltaClockTime() {
        return this.cacheDeltaClockTime;
    }

    public long getAdminAkSkSurviveTime() {
        return this.adminAkSkSurviveTime;
    }

    public int getRefreshAkSkTaskPeriod() {
        return this.refreshAkSkTaskPeriod;
    }

    public boolean isCrrKMSAssumeRole() {
        return this.crrKMSAssumeRole;
    }

    public int getCRRRequestLimit() {
        return this.crrRequestLimit;
    }

    public long getCrrBigObjectSize() {
        return this.crrBigObjectSize;
    }

    public long getCrrMiddleObjectSize() {
        return this.crrMiddleObjectSize;
    }

    public boolean getUseRepEndPoint() {
        String crrUseRepEndPoint = KVConfig.INSTANCE.getStringValue("crr_use_rep_end_point", "true");
        return "true".equalsIgnoreCase(crrUseRepEndPoint);
    }

    public int getCrrUpdateLogCursorPeriod() {
        if (this.crrUpdateLogCursorPeriod <= 0) {
            this.crrUpdateLogCursorPeriod = 5;
        }
        return this.crrUpdateLogCursorPeriod;
    }
}

