/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.dcm;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class DCMConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DCMConfig.class);
    private static final DCMConfig INSTANCE = new DCMConfig();
    private int httpServicePort = 5079;
    private int httpsServicePort = 5442;
    private int failedTimesLimit = 3;
    private TimeUnit delayTime;
    private long delayValue = 10L;
    private int syncRegionPeriodsTime = 10;
    private TimeUnit syncRegionPeriodsUnit;
    private int gmdcExpires = 43200;
    private int newDCExpires = 216000;
    private List<String> validConfigNames;
    private long timeDiff = 600000L;
    private Map<String, String> transferSupports = new HashMap<String, String>();

    private DCMConfig() {
        this.delayTime = TimeUnit.valueOf("MINUTES");
        this.validConfigNames = new LinkedList<String>();
    }

    public static DCMConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        if (configBuilder == null) {
            throw new ConfigurationException("input config is null");
        }
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        LOGGER.debug("begin to load configure for DCM.");
        this.loadConfig();
    }

    private void loadConfig() throws ConfigurationException {
        if (this.getConfig() == null) {
            return;
        }
        this.httpServicePort = this.getConfig().getInt("dcm.http.service.port", 5079);
        this.httpsServicePort = this.getConfig().getInt("dcm.https.service.port", 5442);
        this.failedTimesLimit = this.getConfig().getInt("dcm.failed.times.limit", 3);
        String timeUnitString = this.getConfig().getString("dcm.message.time.unit", "MINUTES");
        try {
            this.delayTime = TimeUnit.valueOf(timeUnitString);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("invalid configure value for time unit[{}]", (Object)timeUnitString);
            this.delayTime = TimeUnit.valueOf("MINUTES");
        }
        this.delayValue = this.getConfig().getLong("dcm.message.time.value", 10L);
        this.syncRegionPeriodsTime = this.getConfig().getInt("dcm.sync.region.periods.time", 10);
        String sycRegionTimeUnit = this.getConfig().getString("dcm.sync.region.periods.unit", "MINUTES");
        this.gmdcExpires = this.getConfig().getInt("gmdc_certificate_expires", 216000);
        this.newDCExpires = this.getConfig().getInt("new_dc_certificate_expires", 43200);
        this.timeDiff = this.getConfig().getLong("dcm.sys.time.diff", 600000L);
        try {
            this.syncRegionPeriodsUnit = TimeUnit.valueOf(sycRegionTimeUnit);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("invalid configure value for time unit[{}]", (Object)sycRegionTimeUnit);
            this.syncRegionPeriodsUnit = TimeUnit.valueOf("MINUTES");
        }
        this.parseValidConfigNames(this.getConfig().getString("mdc_config_names", "region-mdc-policy-switch,upgrade-mark,frozen-mark,data_flow_control_level"));
        this.loadTransferSupports(this.getConfig());
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            try {
                this.loadConfig();
            }
            catch (ConfigurationException e) {
                LOGGER.warn("Refresh file[{}] failed.", (Object)this.getConfigBuilder().getFileHandler().getFileName());
            }
        }
    }

    private void parseValidConfigNames(String value) {
        String[] names;
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        for (String name : names = StringUtils.split((String)value, (char)',')) {
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            this.validConfigNames.add(StringUtils.trim((String)name));
        }
    }

    private void loadTransferSupports(PropertiesConfiguration config) throws ConfigurationException {
        try {
            Properties transferSupportTypes = config.getProperties("dcm_transfer_support_service_types");
            for (Map.Entry<Object, Object> entry : transferSupportTypes.entrySet()) {
                this.transferSupports.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (RuntimeException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public int getHttpServicePort() {
        return this.httpServicePort;
    }

    public void setHttpServicePort(int httpServicePort) {
        this.httpServicePort = httpServicePort;
    }

    public int getHttpsServicePort() {
        return this.httpsServicePort;
    }

    public void setHttpsServicePort(int httpsServicePort) {
        this.httpsServicePort = httpsServicePort;
    }

    public int getFailedTimesLimit() {
        return this.failedTimesLimit;
    }

    public void setFailedTimesLimit(int failedTimesLimit) {
        this.failedTimesLimit = failedTimesLimit;
    }

    public TimeUnit getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(TimeUnit delayTime) {
        this.delayTime = delayTime;
    }

    public long getDelayValue() {
        return this.delayValue;
    }

    public void setDelayValue(long delayValue) {
        this.delayValue = delayValue;
    }

    public void setSyncRegionPeriodsTime(int syncRegionPeriodsTime) {
        this.syncRegionPeriodsTime = syncRegionPeriodsTime;
    }

    public int getSyncRegionPeriodsTime() {
        return this.syncRegionPeriodsTime;
    }

    public void setSyncRegionPeriodsUnit(TimeUnit syncRegionPeriodsUnit) {
        this.syncRegionPeriodsUnit = syncRegionPeriodsUnit;
    }

    public TimeUnit getSyncRegionPeriodsUnit() {
        return this.syncRegionPeriodsUnit;
    }

    public int getGmdcExpires() {
        return this.gmdcExpires;
    }

    public void setGmdcExpires(int gmdcExpires) {
        this.gmdcExpires = gmdcExpires;
    }

    public int getNewDCExpires() {
        return this.newDCExpires;
    }

    public void setNewDCExpires(int newDCExpires) {
        this.newDCExpires = newDCExpires;
    }

    public List<String> getValidConfigNames() {
        return this.validConfigNames;
    }

    public void setValidConfigNames(List<String> validConfigNames) {
        this.validConfigNames = validConfigNames;
    }

    public long getTimeDiff() {
        return this.timeDiff;
    }

    public void setTimeDiff(long timeDiff) {
        this.timeDiff = timeDiff;
    }

    public Map<String, String> getTransferSupports() {
        return Collections.unmodifiableMap(this.transferSupports);
    }

    public void setTransferSupports(Map<String, String> transferSupports) {
        this.transferSupports = transferSupports;
    }
}

