/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.hotconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.hotconfig.HotConfException;

public abstract class ConfComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfComponent.class);
    private String componentName = null;
    private long lastmodify = 0L;

    public abstract void load() throws HotConfException;

    public abstract void init() throws HotConfException;

    public String name() {
        return this.componentName;
    }

    protected void setName(String inputName) {
        this.componentName = inputName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isModified(String file) {
        if (file == null) {
            return false;
        }
        File tmp = null;
        try {
            tmp = new File(file);
            if (tmp == null || !tmp.exists()) {
                boolean bl = false;
                return bl;
            }
            long time = tmp.lastModified();
            if (time != this.lastmodify) {
                this.lastmodify = time;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            tmp = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties readPropertyFile(String propertiesFile) {
        LOGGER.debug("Enter load[{}] in ConfComponent class.", (Object)propertiesFile);
        FileInputStream inputStream = null;
        Properties property = new Properties();
        inputStream = new FileInputStream(new File(propertiesFile));
        property.load(inputStream);
        if (null == inputStream) return property;
        try {
            inputStream.close();
            return property;
        }
        catch (IOException ioe) {
            LOGGER.error(String.format(Locale.ENGLISH, "Close file exception. file=[%s]", propertiesFile), (Throwable)ioe);
        }
        return property;
        catch (FileNotFoundException e) {
            LOGGER.error("error: file not found.");
            if (null == inputStream) return property;
            try {
                inputStream.close();
                return property;
            }
            catch (IOException ioe) {
                LOGGER.error(String.format(Locale.ENGLISH, "Close file exception. file=[%s]", propertiesFile), (Throwable)ioe);
            }
            return property;
        }
        catch (IOException e2) {
            LOGGER.error("error: file io exception:", (Throwable)e2);
            if (null == inputStream) return property;
            {
                catch (Throwable throwable) {
                    if (null == inputStream) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LOGGER.error(String.format(Locale.ENGLISH, "Close file exception. file=[%s]", propertiesFile), (Throwable)ioe);
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return property;
            }
            catch (IOException ioe) {
                LOGGER.error(String.format(Locale.ENGLISH, "Close file exception. file=[%s]", propertiesFile), (Throwable)ioe);
            }
            return property;
        }
    }
}

