/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.hws;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;

public class HWSConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HWSConfig.class);

    public synchronized void loadConfigFile(String fileName) {
        if (this.getConfigBuilder() == null) {
            PropertiesConfigBuilder configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(fileName, null);
            this.setConfigBuilder(configBuilder);
            configBuilder.registerForReloading(this);
        } else {
            LOGGER.warn("Config file[{}] is already loaded", (Object)fileName);
        }
    }

    public long getRevokeListMaxSize() {
        if (this.getConfigBuilder() == null) {
            return 0xA00000L;
        }
        String peroid = this.getConfig().getString("ks_revokelist_max_size");
        if (StringUtils.isBlank((CharSequence)peroid)) {
            return 0xA00000L;
        }
        return NumberUtils.toLong((String)peroid, (long)0xA00000L);
    }

    public long getKSUserCacheTime() {
        if (this.getConfig() == null) {
            return 86400000L;
        }
        String peroid = this.getConfig().getString("ks_user_cache_time");
        if (StringUtils.isBlank((CharSequence)peroid)) {
            return 86400000L;
        }
        return NumberUtils.toLong((String)peroid, (long)86400000L);
    }

    public long getKSRevokeListPeriod() {
        if (this.getConfig() == null) {
            return 60000L;
        }
        String peroid = this.getConfig().getString("ks_revokelist_peroid");
        if (StringUtils.isBlank((CharSequence)peroid)) {
            return 60000L;
        }
        return NumberUtils.toLong((String)peroid, (long)60000L);
    }

    public long getKSCacheValidTimeWhenGetRevokeFailed() {
        if (this.getConfig() == null) {
            return 86400000L;
        }
        String peroid = this.getConfig().getString("ks_valid_time_of_failed_get_revokelist");
        if (StringUtils.isBlank((CharSequence)peroid)) {
            return 86400000L;
        }
        return NumberUtils.toLong((String)peroid, (long)86400000L);
    }

    public long getKSAccountExpireTime() {
        if (this.getConfig() == null) {
            return 86400000L;
        }
        String dataExpire = this.getConfig().getString("ks_account_memcache_timeout");
        if (StringUtils.isBlank((CharSequence)dataExpire)) {
            return 86400000L;
        }
        return NumberUtils.toLong((String)dataExpire, (long)86400000L);
    }

    @Override
    public void reloadConfig() {
    }
}

