/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.index;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;

public enum KVConfig {
    INSTANCE;

    private static final Logger LOGGER;
    private Map<String, String> kvMap = new ConcurrentHashMap<String, String>();
    public static final String CLI_PREFIX = "cli_";
    public static final String VERSION_ID_UPGRADE = "version_id_upgrade";
    public static final String STS_DOMAIN_ID = "sts_domain_id";
    public static final String BILL_IS_JUDGE_FEDERAL_TYPE = "billing_is_judge_federal_type";
    public static final String FEDERAL_TYPE_WHITELIST = "federal_type_whitelist";
    public static final String GCFASTBUCKET_PREFIX = "GCFastBucket_";
    public static final String META_RESCUE = "meta_rescue_";
    public static final String GC_STATISICS_PREFIX = "gc_statisics_task_";
    public static final String OSC_CPU_USAGE_PREFIX = "osc_cpu_usage_";
    public static final String OSC_OPERATE_COUNT_PREFIX = "osc_plog_operate_count_";
    public static final String QUOTA_CHECK = "quota_";
    public static final String FS_REFACTORING_PREFIX = "fs_refactor_";
    public static final String PLOG_DEL_KEY_TASK_PREFIX = "pl_del_key_task_";
    public static final String SYN_ATTR_TASK_PREFIX = "syn_attr_task_";
    public static final String POE_RPO = "poe_rpo";
    public static final String LS_RPO = "ls_rpo";

    public String getValue(String key) {
        return this.kvMap.get(key);
    }

    public String getStringValue(String key, String defaultValue) {
        return this.kvMap.getOrDefault(key, defaultValue);
    }

    public int getIntValue(String key, int defaultValue) {
        String value = this.kvMap.getOrDefault(key, String.valueOf(defaultValue));
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOGGER.debug("error", (Throwable)e);
            return defaultValue;
        }
    }

    public float getFloatValue(String key, float defaultValue) {
        String value = this.kvMap.getOrDefault(key, String.valueOf(defaultValue));
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            LOGGER.debug("error", (Throwable)e);
            return defaultValue;
        }
    }

    public boolean getBoolValue(String key, boolean defaultValue) {
        String value = this.kvMap.getOrDefault(key, String.valueOf(defaultValue));
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            LOGGER.debug("error", (Throwable)e);
            return defaultValue;
        }
    }

    public long getLongValue(String key, long defaultValue) {
        if (this.kvMap.get(key) != null) {
            try {
                return Long.parseLong(this.kvMap.get(key));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("error", (Throwable)e);
            }
        }
        return defaultValue;
    }

    public Map<String, String> getKvMap() {
        return this.kvMap;
    }

    public Map<String, String> getMapByPrefix(String prefix) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (this.kvMap.isEmpty()) {
            return map;
        }
        for (Map.Entry<String, String> entry : this.kvMap.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getKey()) || StringUtils.isEmpty((CharSequence)entry.getValue()) || !StringUtils.startsWith((CharSequence)entry.getKey(), (CharSequence)prefix)) continue;
            map.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return map;
    }

    public void putValue(String key, String value) {
        this.kvMap.put(key, value);
    }

    public boolean isVersionIdUpgrade() {
        return this.getBoolValue(VERSION_ID_UPGRADE, true) || OBSConfig.getInstance().isEnterpriseVersionIdUpgrade();
    }

    static {
        LOGGER = LoggerFactory.getLogger(KVConfig.class);
    }
}

