/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.ReloadableConfig;

public abstract class AbstractConfigPraser
implements ReloadableConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigPraser.class);
    private PropertiesConfigBuilder configBuilder = null;

    public AbstractConfigPraser(PropertiesConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
    }

    public AbstractConfigPraser() {
    }

    public PropertiesConfiguration getConfig() {
        if (this.configBuilder == null) {
            try {
                String res = null;
                return new Configurations().properties(res);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Fatal error: No configBuilder found.");
            }
        }
        return this.configBuilder.getConfiguration();
    }

    public void setConfigBuilder(PropertiesConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
    }

    public PropertiesConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    public String getString(String key) {
        if (key == null) {
            return null;
        }
        return this.getConfig().getString(key);
    }

    public String getString(String key, String defaultValue) {
        if (key == null) {
            return null;
        }
        return this.getConfig().getString(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.getConfig().getInt(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getConfig().getBoolean(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.getConfig().getLong(key, defaultValue);
    }
}

