/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReloadHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReloadHandler.class);
    private static final int DEFAULT_NOTIFY_TIMES = 1;
    private String filename;
    private long lastModefiedTime;
    private int notifycount;

    public AbstractReloadHandler(String file) {
        this(file, System.currentTimeMillis());
    }

    public AbstractReloadHandler(String file, long lastModefiedTime) {
        this.filename = file;
        this.lastModefiedTime = lastModefiedTime;
    }

    public abstract void handle();

    public String getFilename() {
        return this.filename;
    }

    public int needNotifyCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileModified() {
        if (this.filename == null) {
            logger.info("File name is null.");
            return false;
        }
        File tmp = null;
        try {
            tmp = new File(this.filename);
            if (tmp == null || !tmp.exists()) {
                logger.warn("File[{}] not exist, not notified.", (Object)this.filename);
                boolean bl = false;
                return bl;
            }
            if (tmp.length() == 0L) {
                logger.info("File:[{}] length is 0, not notified.", (Object)this.filename);
                boolean bl = false;
                return bl;
            }
            long time = tmp.lastModified();
            logger.debug("Record last modify time:[{}], file last modify time:[{}]", (Object)this.lastModefiedTime, (Object)time);
            if (time != this.lastModefiedTime) {
                this.lastModefiedTime = time;
                this.notifycount = 1;
                logger.debug("Need notify[{}], count={}, handler={}, ModefiedTime", new Object[]{this.getFilename(), this.notifycount, this.getClass().getCanonicalName()});
                boolean bl = true;
                return bl;
            }
            if (this.notifycount < this.needNotifyCount()) {
                ++this.notifycount;
                logger.debug("Need notify[{}], count={}, handler={}", new Object[]{this.getFilename(), this.notifycount, this.getClass().getCanonicalName()});
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn("Judge file changed failed." + this.filename, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tmp = null;
        }
        return false;
    }
}

