/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.ConfigLoadPredicate;
import uds.common.config.interf.ReloadableConfig;
import uds.common.config.interf.ReloadableNotify;

public class ConfigCreateEventListener
implements EventListener<ConfigurationBuilderResultCreatedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCreateEventListener.class);
    private final ReloadingFileBasedConfigurationBuilder<FileBasedConfiguration> configBuilder = null;
    private final Set<ReloadableConfig> configSet = new HashSet<ReloadableConfig>();
    private final Set<ReloadableNotify> notifySet = new HashSet<ReloadableNotify>();
    private final AtomicInteger modifierCounter = new AtomicInteger(0);
    private ConfigLoadPredicate configLoadPredicate = ConfigLoadPredicate.DEFAULT;

    public void onEvent(ConfigurationBuilderResultCreatedEvent event) {
        try {
            while (this.modifierCounter.get() > 0) {
                LOGGER.info("Waiting for config-adding operation to be finished");
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    LOGGER.info(e.getLocalizedMessage());
                }
            }
            if (!this.configLoadPredicate.loadNow()) {
                return;
            }
            if (event != null && ConfigurationBuilderResultCreatedEvent.RESULT_CREATED.getName().equals(event.getEventType().getName())) {
                this.refreshConfig();
                for (ReloadableNotify notify : this.notifySet) {
                    notify.execute();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Got error when refresh config.", (Throwable)exception);
        }
    }

    private void refreshConfig() {
        for (ReloadableConfig config : this.configSet) {
            try {
                LOGGER.warn("Start to reload config:[{}]", (Object)config.getClass().getName());
                config.reloadConfig();
                LOGGER.warn("Success to reload config:[{}]", (Object)config.getClass().getName());
            }
            catch (Exception ex) {
                LOGGER.warn(String.format(Locale.ENGLISH, "Failed to reload configuration [%1$s] due to error [%2$s]", config.getClass().getSimpleName(), ex.getLocalizedMessage()));
            }
        }
    }

    public void registerConfig(ReloadableConfig candiConfig) {
        this.modifierCounter.getAndIncrement();
        if (candiConfig != null) {
            this.configSet.add(candiConfig);
        }
        this.modifierCounter.getAndDecrement();
    }

    public void registerNotify(ReloadableNotify notify) {
        this.modifierCounter.getAndIncrement();
        if (notify != null) {
            this.notifySet.add(notify);
        }
        this.modifierCounter.getAndDecrement();
    }

    public void setConfigLoadPredicate(ConfigLoadPredicate configLoadPredicate) {
        this.configLoadPredicate = configLoadPredicate;
    }
}

