/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.ConfigLoadPredicate;
import uds.common.config.interf.AbstractReloadHandler;
import uds.common.config.util.OBSThreadPoolFactory;
import uds.common.config.util.ReloadFileManager;

public final class ConfigReloadWatcher {
    private static final Logger logger = LoggerFactory.getLogger(ConfigReloadWatcher.class);
    private static final ConfigReloadWatcher CONFIG_INSTANCE = new ConfigReloadWatcher();
    private static final long CHECK_PERIOD = 3000L;
    private ConfigLoadPredicate defaultConfigLoadPredicate = ConfigLoadPredicate.DEFAULT;
    private Future<?> watcher = null;
    private final AtomicBoolean isStart = new AtomicBoolean(false);
    private List<AbstractReloadHandler> registeredLoader = new CopyOnWriteArrayList<AbstractReloadHandler>();
    private ReloadFileManager fileManager = new ReloadFileManager(this.registeredLoader);

    private ConfigReloadWatcher() {
    }

    public static ConfigReloadWatcher getInstance() {
        return CONFIG_INSTANCE;
    }

    public synchronized boolean register(AbstractReloadHandler handler) {
        if (handler == null) {
            logger.info("Handler is null");
            return true;
        }
        return this.registeredLoader.add(handler);
    }

    public void init(ConfigLoadPredicate configLoadPredicate) {
        this.defaultConfigLoadPredicate = configLoadPredicate;
        this.init();
    }

    public void init() {
        logger.debug("Enter init() in UPFHotConfig class.");
        if (this.isStart.getAndSet(true)) {
            return;
        }
        this.fileManager.setConfigLoadPredicate(this.defaultConfigLoadPredicate);
        this.watcher = OBSThreadPoolFactory.createThreadPool(1, "configReloadWatcher-pool-").scheduleAtFixedRate(this.fileManager, 0L, 3000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.isStart.getAndSet(false)) {
            this.watcher.cancel(true);
        }
    }

    public void setStart(boolean isStarted) {
        this.isStart.set(isStarted);
    }

    public void setDefaultConfigLoadPredicate(ConfigLoadPredicate defaultConfigLoadPredicate) {
        this.defaultConfigLoadPredicate = defaultConfigLoadPredicate;
    }
}

