/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.base.SolutionConfig;
import uds.common.config.bill.BillConfig;
import uds.common.config.business.BusinessConfig;
import uds.common.config.business.DefaultConfBusiness;
import uds.common.config.cdm.CDMConfiguration;
import uds.common.config.crr.CRRConfig;
import uds.common.config.dcm.DCMConfig;
import uds.common.config.hws.HWSConfig;
import uds.common.config.index.KVConfig;
import uds.common.config.interf.DefaultConf;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;
import uds.common.config.lz.LzConfig;
import uds.common.config.mdc.MdcConfig;
import uds.common.config.memcache.MemcachConfig;
import uds.common.config.mulazini.MultiazConfig;
import uds.common.config.omd.OmdConfig;
import uds.common.config.osp.OspConfig;
import uds.common.config.otm.MigConfig;
import uds.common.config.poeop.PoeOpConfig;
import uds.common.config.pulsarathenz.PulsarAthenzConfig;
import uds.common.config.qosclient.QosConfig;
import uds.common.config.rep.RepConfig;
import uds.common.config.role.RoleConfig;
import uds.common.config.role.RolesContainer;
import uds.common.config.smc.MigratingConfig;
import uds.common.config.sodclient.SodClientConfig;
import uds.common.config.sysconf.SystemFilePath;
import uds.common.config.system.SystemConfig;
import uds.common.config.system.UpgradeStatusConfig;
import uds.common.config.task.TaskConfig;
import uds.core.util.DiskPoolInfo;

public class OBSConfig {
    private static final Logger logger = LoggerFactory.getLogger(OBSConfig.class);
    private static OBSConfig instance = null;
    private static final Object LOCK = new Object();
    private static PoeOpConfig poeOpConfig;
    private static SystemConfig sysConfig;
    private static SodClientConfig sodConfig;
    private static OmdConfig omdConfig;
    private static OspConfig ospConfig;
    private static BillConfig billConfig;
    private static MdcConfig mdcConfig;
    private static BusinessConfig businessConfig;
    private static TaskConfig taskConfig;
    private static DCMConfig dcmConfig;
    private static MemcachConfig memcacheCofig;
    private static HWSConfig hwsCofig;
    private static RepConfig repConfig;
    private static MigConfig warmMigConfig;
    private static MultiazConfig multiazConfig;
    private static CRRConfig crrConfig;
    private static QosConfig qosConfig;
    private static LzConfig lzConfig;
    private static MigratingConfig migratingConfig;
    private static CDMConfiguration cdmConfiguration;
    private static PulsarAthenzConfig pulsarAthenzConfig;
    private static UpgradeStatusConfig upgradeStatusConfig;
    private RoleConfig roleConfig;
    private String responseNamespace = null;
    private String obsResponseNamespace = null;
    private Boolean isswiftEnable = null;
    private String currentComponent = System.getProperty("component");
    private int wormClockClientUpdatePeriod;
    private int wormClockServerUpdatePeriod;
    private PropertiesConfigBuilder configBuilder = null;
    private boolean hasLoaded = false;

    public OBSConfig() {
        this.roleConfig = new RoleConfig();
        OBSConfig.initConfig();
        this.loadOBSSODproperties(SystemFilePath.CONFIG_FILE_NAME);
    }

    private static void initConfig() {
        memcacheCofig = new MemcachConfig();
        hwsCofig = new HWSConfig();
        sysConfig = new SystemConfig();
        sodConfig = new SodClientConfig();
        omdConfig = new OmdConfig();
        ospConfig = new OspConfig();
        billConfig = new BillConfig();
        mdcConfig = MdcConfig.getInstance();
        businessConfig = BusinessConfig.getInstance();
        taskConfig = new TaskConfig();
        multiazConfig = new MultiazConfig();
        dcmConfig = DCMConfig.getInstance();
        repConfig = RepConfig.getInstance();
        qosConfig = new QosConfig();
        warmMigConfig = MigConfig.getInstance();
        crrConfig = CRRConfig.getInstance();
        migratingConfig = MigratingConfig.getInstance();
        cdmConfiguration = CDMConfiguration.getInstance();
        lzConfig = new LzConfig();
        poeOpConfig = new PoeOpConfig();
        pulsarAthenzConfig = new PulsarAthenzConfig();
        upgradeStatusConfig = new UpgradeStatusConfig();
    }

    public PropertiesConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    public static PoeOpConfig poeop() {
        return poeOpConfig;
    }

    public static SystemConfig sys() {
        return sysConfig;
    }

    public static BusinessConfig business() {
        return businessConfig;
    }

    public static OspConfig osp() {
        return ospConfig;
    }

    public static MemcachConfig memcache() {
        return memcacheCofig;
    }

    public static HWSConfig hws() {
        return hwsCofig;
    }

    public static MdcConfig mdc() {
        return mdcConfig;
    }

    public static LzConfig lz() {
        return lzConfig;
    }

    public static CRRConfig crr() {
        return crrConfig;
    }

    public static UpgradeStatusConfig upgradeStatus() {
        return upgradeStatusConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OBSConfig getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new OBSConfig();
                }
            }
        }
        return instance;
    }

    public synchronized boolean loadOBSSODproperties(String propertyfile) {
        if (this.hasLoaded) {
            return true;
        }
        try {
            logger.debug("Began to load configuration file:{}.", (Object)propertyfile);
            this.configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(propertyfile, Character.valueOf('|'));
            sysConfig.loadConfig(this.configBuilder);
            sodConfig.loadConfig(this.configBuilder);
            omdConfig.loadConfig(this.configBuilder);
            ospConfig.loadConfig(this.configBuilder);
            billConfig.loadConfig(this.configBuilder);
            mdcConfig.loadConfig(this.configBuilder);
            businessConfig.loadConfig(this.configBuilder);
            taskConfig.loadConfig(this.configBuilder);
            dcmConfig.loadConfig(this.configBuilder);
            repConfig.loadConfig(this.configBuilder);
            qosConfig.loadConfig(this.configBuilder);
            warmMigConfig.loadConfig(this.configBuilder);
            crrConfig.loadConfig(this.configBuilder);
            migratingConfig.loadConfig(this.configBuilder);
            cdmConfiguration.loadConfig(this.configBuilder);
            poeOpConfig.loadConfig(this.configBuilder);
            pulsarAthenzConfig.loadConfig(this.configBuilder);
            multiazConfig.loadConfig(this.configBuilder);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to load obs_sod configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to load obs_sod configuration file,unexpected exception.", (Throwable)e);
            return false;
        }
        logger.debug("Successfully load all the configuration file.");
        this.hasLoaded = true;
        return true;
    }

    public boolean checkSwitchOpen() {
        logger.debug("server_certificate_switch is {}", (Object)this.getConfig().getBoolean("server_certificate_switch", false));
        return this.getConfig().getBoolean("server_certificate_switch", false);
    }

    public boolean loadRoleProperties(String file) {
        try {
            this.roleConfig.loadRolePolicy(file);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to load role configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to load role configuration file,unexpected exception.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean loadUpfProperties(String propertyfile) {
        try {
            memcacheCofig.loadConfigFile(propertyfile);
            hwsCofig.loadConfigFile(propertyfile);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to load configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to load configuration file,unexpected exception.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean loadUpgradeStatusConfig(String propertyfile) {
        try {
            upgradeStatusConfig.loadConfigFile(propertyfile);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to load configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to load configuration file,unexpected exception.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean loadLzProperties(String propertyfile) {
        try {
            lzConfig.loadConfigFile(propertyfile);
        }
        catch (ConfigurationException e) {
            logger.error("fail to load configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("fail to load configuration file, unexpected exception.", (Throwable)e);
            return false;
        }
        return true;
    }

    public int getPoeScannerPeriod() {
        return poeOpConfig.getPeriod();
    }

    public int getPoeScannerCoreSize() {
        return poeOpConfig.getCoreSize();
    }

    public int getPoeScannerMaxSize() {
        return poeOpConfig.getMaxSize();
    }

    public int getPoeScannerQueueSize() {
        return poeOpConfig.getQueueSzie();
    }

    public int getPoeScannerDuration() {
        return poeOpConfig.getDuration();
    }

    public int getPoeIdleTime() {
        return poeOpConfig.getIdletime();
    }

    public long getPoeMaxTenantCount() {
        return poeOpConfig.getMaxTenantCount();
    }

    public int getLsIdleSeconds() {
        return this.getConfig().getInt("ls_master_idle_seconds", 15);
    }

    public String getNodeFrontIp() {
        return this.getConfig().getString("node_front_ip");
    }

    public String getNodeBackIp() {
        return this.getConfig().getString("node_back_ip");
    }

    public int getChunkSize() {
        return sysConfig.getChunkSize();
    }

    public int getMaxSize4SmallIoRead() {
        return sysConfig.getMaxSize4SmallIoRead();
    }

    public int getColdChunkSize() {
        return sysConfig.getColdChunkSize();
    }

    public int getPartECGroupTime() {
        if (sysConfig.getPartECGroupTime() > this.getUploadWaitTimeForComplete()) {
            return this.getUploadWaitTimeForComplete() - 10;
        }
        return sysConfig.getPartECGroupTime();
    }

    public int getSodDataVersion() {
        return sysConfig.getSodDataVersion();
    }

    public int getInstanceId() {
        return sysConfig.getInstanceId();
    }

    public String getOmdNodeId() {
        return sysConfig.getOmdNodeId();
    }

    public String getOmdNodeIP() {
        return sysConfig.getOmdNodeIP();
    }

    public String getOamUNodeIP() {
        return sysConfig.getOamUNodeIP();
    }

    public String getPOEFloatIP() {
        return sysConfig.getPOEFloatIP();
    }

    public Boolean checkPOEFloatIP() {
        return sysConfig.isCheckPoeFloatIP();
    }

    public String getOscBussinessIp() {
        return sysConfig.getOscBussinessIp();
    }

    public String getRepEndPoint() {
        return crrConfig.getRepEndPoint();
    }

    public List<String> getFsOscIpList() {
        return sysConfig.getFsOscIpList();
    }

    public String getInternalIp() {
        return sysConfig.getInternalIp();
    }

    public String getCcdbLocalIp() {
        return sysConfig.getCcdbLocalIp();
    }

    public String getCurrentComponent() {
        return this.currentComponent;
    }

    public int getCacheLowCapaticy() {
        return sysConfig.getCacheLowCapacity();
    }

    public int getCacheHighCapaticy() {
        return sysConfig.getCacheHighCapacity();
    }

    public int getPartECScanThreadNum() {
        return sysConfig.getPartECScanThreadNum();
    }

    public String getJobIdByEntryType(String entryType) {
        return taskConfig.getJobIdByEntryType(entryType);
    }

    public int getJobPriorityByEntryType(String entryType) {
        return taskConfig.getJobPriorityByEntryType(entryType);
    }

    public int getJobTimeOutByEntryType(String entryType) {
        return taskConfig.getJobTimeOutByEntryType(entryType);
    }

    public int getEcAlgorithm() {
        return sysConfig.getEcAlgorithm();
    }

    public boolean isTrafficControlOpen() {
        return sysConfig.isTrafficCtontrolOpen();
    }

    public int getMaxCpuUsage() {
        return sysConfig.getMaxCpuUsage();
    }

    public int getCpuLow() {
        return sysConfig.getCpuLow();
    }

    public int getMaxSleepTime() {
        return sysConfig.getMaxSleepTime();
    }

    public int getSmnMaxSleepTime() {
        return sysConfig.getSmnMaxSleepTime();
    }

    public int getMaxUploadMbps() {
        return sysConfig.getMaxUploadMbps();
    }

    public int getMaxSleepStepBase() {
        return sysConfig.getMaxSleepStepBase();
    }

    public int getBalanceSleepTimeWrite() {
        return sysConfig.getBalanceSleepTimeWrite();
    }

    public int getBalanceSleepTimeRead() {
        return sysConfig.getBalanceSleepTimeRead();
    }

    public int getKmcCryptoDomainId() {
        return sysConfig.getKmcCryptoDomainId();
    }

    public int getKmcAlgorithmId() {
        return sysConfig.getKmcAlgorithmId();
    }

    public String getKmcPrimaryKeyPath() {
        return sysConfig.getKmcPrimaryKeyPath();
    }

    public String getKmcStandbyKeyPath() {
        return sysConfig.getKmcStandbyKeyPath();
    }

    public String getKmcLogPath() {
        return sysConfig.getKmcLogPath();
    }

    public String getLicenceCCertPassword() {
        return sysConfig.getLicenceCCertPassword();
    }

    public boolean getIfNeedSupportSSL() {
        return sysConfig.getIfNeedSupportSSL();
    }

    public String getSSECustomerHmacKey() {
        return sysConfig.getSSECustomerHmacKey();
    }

    public boolean isAdLdapUserPolicyEnable() {
        return sysConfig.isAdldapUserPolicyEnable();
    }

    public String getMaintainSCertPassowrd() {
        return sysConfig.getMaintainSCertPassowrd();
    }

    public String[] getMaintainProtocol() {
        return sysConfig.getMaintainProtocol();
    }

    public int getIsolatePercent() {
        return KVConfig.INSTANCE.getIntValue("isolate_percent", 5);
    }

    public int getAzSubHealthPercent() {
        return KVConfig.INSTANCE.getIntValue("az_sub_health_percent", 50);
    }

    public long getAzStatusSwitchCycleLimit() {
        return KVConfig.INSTANCE.getLongValue("az_status_switch_cycle_limit", 300L);
    }

    public int getAzStatusSwitchTimeLimit() {
        return KVConfig.INSTANCE.getIntValue("az_status_switch_time_limit", 3);
    }

    public int getNodeNotNormalPercent() {
        return KVConfig.INSTANCE.getIntValue("node_not_normal_percent", 80);
    }

    public int getNodeContinuesTimes() {
        return KVConfig.INSTANCE.getIntValue("node_continues_times", 3);
    }

    public long getNodeRequestLimit() {
        return KVConfig.INSTANCE.getLongValue("node_request_limit", 1000L);
    }

    public int getAzFaultPercent() {
        return KVConfig.INSTANCE.getIntValue("az_fault_percent", 80);
    }

    public int getNodeAppendTimeoutContinuesTimes() {
        return KVConfig.INSTANCE.getIntValue("node_append_timeout_times", 10);
    }

    public Boolean azIsolationSwitch() {
        return KVConfig.INSTANCE.getBoolValue("az_isolation_switch", false);
    }

    public int getAZCheckInterval() {
        return KVConfig.INSTANCE.getIntValue("az_check_internal", 12);
    }

    public int getStoreRetryBaseTime() {
        return sodConfig.getStoreRetryBaseTime();
    }

    public int getStoreRetryCount() {
        return sodConfig.getStoreRetryCount();
    }

    public int getStoreRetryCountForDelete() {
        return this.getInt("store_retryCount_for_delete", 150);
    }

    public long getStoreMaxRetryWait() {
        return sodConfig.getStoreMaxRetryWait();
    }

    public long getStoreMaxRetryWaitForDelete() {
        return this.getLong("store_maxRetryWait_for_delete", 10000L);
    }

    public boolean isSodPerfOpen() {
        return sodConfig.isSodPerfOpen();
    }

    public int getBusinessRetryBaseTime() {
        return omdConfig.getBusinessRetryBaseTime();
    }

    public int getAsyncDedupProcessThread() {
        return omdConfig.getAsyncDedupProcessThread();
    }

    public int getBusinessRetryCount() {
        return omdConfig.getBusinessRetryCount();
    }

    public long getBusinessMaxRetryWait() {
        return omdConfig.getBusinessMaxRetryWait();
    }

    public int getPlogSealTaskQueueCapacity() {
        return ospConfig.getPlogSealTaskQueueCapacity();
    }

    public int getPlogSealWorkerNumber() {
        return ospConfig.getPlogSealWorkerNumber();
    }

    public int getUploadWaitTimeForComplete() {
        return ospConfig.getUploadWaitTimeForComplete();
    }

    public int getDataTransferSize() {
        return ospConfig.getDataTransferSize();
    }

    public int getOscBufferPoolCapacity() {
        int oscUploadExtendPoolCapacity = ospConfig.getOscUploadExtendPoolCapacity();
        String oscUploadExtendPoolCapacityPropStr = System.getProperty("osc_upload_extend_pool_capacity");
        if (oscUploadExtendPoolCapacityPropStr != null && StringUtils.isNumeric((CharSequence)oscUploadExtendPoolCapacityPropStr) && Integer.parseInt(oscUploadExtendPoolCapacityPropStr) > 0) {
            oscUploadExtendPoolCapacity = Integer.parseInt(oscUploadExtendPoolCapacityPropStr);
        }
        return oscUploadExtendPoolCapacity;
    }

    public int getGCIdleTime() {
        return ospConfig.getIdleTime();
    }

    public int getOspStoragePoolId() {
        return ospConfig.getStoragePoolId();
    }

    public int getOscUploadExtendPoolMinIdle() {
        return ospConfig.getOscUploadExtendPoolMinIdle();
    }

    public int getGCUploadReservedPoolCapacity() {
        return ospConfig.getGCUploadReservedPoolCapacity();
    }

    public int getOisUploadExtendPoolCapacity() {
        return ospConfig.getOisUploadExtendPoolCapacity();
    }

    public int getGCUploadExtendPoolCapacity() {
        int gcUploadExtendPoolCapacity = ospConfig.getGCUploadExtendPoolCapacity();
        String gcUploadExtendPoolCapacityPropStr = System.getProperty("gc_upload_extend_pool_capacity");
        if (gcUploadExtendPoolCapacityPropStr != null && StringUtils.isNumeric((CharSequence)gcUploadExtendPoolCapacityPropStr) && Integer.parseInt(gcUploadExtendPoolCapacityPropStr) > 0) {
            gcUploadExtendPoolCapacity = Integer.parseInt(gcUploadExtendPoolCapacityPropStr);
        }
        return gcUploadExtendPoolCapacity;
    }

    public int getOisUploadExtendPoolMinIdle() {
        return ospConfig.getOisUploadExtendPoolMinIdle();
    }

    public int getOTMUploadExtendPoolCapacity() {
        int otmUploadExtendPoolCapacity = ospConfig.getOTMUploadExtendPoolCapacity();
        String otmUploadExtendPoolCapacityPropStr = System.getProperty("otm_upload_extend_pool_capacity");
        if (otmUploadExtendPoolCapacityPropStr != null && StringUtils.isNumeric((CharSequence)otmUploadExtendPoolCapacityPropStr) && Integer.parseInt(otmUploadExtendPoolCapacityPropStr) > 0) {
            otmUploadExtendPoolCapacity = Integer.parseInt(otmUploadExtendPoolCapacityPropStr);
        }
        return otmUploadExtendPoolCapacity;
    }

    public int getOTMUploadExtendPoolMinIdle() {
        return ospConfig.getOTMUploadExtendPoolMinIdle();
    }

    public int getGCUploadExtendPoolMinIdle() {
        return ospConfig.getGCUploadExtendPoolMinIdle();
    }

    public long getDownloadRequestPoolTokenTimeoutMax() {
        return ospConfig.getDownloadRequestPoolTokenTimeoutMax();
    }

    public int getLocalTokenRetryTimes() {
        return ospConfig.getLocalTokenRetryTimes();
    }

    public int getGetLocalTokenTimeout() {
        return ospConfig.getLocalTokenTimeout();
    }

    public boolean isBufferDirect() {
        return ospConfig.isBufferDirect();
    }

    public boolean isCommonBufferPoolLifo() {
        return ospConfig.isCommonBufferPoolLifo();
    }

    public int getCommonBufferPoolMaxIdle() {
        return ospConfig.getCommonBufferPoolMaxIdle();
    }

    public int getCommonBufferPoolMaxWait() {
        return ospConfig.getCommonBufferPoolMaxWait();
    }

    public long getCommonBufferPoolMinEvictableIdleTimeMillis() {
        return ospConfig.getCommonBufferPoolMinEvictableIdleTimeMillis();
    }

    public int getCommonBufferPoolNumTestsPerEvictionRun() {
        return ospConfig.getCommonBufferPoolNumTestsPerEvictionRun();
    }

    public boolean isCommonBufferPoolTestOnBorrow() {
        return ospConfig.isCommonBufferPoolTestOnBorrow();
    }

    public boolean isCommonBufferPoolTestOnReturn() {
        return ospConfig.isCommonBufferPoolTestOnReturn();
    }

    public boolean isCommonBufferPoolTestWhileIdle() {
        return ospConfig.isCommonBufferPoolTestWhileIdle();
    }

    public long getCommonBufferPoolTimeBetweenEvictionRunsMillis() {
        return ospConfig.getCommonBufferPoolTimeBetweenEvictionRunsMillis();
    }

    public boolean getCommonBufferPoolBlockWhenExhausted() {
        return ospConfig.getCommonBufferPoolBlockWhenExhausted();
    }

    public int getMaxBufferSizePerConn() {
        return ospConfig.getMaxBufferSizePerConn();
    }

    public int getUploadMaxPoolSize() {
        return ospConfig.getUploadPoolSize();
    }

    public int getUploadMaxShrinkSize() {
        return ospConfig.getUploadMaxShrinkSize();
    }

    public int getUploadMaxExpandSize() {
        return ospConfig.getUploadMaxExpandSize();
    }

    public int getUploadAdviceThreshold() {
        return ospConfig.getUploadAdviceThreshold();
    }

    public int getUploadLowAdviceThreshold() {
        return ospConfig.getUploadLowAdviceThreshold();
    }

    public int getUploadNoAdviceThreshold() {
        return ospConfig.getUploadNoAdviceThreshold();
    }

    public long getUploadResourceMonitorPeriod() {
        return ospConfig.getUploadResourceMonitorPeriod();
    }

    public int getDownloadMaxPoolSize() {
        return ospConfig.getDownloadPoolSize();
    }

    public int getDownloadMaxShrinkSize() {
        return ospConfig.getDownloadMaxShrinkSize();
    }

    public int getDownloadMaxExpandSize() {
        return ospConfig.getDownloadMaxExpandSize();
    }

    public int getDownloadAdviceThreshold() {
        return ospConfig.getDownloadAdviceThreshold();
    }

    public int getDownloadLowAdviceThreshold() {
        return ospConfig.getDownloadLowAdviceThreshold();
    }

    public int getDownloadNoAdviceThreshold() {
        return ospConfig.getDownloadNoAdviceThreshold();
    }

    public long getDownloadResourceMonitorPeriod() {
        return ospConfig.getDownloadResourceMonitorPeriod();
    }

    public int getInitMirrorPlogNum() {
        return ospConfig.getInitMirrorPlogNum();
    }

    public int getMaxMirrorPlogNum() {
        return ospConfig.getMaxMirrorPlogNum();
    }

    public int getInitECPlogNum() {
        return ospConfig.getInitECPlogNum();
    }

    public int getColdInitECPlogNum() {
        return ospConfig.getColdInitECPlogNum();
    }

    public int getMaxECPlogNum() {
        return ospConfig.getMaxECPlogNum();
    }

    public int getColdMaxECPlogNum() {
        return ospConfig.getColdMaxECPlogNum();
    }

    public int getInitPartECPlogNum() {
        return ospConfig.getInitPartECPlogNum();
    }

    public int getInitDeltaECPlogNum() {
        return ospConfig.getInitDeltaECPlogNum();
    }

    public int getColdInitPartECPlogNum() {
        return ospConfig.getColdInitPartECPlogNum();
    }

    public int getMaxPartECPlogNum() {
        return ospConfig.getMaxPartECPlogNum();
    }

    public int getMaxDeltaECPlogNum() {
        return ospConfig.getMaxDeltaECPlogNum();
    }

    public int getColdMaxPartECPlogNum() {
        return ospConfig.getColdMaxPartECPlogNum();
    }

    public int getInitSmallECPlogNum() {
        return ospConfig.getInitSmallECPlogNum();
    }

    public int getMaxSmallECPlogNum() {
        return ospConfig.getMaxSmallECPlogNum();
    }

    public int getInitMirrorFDPlogNum() {
        return ospConfig.getInitMirrorFDPlogNum();
    }

    public int getMaxMirrorFDPlogNum() {
        return ospConfig.getMaxMirrorFDPlogNum();
    }

    public int getInitECFDPlogNum() {
        return ospConfig.getInitECFDPlogNum();
    }

    public int getMaxECFDPlogNum() {
        return ospConfig.getMaxECFDPlogNum();
    }

    public int getInitPartECFDPlogNum() {
        return ospConfig.getInitPartECFDPlogNum();
    }

    public int getMaxPartECFDPlogNum() {
        return ospConfig.getMaxPartECFDPlogNum();
    }

    public int getInitSmallECFDPlogNum() {
        return ospConfig.getInitSmallECFDPlogNum();
    }

    public int getMaxSmallECFDPlogNum() {
        return ospConfig.getMaxSmallECFDPlogNum();
    }

    public int getSendOTMMigrateTaskNum() {
        return warmMigConfig.getOtmExecuteMigrateTaskMaxNum();
    }

    public int getSendOTMRestoreTaskNum() {
        return ospConfig.getColdMaxECPlogNum();
    }

    public String getDefaultStore() {
        return this.getConfig().getString("default_store", "standard");
    }

    public String getSupportStore() {
        return this.getConfig().getString("support_store", "standard;file;cold_in_standard;gc_fast_delete");
    }

    public int getLowCostInitMirrorPlogNum() {
        return ospConfig.getLowCostInitMirrorPlogNum();
    }

    public int getLowCostMaxMirrorPlogNum() {
        return ospConfig.getLowCostMaxMirrorPlogNum();
    }

    public int getLowCostInitECPlogNum() {
        return ospConfig.getLowCostInitECPlogNum();
    }

    public int getLowCostMaxECPlogNum() {
        return ospConfig.getLowCostMaxECPlogNum();
    }

    public int getLowCostInitPartECPlogNum() {
        return ospConfig.getLowCostInitPartECPlogNum();
    }

    public int getLowCostMaxPartECPlogNum() {
        return ospConfig.getLowCostMaxPartECPlogNum();
    }

    public long getLowCostSmallWriteAggregationWaitTime() {
        return ospConfig.getLowCostSmallWriteAggregationWaitTime();
    }

    public long getLowCostPartECAggregationWaitTime() {
        return ospConfig.getLowCostPartECAggregationWaitTime();
    }

    public long getDedicatedSmallWriteAggregationWaitTime() {
        return ospConfig.getDedicatedSmallWriteAggregationWaitTime();
    }

    public long getDedicatedPartECAggregationWaitTime() {
        return ospConfig.getDedicatedPartECAggregationWaitTime();
    }

    public int getLowCostInitSmallECPlogNum() {
        return ospConfig.getLowCostInitSmallECPlogNum();
    }

    public int getLowCostMaxSmallECPlogNum() {
        return ospConfig.getLowCostMaxSmallECPlogNum();
    }

    public int getDedicatedInitMirrorPlogNum() {
        return ospConfig.getDedicatedInitMirrorPlogNum();
    }

    public int getDedicatedMaxMirrorPlogNum() {
        return ospConfig.getDedicatedMaxMirrorPlogNum();
    }

    public int getDedicatedInitECPlogNum() {
        return ospConfig.getDedicatedInitECPlogNum();
    }

    public int getDedicatedMaxECPlogNum() {
        return ospConfig.getDedicatedMaxECPlogNum();
    }

    public int getDedicatedInitPartECPlogNum() {
        return ospConfig.getDedicatedInitPartECPlogNum();
    }

    public int getDedicatedMaxPartECPlogNum() {
        return ospConfig.getDedicatedMaxPartECPlogNum();
    }

    public int getDedicatedInitSmallECPlogNum() {
        return ospConfig.getDedicatedInitSmallECPlogNum();
    }

    public int getDedicatedMaxSmallECPlogNum() {
        return ospConfig.getDedicatedMaxSmallECPlogNum();
    }

    public int getLowCostGcInitMirrorPlogNum() {
        return ospConfig.getLowCostGcInitMirrorPlogNum();
    }

    public int getLowCostGcMaxMirrorPlogNum() {
        return ospConfig.getLowCostGcMaxMirrorPlogNum();
    }

    public int getLowCostGcInitECPlogNum() {
        return ospConfig.getLowCostGcInitECPlogNum();
    }

    public int getLowCostGcMaxECPlogNum() {
        return ospConfig.getLowCostGcMaxECPlogNum();
    }

    public int getLowCostGcInitPartECPlogNum() {
        return ospConfig.getLowCostGcInitPartECPlogNum();
    }

    public int getLowCostGcMaxPartECPlogNum() {
        return ospConfig.getLowCostGcMaxPartECPlogNum();
    }

    public int getDedicatedGcInitMirrorPlogNum() {
        return ospConfig.getDedicatedGcInitMirrorPlogNum();
    }

    public int getDedicatedGcMaxMirrorPlogNum() {
        return ospConfig.getDedicatedGcMaxMirrorPlogNum();
    }

    public int getDedicatedGcInitECPlogNum() {
        return ospConfig.getDedicatedGcInitECPlogNum();
    }

    public int getDedicatedGcMaxECPlogNum() {
        return ospConfig.getDedicatedGcMaxECPlogNum();
    }

    public int getDedicatedGcInitPartECPlogNum() {
        return ospConfig.getDedicatedGcInitPartECPlogNum();
    }

    public int getDedicatedGcMaxPartECPlogNum() {
        return ospConfig.getDedicatedGcMaxPartECPlogNum();
    }

    public int getGcInitMirrorPlogNum() {
        return ospConfig.getGcInitMirrorPlogNum();
    }

    public int getGcInitECPlogNum() {
        return ospConfig.getGcInitECPlogNum();
    }

    public int getColdGcInitECPlogNum() {
        return ospConfig.getColdGcInitECPlogNum();
    }

    public int getGcInitPartECPlogNum() {
        return ospConfig.getGcInitPartECPlogNum();
    }

    public int getGcInitSmallECPlogNum() {
        return ospConfig.getGcInitSmallECPlogNum();
    }

    public int getGcInitMirrorFDPlogNum() {
        return ospConfig.getGcInitMirrorFDPlogNum();
    }

    public int getGcInitECFDPlogNum() {
        return ospConfig.getGcInitECFDPlogNum();
    }

    public int getGcInitPartECFDPlogNum() {
        return ospConfig.getGcInitPartECFDPlogNum();
    }

    public int getColdGcInitPartECPlogNum() {
        return ospConfig.getColdGcInitPartECPlogNum();
    }

    public int getGcMaxMirrorPlogNum() {
        return ospConfig.getGcMaxMirrorPlogNum();
    }

    public int getGcMaxECPlogNum() {
        return ospConfig.getGcMaxECPlogNum();
    }

    public int getColdGcMaxECPlogNum() {
        return ospConfig.getColdGcMaxECPlogNum();
    }

    public int getGcMaxPartECPlogNum() {
        return ospConfig.getGcMaxPartECPlogNum();
    }

    public int getGcMaxMirrorFDPlogNum() {
        return ospConfig.getGcMaxMirrorFDPlogNum();
    }

    public int getGcMaxECFDPlogNum() {
        return ospConfig.getGcMaxECFDPlogNum();
    }

    public int getGcMaxPartECFDPlogNum() {
        return ospConfig.getGcMaxPartECFDPlogNum();
    }

    public int getColdGcMaxPartECPlogNum() {
        return ospConfig.getColdGcMaxPartECPlogNum();
    }

    public int getMirrorPlogUseRate() {
        return ospConfig.getMirrorPlogUseRate();
    }

    public int getEcPlogUseRate() {
        return ospConfig.getEcPlogUseRate();
    }

    public int getColdEcPlogUseRate() {
        return ospConfig.getColdEcPlogUseRate();
    }

    public int getPartECPlogUseRate() {
        return ospConfig.getPartECPlogUseRate();
    }

    public int getDeltaECPlogUseRate() {
        return ospConfig.getDeltaECPlogUseRate();
    }

    public int getColdPartECPlogUseRate() {
        return ospConfig.getColdPartECPlogUseRate();
    }

    public int getMirrorPlogCapacity() {
        return ospConfig.getMirrorPlogCapacity();
    }

    public int getEcPlogCapacity() {
        return ospConfig.getEcPlogCapacity();
    }

    public int getDeltaECPlogCapacity() {
        return ospConfig.getDeltaECPlogCapacity();
    }

    public int getColdEcPlogCapacity() {
        return ospConfig.getColdEcPlogCapacity();
    }

    public int getSmallEcPlogCapacity() {
        return ospConfig.getSmallEcPlogCapacity();
    }

    public int getPlogHeaderMagicOffset() {
        return ospConfig.getPlogHeaderMagicOffset();
    }

    public int getPlogHeaderVersionOffset() {
        return ospConfig.getPlogHeaderVersionOffset();
    }

    public int getPlogHeaderBlocklenOffset() {
        return ospConfig.getPlogHeaderBlocklenOffset();
    }

    public int getPlogHeaderFlagOffset() {
        return ospConfig.getPlogHeaderFlagOffset();
    }

    public int getPlogHeaderHeaderlenOffset() {
        return ospConfig.getPlogHeaderHeaderlenOffset();
    }

    public int getPlogHeaderObjectKeylenOffset() {
        return ospConfig.getPlogHeaderObjectKeylenOffset();
    }

    public int getPlogHeaderMagicLength() {
        return ospConfig.getPlogHeaderMagicLength();
    }

    public int getPlogHeaderVersionLength() {
        return ospConfig.getPlogHeaderVersionLength();
    }

    public int getPlogHeaderBlocklenLength() {
        return ospConfig.getPlogHeaderBlocklenLength();
    }

    public int getPlogHeaderFlagLength() {
        return ospConfig.getPlogHeaderFlagLength();
    }

    public int getPlogHeaderHeaderlenLength() {
        return ospConfig.getPlogHeaderHeaderlenLength();
    }

    public int getPlogHeaderObjectKeylenLength() {
        return ospConfig.getPlogHeaderObjectKeylenLength();
    }

    public byte getPlogHeaderMagicValue() {
        return ospConfig.getPlogHeaderMagicValue();
    }

    public byte getPlogHeaderVersionValue() {
        if (KVConfig.INSTANCE.getIntValue("plog_header_version_value", 0) == 0) {
            return ospConfig.getPlogHeaderVersionValue();
        }
        return (byte)KVConfig.INSTANCE.getIntValue("plog_header_version_value", 0);
    }

    public int getPlogHeaderAlignedBytes() {
        return ospConfig.getPlogHeaderAlignedBytes();
    }

    public int getMaxBorrowPlogWaitTime() {
        return ospConfig.getMaxBorrowPlogWaitTime();
    }

    public int getMonitorPlogNumberPeriod() {
        return ospConfig.getMonitorPlogNumberPeriod();
    }

    public int getMonitorUnusedPlogPeriod() {
        return ospConfig.getMonitorUnusedPlogPeriod();
    }

    public int getMonitorDegradePlogPeriod() {
        return ospConfig.getMonitorDegradePlogPeriod();
    }

    public int getMaxNoUsedTimeToSeal() {
        return ospConfig.getMaxNoUsedTimeToSeal();
    }

    public int getMaxNoUsedTimeToForceSeal() {
        return ospConfig.getMaxNoUsedTimeToForceSeal();
    }

    public int getMaxNoUsedTimeToNeedSeal() {
        return ospConfig.getMaxNoUsedTimeToNeedSeal();
    }

    public int getPlogClientInitTimes() {
        return ospConfig.getPlogClientInitTimes();
    }

    public int getPlogObjectListSize() {
        return ospConfig.getPlogObjectListSize();
    }

    public int getPlogObjectListSizeToDisk() {
        return ospConfig.getPlogObjectListSizeToDisk();
    }

    public int getPlogObjectListSizePerDoc() {
        return ospConfig.getPlogObjectListSizePerDoc();
    }

    public int getPlogUsageCacheThreshold() {
        return ospConfig.getPlogUsageCacheThreshold();
    }

    public int getPlogExpiredTime() {
        return ospConfig.getPlogExpiredTime();
    }

    public int getPlogCreatePriority() {
        return ospConfig.getPlogCreatePriority();
    }

    public int getPlogAppendPriority() {
        return ospConfig.getPlogAppendPriority();
    }

    public int getPlogReadPriority() {
        return ospConfig.getPlogReadPriority();
    }

    public int getOscDefaultDataPriority() {
        return ospConfig.getOscDefaultDataPriority();
    }

    public int getGCDefaultDataPriority() {
        return ospConfig.getGCDefaultDataPriority();
    }

    public int getMirrorThreshold() {
        return ospConfig.getMirrorThreshold();
    }

    public int getGCWaitTime() {
        return ospConfig.getGCWaitTime();
    }

    public long getPartECAggregationWaitTime() {
        if (this.isEnterpriseMode()) {
            return ospConfig.getPartECAggregationWaitTime();
        }
        return KVConfig.INSTANCE.getLongValue("partec_aggregation_wait_time", 4000L);
    }

    public long getPartECAggregationWaitTime3AZ() {
        return ospConfig.getPartECAggregationWaitTime3AZ();
    }

    public long getMirrorAggregationWaitTime() {
        return ospConfig.getMirrorAggregationWaitTime();
    }

    public long getSmallWriteAggregationWaitTime() {
        return ospConfig.getSmallWriteAggregationWaitTime();
    }

    public long getDeltaECWriteAggregationWaitTime() {
        return ospConfig.getDeltaECWriteAggregationWaitTime();
    }

    public int getGCWritePercent() {
        return ospConfig.getGCWritePercent();
    }

    public int getMaxWriteCountForOneWrite() {
        return ospConfig.getMaxWriteCountForOneWrite();
    }

    public int getPlogReadMaxFailTime() {
        return ospConfig.getPlogReadMaxFailTime();
    }

    public double getWriteBackPlogThreshold() {
        return ospConfig.getWriteBackPlogThreshold();
    }

    public int getMonitorPlogPoolCapacityPeriod() {
        return ospConfig.getMonitorPlogPoolCapacityPeriod();
    }

    public double getSSDUsageHighThreshold() {
        return ospConfig.getSSDUsageHighThreshold();
    }

    public double getSSDUsageLowThreshold() {
        return ospConfig.getSSDUsageLowThreshold();
    }

    public double getSSDStorageUseUpThreshold() {
        return ospConfig.getSSDUsedUpThreshold();
    }

    public double getSSDStorageAvailableThreshold() {
        return ospConfig.getSSDStorageAvailableThreshold();
    }

    public double getHDDStorageUseUpThreshold() {
        return ospConfig.getHDDUsedUpThreshold();
    }

    public double getHDDStorageAvailableThreshold() {
        return ospConfig.getHDDStorageAvailableThreshold();
    }

    public double getColdUsedUpThreshold() {
        return ospConfig.getColdUsedUpThreshold();
    }

    public double getColdStorageAvailableThreshold() {
        return ospConfig.getColdStorageAvailableThreshold();
    }

    public int getSmallWriteECThreshold() {
        if (this.isEnterpriseMode()) {
            int smallWriteEnterprise = KVConfig.INSTANCE.getIntValue("ec_small_threshold", 0);
            return smallWriteEnterprise != 0 ? smallWriteEnterprise : ospConfig.getSmallWriteECThreshold();
        }
        int smallThreshold = KVConfig.INSTANCE.getIntValue("ec_small_threshold", 0x100000);
        return smallThreshold != 0 ? smallThreshold : ospConfig.getSmallWriteECThreshold();
    }

    public boolean isEnterPriseEC() {
        return ospConfig.isEnterPriseEC();
    }

    public int getSmallWriteWriteBackThreshold() {
        return ospConfig.getSmallWriteWriteBackThreshold();
    }

    public boolean useAsyncMD5() {
        return ospConfig.useAsyncMD5();
    }

    public int getAsyncMD5ThreadNum() {
        return ospConfig.getAsyncMD5ThreadNum();
    }

    public int getAsyncMD5DataSize() {
        return ospConfig.getAsyncMD5DataSize();
    }

    public int getPlogKeyListSplitThreshold() {
        return ospConfig.getPlogKeyListSplitThreshold();
    }

    public List<Integer> getMirrorBackupNumber() {
        return ospConfig.getMirrorBackupNumber();
    }

    public int getAppendPlogMaxRetryCount() {
        return ospConfig.getAppendPlogMaxRetryCount();
    }

    public String getFormerLsHost() {
        return KVConfig.INSTANCE.getStringValue("former_default_cluster_ls_vip", "");
    }

    public int getGlobalTokenLogInterval() {
        return ospConfig.getGlobalTokenLogInterval();
    }

    public boolean testStopAsyn2Sod() {
        return billConfig.testStopAsyn2Sod();
    }

    public int testPreStopWaitFlushCacheTime() {
        return billConfig.testPreStopWaitFlushCacheTime();
    }

    public int getIAAssignedTime() {
        return billConfig.getIAAssignedTime();
    }

    public int getNodeId() {
        return billConfig.getNodeId(this.getConfig());
    }

    public void setNodeId(int nodeId) {
        billConfig.setNodeId(this.getConfig(), nodeId);
    }

    public void setRepEndPoint(String repEndPoint) {
        crrConfig.setRepEndPoint(this.getConfig(), repEndPoint);
    }

    public int getStorageBillGeneratorInfoCheckInterval() {
        return billConfig.getStorageBillGeneratorInfoCheckInterval();
    }

    public String getSpecailBillFormatParam(int index) {
        return billConfig.getBillingFormatArray(this.getConfig())[index];
    }

    public boolean billIsForBucket() {
        return billConfig.billIsForBucket();
    }

    public boolean getIsRecordNeedXdomainId() {
        return billConfig.isRecordNeedXdomainId();
    }

    public boolean billIsWithTagging() {
        return billConfig.billIsWithTagging();
    }

    public String getTmpfsPath() {
        return billConfig.getTmpfsPath();
    }

    public int getTmpfsMaxBillInfoCount() {
        return billConfig.getTmpfsMaxBillInfoCount();
    }

    public long getTmpfsBlockTime() {
        return billConfig.getTmpfsBlockTime();
    }

    public boolean isStatisticLogInfoOpen() {
        return billConfig.isStatisticLogInfoOpen();
    }

    public boolean isStatisticOpenBetweenOsc() {
        return billConfig.isStatisticOpenBetweenOsc();
    }

    public String getSystemUnitedUser() {
        return billConfig.getSystemUnitedUser();
    }

    public int getStatRecordManagerTaskInterval() {
        return billConfig.getStatRecordManagerTaskInterval();
    }

    public int getStatCalculatedRecordStoreMaxNum() {
        return billConfig.getStatCalculatedRecordStoreMaxNum();
    }

    public int getStatRecordWriteMaxNum() {
        return billConfig.getStatRecordWriteMaxNum();
    }

    public int getStatOscNumInOnePB() {
        return billConfig.getStatOscNumInOnePB();
    }

    public int getUserQuotaStatusAvailTime() {
        return billConfig.getUserQuotaStatusAvailTime();
    }

    public int getUserQuotaCacheSize() {
        return billConfig.getUserQuotaCacheSize();
    }

    public String getStatBucketNamePrefix() {
        return billConfig.getStatBucketName(this.getConfig());
    }

    public boolean getSysBillIsForMeterName() {
        return billConfig.getSysBillingForMeterName();
    }

    public boolean getIsUploadBillFileToBucket() {
        return billConfig.getIsUploadBillFileToBucket();
    }

    public boolean getSysBillShowUserType() {
        return billConfig.getSysBillingShowUserType();
    }

    public boolean getSysBillingTest() {
        return billConfig.getSysBillingTest();
    }

    public int getBillingAlarmTime() {
        return billConfig.getBillingAlarmTime();
    }

    public boolean getSysBillingByHour() {
        return billConfig.getSysGenBillingByHour();
    }

    public int getSysBillingInterval() {
        return billConfig.getBillTaskInterval();
    }

    public int getSysAccesslogIntervalTime() {
        return billConfig.getAccesslogIntervalTime();
    }

    public boolean getSysBillingOpen() {
        return billConfig.getSysBillingOpen();
    }

    public String getBillDigestType() {
        return billConfig.getBillDigestType();
    }

    public String getSysBillingUploadMode() {
        return billConfig.getSysBillingUploadMode();
    }

    public int getSysAccessLogLifeCycle() {
        return billConfig.getSysAccessLogLifeCycle();
    }

    public long getaccesslogInterTime() {
        return billConfig.getaccesslogInterTime();
    }

    public long getCesAccessLogUploadPeriod() {
        return businessConfig.getCesAccessLogUploadPeriod();
    }

    public String getSysUserTestRegionID() {
        return billConfig.getSysUserTestRegionID();
    }

    public String getBillBucketNamePrefix() {
        return billConfig.getBillBucketName();
    }

    public String getAccessLogBucketNamePrefix() {
        return billConfig.getAccessLogBucketName();
    }

    public boolean getsHKUserNoBillingSwitch() {
        return billConfig.getHKUserNoBillingSwitch();
    }

    public String getBillCanoUserId() {
        return billConfig.getBillCanoUserId();
    }

    public long getBucketQuotaisZeroThreshold() {
        return billConfig.getBucketQuotaisZeroThreshold();
    }

    public long getBucketQuotaisZeroDelThreshold() {
        return billConfig.getBucketQuotaisZeroDelThreshold();
    }

    public long getBucketQuotaisNotZeroDelThreshold() {
        return billConfig.getBucketQuotaisNotZeroDelThreshold();
    }

    public String getS3fsOrigDir() {
        return billConfig.getS3fsOrigDir(this.getConfig());
    }

    public String getS3fsStorageDir() {
        return billConfig.getS3fsStorageDir(this.getConfig());
    }

    public String getS3fsBackupOrigDir() {
        return billConfig.getS3fsBackupOrigDir(this.getConfig());
    }

    public String getS3fsBackupStorageDir() {
        return billConfig.getS3fsBackupStorageDir(this.getConfig());
    }

    public String getBillingMDCMode() {
        return billConfig.getBillingMDCMode();
    }

    public int getBillOverdueTime() {
        return billConfig.getBillOverdueTime();
    }

    public boolean isRequestIdLogOpen() {
        return billConfig.isRequestIdLogOpen();
    }

    public String getBillingType() {
        return billConfig.getBillingType();
    }

    public String getBillHWSResouceSpecCode() {
        return billConfig.getHwsCloudResourSpecCode();
    }

    public int getBillMonThreshold() {
        return billConfig.getBillMonThreshold();
    }

    public int getBillWriteRegionAlarmThreshold() {
        return billConfig.getBillWriteRegionAlarmThreshold();
    }

    public long getBillWriteRegionAlarmTimeout() {
        return billConfig.getBillWriteRegionAlarmTimeout();
    }

    public boolean isOptionsJudged() {
        return sysConfig.isOptionsJudged();
    }

    public long getMonitorStatisticInterval() {
        return sysConfig.getMonitorStatisticInterval();
    }

    public int getMaxUserOwnBucketNum() {
        return businessConfig.getMaxUserOwnBucketNum();
    }

    public int getFsTaskCleanMaxIntervalTime() {
        return businessConfig.getFsTaskCleanMaxIntervalTime();
    }

    public boolean isUseOscQueue() {
        return businessConfig.isUseOscQueue();
    }

    public int getOscQueueTimeOut() {
        return businessConfig.getOscQueueTimeOut();
    }

    public int getMaxOSCRequest() {
        int maxOscRequest = businessConfig.getMaxOSCRequest();
        String maxOscRequestStr = System.getProperty("maxOSCRequest");
        if (StringUtils.isNumeric((CharSequence)maxOscRequestStr) && Integer.parseInt(maxOscRequestStr) > 0) {
            maxOscRequest = Integer.parseInt(maxOscRequestStr);
        }
        if (SolutionConfig.is93ArchiveScenes()) {
            maxOscRequest /= 2;
        }
        return maxOscRequest;
    }

    public double getMaxOscRequestRatio() {
        return businessConfig.getMaxOscRequestRatio();
    }

    public int getMaxRequestOnCurrentSystem() {
        return businessConfig.getMaxRequestOnCurrentSystem();
    }

    public int getMaxMaintainRequest() {
        return businessConfig.getMaxMaintainRequest();
    }

    public int getMaxObjectLength() {
        return businessConfig.getMaxObjectLength();
    }

    public boolean isCompressSwitchOpen() {
        return businessConfig.isCompressSwitchOpen();
    }

    public void setCompressSwitchOpen(boolean compressSwitchOpen) {
        businessConfig.setCompressSwitchOpen(compressSwitchOpen);
    }

    public int getMaxFileLength() {
        return businessConfig.getMaxFileLength();
    }

    public int getLocalBucketMetaCacheSize() {
        return businessConfig.getLocalBucketMetaCacheSize();
    }

    public int getLocalBucketMetaCacheTimeout() {
        return businessConfig.getLocalBucketMetaCacheTimeoutMs();
    }

    public int getLocalBucketMetaCacheLazyTimeout() {
        return businessConfig.getLocalBucketMetaCacheLazyTimeoutMs();
    }

    public int getLocalBucketMetaCacheWatchPeriod() {
        return businessConfig.getLocalBucketMetaCacheWatchPeriod();
    }

    public long getTempAuthExpireTime() {
        return businessConfig.getTempAuthExpireTime();
    }

    public int getAuthCacheMaxCount() {
        return businessConfig.getAuthCacheMaxCount();
    }

    public boolean isNeedCalcMD5() {
        return businessConfig.isNeedCalcMD5();
    }

    public int getMaxKeys() {
        return businessConfig.getMaxKeys();
    }

    public int getMetaSearchMaxKeys() {
        return businessConfig.getMetaSearchMaxKeys();
    }

    public long getUserMetadataMaxSize() {
        return businessConfig.getUserMetadataMaxSize();
    }

    public int getSmallObjectSize() {
        return businessConfig.getSmallObjectSize();
    }

    public boolean isDomainNameRegexEnable() {
        return businessConfig.isDomainNameRegexEnable();
    }

    public boolean isCDNNotifySwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("config_refresh_policy_for_cdn_is_open", true);
    }

    public boolean isQueryCDNConfigSwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("query_refresh_config_from_cdn_is_open", false);
    }

    public String getDomainNameRegex() {
        return businessConfig.getDomainNameRegex();
    }

    public String getApiHttpExternHeaders() {
        return businessConfig.getApiHttpExternHeaders();
    }

    public String getApiAllUsersGroupURI() {
        return businessConfig.getApiAllUsersGroupURI();
    }

    public String getApiAuthenticatedUsersURI() {
        return businessConfig.getApiAuthenticatedUsersURI();
    }

    public String getApiRootDomainName() {
        return businessConfig.getApiRootDomainName();
    }

    public List<String> getAllApiRootDomainName() {
        return businessConfig.getAllApiRootDomainName();
    }

    public List<Pattern> getAllApiRootDomainPatterns() {
        return businessConfig.getAllApiRootDomainPatterns();
    }

    public String getWebsiteDomainNameSuffix() {
        return businessConfig.getWebsiteDomainNameSuffix();
    }

    public boolean isClusterDomainAccessEnabled() {
        return businessConfig.isClusterDomainAccessEnabled();
    }

    public boolean isDeltaECWriteOpen() {
        return businessConfig.isDeltaECWriteOpen();
    }

    public boolean getSupportCreatingDeltaWriteECPlog() {
        return businessConfig.getSupportCreatingDeltaWriteECPlog();
    }

    public void setSupportCreatingDeltaWriteECPlog(boolean enableToCreateDeltaWriteECPlog) {
        businessConfig.setSupportCreatingDeltaWriteECPlog(enableToCreateDeltaWriteECPlog);
    }

    public boolean enableToCreateDeltaWriteECPlog() {
        return this.isDeltaECWriteOpen() && this.getSupportCreatingDeltaWriteECPlog();
    }

    public boolean isMdcHTTPS() {
        return sysConfig.isMdcHTTPS();
    }

    public int getMdcServicePort() {
        int servicePort = this.isMdcHTTPS() ? businessConfig.getMdcHTTPSPort() : businessConfig.getMdcHTTPPort();
        return servicePort;
    }

    public int getInternalHTTPPort() {
        return businessConfig.getInternalBusinessHTTPPort();
    }

    public int getInternalHTTPSPort() {
        return businessConfig.getInternalBusinessHTTPSPort();
    }

    public boolean isInternalPort(int port) {
        boolean checkInternalPort = sysConfig.isInternalPort();
        return !checkInternalPort || this.getInternalHTTPPort() == port || this.getInternalHTTPSPort() == port;
    }

    public String getLocalDataCenterID() {
        return businessConfig.getLocalDataCenterID();
    }

    public boolean needRegionCopy() {
        return businessConfig.needRegionCopy();
    }

    public boolean isCopySupportRange() {
        return businessConfig.isCopySupportRange(this.getConfig());
    }

    public String getSystemUnitedUserAuthID() {
        return businessConfig.getSystemUnitedUserAuthID();
    }

    public boolean isAkWrongAccessOpen() {
        return businessConfig.isAkWrongAccessOpen();
    }

    public boolean isIpWrongAccessOpen() {
        return businessConfig.isIpWrongAccessOpen();
    }

    public boolean isIpViolentAccessOpen() {
        return businessConfig.isIpViolentAccessOpen();
    }

    public boolean isAkandipWrongAccessOpen() {
        return businessConfig.isAkandipWrongAccessOpen();
    }

    public boolean isHcpCompatible() {
        return businessConfig.isHcpCompatible();
    }

    public boolean isDdosAtackAlarmOpen() {
        return businessConfig.isDdosAtackAlarmOpen();
    }

    public Properties getAkPolicy() {
        return businessConfig.getAkPolicy();
    }

    public Properties getIpPolicy() {
        return businessConfig.getIpPolicy();
    }

    public Properties getAkAndIpPolicy() {
        return businessConfig.getAkAndIpPolicy();
    }

    public long getRequestFlowThreshold() {
        return businessConfig.getRequestFlowThreshold();
    }

    public long getRequestTimesThreshold() {
        return businessConfig.getRequestTimesThreshold();
    }

    public boolean isTracingEnabled() {
        return businessConfig.isTracingEnabled();
    }

    public boolean isPermitDeleteBucketData() {
        return businessConfig.isPermitDeleteBucketData();
    }

    public int getMaxMultiDeleteNum() {
        return businessConfig.getMaxMultiDeleteNum();
    }

    public int getAveLoad() {
        return businessConfig.getAveLoad();
    }

    public int getMaxMultiDeleteRequestNum() {
        return businessConfig.getMaxMultiDeleteRequestNum();
    }

    public int getMultiDeleteTimeOut() {
        return businessConfig.getMultiDeleteTimeOut();
    }

    public int getMaxMultiDeleteThreadNum() {
        if (this.isEnterpriseMode()) {
            return businessConfig.getMaxMultiDeleteThreadNum();
        }
        return KVConfig.INSTANCE.getIntValue("max_multi_delete_thread_num", 40);
    }

    public int getMaxMultiDelReqBody() {
        return businessConfig.getMaxMultiDelReqBody();
    }

    public int getMaxMultiModifyReqBody() {
        return businessConfig.getMaxMultiModifyReqBody();
    }

    public int getMaxMultiDelThreadPoolNum() {
        return businessConfig.getMaxMultiDelThreadPoolNum();
    }

    public int getMaxLogCount() {
        return businessConfig.getMaxLogCount();
    }

    public long getTimeIntervalOfBucketAccessLog() {
        return businessConfig.getTimeIntervalOfBucketAccessLog();
    }

    public boolean isObjectCheckStatusRecordSwitchOpen() {
        return taskConfig.isObjectCheckStatusRecordSwitchOpen();
    }

    public int getScanDeletedObjectPeriod() {
        return taskConfig.getScanDeleteObjectPeriod();
    }

    public int getScanDeletedObjectThread() {
        return taskConfig.getScanDeleteObjectThread();
    }

    public int getDeleteObjectTaskSize() {
        return taskConfig.getDeleteObjectTaskSize();
    }

    public boolean isQueryCurrentUsersSwitchOpen() {
        return businessConfig.isQueryCurrentUsersSwitchOpen();
    }

    public int getDataCenterReqRetryTime() {
        return businessConfig.getDataCenterReqRetryTime();
    }

    public boolean isLifeCycleForTestSwitch() {
        return taskConfig.isLifeCycleForTestSwitchOpen();
    }

    public boolean isMidNightForTestSwitch() {
        return taskConfig.isLifeCycleMidnightForTestOpen();
    }

    public boolean isCheckObjectDataSwitchOpen() {
        return taskConfig.isCheckObjectDataSwitchOpen();
    }

    public boolean isCheckObjectCreatetimeSwitchOpen() {
        return taskConfig.isCheckObjectCreatetimeSwitchOpen();
    }

    public boolean isCheckObjectEtagSwitchOpen() {
        return taskConfig.isCheckObjectEtagSwitchOpen();
    }

    public boolean checkObjectWithReplicationFinishTimeSwitch() {
        return taskConfig.checkObjectWithReplicationFinishTimeSwitch();
    }

    public long getRepSwitchBucketTaskRetryTime() {
        return taskConfig.getRepSwitchBucketTaskRetryTime();
    }

    public long getClusterUserRepSwitchTaskRetryTime() {
        return taskConfig.getClusterUserRepSwitchTaskRetryTime();
    }

    public long getTestReplicationFinishTime() {
        return taskConfig.getTestReplicationFinishTime();
    }

    public boolean getTestRepSwitchAction() {
        return taskConfig.getTestRepSwitchAction();
    }

    public int getMaxDedupMasterIdleTime() {
        return taskConfig.getMaxDedupMasterIdleTime();
    }

    public String getString(String key) {
        return this.getConfig().getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getConfig().getString(key, defaultValue);
    }

    public int getInt(String key) {
        return this.getConfig().getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.getConfig().getInt(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.getConfig().getLong(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getConfig().getBoolean(key, defaultValue);
    }

    public String getMessageQueueIp() {
        return sysConfig.getMessageQueueIp();
    }

    public String getProxyServiceIpList() {
        return sysConfig.getProxyServiceIps();
    }

    public long getInspectionInterval() {
        long timeValue;
        String timeUnitStr = sysConfig.getObjchkInspectTimeunit();
        try {
            timeValue = sysConfig.getObjchkInspectInterval();
        }
        catch (RuntimeException e) {
            timeValue = 0L;
        }
        if (timeValue <= 0L) {
            timeValue = 90L;
        }
        TimeUnit tu = null;
        try {
            tu = TimeUnit.valueOf(timeUnitStr);
        }
        catch (RuntimeException e) {
            tu = DefaultConf.OBJCHK_INSPECT_TIME_UNIT;
        }
        return tu.toMillis(timeValue);
    }

    public long getObjectWalkingCycle() {
        long timeValue;
        try {
            timeValue = sysConfig.getObjectWalkingCycleTime();
        }
        catch (RuntimeException e) {
            timeValue = 0L;
        }
        if (timeValue <= 0L) {
            timeValue = 7L;
        }
        String timeUnitStr = sysConfig.getObjectWalkingCycleTimeUnit();
        TimeUnit tu = null;
        try {
            tu = TimeUnit.valueOf(timeUnitStr);
        }
        catch (RuntimeException e) {
            tu = DefaultConf.OBJECT_WALKING_CYCLE_TIME_UNIT;
        }
        return tu.toMillis(timeValue);
    }

    public long getSleepTimeOfObjectWalkerAfterOneCycle() {
        long timeValue;
        try {
            timeValue = sysConfig.getAfterOneCycleObjectWalkerSleepInSeconds();
        }
        catch (RuntimeException e) {
            timeValue = 0L;
        }
        if (timeValue <= 0L) {
            timeValue = 600L;
        }
        return TimeUnit.SECONDS.toMillis(timeValue);
    }

    public long getObjectWalkerMonitorReadStatusInterval() {
        long timeValue;
        try {
            timeValue = sysConfig.getObjectWalkerMonitorReadStatusIntervalInSeconds();
        }
        catch (RuntimeException e) {
            timeValue = 0L;
        }
        if (timeValue <= 0L) {
            timeValue = 3600L;
        }
        return TimeUnit.SECONDS.toMillis(timeValue);
    }

    public long getDeletedUserDataCleanTaskDelayTime() {
        long deletedUserDataCleanTaskDelayTime;
        try {
            deletedUserDataCleanTaskDelayTime = sysConfig.getDeletedUserDataCleanTaskDelayTime();
        }
        catch (RuntimeException e) {
            deletedUserDataCleanTaskDelayTime = 1800000L;
        }
        if (deletedUserDataCleanTaskDelayTime <= 0L) {
            deletedUserDataCleanTaskDelayTime = 1800000L;
        }
        return deletedUserDataCleanTaskDelayTime;
    }

    public long getDeleteDeregisterBucketDataDelayTime() {
        long delay;
        try {
            delay = sysConfig.getDeleteBucketDataTaskDelayTime();
        }
        catch (RuntimeException e) {
            delay = 3600000L;
        }
        if (delay <= 0L) {
            delay = 3600000L;
        }
        return delay;
    }

    public boolean isOisTaskEnable() {
        return sysConfig.isOisTaskEnable();
    }

    public boolean isLifecycleTaskEnable() {
        try {
            return this.getConfig().getBoolean("lifecycle_task_enable", true);
        }
        catch (Exception e) {
            logger.warn("getConfig().getBoolean(ConfProps.LIFECYCLE_TASK_ENABLE) failed", (Throwable)e);
            return true;
        }
    }

    public boolean isSmcTaskEnable() {
        try {
            return this.getConfig().getBoolean("smc_task_enable", true);
        }
        catch (Exception e) {
            logger.warn("getConfig().getBoolean(ConfProps.SMC_TASK_ENABLE) failed", (Throwable)e);
            return true;
        }
    }

    public long getThresholdTimeForDelete() {
        long thresholdTimeForDelete;
        try {
            thresholdTimeForDelete = sysConfig.getThresholdTimeForDelete();
        }
        catch (RuntimeException e) {
            thresholdTimeForDelete = 0L;
        }
        if (thresholdTimeForDelete <= 0L) {
            thresholdTimeForDelete = 0L;
        }
        return thresholdTimeForDelete;
    }

    public boolean isNotifyBSSByBucket() {
        return sysConfig.isNotifyBSSByBucket();
    }

    public long getThresholdTimeForNotifyDelete() {
        long thresholdTimeForNotifyDelete;
        try {
            thresholdTimeForNotifyDelete = sysConfig.getThresholdTimeForNotifyDelete();
        }
        catch (RuntimeException e) {
            thresholdTimeForNotifyDelete = 0L;
        }
        if (thresholdTimeForNotifyDelete <= 0L) {
            thresholdTimeForNotifyDelete = 0L;
        }
        return thresholdTimeForNotifyDelete;
    }

    public boolean isCheckAuthTimeOpen() {
        return sysConfig.isCheckAuthTimeOpen();
    }

    public boolean isSwitchOfPerfStat() {
        return sysConfig.isSwitchOfPerfStat();
    }

    public boolean getRemoteReplication() {
        return sysConfig.isRemoteReplication();
    }

    public boolean getRepSwitchSlaveDeleteUpload() {
        return sysConfig.isRepSwitchSlaveDeleteUpload();
    }

    public boolean getRepSwitchSlaveDeleteObject() {
        return sysConfig.isRepSwitchSlaveDeleteObject();
    }

    public boolean getRepSwitchSlaveCopyObject() {
        return sysConfig.isRepSwitchSlaveCopyObject();
    }

    public int getMaxObjectDedupedNum() {
        return businessConfig.getMaxObjectDedupedNum();
    }

    public TaskConfig getTaskConfig() {
        return taskConfig;
    }

    public int getOisObjectCheckerPoolSize() {
        int poolSize = 1;
        try {
            poolSize = sysConfig.getOisObjectCheckerPoolSize();
        }
        catch (RuntimeException e) {
            poolSize = 0;
        }
        if (poolSize <= 0) {
            poolSize = 30;
        }
        return poolSize;
    }

    public int getClusterAbility() {
        return sysConfig.getClusterAbility();
    }

    public String getClusterId() {
        return sysConfig.getClusterId();
    }

    public String getConsoleOrigin() {
        return businessConfig.getConsoleOrigin();
    }

    public boolean isAccessLogOpen() {
        return businessConfig.isAccessLogOpen();
    }

    public boolean isInnerAccessBucketActive() {
        return businessConfig.isInnerAccessBucketActive();
    }

    public boolean isAbortMultiLc2Ccdb() {
        return businessConfig.isAbortMultiLc2Ccdb();
    }

    public boolean isInnerAccessBucketOpen() {
        return businessConfig.isInnerAccessBucketOpen();
    }

    public int getInnerAccessBucketRetention() {
        return businessConfig.getInnerAccessBucketRetention();
    }

    public int getInnerAccessBucketRecycleTime() {
        return businessConfig.getInnerAccessBucketRecycleTime();
    }

    public boolean isInnerMgcBucketOpen() {
        return businessConfig.isInnerMgcBucketOpen();
    }

    public int getInnerMgcBucketRetention() {
        return businessConfig.getInnerMgcBucketRetention();
    }

    public int getInnerMgcBucketRecycleTime() {
        return businessConfig.getInnerMgcBucketRecycleTime();
    }

    public String getInnerAccessBucketNameSuffix() {
        return businessConfig.getInnerAccessBucketNameSuffix();
    }

    public long getInnerAccessBucketCapacity() {
        return businessConfig.getInnerAccessBucketCapacity();
    }

    public long getStsXattrCapacity() {
        return businessConfig.getStsXattrCapacity();
    }

    public int getStsRecCoreThreadNum() {
        return businessConfig.getStsRecCoreThreadNum();
    }

    public int getStsRecTotalThreadNum() {
        return businessConfig.getStsRecTotalThreadNum();
    }

    public boolean isGetAccessLogOpen() {
        return businessConfig.isGetAccessLogOpen();
    }

    public boolean isMeterAccessLogOpen() {
        return businessConfig.isMeterAccessLogOpen();
    }

    public boolean isCESAccessLogOpen() {
        return businessConfig.isCESAccessLogOpen();
    }

    public boolean isReadMetaFromRemoteOpen() {
        return businessConfig.isReadMetaFromRemoteOpen();
    }

    public boolean isAutoSwitchWhenMasterAbnormal() {
        return businessConfig.isAutoSwitchWhenMasterAbnormal();
    }

    public boolean isAllowedReadInStandy() {
        return businessConfig.isAllowedReadInStandy();
    }

    public long getBucketCleanTime() {
        if (this.isEnterpriseMode()) {
            int delayTimeOfUserClean = KVConfig.INSTANCE.getIntValue("user_data_clean_time", 0);
            return delayTimeOfUserClean != 0 ? (long)delayTimeOfUserClean : mdcConfig.getBucketCleanTime();
        }
        return mdcConfig.getBucketCleanTime();
    }

    public int getMdcHttpSocketTimeoutInMs() {
        return mdcConfig.getHttpSocketTimeoutInMs();
    }

    public int getMdcHttpConectionTimeOutInMs() {
        return mdcConfig.getHttpConnectionTimeOutInMs();
    }

    public boolean isSlaveDcTakeOverSwitchOpen() {
        return sysConfig.isSlaveDcTakeOverSwitchOpen();
    }

    public long getCheckObjectLifeCycleTaskPeriod() {
        long cycle = 3600L;
        try {
            cycle = sysConfig.getCheckObjectLifeCycleTaskPeriod();
        }
        catch (RuntimeException e) {
            cycle = 0L;
        }
        if (cycle <= 0L) {
            cycle = 3600L;
        }
        return cycle;
    }

    public long getCheckObjectLifeCycleTimeout() {
        long timeout = 21600L;
        try {
            timeout = sysConfig.getCheckObjectLifeCycleTimeout();
        }
        catch (RuntimeException e) {
            timeout = 0L;
        }
        if (timeout <= 0L) {
            timeout = 21600L;
        }
        return timeout;
    }

    public long getRepairClusterDgFlagTaskPeriod() {
        long value = sysConfig.getRepairClusterDgFlagTaskPeriod();
        if (value <= 0L) {
            value = 3600L;
        }
        return value;
    }

    public long getRepairBucketIndexTaskPeriod() {
        long value = sysConfig.getRepairBucketIndexTaskPeriod();
        if (value <= 0L) {
            value = 60L;
        }
        return value;
    }

    public long getCleanBucketIndexTaskPeriod() {
        long value = sysConfig.getCleanBucketIndexTaskPeriod();
        if (value <= 0L) {
            value = 14400L;
        }
        return value;
    }

    public int getScanIndexRecordDelayLogicTime() {
        int value = sysConfig.getScanIndexRecordDelayLogicTime();
        if (value <= 0) {
            value = 3;
        }
        return value;
    }

    public long getRepSwitchNormalKeepTime() {
        long value = sysConfig.getRepSwitchNormalKeepTime();
        if (value <= 0L) {
            value = 86400000L;
        }
        return value;
    }

    public long getRepairDegradeReadyBucketTaskPeriod() {
        long value = sysConfig.getRepairDegradeReadyBucketTaskPeriod();
        if (value <= 0L) {
            value = 300000L;
        }
        return value;
    }

    public long getListMultiPartWeight() {
        long value = 30L;
        try {
            value = this.getConfig().getLong("list_multi_part_weight", 30L);
        }
        catch (RuntimeException e) {
            value = 0L;
        }
        if (value <= 0L) {
            value = 30L;
        }
        return value;
    }

    public int getMultiPartThreadNumber() {
        return sysConfig.getMultiPartThreadNumber();
    }

    public int getSecretKeyScannerThreadNumber() {
        return sysConfig.getSecretKeyScannerThreadNumber();
    }

    public int getFsMultiPartMovedThreadNumber() {
        return sysConfig.getFsMultiPartMovedThreadNumber();
    }

    public int getMultiPartQueueNumber() {
        return sysConfig.getMultiPartQueueNumber();
    }

    public int getRepairDegradeReadyBucketRunningNum() {
        int value = sysConfig.getRepairDegradeReadyBucketRunningNum();
        if (value <= 0) {
            value = 3;
        }
        return value;
    }

    public int getRepairAndMarkMinIntervalLogicTime() {
        int value = 2;
        try {
            value = this.getConfig().getInt("repair_and_mark_min_interval_logic_time", 2);
        }
        catch (RuntimeException e) {
            value = 0;
        }
        if (value <= 0) {
            value = 2;
        }
        return value;
    }

    public long getAvailableMaxIntervalTime() {
        long value = 600000L;
        try {
            value = this.getConfig().getInt("task_available_max_interval_time", 600000);
        }
        catch (Exception e) {
            value = 0L;
        }
        if (value <= 0L) {
            value = 600000L;
        }
        return value;
    }

    public long getUpdateIntervalTime() {
        long value = 300000L;
        try {
            value = this.getConfig().getInt("task_update_interval_time", 300000);
        }
        catch (Exception e) {
            value = 0L;
        }
        if (value <= 0L) {
            value = 300000L;
        }
        return value;
    }

    public long getPrimaryMaxWaitTime() {
        long value;
        try {
            value = this.getConfig().getInt("node_monitor_wait_time", 15000);
        }
        catch (Exception e) {
            value = 15000L;
        }
        if (value <= 0L) {
            value = 15000L;
        }
        return value;
    }

    public int getBuildBucketLocationTaskPeriod() {
        int value = sysConfig.getBuildBucketLocationTaskPeriod();
        if (value <= 0) {
            value = 10;
        }
        return value;
    }

    public long getBuildBucketLocationTaskExpried() {
        long value = sysConfig.getBuildBucketLocationTaskExpried();
        if (value <= 0L) {
            value = 1800000L;
        }
        return value;
    }

    public int getBuildBucketLocationThreadNum() {
        int value = sysConfig.getBuildBucketLocationThreadNum();
        if (value <= 0) {
            value = 30;
        }
        return value;
    }

    public int getRepairOldObjRepLogTaskPeriod() {
        int value = sysConfig.getRepairOldObjRepLogTaskPeriod();
        if (value <= 0) {
            value = 3600;
        }
        return value;
    }

    public long getRepairOldObjRepLogTaskExpried() {
        long value = sysConfig.getRepairOldObjRepLogTaskExpried();
        if (value <= 0L) {
            value = 0x6DDD00L;
        }
        return value;
    }

    public int getRepairOldObjRepLogThreadNum() {
        int value = sysConfig.getRepairOldObjRepLogThreadNum();
        if (value <= 0) {
            value = 10;
        }
        return value;
    }

    public long getRepairOldObjRepLogTaskExpriedCreate() {
        long value = sysConfig.getRepairOldObjRepLogTaskExpriedCreate();
        if (value <= 0L) {
            value = 86400000L;
        }
        return value;
    }

    public int getRepairBucketOldObjRepLogThreadNum() {
        int value = sysConfig.getRepairBucketOldObjRepLogThreadNum();
        if (value <= 0) {
            value = 20;
        }
        return value;
    }

    public long getRepairBucketOldObjRepLogTaskToleranceTime() {
        long value = sysConfig.getRepairBucketOldObjRepLogTaskToleranceTime();
        if (value <= 0L) {
            value = 172800000L;
        }
        return value;
    }

    public int getObsQueueRegionManageTaskNum() {
        int value = sysConfig.getObsQueueRegionManageTaskNum();
        if (value <= 0) {
            value = 20;
        }
        return value;
    }

    public long getFixMetaClock() {
        long value = sysConfig.getFixMetaClock();
        if (value <= 0L) {
            value = 1000L;
        }
        return value;
    }

    public long getCheckObjectLifeCycleBucketTaskTimeout() {
        long timeout = sysConfig.getCheckObjectLifeCycleBucketTaskTimeout();
        if (timeout <= 0L) {
            timeout = 86400L;
        }
        return timeout;
    }

    public long getCheckAllObjectLifeCycleBucketTaskInternal() {
        long timeout = sysConfig.getCheckAllObjectLifeCycleBucketTaskInternal();
        if (timeout <= 0L) {
            timeout = 604800L;
        }
        return timeout;
    }

    public long getDefaultCacheExpireTime() {
        long timeout = sysConfig.getLocalCacheLsExpireTime();
        if (timeout <= 0L) {
            timeout = 3600L;
        }
        return timeout;
    }

    public boolean isBucketAccessLogLocalConfigurated() {
        return businessConfig.isBucketAccessLogLocalConfigurated();
    }

    public boolean isMultiversionSupport() {
        return sysConfig.isMultiversionSupport();
    }

    public boolean isRestrictedStatusClosed() {
        return sysConfig.isRestrictedStatusClosed();
    }

    public String getWebsiteHomeLocation() {
        return businessConfig.getWebsiteHomeLocation();
    }

    public boolean isSendTaskSwitchOpen() {
        return businessConfig.isSendTaskSwitchOpen();
    }

    public boolean isReceiveTaskSwitchOpen() {
        return businessConfig.isReceiveTaskSwitchOpen();
    }

    public boolean getConflictBucketSwitch() {
        return businessConfig.getConflictBucketSwitch();
    }

    public String getLifecycleExecutionTimeSegment() {
        return businessConfig.getLifecycleExecutionTimeSegment();
    }

    public boolean getConflictBucketClusterCheckSwitch() {
        return businessConfig.getConflictBucketClusterCheckSwitch();
    }

    public String getConflictBucketClusterCheckIPs() {
        return businessConfig.getConflictBucketClusterCheckIPs();
    }

    public boolean isReducedMeta() {
        return businessConfig.isReducedMeta();
    }

    public long getControlIOSizeBandwidth() {
        return sysConfig.getControlIOSizeBandwidth();
    }

    public boolean isSwiftEnable() {
        try {
            if (this.isswiftEnable == null) {
                this.isswiftEnable = this.getConfig().getBoolean("swift_enable", false);
            }
        }
        catch (RuntimeException e) {
            this.isswiftEnable = false;
        }
        return this.isswiftEnable;
    }

    public boolean isRepair330BEnable() {
        return sysConfig.isRepair330BEnable();
    }

    public boolean isCrossDomianEnable() {
        return sysConfig.isCrossDomianEnable();
    }

    public boolean isSwiftSwitch() {
        return sysConfig.isSwiftSwitch();
    }

    public RolesContainer getRolesPolicy() {
        return this.roleConfig.getRolesPolicy();
    }

    public long getLastChunkSkipTimeout() {
        return sysConfig.getLastChunkSkipTimeout();
    }

    public int getInitialized() {
        return multiazConfig.getInitialized();
    }

    public boolean getClusterInitializedStatus() {
        return this.getInitialized() == 1;
    }

    public String getRegionName() {
        return multiazConfig.getRegionName();
    }

    public String getDefaultRegion() {
        return multiazConfig.getDefaultRegion();
    }

    public boolean getAuthLocationEnableStatus() {
        return multiazConfig.getAuthLocation() == 1;
    }

    public boolean isKeystone() {
        return "Keystone".equals(multiazConfig.getAuthType());
    }

    public boolean isAccountVersionEnable() {
        return sysConfig.isAccountVersionCheckEnable();
    }

    public boolean isIAM() {
        return "IAM".equals(multiazConfig.getAuthType());
    }

    public boolean isClusterIn() {
        return "cluster_in".equals(multiazConfig.getAuthType());
    }

    public boolean isPOEAuth() {
        return "POE".equals(multiazConfig.getAuthType());
    }

    public boolean isMultiAZ() {
        return multiazConfig.getIsMultiAZ() == 1;
    }

    public int getAuthLocation() {
        return multiazConfig.getAuthLocation();
    }

    public String getRLSIntranetAddrM() {
        return multiazConfig.getRLSIntranetAddrM();
    }

    public String getRLSIntranetAddrS() {
        return multiazConfig.getRLSIntranetAddrS();
    }

    public String getLSBusinessPort() {
        return multiazConfig.getLSBusinessPort();
    }

    public String getPOERole() {
        return multiazConfig.getPOERole();
    }

    public String getOscAuthVersion() {
        return sysConfig.getOscAuthVersion();
    }

    public boolean isS3SupportHttpRequest() {
        return sysConfig.isOscHttpSwitch();
    }

    public String getMemAlarmThreshold() {
        return sysConfig.getMemAlarmThreshold();
    }

    public boolean isOscPassiveWriteOpen() {
        return sysConfig.isOscPassiveWriteOpen();
    }

    public boolean isForceCreateOpen() {
        return sysConfig.isForceCreateOpen();
    }

    public String getTierStorageClass() {
        return sysConfig.getTierStorageClass();
    }

    public int getTierVendor() {
        return sysConfig.getTierVendor();
    }

    public boolean isNeedAuthProxyByOSC() {
        return sysConfig.isNeedAuthProxyByOSC();
    }

    public int getParallelFactor() {
        logger.debug("Began to get parallel factor value from config file.");
        int parallelFactor = 1;
        int defaultParallelFactor = 1;
        int maxParallelFactor = 32;
        parallelFactor = sysConfig.getParallelFactor();
        if (parallelFactor < 1 || parallelFactor > maxParallelFactor) {
            logger.warn("The parallel factor is out of range, using default value = {}.", (Object)defaultParallelFactor);
            parallelFactor = defaultParallelFactor;
        }
        logger.debug("Using parallel factor, value = {}", (Object)parallelFactor);
        return parallelFactor;
    }

    public void setParallelFactor(int parallelFactor) {
        sysConfig.setParallelFactor(parallelFactor);
    }

    public boolean getServerSideEncryptionHttps() {
        return businessConfig.getServerSideEncryptionHttps();
    }

    public boolean getServerSideEncryptionKmsV4() {
        return businessConfig.getServerSideEncryptionKmsV4();
    }

    public boolean getServerSideEncryptionSsecV4() {
        return businessConfig.getServerSideEncryptionSsecV4();
    }

    public boolean getServerSideEncryptionEnable() {
        return businessConfig.getServerSideEncryptionEnable();
    }

    public String getServerSideEncryptionKmsCmkIdAlias() {
        return businessConfig.getServerSideEncryptionKmsCmkIdAlias();
    }

    public boolean isBucketEncryptionOpen() {
        return KVConfig.INSTANCE.getBoolValue("bucket_encryption_config_switch", false);
    }

    public String getKmsCmkIdListLimit() {
        return businessConfig.getKmsCmkListLimit();
    }

    public String getKmsTransportLayer() {
        return businessConfig.getKmsTransportLayer();
    }

    public String getKmsTargetHostname() {
        return businessConfig.getKmsTargetHostname();
    }

    public String getKmsKeyStoreLocation() {
        return businessConfig.getKmsKeyStoreLocation();
    }

    public String getKmsKeyStorePW() {
        return businessConfig.getKmsKeyStorePW();
    }

    public String getKmsTrustStorePW() {
        return businessConfig.getKmsTrustStorePW();
    }

    public String getKmsTrustStoreFileName() {
        return businessConfig.getKmsTrustStoreFileName();
    }

    public String getConnectKmsType() {
        return businessConfig.getConnectKmsType();
    }

    public int getKMSClientMaxConnections() {
        return businessConfig.getKmsClientMaxConnections();
    }

    public String getStaticXMLNamespace() {
        if (StringUtils.isNotBlank((CharSequence)this.responseNamespace)) {
            return this.responseNamespace;
        }
        return "http://obs.myclouds.com/doc/2015-06-30/";
    }

    public String getObsResponseNamespace() {
        if (StringUtils.isNotBlank((CharSequence)this.obsResponseNamespace)) {
            return this.obsResponseNamespace;
        }
        return "http://obs.myclouds.com/doc/2015-06-30/";
    }

    public void setStaticXMLNamespace(String responseNamespace) {
        this.responseNamespace = responseNamespace;
    }

    public void setObsResponseNamespace(String obsResponseNamespace) {
        this.obsResponseNamespace = obsResponseNamespace;
    }

    public boolean isNeedAddMDCMSGVersion() {
        return mdcConfig.isNeedAddMDCMSGVersion();
    }

    public int getScanBucket2DeleteTaskPriority() {
        return sysConfig.getScanBucket2DeleteTaskPriority();
    }

    public int getRepairAndMarkMultiPartTaskPriority() {
        return this.getConfig().getInt("repairAndMarkMultiPartPriority", 4);
    }

    public int getBucketDeleteTaskPriority() {
        return sysConfig.getBucketDeleteTaskPriority();
    }

    public long getScanBucket2DelPeriod() {
        return sysConfig.getScanBucket2DelPeriod();
    }

    public int getRepairAndMarkMultiPartPeriod() {
        return sysConfig.getRepairAndMarkMultiPartPeriod();
    }

    public int getFsCleanTaskRecordPeriod() {
        return sysConfig.getFsCleanTaskRecordPeriod();
    }

    public long getAlarmCheckerPeriod() {
        return sysConfig.getAlarmCheckerPeriod();
    }

    public long getCpuMonitorPeriod() {
        return sysConfig.getCpuMonitorPeriod();
    }

    public boolean getIsRangerPolicySaveToLocalFile() {
        return sysConfig.isRangerPolicySaveToLocalFile();
    }

    public long getRangerPolicyTotalSize() {
        return sysConfig.getRangerPolicyTotalSize();
    }

    public int getRepMode() {
        return repConfig.getRepMode();
    }

    public int getRepHighAvailabilityNrwR() {
        return repConfig.getRepHighAvailabilityNrwR();
    }

    public int getRepHighAvailabilityNrwW() {
        return repConfig.getRepHighAvailabilityNrwW();
    }

    public int getRepHighReliabilityNrwR() {
        return repConfig.getRepHighReliabilityNrwR();
    }

    public int getRepHighReliabilityNrwW() {
        return repConfig.getRepHighReliabilityNrwW();
    }

    public int getRepLogParallelNum() {
        return repConfig.getRepLogParallelNum();
    }

    public int getRepLogRepSwitchParallelNum() {
        return repConfig.getRepLogRepSwitchParallelNum();
    }

    public int getRepLogSpecialParallelNum() {
        return repConfig.getRepLogSpecialParallelNum();
    }

    public int getRepLogParallelSecondHash() {
        return repConfig.getRepLogParallelSecondHash();
    }

    public int getRepLogStatusMaxItem() {
        return repConfig.getRepLogStatusMaxItem();
    }

    public int getRepLogEntryMaxItem() {
        return repConfig.getRepLogEntryMaxItem();
    }

    public int getRepLogSwitchTimeoutMinute() {
        return repConfig.getRepLogSwitchTimeoutMinute();
    }

    public int getRepLogSwitchSysRepFailedMinute() {
        return repConfig.getRepLogSwitchSysRepFailedMinute();
    }

    public int getRepEntryStatusFlushThreshold() {
        return repConfig.getRepEntryStatusFlushThreshold();
    }

    public int getRepLogDeleteScanPeriodMinute() {
        return repConfig.getRepLogDeleteScanPeriodMinute();
    }

    public int getRepSyncRepWorkQueueCapacity() {
        return repConfig.getRepSyncRepWorkQueueCapacity();
    }

    public int getRepDataRecoverDefaultThreadNum() {
        return repConfig.getRepDataRecoverDefaultThreadNum();
    }

    public int getRepDataRecoverMaxThreadNum() {
        return repConfig.getRepDataRecoverMaxThreadNum();
    }

    public int getRepDataRecoverWorkQueueCapacity() {
        return repConfig.getRepDataRecoverWorkQueueCapacity();
    }

    public int getRepDataRecoverTaskQueueCapacity() {
        return repConfig.getRepDataRecoverTaskQueueCapacity();
    }

    public int getRepMsgProcessDefaultThreadNum() {
        return repConfig.getRepMsgProcessDefaultThreadNum();
    }

    public int getRepMsgProcessMaxThreadNum() {
        return repConfig.getRepMsgProcessMaxThreadNum();
    }

    public int getRepMsgProcessWorkQueueCapacity() {
        return repConfig.getRepMsgProcessWorkQueueCapacity();
    }

    public int getRepAddTaskFailMaxTryNum() {
        return repConfig.getRepAddTaskFailMaxTryNum();
    }

    public int getRepAddTaskFailSleepTimeMs() {
        return repConfig.getRepAddTaskFailSleepTimeMs();
    }

    public int getRepLogStatusMaxCacheNum() {
        return repConfig.getRepLogStatusMaxCacheNum();
    }

    public int getRepLogHeaderMaxCacheNum() {
        return repConfig.getRepLogHeaderMaxCacheNum();
    }

    public int getRepDataRecoverScanPeriodS() {
        return repConfig.getRepDataRecoverScanPeriodS();
    }

    public int getRepDataRecoverDispatchPeriodS() {
        return repConfig.getRepDataRecoverDispatchPeriodS();
    }

    public int getRepLogDeletePeriod() {
        return repConfig.getRepLogDeletePeriod();
    }

    public int getRepLogsStorageMaxNum() {
        return repConfig.getRepLogsStorageMaxNum();
    }

    public int getRepDataRecoverScanMode() {
        return repConfig.getRepDataRecoverScanMode();
    }

    public int getRepMoveStatusCursorInterval() {
        return repConfig.getRepMoveStatusCursorInterval();
    }

    public int getRepStateMaxRetryTimes() {
        return repConfig.getRepStateMaxRetryTimes();
    }

    public int getRepMinRetryIntervalMs() {
        return repConfig.getRepMinRetryIntervalMs();
    }

    public int getRepDelEntryLogTimeoutMin() {
        return repConfig.getDelEntryLogTimeoutMin();
    }

    public int getEnableMmlCompile() {
        return repConfig.getEnableMmlCompile();
    }

    public int getHighCPUUsagePercent() {
        return repConfig.getHighCPUUsagePercent();
    }

    public int getLowCPUUsagePercent() {
        return repConfig.getLowCPUUsagePercent();
    }

    public int getRepCPUUsageMode() {
        return repConfig.getRepCPUUsageMode();
    }

    public int getMasternodeMaxLostCount() {
        return repConfig.getMasternodeMaxLostCount();
    }

    public int getHeartbeatMaxLostCount() {
        return repConfig.getHeartbeatMaxLostCount();
    }

    public int getRepSendMsgRetrytime() {
        return repConfig.getRepSendMsgRetrytime();
    }

    public int getRepMaxTakeoverNum() {
        return repConfig.getRepMaxTakeoverNum();
    }

    public boolean isFsPartLayoutMoveAsyncSwitch() {
        return businessConfig.isFsPartLayoutMoveAsyncSwitch();
    }

    public boolean isCorsUploadSwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("cors_upload_is_open", true);
    }

    public boolean isPulsarSwitchOpen() {
        return pulsarAthenzConfig.isPulsarSwitchOpen();
    }

    public String getPulsarAddress() {
        return pulsarAthenzConfig.getPulsarAddress();
    }

    public String getPulsarAuthTenantDomain() {
        return pulsarAthenzConfig.getTenantDomain();
    }

    public String getPulsarAuthTenantService() {
        return pulsarAthenzConfig.getTenantService();
    }

    public String getPulsarAuthProviderDomain() {
        return pulsarAthenzConfig.getProviderDomain();
    }

    public String getPulsarAuthKeyId() {
        return pulsarAthenzConfig.getKeyId();
    }

    public String getPulsarAuthPrivateKey() {
        return pulsarAthenzConfig.getPrivateKey();
    }

    public String getPulsarAthenzConfPath() {
        return pulsarAthenzConfig.getAthenzConfPath();
    }

    public String getPulsarAthenzPrincipalHeader() {
        return pulsarAthenzConfig.getPrincipalHeader();
    }

    public String getPulsarAthenzRoleHeader() {
        return pulsarAthenzConfig.getRoleHeader();
    }

    public String getPulsarAthenzZtsUrl() {
        return pulsarAthenzConfig.getZtsUrl();
    }

    public String getPulsarTlsCertFile() {
        return pulsarAthenzConfig.getTlsCertFile();
    }

    public String getPulsarTlsKeyFile() {
        return pulsarAthenzConfig.getTlsKeyFile();
    }

    public String getPulsarCacertPath() {
        return pulsarAthenzConfig.getPulsarCacertPath();
    }

    public boolean isSMNSwitchOpen() {
        return businessConfig.isSMNSwitchOpen();
    }

    public String getSMNAddress() {
        return businessConfig.getSMNAddress();
    }

    public String getSMNTopicUrn() {
        return KVConfig.INSTANCE.getStringValue("smn_topic_urn", "");
    }

    public String getCDNAddress() {
        return KVConfig.INSTANCE.getStringValue("cdn_address", "");
    }

    public boolean isCloudFunctionSwitchOpen() {
        return businessConfig.isCloudFunctionSwitchOpen(this.getConfig());
    }

    public String getCloudFunctionAddress() {
        return businessConfig.getCloudFunctionAddress(this.getConfig());
    }

    public boolean isFunctionGraphSwitchOpen() {
        return businessConfig.isFunctionGraphSwitchOpen(this.getConfig());
    }

    public String getFunctionGraphAddress() {
        return businessConfig.getFunctionGraphAddress(this.getConfig());
    }

    public String getAdminTokenRolesName() {
        return KVConfig.INSTANCE.getStringValue("admin_token_roles_name", "op_service");
    }

    public String getFunctionGraphUrnCheckAddress() {
        return businessConfig.getFunctionGraphUrnCheckAddress(this.getConfig());
    }

    public boolean isRecordCtsLogWithRequestBodyOpen() {
        return KVConfig.INSTANCE.getBoolValue("cts_log_with_request_body_switch", false);
    }

    public boolean isImageTranscodeOpen() {
        return businessConfig.isImageTranscodeOpen(this.getConfig());
    }

    public boolean imgTranscodeRouteOpen() {
        return businessConfig.imgTranscodeRouteOpen(this.getConfig());
    }

    public String getImgTransAddress() {
        return businessConfig.getImgTransAddress(this.getConfig());
    }

    public boolean imgS3SignatureHttpsOnly() {
        return businessConfig.imgS3SignatureHttpsOnly(this.getConfig());
    }

    public boolean imgS3SignatureGen() {
        return businessConfig.imgS3SignatureGen(this.getConfig());
    }

    @Deprecated
    public String getImageCommandPattern() {
        return this.getConfig().getString("img_cmd_pattern", DefaultConfBusiness.DEFAULT_IMG_CMD_PATTERN);
    }

    @Deprecated
    public String getImageStylePattern() {
        return this.getConfig().getString("img_style_pattern", "^style/[\\.a-z0-9A-Z_-]*$");
    }

    @Deprecated
    public int getImageCmdMaxLenth() {
        return this.getConfig().getInt("img_cmd_max_length", 512);
    }

    @Deprecated
    public long getImageMaxLenth() {
        return this.getConfig().getLong("img_max_length", 0x1400000L);
    }

    @Deprecated
    public String getImageNameSuffixPattern() {
        return this.getConfig().getString("img_name_suffix_pattern", "^.+\\.(jpg)|(jpeg)|(png)|(bmp)|(webp)|(gif)|(tiff)$");
    }

    public String getQiNiuHeader() {
        return KVConfig.INSTANCE.getStringValue("img_qiniu_header", "imageMogr2,imageView2,watermark,imageslim,imageInfo,imageAve,exif,roundPic");
    }

    public String getALIWhiteList() {
        return KVConfig.INSTANCE.getStringValue("img_ali_whitelist", "");
    }

    public String getQiNiuWhiteList() {
        return KVConfig.INSTANCE.getStringValue("img_qiniu_whitelist", "");
    }

    public String getPOEServiceEndpoint() {
        return KVConfig.INSTANCE.getStringValue("v1r2_cluster_poe_float_ip", "");
    }

    public List<String> getUserWhiteList() {
        String whitelistStr = businessConfig.getUserWhitelistStr();
        ArrayList<String> whitelist = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)whitelistStr)) {
            whitelist.addAll(Arrays.asList(whitelistStr.split(";")));
        }
        return whitelist;
    }

    public long getKVPerformanceStatInterval() {
        return businessConfig.getKVPerformanceStatInterval();
    }

    public String getBackendThreadPrefixt() {
        return businessConfig.getBackendThreadPrefixt();
    }

    public boolean isAbsoluteRedirectUrl() {
        return businessConfig.isAbsoluteRedirectUrl(this.getConfig());
    }

    public int getRepAlarmScanPeriodS() {
        return repConfig.getRepAlarmScanPeriodS();
    }

    public int getRepRecoverReportAlarmThreshold() {
        return repConfig.getRepRecoverReportAlarmThreshold();
    }

    public int getRepRecoverFailedThreshold() {
        return repConfig.getRepRecoverFailedThreshold();
    }

    public int getRepRecoverCounterSwitch() {
        return repConfig.getRepRecoverCounterSwitch();
    }

    public boolean isRepBgTaskEnable() {
        return repConfig.isRepBgTaskEnabled();
    }

    public int getRepKeyMetadataBackupPeriod() {
        return repConfig.getRepKeyMetadataBackupPeriod();
    }

    public long getCacheExpireTime() {
        return sysConfig.getClusterCacheExpireTime();
    }

    public Integer getBucketThreads() {
        return sysConfig.getClusterBucketThreads();
    }

    public Integer getPerUserTime() {
        return sysConfig.getClusterPerUserTime();
    }

    public Integer getHandleUsers() {
        return sysConfig.getClusterPerThreadHandleUsers();
    }

    public int getRepSwitchLib2DPriority() {
        return taskConfig.getRepSwitchLib2DPriority();
    }

    public Integer getListS3ReqPoolMaxSize() {
        return sysConfig.getListS3ReqPoolMaxSize();
    }

    public Integer getListMaxSize4LsAndPoe() {
        return sysConfig.getListMaxSize4LsAndPoe();
    }

    public boolean isStripRead() {
        return this.getConfig().getBoolean("is_strip_read", true);
    }

    public int getRemoteChannelGiveupTimeS() {
        return mdcConfig.getRemoteChannelGiveupTimeS();
    }

    public int getParellelDataStreamTimeoutMs() {
        return mdcConfig.getParellelDataStreamTimeoutMs();
    }

    public int getForwardSocketTimeoutMs() {
        return mdcConfig.getForwardSocketTimeoutMs();
    }

    public boolean getTimeoutNeedRetry() {
        return mdcConfig.getTimeoutNeedRetry();
    }

    public int getTimeoutNeedRetryTimes() {
        return mdcConfig.getTimeoutNeedRetryTimes();
    }

    public int getFileInitMirrorPlogNum() {
        return ospConfig.getInitFileMirrorPlogNum();
    }

    public int getFileMaxMirrorPlogNum() {
        return ospConfig.getMaxFileMirrorPlogNum();
    }

    public int getFileInitECPlogNum() {
        return ospConfig.getInitFileECPlogNum();
    }

    public int getFileMaxECPlogNum() {
        return ospConfig.getMaxFileECPlogNum();
    }

    public int getFileInitPartECPlogNum() {
        return ospConfig.getInitFilePartECPlogNum();
    }

    public int getFileMaxPartECPlogNum() {
        return ospConfig.getMaxFilePartECPlogNum();
    }

    public int getFsBigIoLength() {
        return ospConfig.getFsBigIoLength();
    }

    public boolean getAllowDeleteWhenUserInactive() {
        return sysConfig.getAllowDeleteWhenUserInactive();
    }

    public int getMaintainPoolSize() {
        return businessConfig.getMaintainPoolSize();
    }

    public int getUsgaeScanAbnormalPlogInterval() {
        return taskConfig.getUsgaeScanAbnormalPlogInterval();
    }

    public long getIpRangeTpsGet() {
        return qosConfig.getIpRangeTpsGet();
    }

    public long getIpRangeTpsPut() {
        return qosConfig.getIpRangeTpsPut();
    }

    public long getIpRangeTpsList() {
        return qosConfig.getIpRangeTpsList();
    }

    public long getIpRangeBpsGet() {
        return qosConfig.getIpRangeBpsGet();
    }

    public long getIpRangeBpsPut() {
        return qosConfig.getIpRangeBpsPut();
    }

    public long getIpRangeConcurrentReq() {
        return qosConfig.getIpRangeConcurrentReq();
    }

    public String getIpRangeName() {
        return qosConfig.getIpRangeName();
    }

    public long getQosStatisticsPeriod() {
        return qosConfig.getQosStatisticsPeriod();
    }

    public long getDefaultBucketTpsGet() {
        return qosConfig.getDefaultBucketTpsGet();
    }

    public long getDefaultBucketTpsPutDel() {
        return qosConfig.getDefaultBucketTpsPutDel();
    }

    public long getDefaultBucketTpsGetPutDel() {
        return qosConfig.getDefaultBucketTpsGetPutDel();
    }

    public long getDefaultBucketTpsList() {
        return qosConfig.getDefaultBucketTpsList();
    }

    public long getDefaultBucketBpsGet() {
        return qosConfig.getDefaultBucketBpsGet();
    }

    public long getDefaultBucketBpsPut() {
        return qosConfig.getDefaultBucketBpsPut();
    }

    public long getDefaultBucketBpsGetPut() {
        return qosConfig.getDefaultBucketBpsGetPut();
    }

    public long getDefaultBucketConcurrentreq() {
        return qosConfig.getDefaultBucketConcurrentreq();
    }

    public int getDefaultBucketPriority() {
        return qosConfig.getDefaultBucketPriority();
    }

    public boolean isDefaultBucketQosSwitch() {
        return qosConfig.isDefaultBucketQosSwitch();
    }

    public boolean isIamAllCacheOpen() {
        return memcacheCofig.isIamAllCacheSwitchOpen();
    }

    public long getIamAllCacheTimeout() {
        return memcacheCofig.getIamAllCacheTimeout();
    }

    public int getIamUserCheckPeriod() {
        return memcacheCofig.getIamUserCheckPeriod();
    }

    public int getIamUserCheckTimes() {
        return memcacheCofig.getIamUserCheckTimes();
    }

    public long getDefaultClusterStatusTimeout() {
        return memcacheCofig.getDefaultClusterStatusTimeout();
    }

    public boolean isOverloadControlSwitch() {
        return qosConfig.isOverloadControlSwitch();
    }

    public boolean isOverloadchunkControlSwitch() {
        return qosConfig.isOverloadchunkControlSwitch();
    }

    public boolean isLoadNativeQosLibrary() {
        return qosConfig.isLoadNativeQosLibrary();
    }

    public boolean isQosInitEnable(boolean isInterWorking) {
        return qosConfig.isQosInitEnable(isInterWorking);
    }

    public boolean isOneTrunkToWrite() {
        return qosConfig.isOneTrunkToWrite();
    }

    public int getFrontTaskPriority() {
        return qosConfig.getFrontTaskPriority();
    }

    public long getDefaultAccountTpsGet() {
        return qosConfig.getDefaultAccountTpsGet();
    }

    public long getDefaultAccountTpsPutDel() {
        return qosConfig.getDefaultAccountTpsPutDel();
    }

    public long getDefaultAccountTpsGetPutDel() {
        return qosConfig.getDefaultAccountTpsGetPutDel();
    }

    public long getDefaultAccountTpsList() {
        return qosConfig.getDefaultAccountTpsList();
    }

    public long getDefaultAccountBpsGet() {
        return qosConfig.getDefaultAccountBpsGet();
    }

    public long getDefaultAccountBpsPut() {
        return qosConfig.getDefaultAccountBpsPut();
    }

    public long getDefaultAccountBpsGetPut() {
        return qosConfig.getDefaultAccountBpsGetPut();
    }

    public long getDefaultAccountConcurrentreq() {
        return qosConfig.getDefaultAccountConcurrentreq();
    }

    public boolean isDefaultAccountQosSwitch() {
        return qosConfig.isDefaultAccountQosSwitch();
    }

    public long getCrrQosLimitBpsGet() {
        return qosConfig.getCrrQosLimitBpsGet();
    }

    public long getCrrQosLimitConcurrentreq() {
        return qosConfig.getCrrQosLimitConcurrentreq();
    }

    public long getCrrQosLimitBpsPut() {
        return qosConfig.getCrrQosLimitBpsPut();
    }

    public long getCrrQosLimitTpsPutDel() {
        return qosConfig.getCrrQosLimitTpsPutDel();
    }

    public long getOTMQosLimitBpsGet() {
        return qosConfig.getOTMQosLimitBpsGet();
    }

    public long getOTMQosLimitConcurrentreq() {
        return qosConfig.getOTMQosLimitConcurrentreq();
    }

    public long getSMCQosLimitBpsPut() {
        return qosConfig.getSMCQosLimitBpsPut();
    }

    public long getSMCQosLimitConcurrentreq() {
        return qosConfig.getSMCQosLimitConcurrentreq();
    }

    public Properties getQosPriorityClassList() {
        return qosConfig.getPriorityClassList();
    }

    public long getQosPerConnectBps() {
        return qosConfig.getQosPerConnectBps();
    }

    public int getZookeeperSessionTimeout() {
        return this.getConfig().getInt("zookeeper_session_timeout_ms", 60000);
    }

    public int getZookeeperConnectionTimeout() {
        return this.getConfig().getInt("zookeeper_connection_timeout_ms", 30000);
    }

    public String getZookeeperHostPort() {
        return sysConfig.getZookeeperHostPort();
    }

    public String getZookeeperLogicClockNode() {
        return "/dfv/logicclock";
    }

    public int getMonitorLogicClockZkConfPeriod() {
        return sysConfig.getMonitorLogicClockZkConfPeriod();
    }

    public int getMonitorLogicClockStatusPeriod() {
        return sysConfig.getMonitorLogicClockStatusPeriod();
    }

    public int getLoggicClockUpdatePeriodThreshold() {
        return sysConfig.getLoggicClockUpdatePeriodThreshold();
    }

    public int getLoggicClockExpiredPeriodThreshold() {
        return this.getConfig().getInt("logicclock_expired_period_threshold", 120);
    }

    public int getLogicClockUnit() {
        return taskConfig.getLogicClockUpPeriod() * taskConfig.getLogicClockRepeatInterval();
    }

    public int getScanLifecycleBucketTaskNum() {
        return taskConfig.getScanLifecycleBucketTaskNum();
    }

    public int getLogicClockClientUpdateInterval() {
        return sysConfig.getLogicClockClientUpdateInterval();
    }

    public int getZkMsBetweenRetry() {
        return sysConfig.getZkMsBetweenRetry();
    }

    public int getWaitZookeeperAsycnSec() {
        return this.getConfig().getInt("wait_zookeeper_asycn_sec", 1000);
    }

    public String getWarmmingFormatArray(int index) {
        return warmMigConfig.getWarmingFormatArray(index);
    }

    public PropertiesConfiguration getConfig() {
        if (this.configBuilder == null) {
            try {
                String pro = null;
                return new Configurations().properties(pro);
            }
            catch (ConfigurationException e) {
                logger.error("Fatal error: No configBuilder found.");
            }
        }
        return this.configBuilder.getConfiguration();
    }

    public String getBillSdrHostIp() {
        return billConfig.getBillSdrHostIp(this.getConfig());
    }

    public String getBillSdrPassword() {
        return billConfig.getBillSdrPassword(this.getConfig());
    }

    public String getBillSdrUserName() {
        return billConfig.getBillSdrUserName(this.getConfig());
    }

    public String getBillSdrAuthMode() {
        return billConfig.getBillSdrAuthMode(this.getConfig());
    }

    public String getBillSdrPkFilePath() {
        return billConfig.getBillSdrPrivateKeyFilePath(this.getConfig());
    }

    public String getBillSdrSwitch() {
        return billConfig.getBillSdrSwitch(this.getConfig());
    }

    public String getBillSdrPassphrase() {
        return billConfig.getBillSdrPassphrase(this.getConfig());
    }

    public String getBillSdrOrigUploadPath() {
        return billConfig.getBillSdrOrigUploadPath(this.getConfig());
    }

    public String getBillSdrStorageUploadPath() {
        return billConfig.getBillSdrStorageUploadPath(this.getConfig());
    }

    public String getBillSdrRefreshTime() {
        return billConfig.getBillSdrRefreshTime(this.getConfig());
    }

    public String getBillSdrBucketName() {
        return billConfig.getBillBucketName();
    }

    public String getCESLogBucketName() {
        return businessConfig.getCESLogBucketName();
    }

    public String getBillSdrPort() {
        return billConfig.getBillPort(this.getConfig());
    }

    public int getFailedPartsNum() {
        return warmMigConfig.getFailedPartsNum();
    }

    public int getStandardRestoreMinTime() {
        return this.getConfig().getInt("restore_standard_min_time_in_mill_sec", 10800000);
    }

    public int getStandardRestoreMaxTime() {
        return this.getConfig().getInt("restore_standard_max_time_in_mill_sec", 18000000);
    }

    public int getExpeditedRestoreMinTime() {
        return this.getConfig().getInt("restore_expedited_min_time_in_mill_sec", 60000);
    }

    public int getExpeditedRestoreMaxTime() {
        return this.getConfig().getInt("restore_expedited_max_time_in_mill_sec", 300000);
    }

    public int getBulkRestoreMinTime() {
        return this.getConfig().getInt("restore_bulk_min_time_in_mill_sec", 18000000);
    }

    public int getBulkRestoreMaxTime() {
        return this.getConfig().getInt("restore_bulk_max_time_in_mill_sec", 43200000);
    }

    public int getMaxDaysOfRestoreRequest() {
        int maxDays;
        try {
            maxDays = this.getConfig().getInt("max_days_of_restore_req", 30);
        }
        catch (Exception e) {
            maxDays = 30;
        }
        return maxDays > 0 ? maxDays : 30;
    }

    public boolean isMigUseHttps() {
        return warmMigConfig.isMigHttps();
    }

    public boolean getBucketUsageCacheSwitch() {
        return sysConfig.getBucketUsageCacheSwitch();
    }

    public boolean getFsBucketUsageSwitch() {
        return sysConfig.getFsBucketUsageSwitch();
    }

    public int getFsBucketUsageBatchFlushCount() {
        return sysConfig.getFsBucketUsageBatchFlushCount();
    }

    public int getFsBucketUsagePreStopOscWaitCount() {
        return sysConfig.getFsBucketUsagePreStopOscWaitCount();
    }

    public boolean isFsBUDeltaCheckEnable() {
        return sysConfig.isFsBUDeltaCheckEnable();
    }

    public double getFsBUDeltaValidRatio() {
        return sysConfig.getFsBUDeltaValidRatio();
    }

    public boolean getFsBucketUsageValidCheck() {
        return sysConfig.getFsBucketUsageValidCheck();
    }

    public int getFsSwitchCacheThreadPeriod() {
        return sysConfig.getFsSwitchCacheThreadPeriod();
    }

    public int getFsDeleteObjChunkThreadNum() {
        return sysConfig.getFsDeleteObjChunkThreadNum();
    }

    public int getFsDeleteObjChunkQueCapatity() {
        return sysConfig.getFsDeleteObjChunkQueCapacity();
    }

    public int getFsDeleteObjChunkIntervalClock() {
        return sysConfig.getFsDeleteObjChunkIntervalClock();
    }

    public int getRquestTimedTaskPeriodS() {
        return sysConfig.getRquestTimedTaskPeriodS();
    }

    public int getRequestTimeoutS() {
        return sysConfig.getRequestTimeoutS();
    }

    public int getRequestInfoRemoveTimeS() {
        return sysConfig.getRequestInfoRemoveTimeS();
    }

    public boolean isAccessKeyNeedCheck() {
        return businessConfig.isAccessKeyNeedCheck(this.getConfig());
    }

    public List<String> getUsersAllowedToSpecifyLocation() {
        String usersStr = businessConfig.getUsersAllowedToSpecifyLocationStr(this.getConfig());
        ArrayList<String> userAccountIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)usersStr)) {
            userAccountIds.addAll(Arrays.asList(usersStr.split(";")));
        }
        return userAccountIds;
    }

    public boolean isBucketTaggingEnable() {
        return this.getBoolean("bucket_tagging_enable", true);
    }

    public String[] getBillList() {
        return sysConfig.getBillList();
    }

    public int getGCLogLifeCycleDay() {
        return this.getConfig().getInt("gc_log_lifecycle_day", 90);
    }

    public int getBULogLifeCycleDay() {
        return this.getConfig().getInt("bu_log_lifecycle_day", 90);
    }

    public int getSysBUlogIntervalTime() {
        return this.getConfig().getInt("bulog_file_interval", 60000);
    }

    public boolean isBUlogUploadEnable() {
        return this.getConfig().getBoolean("bulog_upload_enable", true);
    }

    public int getOISDelayResumeAlarmThreshold() {
        return this.getConfig().getInt("delay_resume_alarm_threshold", 4);
    }

    public boolean isSTSOpen() {
        return businessConfig.isSTSOpen(this.getConfig());
    }

    public boolean isRealNameAuthMasterSwitchOpen() {
        return sysConfig.isRealNameAuthMasterSwitchOpen();
    }

    public boolean isRealNameAuthStageTwoSwitchOpen() {
        return sysConfig.isRealNameAuthStageTwoSwitchOpen();
    }

    public boolean isRealNameAuthStageOneSwitchOpen() {
        return sysConfig.isRealNameAuthStageOneSwitchOpen();
    }

    public boolean isAllRequestNeedRealNameAuth() {
        boolean isAllRequestNeedRealNameAuth;
        try {
            isAllRequestNeedRealNameAuth = this.getConfig().getBoolean("all_request_need_realname_auth_switch", false);
        }
        catch (RuntimeException e) {
            isAllRequestNeedRealNameAuth = false;
        }
        return isAllRequestNeedRealNameAuth;
    }

    public boolean isRealNameAuthInternationalAccessGlobalSwitchOpen() {
        return sysConfig.isRealNameAuthInternationalAccessGlobalSwitchOpen();
    }

    public boolean isRealNameAuthMainlandAccessGlobalSwitchOpen() {
        return sysConfig.isRealNameAuthMainlandAccessGlobalSwitchOpen();
    }

    public long getCalRegionStatisTaskPeriod() {
        long period;
        try {
            period = sysConfig.getCalRegionStatisTaskPeriod();
        }
        catch (RuntimeException e) {
            period = 1800L;
        }
        if (period <= 0L) {
            period = 1800L;
        }
        return period;
    }

    public long getMonitorAzQosTaskPeriod() {
        return sysConfig.getMonitorAzQosTaskPeriod();
    }

    public boolean isOriginSourceOpen() {
        return businessConfig.getOriginSourceOpen();
    }

    public String getSupportAPI() {
        return sysConfig.getSupportAPI();
    }

    public String getDefaultAPI() {
        return sysConfig.getDefaultAPI();
    }

    public boolean isClusterAutoSwitch() {
        return sysConfig.isClusterAutoSwitch();
    }

    public int getClusterAutoSwitchTime() {
        return sysConfig.getClusterAutoSwitchTime();
    }

    public int getFlowControlConfig() {
        return sysConfig.getFlowControl();
    }

    public int getCdmConsumerTimeout() {
        return businessConfig.getCdmConsumerTimeout();
    }

    public long getPartMinSize() {
        return businessConfig.getPartMinSize();
    }

    public int getSendCdmMesasgeSize() {
        return businessConfig.getSendCdmMesasgeSize();
    }

    public String getCDMAddress() {
        return businessConfig.getCDMAddress();
    }

    public boolean isDataMigrationOpen() {
        return businessConfig.isDataMigrationOpen();
    }

    public int getCdmMaxQueueSize() {
        return businessConfig.getCdmMaxQueueSize();
    }

    public int getCdmMaxExtractorsNum() {
        return businessConfig.getCdmExtractorsNum();
    }

    public int getCdmRulesMaxCount() {
        return KVConfig.INSTANCE.getIntValue("cdm_rules_max_count", 5);
    }

    public long getStatisticsLogInvervalTime() {
        return sysConfig.getStatisticsLogCollectInterval();
    }

    public long getCDNMonitorStatisticsPeriod() {
        return KVConfig.INSTANCE.getLongValue("cdn_request_monitor_period", 3600L);
    }

    public int getMaxTagKeyLength() {
        return businessConfig.getMaxTagKeyLength();
    }

    public int getMaxTagValueLength() {
        return businessConfig.getMaxTagValueLength();
    }

    public int getMaxCountOfBucketTag() {
        return businessConfig.getMaxCountOfBucketTag();
    }

    public int getObjectMaxTagKeyLength() {
        return businessConfig.getObjectMaxTagKeyLength();
    }

    public int getObjectMaxTagValueLength() {
        return businessConfig.getObjectMaxTagValueLength();
    }

    public int getMaxCountOfObjectTag() {
        return businessConfig.getMaxCountOfObjectTag();
    }

    public int getMaxSizeOfObjectTag() {
        return businessConfig.getMaxSizeOfObjectTag();
    }

    public String getTagKeyPattern() {
        return businessConfig.getTagKeyPattern();
    }

    public String getTagValuePattern() {
        return businessConfig.getTagValuePattern();
    }

    public boolean isCalcBuImmediately() {
        return businessConfig.isCalcBuImmediately();
    }

    public Long getCheckObjectExpirationTaskPeriod() {
        long cycle = 3600L;
        try {
            cycle = sysConfig.getCheckObjectExpirationTaskPeriod();
        }
        catch (RuntimeException e) {
            cycle = 0L;
        }
        if (cycle <= 0L) {
            cycle = 3600L;
        }
        return cycle;
    }

    public int getScanObjectExpirationTaskNum() {
        return taskConfig.getScanObjectExpirationTaskNum();
    }

    public long getCheckObjectExpirationTaskTimeout() {
        long timeout = sysConfig.getCheckObjectExpirationTaskTimeout();
        if (timeout <= 0L) {
            timeout = 43200L;
        }
        return timeout;
    }

    public boolean isPartMetaCacheOpen() {
        return businessConfig.getPartMetaCacheOpen();
    }

    public int getParMetaCacheSize() {
        return OBSConfig.business().getParMetaCacheSize();
    }

    public boolean isHeadBucketOpen() {
        return businessConfig.isHeadBucketOpen();
    }

    public boolean isAllowHeadBucket() {
        return businessConfig.isAllowHeadBucket();
    }

    public boolean isDebugLogAllow() {
        return businessConfig.isDebugLogAllow();
    }

    public String getLsIpList() {
        String lsDomain;
        if (this.isEnterpriseMode() && !StringUtils.isBlank((CharSequence)(lsDomain = multiazConfig.getLsDomain()))) {
            return lsDomain;
        }
        return multiazConfig.getLsIpList();
    }

    public String getLsIpListpoe() {
        return multiazConfig.getLsIpList();
    }

    public String getMemcacheIpListPoe() {
        return memcacheCofig.getMemcacheIpList();
    }

    public String getLsRole() {
        return multiazConfig.getLSRole();
    }

    public String getVpcIpType() {
        return businessConfig.getVpcIpType();
    }

    public List<String> getVpcIpList() {
        return businessConfig.getVpcIpList();
    }

    public String getVpcUrl() {
        return businessConfig.getVpcUrl();
    }

    public String[] getVpcIdConfig() {
        return businessConfig.getVpcIdConfig();
    }

    public List<String> getVpcIdList() {
        return businessConfig.getVpcIdList();
    }

    public List<String> getTenantIdList() {
        return businessConfig.getTenantIdList();
    }

    public List<String> getVpcIdAndTenantIdList() {
        return businessConfig.getVpcIdAndTenantIdList();
    }

    public long getVPCKVPeriod() {
        return businessConfig.getVpcKVPeriod();
    }

    public long getSmcOscMonitorCycle() {
        return migratingConfig.getSmcOscMonitorCycle();
    }

    public boolean isCheckOSCHealth() {
        return migratingConfig.isCheckOSCHealth();
    }

    public long getSmcNodeAsyncMonitorCycle() {
        return migratingConfig.getSmcNodeAsyncMonitorCycle();
    }

    public int getSmcMigratingCreateTimeout() {
        return migratingConfig.getSmcMigratingCreateTimeout();
    }

    public int getSmcMigratingUpdateTimeout() {
        return migratingConfig.getSmcMigratingUpdateTimeout();
    }

    public int getSmcMaxObjectNum() {
        return migratingConfig.getSmcMaxObjectNum();
    }

    public long getSMCQosLimitTpsPut() {
        return qosConfig.getSMCQosLimitTpsPut();
    }

    public int getCdmConsumerThreadNumber() {
        return businessConfig.getCdmConsumerThreadNumber();
    }

    public String getShortConnectionsBuckets() {
        return sysConfig.getShortConnectionsBuckets();
    }

    public String getShortConnectionsUsers() {
        return sysConfig.getShortConnectionsUsers();
    }

    public Boolean is3AZOpen() {
        return KVConfig.INSTANCE.getBoolValue("three_az_open", false);
    }

    public String getCdmSpecifiedInvalidClustersList() {
        return KVConfig.INSTANCE.getStringValue("cdm_specified_invalid_cluster_list", "");
    }

    public String getNodeHeartBeatFilter() {
        return KVConfig.INSTANCE.getStringValue("node_heartbeat_filter", "null");
    }

    public boolean isSilenceMigrateEnable() {
        return migratingConfig.isSilenceMigrateEnable();
    }

    public boolean isTryReadRemote() {
        return migratingConfig.isTryReadRemote();
    }

    public String getCDMObjectSeperator() {
        return KVConfig.INSTANCE.getStringValue("cdm_object_seperator", "|");
    }

    public int getCdmJsonValueMaxLength() {
        return KVConfig.INSTANCE.getIntValue("cdm_json_value_max_length", 4000);
    }

    public int getBackToSourceValidatorMaxLength() {
        return KVConfig.INSTANCE.getIntValue("back_to_source_validator_max_length", 256);
    }

    public boolean getBackToSourceApiOpen() {
        return KVConfig.INSTANCE.getBoolValue("back_to_source_api_open", true);
    }

    public boolean getCDMApiOpen() {
        return KVConfig.INSTANCE.getBoolValue("cdm_api_open", false);
    }

    public Map<String, String> getDataplusForwardCodeMapByPrefix(String pre) {
        return KVConfig.INSTANCE.getMapByPrefix(pre);
    }

    public boolean isDataPlusForwardOpen() {
        return KVConfig.INSTANCE.getBoolValue("data_plus_forward_open", false);
    }

    public double getDataPlusForwardRatio() {
        String ratioTmp = KVConfig.INSTANCE.getStringValue("data_plus_forward_concurrent_ratio", "0.2");
        double ratio = Double.parseDouble(ratioTmp);
        if (ratio < 0.0 || ratio > 1.0) {
            ratio = Double.parseDouble("0.2");
        }
        return ratio;
    }

    public int getDataplusForwardConnectionTimeOut() {
        return sysConfig.getDataplusForwardConnectionTimeOut();
    }

    public int getDataplusForwardSocketTimeOut() {
        return sysConfig.getDataplusForwardSocketTimeOut();
    }

    public int getDataplusAccessMethodMaxLength() {
        return sysConfig.getDataplusAccessMethodMaxLength();
    }

    public String getDataplusForwardScheme() {
        return KVConfig.INSTANCE.getStringValue("data_plus_forward_scheme", "https");
    }

    public long getDataplusMonitorStatisticInterval() {
        return KVConfig.INSTANCE.getLongValue("data_plus_monitor_interval", 300L);
    }

    public boolean isCloseLongConnection() {
        return sysConfig.isCloseLongConnection();
    }

    public int getAsyncBucketUsageUpdateThread() {
        return sysConfig.getAsyncBucketUsageUpdateThread();
    }

    public long getFsServerCacheMemMB() {
        return sysConfig.getFsServerCacheMemMB();
    }

    public long getFsMaxTruncLenGB() {
        return sysConfig.getFsMaxTruncLenGB();
    }

    public long getFsClientMetaCacheMemMB() {
        return sysConfig.getFsClientMetaCacheMemMB();
    }

    public long getFsMaxCacheSeconds() {
        return sysConfig.getFsMaxCacheSeconds();
    }

    public long getFsMaxReadSize() {
        return sysConfig.getFsMaxReadSize();
    }

    public long getFsDelayPrintThreshold() {
        return sysConfig.getFsDelayPrintThreshold();
    }

    public long getFsStatPrintInterval() {
        return sysConfig.getFsStatPrintInterval();
    }

    public long getFsStatPrintCountThreshold() {
        return sysConfig.getFsStatPrintCountThreshold();
    }

    public int getKVConfigScanInterval() {
        return sysConfig.getKVConfigScanInterval();
    }

    public int getTenantStoreCacheDelay() {
        return sysConfig.getTenantStoreCacheDelay();
    }

    public int getTenantStoreCacheInterval() {
        return sysConfig.getTenantStoreCacheInterval();
    }

    public int getFsMaxDirDepth() {
        return businessConfig.getFsMaxDirDepth();
    }

    public int getFsMaxCacheNode() {
        return businessConfig.getFsMaxCacheNode();
    }

    public int getfsDefragmentMaxTreemapMoveLimit() {
        return sysConfig.getFsDefragmentMaxTreemapMoveLimit();
    }

    public boolean getfsDefragmentEnable() {
        return sysConfig.getFsDefragmentEnable();
    }

    public boolean getfsChunkMarkDelEnable() {
        return sysConfig.getfsChunkMarkDelEnable();
    }

    public boolean getfsDefragmentMd5CheckEnable() {
        return sysConfig.getFsDefragmentMd5CheckEnable();
    }

    public boolean getfsDefragmentConflictClear() {
        return sysConfig.getfsDefragmentConflictCountClear();
    }

    public boolean getFsDefragmentMd5CheckStatisticsClear() {
        return sysConfig.getFsDefragmentMd5CheckStatisticsClear();
    }

    public boolean getFsDefragmentEcCutLocationStatisticsClear() {
        return sysConfig.getFsDefragmentEcCutLocationStatisticsClear();
    }

    public boolean getFsDefragmentCutPlogTypeStatisticsClear() {
        return sysConfig.getFsDefragmentCutPlogTypeStatisticsClear();
    }

    public long getfsDefragmentMaxLayoutPerRangeThreshold() {
        return sysConfig.getfsDefragmentMaxLayoutPerRangeThreshold();
    }

    public double getfsDefragmentDatasizePerRangeThreshold() {
        return sysConfig.getfsDefragmentDatasizePerRangeThreshold();
    }

    public double getfsDefragmentPieceLevel() {
        return sysConfig.getfsDefragmentPieceLevel();
    }

    public long getfsDefragmentRangesize() {
        return sysConfig.getfsDefragmentRangesize();
    }

    public long getfsDefragmentCacheMemThreshold() {
        return sysConfig.getfsDefragmentCacheMemThreshold();
    }

    public long getfsDefragmentCacheAverMemThreshold() {
        return sysConfig.getfsDefragmentCacheAverMemThreshold();
    }

    public long getfsDefragmentCacheMaxCount() {
        return this.getfsDefragmentCacheMemThreshold() / this.getfsDefragmentCacheAverMemThreshold();
    }

    public double getfsDefragmentSysPriorityThreshold() {
        return sysConfig.getfsDefragmentSysPriorityThreshold();
    }

    public int getfsDefragmentMaptoqCycle() {
        return sysConfig.getfsDefragmentMaptoqCycle();
    }

    public boolean getFsDefragementQosEnable() {
        return KVConfig.INSTANCE.getBoolValue("fs_defragement_qos_ensble", true);
    }

    public long getFsDefragementQosConcurrent() {
        return KVConfig.INSTANCE.getLongValue("fs_defragement_qos_limit_concurrent", 1000L);
    }

    public long getFsDefragementQosBps() {
        return KVConfig.INSTANCE.getLongValue("fs_defragement_qos_limit_bps", 0x40000000L);
    }

    public long getFsDefragementQosTps() {
        return KVConfig.INSTANCE.getLongValue("fs_defragement_qos_limit_tps", 500L);
    }

    public boolean isFsDefragmentObjectLayout() {
        return sysConfig.isFsDefragmentObjectLayout();
    }

    public long getFsDefragmentMaxLayoutPerLogicClock() {
        return sysConfig.getFsDefragmentMaxLayoutPerLogicClock();
    }

    public boolean getfsMultipartMoveStatisticsClear() {
        return sysConfig.getfsMultipartMoveStatisticsClear();
    }

    public int getKVConfigScanInitDelay() {
        return sysConfig.getKVConfigScanInitDelay();
    }

    public int getMaxCustomDomain() {
        return KVConfig.INSTANCE.getIntValue("max_custom_domain", 5);
    }

    public int getCustomDomainMaxLength() {
        return KVConfig.INSTANCE.getIntValue("custom_domain_max_length", 256);
    }

    public String getCustomDomainPattern() {
        return KVConfig.INSTANCE.getStringValue("custom_domain_pattern", "^([^\\\\*]+\\\\.)?([a-zA-Z0-9]([a-zA-Z0-9-]{0,60}[a-zA-Z0-9])?\\.){1,}[a-zA-Z]{2,6}$");
    }

    public int getCdmTaskExpiredInterval() {
        return KVConfig.INSTANCE.getIntValue("cdm_task_expired_interval", 72);
    }

    public int getCdmTaskRetryTime() {
        return KVConfig.INSTANCE.getIntValue("cdm_task_retry_time", 3);
    }

    public long getCdmRedirectLocationExpiredInterval() {
        return KVConfig.INSTANCE.getLongValue("cdm_redirect_location_expired_interval", 900L);
    }

    public boolean isCdmLinkUseCustomDomain() {
        return KVConfig.INSTANCE.getBoolValue("cdm_link_config_use_custom_domain", true);
    }

    public int getTaskMessageScanInterval() {
        return KVConfig.INSTANCE.getIntValue("task_message_scan_interval", 30);
    }

    public int getTaskMessageSchedulerThreadNumber() {
        return KVConfig.INSTANCE.getIntValue("task_message_schedule_thead_number", 5);
    }

    public long getCdmMonitorStatisticInterval() {
        return KVConfig.INSTANCE.getLongValue("cdm_monitor_interval_second", 300L);
    }

    public String getNotificateMessageType() {
        return KVConfig.INSTANCE.getStringValue("notification_message_type", "S3");
    }

    public boolean allowSDKnegotiate() {
        return KVConfig.INSTANCE.getBoolValue("allow_sdk_negotiate", true);
    }

    public int getMasterKeyInterval() {
        return KVConfig.INSTANCE.getIntValue("master_key_scan_interval", 30);
    }

    public int checkMasterKeyInterval() {
        return KVConfig.INSTANCE.getIntValue("master_key_check_interval", 30);
    }

    public int getEnterpriseUsageMode() {
        return sysConfig.getEnterpriseUsageMode();
    }

    public boolean isBuSummaryList() {
        return sysConfig.isBuSummaryList();
    }

    public boolean isDedupEnabled() {
        return sysConfig.isDedupswitch();
    }

    public boolean isEnterpriseVersionIdUpgrade() {
        return sysConfig.isEnterpriseVersionIdUpgrade();
    }

    public boolean isEnterpriseMode() {
        return sysConfig.isEnterpriseMode();
    }

    public boolean isReadWriteThreadPoolIsolationSwitch() {
        return sysConfig.isReadWriteThreadPoolIsolationSwitch();
    }

    public int getPlogPerfType() {
        return sysConfig.getPlogPerfType();
    }

    public String getSwiftResellerPrefix() {
        return sysConfig.getSwiftResellerPrefix();
    }

    public String getSwiftServiceType() {
        return sysConfig.getSwiftServiceType();
    }

    public String getSwiftTempURLMethods() {
        return sysConfig.getSwiftTempURLMethods();
    }

    public String getSwiftIncomingRemoveHeaders() {
        return sysConfig.getSwiftIncomingRemoveHeaders();
    }

    public String getSwiftIncomingAllowHeaders() {
        return sysConfig.getSwiftIncomingAllowHeaders();
    }

    public boolean isListObjectV2() {
        return sysConfig.isListObjectV2();
    }

    public boolean isEnterpriseOccCheck() {
        return sysConfig.isEnterpriseOccCheck();
    }

    public boolean getEnterpriseAlarmSwitch() {
        return sysConfig.getEnterpriseAlarmSwitch();
    }

    public boolean enterpriseSmallECEnabled() {
        return businessConfig.enterpriseSmallECEnabled();
    }

    public int getLsForwardCheckerTimeout() {
        return multiazConfig.getForwardHangCheckerTimeout();
    }

    public int getAccountCheckingMaxThreadNum() {
        return businessConfig.getAccountCheckingMaxThreadNum();
    }

    public String getUserDefaultPermission() {
        return businessConfig.getUserDefaultPermission();
    }

    public String getUserDirDefaultPermission() {
        return businessConfig.getUserDirDefaultPermission();
    }

    public int getBucketCheckingMaxThreadNum() {
        return businessConfig.getBucketCheckingMaxThreadNum();
    }

    public int getAsyncMD5Threshold() {
        return ospConfig.getAsyncMD5Threshold();
    }

    public String getServiceType() {
        return sysConfig.getServiceType();
    }

    public boolean isLimitHddDurability() {
        return KVConfig.INSTANCE.getBoolValue("limit_hdd_durability_flag", false);
    }

    public int getChangeOriginNumberRatio() {
        return KVConfig.INSTANCE.getIntValue("change_origin_number_ratio", 50);
    }

    public boolean isPoeDomainSwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("poe_domain_switch", false);
    }

    public int getImportDataMaxThreadCount() {
        return sysConfig.getImportDataMaxThreadCount();
    }

    public int getImportDataCountPerThread() {
        return sysConfig.getImportDataCountPerThread();
    }

    public boolean shouldForwardLsRequest() {
        return KVConfig.INSTANCE.getBoolValue("ls_should_forward_request", false);
    }

    public boolean isLocationBackTaskSwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("delete_bucket_location_switch", true);
    }

    public boolean isUpfDataImportDone() {
        return KVConfig.INSTANCE.getBoolValue("upf_data_import_done", false);
    }

    public boolean isStreamUnclosedMonitorSwitchOpen() {
        return KVConfig.INSTANCE.getBoolValue("stream_unclosed_monitor_switch", true);
    }

    public boolean isEpOpen() {
        return KVConfig.INSTANCE.getBoolValue("enterprise_project_open", false);
    }

    public boolean isFgOpen() {
        return KVConfig.INSTANCE.getBoolValue("fine_grained_open", false);
    }

    public boolean isForceFgOpen() {
        return KVConfig.INSTANCE.getBoolValue("force_fine_grained", false);
    }

    public boolean isEpsOk() {
        return KVConfig.INSTANCE.getBoolValue("eps_ok", true);
    }

    public boolean isLsAuthCheckExpTime() {
        return KVConfig.INSTANCE.getBoolValue("ls_auth_check_exp_time_open", true);
    }

    public boolean isFgpWhitelistUser(String domainId) {
        String fgpPrefix = "fgp_whitelist_";
        String key = fgpPrefix + domainId;
        return KVConfig.INSTANCE.getBoolValue(key, false);
    }

    public boolean isSmallECneedToFastGCSwitch() {
        return KVConfig.INSTANCE.getBoolValue("is_smallec_needtofastgc_switch", true);
    }

    public long getFastGCThreadHoldForSmallEC() {
        return KVConfig.INSTANCE.getLongValue("fastgc_threadhld_for_smallec", 524288L);
    }

    public long getFastGCThreadHoldForEC() {
        return KVConfig.INSTANCE.getLongValue("fastgc_threadhld_for_ec", 0x2000000L);
    }

    public long getFastGCThreadHoldForPartEC() {
        return KVConfig.INSTANCE.getLongValue("fastgc_threadhld_for_partec", 0x400000L);
    }

    public static OmdConfig omd() {
        return omdConfig;
    }

    public int getCreatePlogNumPerTimes() {
        return ospConfig.getCreatePlogNumPerTimes();
    }

    public int getUsedTokenRatioMid() {
        return ospConfig.getUsedTokenRatioMid();
    }

    public int getUsedTokenRatioHigh() {
        return ospConfig.getUsedTokenRatioHigh();
    }

    public int getLocalTokenRetryTime() {
        return ospConfig.getLocalTokenRetryTime();
    }

    public boolean isProductIdEmpty() {
        String billBssdomainIndex101 = "1";
        return billBssdomainIndex101.equals(this.getSpecailBillFormatParam(1));
    }

    public boolean isForS3Bill() {
        String billBssdomainIndex2002 = "2";
        return billBssdomainIndex2002.equals(this.getSpecailBillFormatParam(20));
    }

    public boolean isForDTBill() {
        String billBssdomainIndex2001 = "1";
        return billBssdomainIndex2001.equals(this.getSpecailBillFormatParam(20));
    }

    public boolean isForFTBill() {
        return this.isForDTBill() && this.isProductIdEmpty();
    }

    public long getLoadCMViewInterval() {
        return sysConfig.getLoadCMViewInterval();
    }

    public long getLoadDHTViewInterval() {
        return sysConfig.getLoadDHTViewInterval();
    }

    public long getFsHeartBeatInterval() {
        return sysConfig.getFsHeartBeatInterval();
    }

    public boolean isMockZkLoadDHTViewFailed() {
        return sysConfig.isMockZkLoadDHTViewFailed();
    }

    public boolean isMockSupportFs() {
        return sysConfig.isMockSupportFs();
    }

    public boolean isEnableMonitorPlogOperate() {
        return sysConfig.isEnableMonitorPlogOperate();
    }

    public int getItsResumeAlarmThreshold() {
        return KVConfig.INSTANCE.getIntValue("its_resume_alarm_threshold", 20);
    }

    public int getItsAlarmThreshold() {
        return KVConfig.INSTANCE.getIntValue("its_alarm_threshold", 5);
    }

    public boolean isAmzAndObsAuthOpen() {
        return KVConfig.INSTANCE.getBoolValue("compatible_amz_obs_temp", true);
    }

    public int getBucketInfoMapMaxCapacity() {
        return billConfig.getBucketInfoMapMaxCapacity();
    }

    public int getInitColdInStandardMirrorPlogNum() {
        return ospConfig.getInitColdInStandardMirrorPlogNum();
    }

    public int getInitColdInStandardECPlogNum() {
        return ospConfig.getInitColdInStandardECPlogNum();
    }

    public int getInitColdInStandardPartECPlogNum() {
        return ospConfig.getInitColdInStandardPartECPlogNum();
    }

    public int getInitColdInStandardSmallECPlogNum() {
        return ospConfig.getInitColdInStandardSmallECPlogNum();
    }

    public int getMaxColdInStandardMirrorPlogNum() {
        return ospConfig.getMaxColdInStandardMirrorPlogNum();
    }

    public int getMaxColdInStandardECPlogNum() {
        return ospConfig.getMaxColdInStandardECPlogNum();
    }

    public int getMaxColdInStandardPartECPlogNum() {
        return ospConfig.getMaxColdInStandardPartECPlogNum();
    }

    public int getMaxColdInStandardSmallECPlogNum() {
        return ospConfig.getMaxColdInStandardSmallECPlogNum();
    }

    public int isDebug() {
        return this.getConfig().getInt("debug", 0);
    }

    public boolean isKMSMultiProjectOpen() {
        return KVConfig.INSTANCE.getBoolValue("kms_multi_project_open", false);
    }

    public List<String> getLVSIPList() {
        return sysConfig.getObsLVSIPList();
    }

    public int getMaxCESAccessLogUsageRate() {
        return billConfig.getMaxCESAccessLogUsageRate();
    }

    public long getBUIdleTime() {
        return sysConfig.getBUIdleTime();
    }

    public long getOisIdleTime() {
        return sysConfig.getOISIdleTime();
    }

    public long getBillIdleTime() {
        return billConfig.getBillIdleTime();
    }

    public boolean isListMultiPartTaskWithMultiIndex() {
        return sysConfig.isListMultiPartTaskWithMultiIndex();
    }

    public String getOutgoingRemoveHeaders() {
        String value;
        try {
            value = this.getConfig().getString("outgoing_remove_headers", "");
        }
        catch (RuntimeException e) {
            value = "";
        }
        return value;
    }

    public String getOutgoingAllowHeaders() {
        String value;
        try {
            value = this.getConfig().getString("outgoing_allow_headers", "");
        }
        catch (RuntimeException e) {
            value = "";
        }
        return value;
    }

    public boolean getSwiftUndocumentedApiEnbale() {
        return this.getConfig().getBoolean("swift_undocumented_api_enable", false);
    }

    public long getBucketLocationCacheTtl() {
        return mdcConfig.getBucketLocationCacheTtl();
    }

    public long getColdPoolMemMaxLength() {
        return ospConfig.getColdPoolMemMaxLength();
    }

    public boolean isUseNewKeyListTable() {
        return KVConfig.INSTANCE.getIntValue("use_new_key_list_table", 0) > 0;
    }

    public int getFsMaxPartMoveLayoutRate() {
        return businessConfig.getFsMaxPartMoveLayoutRate();
    }

    public boolean isReadObjectCacheOpen() {
        return sysConfig.isReadObjectCacheOpen();
    }

    public boolean isTrimSlashOpen() {
        return sysConfig.isTrimSlashOpen();
    }

    public boolean isAllowDirReceive1ByteData() {
        return sysConfig.isAllowDirReceive1ByteData();
    }

    public boolean isDataPilotServiceOpen() {
        return sysConfig.isDataPilotServiceOpen();
    }

    public boolean isAddMD5PrefixToObjectName() {
        return sysConfig.isAddMD5PrefixToObjectName();
    }

    public void setAddMD5PrefixToObjectName(boolean addMD5PrefixToObjectName) {
        sysConfig.setAddMD5PrefixToObjectName(addMD5PrefixToObjectName);
    }

    public long getWormPolicyConfirmMaxTime() {
        return sysConfig.getWormPolicyConfirmMaxTime();
    }

    public int getWormClockClientUpdatePeriod() {
        return sysConfig.getWormClockClientUpdatePeriod();
    }

    public int getWormClockServerUpdatePeriod() {
        return sysConfig.getWormClockServerUpdatePeriod();
    }

    public int getWormClockClientUpdateThreshold() {
        return sysConfig.getWormClockClientUpdateThreshold();
    }

    public int getWormClockClientExpiredThreshold() {
        return sysConfig.getWormClockClientExpiredThreshold();
    }

    public boolean isBucketWormEnable() {
        return KVConfig.INSTANCE.getBoolValue("bucket_worm_switch", false);
    }

    public boolean isWormClockInit() {
        if (!this.isBucketWormEnable()) {
            return false;
        }
        return KVConfig.INSTANCE.getBoolValue("bucket_worm_init", false);
    }

    public boolean isCoexistForwardOpen() {
        return businessConfig.isCoexistForwardOpen();
    }

    public boolean isCoexistLastModifyTimeOpen() {
        return businessConfig.isCoexistLastModifyTimeOpen();
    }

    public boolean isCompareLastModifyTimeOpen() {
        return businessConfig.isCompareLastModifyTimeOpen();
    }

    public String getCoexistClusterForwardEndpoint() {
        return businessConfig.getCoexistClusterForwardEndpoint();
    }

    public long getBlockKeyUpdateInterval() {
        return sysConfig.getBlockKeyUpdateInterval();
    }

    public long getBlockKeyLifetime() {
        return sysConfig.getBlockKeyLifetime();
    }

    public long getBlockKeyScanInterval() {
        return sysConfig.getBlockKeyScanInterval();
    }

    public String getBucketNameForChangeCreateTime() {
        return KVConfig.INSTANCE.getStringValue("bucket_name_change_create_time", "");
    }

    public int getDeltaDaysForChangeCreateTime() {
        return KVConfig.INSTANCE.getIntValue("delta_days_change_create_time", 0);
    }

    public boolean isFastDeleteBucket(String bucketName) {
        return this.getFastDeleteBuckets().contains("," + bucketName + ",");
    }

    public String getFastDeleteBuckets() {
        return "," + KVConfig.INSTANCE.getStringValue("gc_fast_delete_buckets", "") + ",";
    }

    public boolean isFastDeleteUser(String ownerId) {
        return this.getFastDeleteUsers().contains("," + ownerId + ",");
    }

    public String getFastDeleteUsers() {
        return "," + KVConfig.INSTANCE.getStringValue("gc_fast_delete_users", "") + ",";
    }

    public long getSyncDataTimeoutInMicros() {
        return sysConfig.getSyncDataTimeoutInMicros();
    }

    public boolean isInternalReqAddFTDSDelay() {
        return sysConfig.isInternalReqAddFTDSDelay();
    }

    public boolean isObsSupportFtdsBelowHigh() {
        return sysConfig.isObsSupportFtdsBelowHigh();
    }

    public String getCoexistSpaceBalanceLocationStub() {
        return this.getConfig().getString("coexist_spacebalance_location_stub", "");
    }

    public boolean isSealDowngradePlogOpen() {
        return sysConfig.isSealDowngradePlogOpen();
    }

    public int getFSTransTaskTread() {
        return this.getConfig().getInt("fs_transtask_thread", 100);
    }

    public int getFSEditLogQueue() {
        return this.getConfig().getInt("fs_editlog_queue", 10000);
    }

    public int getFsDeleteObjChunkPeriod() {
        return sysConfig.getFsDeleteObjChunkPeriod();
    }

    public int getFsDeleteObjChunkAllowOverTime() {
        return sysConfig.getFsDeleteObjChunkAllowOverTime();
    }

    public int getOisOCCPoolSize() {
        int poolSize = 1;
        try {
            poolSize = sysConfig.getOisOCCPoolSize();
        }
        catch (RuntimeException e) {
            poolSize = 0;
        }
        if (poolSize <= 0) {
            poolSize = 5;
        }
        return poolSize;
    }

    public long getAuScanCacheMonitorInterval() {
        return sysConfig.getAuScanCacheMonitorInterval();
    }

    public long getBuUpdateStorageInterval() {
        return sysConfig.getBuUpdateStorageInterval();
    }

    public long getAuScanMaxAddInterval() {
        return sysConfig.getAuScanMaxAddInterval();
    }

    public boolean isBucketUsageCheckSwitch() {
        return sysConfig.isBucketUsageCheckSwitch();
    }

    public long getScheduleTotalAccountUsageInterval() {
        return sysConfig.getScheduleTotalAccountUsageInterval();
    }

    public String getOAMSIpList() {
        return sysConfig.getOAMSIpList();
    }

    public String getOAMIIpList() {
        return sysConfig.getOAMIIpList();
    }

    public String getOAMPIpList() {
        return sysConfig.getOAMPIpList();
    }

    public String getOamgsIpList() {
        return sysConfig.getOamgsIpList();
    }

    public String getOAMUIpList() {
        return sysConfig.getOAMUIpList();
    }

    public boolean isDns3AzSwitchOpen() {
        return sysConfig.isDns3AzSwitchOpen();
    }

    public int getAsyECDelayHour() {
        return sysConfig.getAsyECDelayHour();
    }

    public boolean isSupportBucketUnderLine() {
        return sysConfig.isSupportBucketUnderLine();
    }

    public boolean isSupportBucketNameWithNas() {
        return sysConfig.isSupportBucketNameWithNas();
    }

    public String getKmsIpList() {
        return sysConfig.getKmsIpList();
    }

    public String getClusterSn() {
        return sysConfig.getClusterSn();
    }

    public long getSecretKeyUpdateInterval() {
        return sysConfig.getSecretKeyUpdateInterval();
    }

    public boolean isSoftEncryptOn() {
        return sysConfig.isSoftEncryptOn();
    }

    public boolean isDegPlogMoveOpen() {
        return KVConfig.INSTANCE.getBoolValue("degrade_plog_move_switch", true);
    }

    public boolean noLocation() {
        return KVConfig.INSTANCE.getBoolValue("no_location", false);
    }

    public boolean checkFsObjChunkDeletePrg() {
        return this.getConfig().getBoolean("fsobjchunk_delprg_check_switch", true);
    }

    public boolean isNeedInitCM() {
        return this.getConfig().getBoolean("init_cm_client", true);
    }

    public boolean isGcDynamicSwitch() {
        return sysConfig.isGcDynamicSwitch();
    }

    public String getGCDynamicRatioThreshold() {
        return sysConfig.getGCDynamicRatioThreshold();
    }

    public String getGCDynamicScanMetaDelLogicTime() {
        return sysConfig.getGCDynamicScanMetaDelLogicTime();
    }

    public String getGCDynamicHddPlogDelaySinceLastModifyTime() {
        return sysConfig.getGCDynamicHddPlogDelaySinceLastModifyTime();
    }

    public String getGCDynamicHddPlogTaskDelayTimeParams() {
        return sysConfig.getGCDynamicHddPlogTaskDelayTimeParams();
    }

    public String getGCDynamicGcQosBPS() {
        return sysConfig.getGCDynamicGcQosBPS();
    }

    public String getGCDynamicGcQosTPS() {
        return sysConfig.getGCDynamicGcQosTPS();
    }

    public String getGCDynamicPlogUsage() {
        return sysConfig.getGCDynamicPlogUsage();
    }

    public int getGCDynamicCPUBusyCore() {
        return sysConfig.getGCDynamicCPUBusyCore();
    }

    public int getGCDynamicPlogTime() {
        return sysConfig.getGCDynamicPlogTime();
    }

    public long getRepRetryTime() {
        return sysConfig.getRepRetryTime();
    }

    public int getRepRetryCount() {
        return sysConfig.getRepRetryCount();
    }

    public long getLsid() {
        return sysConfig.getLsid();
    }

    public long getPoeLsid() {
        return sysConfig.getPoeLsid();
    }

    public boolean getMetaSearchSwitch() {
        return sysConfig.getMetaSearchSwitch();
    }

    public int getMaxMetaIndexKeyNumber() {
        return sysConfig.getMaxMetaIndexKeyNumber();
    }

    public long getCmrCmLsid() {
        return sysConfig.getCmrCmLsid();
    }

    public int getCmrCmPort() {
        return sysConfig.getCmrCmPort();
    }

    public long getEbsServerLsid() {
        return sysConfig.getEbsServerLsid();
    }

    public int getEbsServerPort() {
        return sysConfig.getEbsServerPort();
    }

    public long getCcdbLsid() {
        return sysConfig.getCcdbLsid();
    }

    public String getNsGlobalIpList() {
        return sysConfig.getNsGlobalIpList();
    }

    public Boolean hasOldDataInMongo() {
        return sysConfig.hasOldDataInMongo();
    }

    public boolean isInterworking() {
        return sysConfig.isInterworking();
    }

    public int getMaxFullPathLength() {
        return sysConfig.getMaxFullPathLength();
    }

    public int getMaxKeyLengthInPath() {
        return sysConfig.getMaxKeyLengthInPath();
    }

    public boolean isSupportPartition() {
        return sysConfig.isSupportPartition();
    }

    public int getSysPartitionNum() {
        return sysConfig.getSysPartitionNum();
    }

    public String getBucketName() {
        return sysConfig.getBucketName();
    }

    public String getBucketID() {
        return sysConfig.getBucketID();
    }

    public String getCanonicalID() {
        return sysConfig.getCanonicalID();
    }

    public boolean isDeltaECUseMem() {
        return ospConfig.isDeltaECUseMem();
    }

    public String getDiskPoolInfo() {
        return sysConfig.getDiskPoolInfo();
    }

    public Map<Integer, DiskPoolInfo> getDiskPoolMap() {
        return sysConfig.getDiskPoolMap();
    }

    public long getPartMetaRepairSpan() {
        return sysConfig.getPartMetaRepairSpan();
    }

    public boolean isSupportOrigBucket() {
        return sysConfig.isSupportOrigBucket();
    }

    public String getPoolType() {
        return sysConfig.getPoolType();
    }

    public boolean isObjectEnable() {
        return sysConfig.isObjectEnable();
    }

    public boolean isHDFSEnable() {
        return sysConfig.isHDFSEnable();
    }

    public boolean isNASEnable() {
        return sysConfig.isNASEnable();
    }

    public boolean isNeedForwardSwitch() {
        return sysConfig.isNeedForwardSwitch();
    }

    public String getDefaultBucketType() {
        return sysConfig.getDefaultBucketType();
    }

    public boolean isMD5Enable() {
        return sysConfig.isMD5Enable();
    }

    public int getEdsFlushSize() {
        return sysConfig.getEdsFlushSize();
    }

    public boolean isNeedImportAccounts() {
        return sysConfig.isNeedImportAccounts();
    }

    public int getMaxAllowedKeyPairCount() {
        return poeOpConfig.getMaxKeyPairCount();
    }

    public boolean isMobileUser() {
        return poeOpConfig.isMobileUser();
    }

    public String getContentTypeDefaultValue() {
        return sysConfig.getContentTypeDefaultValue();
    }

    public boolean getMobileSwitch() {
        return sysConfig.getMobileSwitch();
    }

    public String getMobileInnerClientIpList() {
        return sysConfig.getMobileInnerClientIpList();
    }

    public long getMobileStatisticInterval() {
        return sysConfig.getMobileStatisticInterval();
    }

    public boolean isDeleteAccountAsync() {
        return sysConfig.isDeleteAccountAsync();
    }

    public long getMaxInitializingTime4Repair() {
        return sysConfig.getMaxInitializingTime4Repair();
    }

    public long getMaxInitializedTime4Repair() {
        return sysConfig.getMaxInitializedTime4Repair();
    }

    public long getCheckInitUploadIdInterval() {
        return sysConfig.getCheckInitUploadIdInterval();
    }

    public long getCheckInitUploadIdFailedInterval() {
        return sysConfig.getCheckInitUploadIdFailedInterval();
    }

    public long getDelEmptyObjDirInterval4Repair() {
        return sysConfig.getDelEmptyObjDirInterval4Repair();
    }

    public String getZkAuthUserName() {
        return sysConfig.getZkAuthUserName();
    }

    public String getZkAuthPassword() {
        return sysConfig.getZkAuthPassWord();
    }

    public int getMaxMultiPartObjFullPathLength() {
        return sysConfig.getMaxMultiPartObjFullPathLength();
    }

    public boolean isCircularDeleteDir() {
        return sysConfig.isSupportCircularDeleteDir();
    }

    public boolean isForceDeleteDir() {
        return sysConfig.isForceDeleteDir();
    }

    public boolean isCheckCompressMetadataSize() {
        return sysConfig.isCheckCompressMetadataSize();
    }

    public int getPocLevel() {
        return sysConfig.getPocLevel();
    }

    public boolean isFtdsStatOn() {
        return sysConfig.isFtdsStatOn();
    }

    public int getMultipartMaxCount() {
        return businessConfig.getMultipartMaxCount();
    }

    public int getTierQos() {
        return qosConfig.getTierQos();
    }

    public int getTierMaxSegSize() {
        return sysConfig.getTierMaxSegSize();
    }

    public boolean isHttpClientNormalizeSwitchOpen() {
        return sysConfig.isHttpClientNormalizeSwitchOpen();
    }

    public boolean isPathTransferVirtualHost() {
        return sysConfig.isPathTransferVirtualHost();
    }

    public boolean isMultiPartLocationFormatOn() {
        return businessConfig.isMultiPartLocationFormatOn();
    }

    public boolean isMultiPartLocationFormatSwitchOpen() {
        return businessConfig.isMultiPartLocationFormatSwitchOpen();
    }

    public boolean isInUpgrade() {
        return upgradeStatusConfig.isInUpgrade();
    }

    public boolean isLogRequesterSwitchOpen() {
        return businessConfig.isLogRequesterSwitchOpen();
    }
}

