/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSFileHandlerReloadingDetector
extends FileHandlerReloadingDetector {
    private static final Logger logger = LoggerFactory.getLogger(OBSFileHandlerReloadingDetector.class);
    private long lastModifiedTime;
    private long lastCheckedTime = System.nanoTime();

    public OBSFileHandlerReloadingDetector(FileHandler handler, long refreshDelay) {
        super(handler, refreshDelay);
    }

    public OBSFileHandlerReloadingDetector(FileHandler handler) {
        super(handler);
    }

    public boolean isReloadingRequired() {
        long now = System.nanoTime();
        if ((now - this.lastCheckedTime) / 1000000L < this.getRefreshDelay()) {
            return false;
        }
        this.lastCheckedTime = now;
        long modified = this.getLastModificationDate();
        if (modified <= 0L) {
            return false;
        }
        if (this.lastModifiedTime == 0L) {
            this.updateLastModified(modified);
            return false;
        }
        if (modified != this.lastModifiedTime || System.currentTimeMillis() - modified < this.getRefreshDelay() * 3L) {
            logger.warn("file is changed. modified[{}] , lastModifiedTime[{}]", (Object)modified, (Object)this.lastModifiedTime);
            return true;
        }
        return false;
    }

    protected void updateLastModified(long time) {
        this.lastModifiedTime = time;
    }

    public void refresh() {
        this.updateLastModified(this.getLastModificationDate());
    }

    public void reloadingPerformed() {
        this.updateLastModified(this.getLastModificationDate());
    }
}

