/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.ConfigLoadPredicate;
import uds.common.config.interf.ConfigCreateEventListener;
import uds.common.config.interf.ConfigReloadEventListener;
import uds.common.config.interf.OBSDefaultReloadingDetectorFactory;
import uds.common.config.interf.ReloadableConfig;
import uds.common.config.interf.ReloadableNotify;

public class PropertiesConfigBuilder
extends ReloadingFileBasedConfigurationBuilder<FileBasedConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigBuilder.class);
    private static final char DEFAULT_DELIMITER = '|';
    private static final int CHECK_INTERVAL = 3;
    private ConfigCreateEventListener createListener = null;
    private PeriodicReloadingTrigger checkTrigger = null;

    public PropertiesConfigBuilder(String fileName, Character delimiter, ConfigLoadPredicate configLoadPredicate) {
        super(PropertiesConfiguration.class);
        Parameters params = new Parameters();
        char realListDelimiter = delimiter == null ? (char)'|' : (char)delimiter.charValue();
        this.configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)params.properties().setFileName(fileName)).setThrowExceptionOnMissing(false)).setReloadingDetectorFactory((ReloadingDetectorFactory)new OBSDefaultReloadingDetectorFactory())).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(realListDelimiter))});
        try {
            super.getConfiguration();
        }
        catch (ConfigurationException e) {
            LOGGER.error(String.format(Locale.ROOT, "Failed to load configuration for file [%1$s] due to error [%2$s]", fileName, e.getLocalizedMessage()));
        }
        this.createListener = new ConfigCreateEventListener();
        this.createListener.setConfigLoadPredicate(configLoadPredicate);
        this.addEventListener(ConfigurationBuilderResultCreatedEvent.RESULT_CREATED, this.createListener);
        this.getReloadingController().addEventListener(ReloadingEvent.ANY, (EventListener)new ConfigReloadEventListener(this));
        this.checkTrigger = new PeriodicReloadingTrigger(this.getReloadingController(), null, 3L, TimeUnit.SECONDS);
        this.checkTrigger.start();
    }

    public void registerForReloading(ReloadableConfig config) {
        if (this.createListener != null && config != null) {
            this.createListener.registerConfig(config);
            LOGGER.warn(String.format(Locale.ROOT, "AbstractConfigPraser [%1$s] registered for reloading.", config.getClass().getSimpleName()));
            return;
        }
        LOGGER.info(String.format(Locale.ROOT, "AbstractConfigPraser [%1$s] registered failed.", config.getClass().getSimpleName()));
    }

    public void registerForNotify(ReloadableNotify notify) {
        if (this.createListener != null && notify != null) {
            this.createListener.registerNotify(notify);
            LOGGER.warn("AbstractConfigParser {} registered for reload notify.", (Object)notify.getClass().getSimpleName());
            return;
        }
        LOGGER.info("AbstractConfigParser {} registered for reload notify failed.", (Object)notify.getClass().getSimpleName());
    }

    public void stopAutoReloading() {
        if (this.checkTrigger != null) {
            this.checkTrigger.shutdown();
        }
    }

    public void startAutoReloading() {
        if (this.checkTrigger != null) {
            this.checkTrigger.start();
        } else {
            this.checkTrigger = new PeriodicReloadingTrigger(this.getReloadingController(), null, 3L, TimeUnit.SECONDS);
            this.checkTrigger.start();
        }
    }

    public PropertiesConfiguration getConfiguration() {
        PropertiesConfiguration result = null;
        try {
            if (super.getConfiguration() instanceof PropertiesConfiguration) {
                result = (PropertiesConfiguration)super.getConfiguration();
            }
        }
        catch (ConfigurationException e) {
            LOGGER.warn(String.format(Locale.ROOT, "Failed to get PropertiesConfiguration from configBuilder of file [%1$s] due to error [%2$s]", this.getFileHandler().getFileName(), e.getLocalizedMessage()));
        }
        return result;
    }
}

