/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.interf;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.ConfigLoadPredicate;
import uds.common.config.interf.PropertiesConfigBuilder;

public final class PropertiesConfigBuilderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigBuilderManager.class);
    private static final PropertiesConfigBuilderManager INSTANCE = new PropertiesConfigBuilderManager();
    private final Map<String, ConfigLoadPredicate> configLoadPredicateMap = new HashMap<String, ConfigLoadPredicate>();
    private final Map<String, PropertiesConfigBuilder> file2BuilderMap = new HashMap<String, PropertiesConfigBuilder>();
    private ConfigLoadPredicate defaultConfigLoadPredicate = ConfigLoadPredicate.DEFAULT;

    public static PropertiesConfigBuilderManager getInstance() {
        return INSTANCE;
    }

    public void setDefaultConfigLoadPredicate(ConfigLoadPredicate defaultConfigLoadPredicate) {
        this.defaultConfigLoadPredicate = defaultConfigLoadPredicate;
    }

    public void addConfigLoadPredicate(String fileName, ConfigLoadPredicate configLoadPredicate) {
        this.configLoadPredicateMap.put(fileName, configLoadPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesConfigBuilder getPropertiesConfigBuilder(String fileName, Character delimiter) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            LOGGER.error("Try to get config builder for null file.");
            throw new ConfigurationRuntimeException("Try to get config builder for null file.");
        }
        if (this.file2BuilderMap.containsKey(fileName)) {
            LOGGER.debug(String.format(Locale.ROOT, "PropertiesConfigBuilder found for file [%1$s]", fileName));
            return this.file2BuilderMap.get(fileName);
        }
        Class<PropertiesConfigBuilderManager> clazz = PropertiesConfigBuilderManager.class;
        synchronized (PropertiesConfigBuilderManager.class) {
            if (this.file2BuilderMap.containsKey(fileName)) {
                LOGGER.debug(String.format(Locale.ROOT, "PropertiesConfigBuilder found for file [%1$s]", fileName));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.file2BuilderMap.get(fileName);
            }
            LOGGER.debug(String.format(Locale.ROOT, "Creating PropertiesConfigBuilder for properties file [%1$s]", fileName));
            ConfigLoadPredicate configLoadPredicate = this.defaultConfigLoadPredicate;
            ConfigLoadPredicate tmpLoadPredicate = this.configLoadPredicateMap.get(fileName);
            if (tmpLoadPredicate != null) {
                configLoadPredicate = tmpLoadPredicate;
            }
            PropertiesConfigBuilder builder = new PropertiesConfigBuilder(fileName, delimiter, configLoadPredicate);
            this.file2BuilderMap.put(fileName, builder);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return builder;
        }
    }
}

